/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.text.MessageFormat;
import progress.message.crypto.BlockCipher;
import progress.message.crypto.DesKey;
import progress.message.crypto.JavaDes;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.IDES;

public final class DES
extends BlockCipher
implements IDES {
    private boolean m_decrypting;
    private DesKey javaDesKey;
    private JavaDes javaDesOb;

    public void init(int operation, byte[] key) {
        if (operation == 2) {
            this.m_decrypting = true;
        } else if (operation == 1) {
            this.m_decrypting = false;
        } else {
            String mf107 = prAccessor.getString("STR010");
            Object[] ob107 = new Object[]{Integer.toString(operation)};
            throw new EAssertFailure(MessageFormat.format(mf107, ob107));
        }
        if (key.length < 8) {
            throw new EAssertFailure("key.length = " + key.length);
        }
        this.javaDesKey = new DesKey(key, false);
        this.javaDesOb = new JavaDes(this.javaDesKey);
    }

    @Override
    protected void blockEncrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        this.javaDesOb.ecb_encrypt(in, in_offset, out, out_offset, true);
    }

    @Override
    protected void blockDecrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        this.javaDesOb.ecb_encrypt(in, in_offset, out, out_offset, false);
    }

    @Override
    public int blockLength() {
        return 8;
    }

    @Override
    public int keyLength() {
        return 8;
    }

    public static int computePad(int dataSize) {
        int pad = 0;
        int invpad = dataSize % 8;
        if (invpad > 0) {
            pad = 8 - invpad;
        }
        return pad;
    }

    public void doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        if (output.length - outputOffset < inputLength) {
            throw new EAssertFailure("output.length = " + output.length + ", outputOffset = " + outputOffset + ", inputLength = " + inputLength);
        }
        if (input.length - inputOffset < inputLength) {
            throw new EAssertFailure("input.length = " + input.length + ", inputOffset = " + inputOffset + ", inputLength = " + inputLength);
        }
        int iterations = inputLength / 8;
        int remBytes = inputLength % 8;
        if (remBytes > 0) {
            throw new EAssertFailure("remBytes = " + remBytes);
        }
        try {
            for (int i = 0; i < iterations; ++i) {
                if (this.m_decrypting) {
                    this.blockDecrypt(input, inputOffset + i * 8, output, outputOffset + i * 8);
                    continue;
                }
                this.blockEncrypt(input, inputOffset + i * 8, output, outputOffset + i * 8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EAssertFailure(e.toString());
        }
    }
}

