/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class DurableSyncReplicationMgr
extends DebugObject {
    private long m_maxTrackingNum;
    private long m_currentTrackingNum;
    private volatile boolean m_inDurableSync = false;
    private boolean m_replUndelMsgs = false;

    public DurableSyncReplicationMgr() {
        super(DebugState.GLOBAL_DEBUG_ON ? "DurableSyncReplicationMgr" : null);
    }

    public void setInDurableDynamicSync(long maxTrackingNumber) {
        this.m_maxTrackingNum = maxTrackingNumber;
        this.m_inDurableSync = true;
        this.m_replUndelMsgs = true;
    }

    public void dynamicSyncComplete() {
        this.m_inDurableSync = false;
        this.m_replUndelMsgs = false;
    }

    public void setUndelMsgsComplete() {
        this.m_replUndelMsgs = false;
    }

    public void setCurrentTrackingNum(long currentTrackingNum) {
        this.m_currentTrackingNum = currentTrackingNum;
    }

    public boolean suppressSynchronization(long trackingNum) {
        if (trackingNum != -1L && this.m_inDurableSync && this.m_replUndelMsgs) {
            if (trackingNum <= this.m_currentTrackingNum) {
                if (this.DEBUG) {
                    this.debug("Update on replicated data, replicate: " + trackingNum);
                }
                return false;
            }
            if (trackingNum > this.m_maxTrackingNum) {
                if (this.DEBUG) {
                    this.debug("Update outside snapshot, replicate: " + trackingNum);
                }
                return false;
            }
            if (this.DEBUG) {
                this.debug("Suppressing: " + trackingNum + " Max Syncd: " + this.m_maxTrackingNum);
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("Not in dynamic sync, replicate: " + trackingNum);
        }
        return false;
    }
}

