/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.msg.v25.DefaultDynamicHeader;
import progress.message.msg.v25.DynamicHeader;
import progress.message.msg.v25.Mgram;
import progress.message.util.ArrayUtil;
import progress.message.util.EnhancedByteArrayOutputStream;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

public final class SecureDynamicHeader
extends DynamicHeader {
    private byte m_securityAttributeByte = SecurityLogic.getQueryAttribs();
    private int m_messageLenPad = 0;
    private IMessageProtection m_mp = null;
    private int m_dbSize;
    private byte[] m_messageKey = null;
    private byte[] m_digest = null;
    private byte[] m_db = null;
    private DynamicHeader m_dynamicHeader = null;
    private boolean m_dbDirty = true;
    static final int s_dhMemSize = MemoryUtil.estimateBaseSize(SecureDynamicHeader.class);
    private static int s_dynamicHeaderSize;
    private boolean m_isProtected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            this.printMgramSecurityInfo();
            this.m_dynamicHeader.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramSecurityInfo() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Security Attributes: ");
            if (this.m_mgram.isSecure()) {
                SecurityLogic.debugPrintPrivate(this.m_securityAttributeByte);
            } else {
                log.println("NONE");
            }
        }
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        if (!this.m_dbDirty) {
            sdh.m_db = new byte[this.m_dbSize];
            System.arraycopy(this.m_db, 0, sdh.m_db, 0, this.m_dbSize);
        }
        if (this.m_messageKey != null) {
            sdh.m_messageKey = new byte[this.m_messageKey.length];
            System.arraycopy(this.m_messageKey, 0, sdh.m_messageKey, 0, this.m_messageKey.length);
        }
        if (this.m_digest != null) {
            sdh.m_digest = new byte[this.m_digest.length];
            System.arraycopy(this.m_digest, 0, sdh.m_digest, 0, this.m_digest.length);
        }
        return sdh;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        return sdh;
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.m_isProtected = true;
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.protectedClone(m);
        return sdh;
    }

    @Override
    public void protect() {
        this.m_isProtected = true;
    }

    public void unprotectDynamicHeader() {
        if (this.m_isProtected) {
            if (!this.m_dbDirty) {
                byte[] db = new byte[this.m_dbSize];
                System.arraycopy(this.m_db, 0, db, 0, this.m_dbSize);
                this.m_db = db;
            } else {
                this.m_db = null;
            }
            if (this.m_messageKey != null) {
                byte[] messageKey = new byte[this.m_messageKey.length];
                System.arraycopy(this.m_messageKey, 0, messageKey, 0, messageKey.length);
                this.m_messageKey = messageKey;
            }
            if (this.m_digest != null) {
                byte[] digest = new byte[this.m_digest.length];
                System.arraycopy(this.m_digest, 0, digest, 0, this.m_digest.length);
                this.m_digest = digest;
            }
            this.m_isProtected = false;
        }
    }

    public SecureDynamicHeader(IMessageProtection mp, DynamicHeader dn) {
        super(dn.m_mgram);
        this.m_mp = mp;
        this.m_dynamicHeader = dn;
        this.m_dbDirty = true;
    }

    SecureDynamicHeader(Mgram m, IMessageProtection mp) throws IOException {
        super(m);
        this.m_dynamicHeader = new DefaultDynamicHeader(m);
        this.m_mp = mp;
    }

    private SecureDynamicHeader() throws IOException {
        super(null);
        this.m_dynamicHeader = new DefaultDynamicHeader(null);
    }

    public void setMessageProtection(IMessageProtection mp) {
        this.m_mp = mp;
    }

    @Override
    public int getMessageLength() {
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public int getMessagePad() {
        return this.m_messageLenPad;
    }

    @Override
    IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    @Override
    public byte getSecurity() {
        return this.m_securityAttributeByte;
    }

    @Override
    public byte[] getMessageKey() {
        return this.m_messageKey;
    }

    @Override
    public byte[] getDigest() {
        return this.m_digest;
    }

    @Override
    public void setMessageDigest(byte[] digest) {
        this.unprotectDynamicHeader();
        this.m_digest = digest;
        this.m_dbDirty = true;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(null);
    }

    @Override
    byte[] toByteArray(IMessageProtection mp) {
        this.sync();
        byte[] result = new byte[this.m_dbSize];
        System.arraycopy(this.m_db, 0, result, 0, this.m_dbSize);
        int messageLength = this.m_dynamicHeader.getMessageLength();
        ArrayUtil.writeInt(result, this.m_dbSize - 4, messageLength);
        return result;
    }

    @Override
    int length() {
        this.sync();
        return this.m_dbSize;
    }

    @Override
    int memoryLength() {
        return s_dhMemSize + this.length();
    }

    @Override
    public void setSecurityAttributeByte(byte value) {
        if (this.m_securityAttributeByte != value) {
            this.m_securityAttributeByte = value;
            this.m_dbDirty = true;
        }
    }

    @Override
    public void setMessageKey(byte[] messageKey) {
        this.unprotectDynamicHeader();
        this.m_messageKey = messageKey;
        this.m_dbDirty = true;
    }

    @Override
    public void setMessagePad(int pad) {
        this.m_messageLenPad = pad;
    }

    @Override
    void sync() {
        if (this.m_dbDirty) {
            this.syncInternalData();
        }
    }

    private void syncInternalData() {
        EnhancedByteArrayOutputStream bos = new EnhancedByteArrayOutputStream(s_dynamicHeaderSize);
        Object result = null;
        try {
            this.writeToStream(bos, this.m_mp);
            bos.flush();
            this.m_dbDirty = false;
            this.m_db = bos.getBuffer();
            this.m_dbSize = bos.getBufferSize();
            if (this.m_dbSize > s_dynamicHeaderSize) {
                s_dynamicHeaderSize = this.m_dbSize * 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        this.writeToStream(os, null);
    }

    @Override
    void writeToStream(OutputStream os, IMessageProtection mp) throws IOException {
        this.writeToStream(os, mp, null, null);
    }

    @Override
    public void writeToStream(OutputStream os, IMessageProtection mp, byte[] encyptedMessageKey, byte[] digest) throws IOException {
        if (this.m_dbDirty || encyptedMessageKey != null || digest != null) {
            os.write(this.m_securityAttributeByte);
            if (encyptedMessageKey != null) {
                StreamUtil.writeShort((short)encyptedMessageKey.length, os);
                os.write(encyptedMessageKey);
            } else if (this.m_messageKey != null) {
                StreamUtil.writeShort((short)this.m_messageKey.length, os);
                os.write(this.m_messageKey);
            } else {
                if (this.m_mp == null) {
                    try {
                        this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (ClassCastException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                }
                StreamUtil.writeShort((short)this.m_mp.getSecretKeyLength(), os);
                byte[] dummyMKey = new byte[this.m_mp.getSecretKeyLength()];
                os.write(dummyMKey);
            }
            if (digest != null) {
                StreamUtil.writeShort((short)digest.length, os);
                os.write(digest);
            } else if (this.m_digest != null) {
                StreamUtil.writeShort((short)this.m_digest.length, os);
                os.write(this.m_digest);
            } else {
                StreamUtil.writeShort((short)0, os);
            }
        } else {
            int messageLength = this.m_dynamicHeader.getMessageLength();
            os.write(this.m_db, 0, this.m_dbSize - 4);
            StreamUtil.writeInt(messageLength, os);
            return;
        }
        this.m_dynamicHeader.writeToStream(os);
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is) throws IOException {
        this.m_securityAttributeByte = StreamUtil.readByte(is);
        short messageKeyLen = StreamUtil.readShort(is);
        if (messageKeyLen > 0) {
            this.m_messageKey = new byte[messageKeyLen];
            StreamUtil.readBytes(is, this.m_messageKey, 0, messageKeyLen);
        } else {
            this.m_messageKey = null;
        }
        short digestLen = StreamUtil.readShort(is);
        if (digestLen > 0) {
            this.m_digest = new byte[digestLen];
            StreamUtil.readBytes(is, this.m_digest, 0, digestLen);
        } else {
            this.m_digest = null;
        }
        this.m_dynamicHeader.initDynamicHeaderFromStream(is);
        if (this.m_mp != null) {
            int cipherTextSize = this.m_mp.getOutputSize(this.m_dynamicHeader.getMessageLength());
            this.m_messageLenPad = cipherTextSize - this.m_dynamicHeader.getMessageLength();
        }
        this.m_mgram.setStatus(2);
    }

    @Override
    boolean isDirty() {
        return this.m_dbDirty;
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        return this;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this.m_dynamicHeader;
    }
}

