/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.Mgram;
import progress.message.zclient.EMgramFormatError;

final class TXNRequestPayload
extends DefaultPayload
implements ITXNRequestHandle {
    private static short TX_REQUEST_MASK_CHAINED = 1;
    private static short TX_REQUEST_MASK_SUBTYPE = (short)30;
    private static short TX_REQUEST_SHIFT_SUBTYPE = 1;
    private static short TX_REQUEST_MASK_XONCE = (short)32;
    boolean m_syncd = false;
    private short m_flags;
    private int m_replyTracking = 0;
    private int m_tid = -1;
    private long m_clientId;
    private String m_transactionId;
    private long m_lifespan = 0L;
    private int m_channelState = -1;
    private String m_channelID;

    public TXNRequestPayload(Mgram m) {
        super(m);
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        super.initPayloadFromStream(is, sc);
        this.initRemainingPayload();
    }

    @Override
    public void initRemainingPayload() throws IOException {
        ObjectInput dis = this.getPayloadInputStreamHandle();
        this.m_flags = dis.readShort();
        this.m_replyTracking = dis.readInt();
        this.m_tid = dis.readInt();
        this.m_clientId = dis.readLong();
        int typ = this.getType();
        if (typ == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            this.m_transactionId = dis.readUTF();
            this.m_lifespan = dis.readLong();
        }
        if (typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            this.m_channelID = dis.readUTF();
            this.m_channelState = dis.readInt();
        }
    }

    @Override
    protected void syncPayload() {
        if (this.m_syncd) {
            return;
        }
        try {
            ObjectOutput os = this.getPayloadOutputStreamHandle();
            os.writeShort(this.m_flags);
            os.writeInt(this.m_replyTracking);
            os.writeInt(this.m_tid);
            os.writeLong(this.m_clientId);
            int typ = this.getType();
            if (typ == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
                os.writeUTF(this.m_transactionId);
                os.writeLong(this.m_lifespan);
            }
            if (typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE || typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
                os.writeUTF(this.m_channelID);
                os.writeInt(this.m_channelState);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.m_syncd = true;
        super.sync();
    }

    @Override
    public int getType() {
        return (this.m_flags & TX_REQUEST_MASK_SUBTYPE) >>> TX_REQUEST_SHIFT_SUBTYPE;
    }

    @Override
    public void setType(int typ) {
        this.m_flags = (short)(this.m_flags & ~TX_REQUEST_MASK_SUBTYPE);
        this.m_flags = (short)(this.m_flags | typ << TX_REQUEST_SHIFT_SUBTYPE);
    }

    @Override
    public boolean isChained() {
        return (this.m_flags & TX_REQUEST_MASK_CHAINED) == TX_REQUEST_MASK_CHAINED;
    }

    @Override
    public void setChained(boolean chained) {
        this.m_flags = chained ? (short)(this.m_flags | TX_REQUEST_MASK_CHAINED) : (short)(this.m_flags & ~TX_REQUEST_MASK_CHAINED);
    }

    @Override
    public String opStr() {
        int typ = this.getType();
        if (typ == MgramConstants.TX_REQUEST_ABORT_SUBTYPE) {
            return "abort";
        }
        if (typ == MgramConstants.TX_REQUEST_BEGIN_SUBTYPE) {
            return "begin";
        }
        if (typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
            return "commitchannodup";
        }
        if (typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            return "deletechannodup";
        }
        if (typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE) {
            return "updatechannodup";
        }
        if (typ == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE) {
            return "commitnodup";
        }
        return "commit";
    }

    private String typStr() {
        int typ = this.getType();
        if (typ == MgramConstants.TX_REQUEST_ABORT_SUBTYPE) {
            return "abort";
        }
        if (typ == MgramConstants.TX_REQUEST_BEGIN_SUBTYPE) {
            return "begin";
        }
        if (typ == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
            return "commit chan nodup," + this.m_transactionId + "," + this.m_lifespan + "," + this.m_channelID + "," + this.m_channelState;
        }
        if (typ == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
            return "delete chan nodup," + this.m_transactionId + "," + this.m_channelID;
        }
        if (typ == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE) {
            return "update chan nodup," + this.m_transactionId + "," + this.m_lifespan + "," + this.m_channelID + "," + this.m_channelState;
        }
        if (typ == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE) {
            return "commit nodup," + this.m_transactionId + "," + this.m_lifespan;
        }
        return "commit";
    }

    @Override
    public boolean isXonce() {
        return (this.m_flags & TX_REQUEST_MASK_XONCE) == TX_REQUEST_MASK_XONCE;
    }

    @Override
    public void setXonce(boolean xo) {
        this.m_flags = xo ? (short)(this.m_flags | TX_REQUEST_MASK_XONCE) : (short)(this.m_flags & ~TX_REQUEST_MASK_XONCE);
    }

    @Override
    public int getReplyTracking() {
        return this.m_replyTracking;
    }

    @Override
    public int getTID() {
        return this.m_tid;
    }

    @Override
    public long getClientId() {
        return this.m_clientId;
    }

    @Override
    public String getTransactionId() {
        return this.m_transactionId;
    }

    @Override
    public long getLifespan() {
        return this.m_lifespan;
    }

    @Override
    public String getChannelID() {
        return this.m_channelID;
    }

    @Override
    public int getChannelState() {
        return this.m_channelState;
    }

    @Override
    public void setReplyTracking(int replyTracking) {
        this.m_replyTracking = replyTracking;
    }

    @Override
    public void setTID(int tid) {
        this.m_tid = tid;
    }

    @Override
    public void setClientId(long clientId) {
        this.m_clientId = clientId;
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.m_transactionId = transactionId;
    }

    @Override
    public void setLifespan(long lifespan) {
        this.m_lifespan = lifespan;
    }

    @Override
    public void setChannelID(String channelID) {
        this.m_channelID = channelID;
    }

    @Override
    public void setChannelState(int channelState) {
        this.m_channelState = channelState;
    }

    @Override
    public ITXNRequestHandle getTXNRequestHandle() {
        return this;
    }

    @Override
    public String summaryString() {
        String chained = ",chained";
        if (!this.isChained()) {
            chained = "";
        }
        String xo = ",xo";
        if (!this.isXonce()) {
            xo = "";
        }
        return "tid=" + this.m_tid + ",cid=" + this.m_clientId + ",replyTracking=" + ((long)this.m_replyTracking & 0xFFFFFFFFL) + ",flags=" + this.m_flags + "(" + this.typStr() + chained + xo + ")";
    }
}

