/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26.broker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.broker.MgramSerializer;
import progress.message.msg.IMgram;
import progress.message.msg.IReplicatedMgramHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;

final class ReplicatedMgramPayload
extends Payload
implements IReplicatedMgramHandle {
    static final int s_replicatedMgramPayloadMemSize = MemoryUtil.estimateBaseSize(ReplicatedMgramPayload.class);
    private IMgram m_replicatedMgram;
    private boolean m_tteTTLConvert = false;
    private long m_dbTracking;
    private boolean m_dbTrackingSet = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            if (this.m_replicatedMgram != null) {
                log.print("Replicating Mgram");
                if (this.m_mgram.isGuarenteed()) {
                    log.print("Tracking Num: " + this.m_mgram.getGuarenteedTrackingNum());
                }
            }
        }
    }

    public ReplicatedMgramPayload(Mgram m) {
        super(m);
    }

    public ReplicatedMgramPayload(Mgram m, IMgram replicatedMgram, boolean tteTTLConvert) {
        super(m);
        this.m_tteTTLConvert = tteTTLConvert;
        this.m_replicatedMgram = replicatedMgram;
        if (this.m_replicatedMgram != null) {
            boolean guaranteed = this.m_replicatedMgram.isGuarenteed();
            if (this.m_replicatedMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                boolean bl = guaranteed = !guaranteed;
            }
            if (!guaranteed && this.m_replicatedMgram.getBrokerHandle().isDbTrackingSet()) {
                this.m_dbTracking = this.m_replicatedMgram.getBrokerHandle().getDbTracking();
                this.m_dbTrackingSet = true;
            }
        }
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public int memoryLength() {
        return s_replicatedMgramPayloadMemSize + this.m_replicatedMgram.memoryLength();
    }

    @Override
    public int length() {
        return 9 + this.m_replicatedMgram.networkLength();
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_tteTTLConvert = StreamUtil.readBoolean(is);
        this.m_dbTrackingSet = StreamUtil.readBoolean(is);
        if (this.m_dbTrackingSet) {
            this.m_dbTracking = StreamUtil.read6ByteLong(is);
        }
        this.m_replicatedMgram = MgramSerializer.getMgramSerializer().unserialize(is, this.m_tteTTLConvert);
    }

    @Override
    protected void syncPayload() {
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeBoolean(this.m_tteTTLConvert, os);
        StreamUtil.writeBoolean(this.m_dbTrackingSet, os);
        if (this.m_dbTrackingSet) {
            StreamUtil.write6ByteLong(this.m_dbTracking, os);
        }
        MgramSerializer.getMgramSerializer().serialize(os, this.m_replicatedMgram, this.m_tteTTLConvert);
    }

    @Override
    protected IReplicatedMgramHandle getReplicatedMgramHandle() {
        return this;
    }

    @Override
    public IMgram getReplicatedMgram() {
        if (this.m_replicatedMgram != null && this.m_dbTrackingSet) {
            this.m_replicatedMgram.getBrokerHandle().setDbTracking(this.m_dbTracking);
        }
        return this.m_replicatedMgram;
    }

    @Override
    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeToStream(baos);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap result = new HashMap();
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
    }
}

