/*
 * Decompiled with CFR 0.152.
 */
package progress.message.resources;

import java.awt.Checkbox;
import java.lang.reflect.Constructor;
import progress.message.resources.CannotCreateResourceException;

public class TranslatableObject {
    Object theObject = null;
    String theClassName = null;
    Object[] theInitializers = null;
    String description = null;
    double maxLength;
    boolean translatable;
    String[] theInitializerClasses = null;
    boolean[] translatables = null;

    public TranslatableObject(Object newObject, String newDescription, double newMaxLength, boolean newTranslate) {
        this.theObject = newObject;
        this.description = newDescription;
        this.maxLength = newMaxLength;
        this.translatable = newTranslate;
    }

    public TranslatableObject(String className, Object[] initializers, String newDescription, double newMaxLength, boolean newTranslate) {
        this.theClassName = new String(className);
        this.theInitializers = initializers;
        this.description = new String(newDescription);
        this.maxLength = newMaxLength;
        this.translatable = newTranslate;
    }

    public TranslatableObject(String className, Object[] initializers, String[] initializerClasses, String newDescription, double newMaxLength, boolean[] newTranslatables) {
        this.theClassName = new String(className);
        this.theInitializers = initializers;
        this.theInitializerClasses = initializerClasses;
        this.description = new String(newDescription);
        this.maxLength = newMaxLength;
        this.translatables = newTranslatables;
    }

    public Object getObject() throws CannotCreateResourceException {
        Constructor theConstructor = null;
        Object newObject = null;
        Class<?> theClass = null;
        Class[] parameterTypes = null;
        if (this.theObject != null) {
            return this.theObject;
        }
        try {
            theClass = Class.forName(this.theClassName);
        }
        catch (ClassNotFoundException exception) {
            throw new CannotCreateResourceException(this.theClassName + ": Invalid class name for Resource");
        }
        if (this.theInitializerClasses != null && this.theInitializerClasses.length > 0) {
            parameterTypes = new Class[this.theInitializerClasses.length];
            for (int i = 0; i < this.theInitializerClasses.length; ++i) {
                try {
                    parameterTypes[i] = Class.forName(this.theInitializerClasses[i]);
                    continue;
                }
                catch (ClassNotFoundException exception) {
                    if ("BOOLEAN".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Boolean.TYPE;
                        continue;
                    }
                    if ("INT".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Integer.TYPE;
                        continue;
                    }
                    if ("SHORT".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Short.TYPE;
                        continue;
                    }
                    if ("LONG".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Long.TYPE;
                        continue;
                    }
                    if ("FLOAT".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Float.TYPE;
                        continue;
                    }
                    if ("DOUBLE".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Double.TYPE;
                        continue;
                    }
                    if ("CHAR".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Character.TYPE;
                        continue;
                    }
                    if ("BYTE".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Byte.TYPE;
                        continue;
                    }
                    if ("VOID".equals(this.theInitializerClasses[i])) {
                        parameterTypes[i] = Void.TYPE;
                        continue;
                    }
                    throw new CannotCreateResourceException(this.theInitializerClasses[i] + ": Invalid class name for Resource initializer");
                }
            }
        } else if (this.theInitializers != null && this.theInitializers.length > 0) {
            parameterTypes = new Class[this.theInitializers.length];
            for (int i = 0; i < this.theInitializers.length; ++i) {
                parameterTypes[i] = this.theInitializers[i].getClass();
            }
        }
        theConstructor = this.getObjectConstructor(theClass, parameterTypes);
        try {
            newObject = theConstructor != null ? theConstructor.newInstance(this.theInitializers) : theClass.newInstance();
        }
        catch (Exception exception) {
            throw new CannotCreateResourceException(this.theClassName + ": Couldn't create instance of this resource");
        }
        return newObject;
    }

    Constructor getObjectConstructor(Class theClass, Class[] parameterClasses) throws CannotCreateResourceException {
        Constructor theConstructor = null;
        try {
            theConstructor = theClass.getConstructor(parameterClasses);
        }
        catch (NoSuchMethodException exception) {
            throw new CannotCreateResourceException(this.theClassName + ": Valid constructor could not be found for this class and its initializers");
        }
        return theConstructor;
    }

    public String getString() throws CannotCreateResourceException {
        Object thisObject = this.theObject == null ? this.getObject() : this.theObject;
        if ("java.awt.Checkbox".equals(this.theClassName)) {
            return ((Checkbox)thisObject).getLabel();
        }
        return thisObject.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public boolean[] getTranslatable() {
        return this.translatables;
    }

    public void setObject(String className, Object[] initializers) throws ClassNotFoundException {
        this.theClassName = className;
        this.theInitializers = initializers;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setMaxLength(double newMaxLength) {
        this.maxLength = newMaxLength;
    }

    public void setTranslatable(boolean[] newTranslatables) {
        if (this.translatables == null) {
            this.translatables = new boolean[newTranslatables.length];
        }
        for (int i = 0; i < this.translatables.length; ++i) {
            this.translatables[i] = newTranslatables[i];
        }
    }
}

