/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import progress.message.broker.Config;
import progress.message.zclient.SessionConfig;

public class ConnectionTuningConfigChangeHandler
implements IAttributeChangeHandler {
    public static void init() {
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                this.attributeModified(newAttributes[i], delta.getNewValue(newAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            try {
                this.attributeModified(modifiedAttributes[i], delta.getNewValue(modifiedAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            this.attributeDeleted(deletedAttributes[i]);
        }
    }

    private void attributeModified(String attribute, Object value) {
        if (attribute.equals("MAX_CONNECTIONS")) {
            Config.MAX_CONNECTIONS = (Integer)value;
        }
        if (attribute.equals("MAX_SESSIONS_PER_CONNECTION")) {
            Config.MAX_SESSIONS_PER_CONNECTION = (Integer)value;
        }
        if (attribute.equals("MAX_TEMPORARY_QUEUES_PER_SESSION")) {
            Config.MAX_TEMPORARY_QUEUES_PER_SESSION = (Integer)value;
        }
        if (attribute.equals("MAX_MSG_SIZE")) {
            SessionConfig.setMaxMsgSize((Integer)value);
        }
    }

    private void attributeDeleted(String attribute) {
        if (attribute.equals("MAX_CONNECTIONS")) {
            Config.MAX_CONNECTIONS = -1;
        }
        if (attribute.equals("MAX_SESSIONS_PER_CONNECTION")) {
            Config.MAX_SESSIONS_PER_CONNECTION = -1;
        }
        if (attribute.equals("MAX_TEMPORARY_QUEUES_PER_SESSION")) {
            Config.MAX_TEMPORARY_QUEUES_PER_SESSION = -1;
        }
        if (attribute.equals("MAX_MSG_SIZE")) {
            SessionConfig.setMaxMsgSize(SessionConfig.MAX_MSG_SIZE_BROKER_DEFAULT);
        }
    }
}

