/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.IClientContextTracker;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.EPermissionConflict;
import progress.message.security.EUnknownPermission;
import progress.message.security.SecurityCache;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.SessionConfig;

public class RemoveACLChangeHandler
implements IAttributeChangeHandler {
    private String m_principalName = null;
    private String m_principalType = null;
    private String m_resourceName = null;
    private String m_aclType = null;

    public RemoveACLChangeHandler(String principalName, String principalType, String resourceName, String aclType) {
        this.m_principalName = principalName;
        this.m_principalType = principalType;
        this.m_resourceName = resourceName;
        this.m_aclType = aclType;
    }

    public void itemDeleted() {
        ProgressPrincipal p = null;
        p = this.m_principalType.equalsIgnoreCase("GROUP") ? AgentRegistrar.getAgentRegistrar().getSecurityBean().getGroup(this.m_principalName) : AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(this.m_principalName);
        if (p == null) {
            if (this.m_principalType.equalsIgnoreCase("GROUP")) {
                p = new ProgressGroup(this.m_principalName);
                ((ProgressPrincipal)p).setInternalPrincipal(false);
                ((ProgressPrincipal)p).setCreatedDueToACLEntry(true);
            } else {
                p = new ProgressPasswordUser(this.m_principalName, "");
                ((ProgressPrincipal)p).setInternalPrincipal(false);
                ((ProgressPrincipal)p).setCreatedDueToACLEntry(true);
            }
        }
        if (p != null) {
            if (this.m_aclType.equals("ROUTING_USER_ACL")) {
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().delRoutingUserAclEntry(this.m_resourceName, p);
                }
                catch (IOException iOException) {}
            } else {
                try {
                    SubjectAclEntry delEntryPos = new SubjectAclEntry(p);
                    SubjectAclEntry delEntryNeg = new SubjectAclEntry(p);
                    this.setSubjectACLPermissions(this.m_aclType, "GRANT", delEntryPos);
                    this.setSubjectACLPermissions(this.m_aclType, "DENY", delEntryNeg);
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().delAclEntry(this.m_resourceName, delEntryPos);
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().delAclEntry(this.m_resourceName, delEntryNeg);
                }
                catch (IOException delEntryPos) {
                    // empty catch block
                }
            }
            try {
                if (!((ProgressPrincipal)p).isInternalPrincipal()) {
                    boolean delEntryPos = this.removeExternalPrincipal();
                }
            }
            catch (Exception e) {
                SessionConfig.logMessage(e.getMessage(), e, SessionConfig.getLevelInfo());
            }
            this.m_principalName = null;
            this.m_principalType = null;
            this.m_resourceName = null;
            this.m_aclType = null;
        }
    }

    public void itemModified(Object newValue) {
    }

    private final boolean removeExternalPrincipal() {
        Hashtable<String, Vector<RoutingUserAclEntry>> routingUserACLEntries;
        ProgressPasswordUser p;
        ProgressGroup g;
        SecurityCache cache = Broker.getBroker().getSecurityCache();
        if (cache == null) {
            return false;
        }
        if (this.m_principalType.equalsIgnoreCase("GROUP") ? (g = AgentRegistrar.getAgentRegistrar().getSecurityBean().getGroup(this.m_principalName)).isInternalPrincipal() : (p = AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(this.m_principalName)).isInternalPrincipal()) {
            return false;
        }
        boolean isAdditionalACLEntryExists = false;
        Hashtable<String, Vector<SubjectAclEntry>> subjectACLEntries = cache.getSubjectACLEntries();
        if (subjectACLEntries != null && !subjectACLEntries.isEmpty()) {
            for (String key : subjectACLEntries.keySet()) {
                if (key != null && !SessionConfig.isSystemSubject(key) && !key.startsWith("SonicMQ.mf")) {
                    try {
                        Vector<SubjectAclEntry> value = subjectACLEntries.get(key);
                        this.traceKeyAndValue(key, value);
                        Enumeration<SubjectAclEntry> enumeration = value.elements();
                        while (enumeration.hasMoreElements()) {
                            SubjectAclEntry subjectACLEntry = enumeration.nextElement();
                            if (subjectACLEntry == null) continue;
                            Principal principal = subjectACLEntry.getPrincipal();
                            isAdditionalACLEntryExists = this.checkAdditionalACLEntry(isAdditionalACLEntryExists, principal);
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                if (!isAdditionalACLEntryExists) continue;
                break;
            }
        }
        if ((routingUserACLEntries = cache.getRoutingUserACLEntries()) != null && !routingUserACLEntries.isEmpty() && !isAdditionalACLEntryExists) {
            for (String key : routingUserACLEntries.keySet()) {
                if (key != null && !SessionConfig.isSystemSubject(key) && !key.startsWith("SonicMQ.mf")) {
                    try {
                        Vector<RoutingUserAclEntry> value = routingUserACLEntries.get(key);
                        this.traceKeyAndValue(key, value);
                        Enumeration<RoutingUserAclEntry> enumeration = value.elements();
                        while (enumeration.hasMoreElements()) {
                            RoutingUserAclEntry routingUserAclEntry = enumeration.nextElement();
                            if (routingUserAclEntry == null) continue;
                            Principal principal = routingUserAclEntry.getPrincipal();
                            isAdditionalACLEntryExists = this.checkAdditionalACLEntry(isAdditionalACLEntryExists, principal);
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                if (!isAdditionalACLEntryExists) continue;
                break;
            }
        }
        if (isAdditionalACLEntryExists) {
            return false;
        }
        if (this.m_principalType.equalsIgnoreCase("GROUP")) {
            ProgressGroup g2 = AgentRegistrar.getAgentRegistrar().getSecurityBean().getGroup(this.m_principalName);
            if (g2 != null && g2.isCreatedDueToACLEntry()) {
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().delGroup(this.m_principalName);
                    return true;
                }
                catch (IOException key) {}
            }
        } else {
            ProgressPasswordUser p2 = AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(this.m_principalName);
            if (p2 != null && p2.isCreatedDueToACLEntry()) {
                p2.setCreatedDueToACLEntry(false);
                Broker.getBroker().getSecurityCache().addUser(p2);
            }
            String userName = p2 == null ? null : p2.getName();
            IClientContextTracker ccTracker = AgentRegistrar.getClientContextTracker();
            if (ccTracker != null && ccTracker.getCurrentClientContextUsage(userName) > 0) {
                return false;
            }
            return AgentRegistrar.getAgentRegistrar().removeExternalUserFromSecBean(userName);
        }
        return false;
    }

    private void traceKeyAndValue(String key, Object value) {
    }

    private boolean checkAdditionalACLEntry(boolean isAdditionalACLEntryExistsParam, Principal principal) {
        boolean isAdditionalACLEntryExists = isAdditionalACLEntryExistsParam;
        if (principal != null && principal.getName().equals(this.m_principalName)) {
            isAdditionalACLEntryExists = true;
        }
        return isAdditionalACLEntryExists;
    }

    private void setSubjectACLPermissions(String aclType, String permission, SubjectAclEntry sae) {
        try {
            if (permission.equalsIgnoreCase("GRANT")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)4);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)8);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            } else if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                sae.addPermission((byte)-2);
            } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                sae.addPermission((byte)-3);
            } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                sae.addPermission((byte)-5);
            } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                sae.addPermission((byte)-2);
            } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                sae.addPermission((byte)-3);
            } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                sae.addPermission((byte)-9);
            } else {
                BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
            }
        }
        catch (EPermissionConflict ePermissionConflict) {
        }
        catch (EUnknownPermission eUnknownPermission) {
            // empty catch block
        }
    }
}

