/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.MessageHandlingException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import progress.message.jclient.Header;
import progress.message.jclient.MessagePart;
import progress.message.jclient.Part;
import progress.message.jimpl.Message;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.msg.IMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;

public abstract class Mgram2Http {
    protected byte[] m_buffer = null;
    protected int m_length = 0;
    protected int m_offset = 0;
    protected String m_contentType = null;
    protected String m_method = "POST";
    protected String m_charset = null;
    private Hashtable m_invalidHeaders = new Hashtable();

    public abstract void setProperty(String var1, String var2);

    public abstract void setProperty(String var1, boolean var2);

    public abstract void setProperty(String var1, long var2);

    public abstract void setProperty(String var1, int var2);

    public void setContentLength(int length) {
        this.setProperty("Content-Length", length);
    }

    public void setContentType(String type) {
        this.setProperty("Content-Type", type);
        this.m_contentType = type;
    }

    public void setContent(byte[] buffer, int offset, int length) {
        this.m_buffer = buffer;
        this.m_offset = offset;
        this.m_length = length;
    }

    public void contentToStream(OutputStream stream) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(stream);
            if (this.m_buffer != null && this.m_length > 0) {
                out.write(this.m_buffer, this.m_offset, this.m_length);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    protected static String getStringProperty(IMgram mgram, String name) {
        ISidebandData side = mgram.getSidebandData();
        Object property = side.getProperties().get(name);
        if (property == null) {
            return null;
        }
        if (property instanceof String) {
            return (String)property;
        }
        if (property instanceof Boolean) {
            return ((Boolean)property).toString();
        }
        if (property instanceof Number) {
            return ((Number)property).toString();
        }
        return null;
    }

    public static String getMessageType(IMgram mgram) {
        ISidebandData side = mgram.getSidebandData();
        switch (side.getBodyType()) {
            case 2: {
                return "BYTES";
            }
            case 6: {
                return "TEXT";
            }
            case 7: {
                return "XML";
            }
            case 1: {
                String ext = Mgram2Http.getStringProperty(mgram, "JMS_SonicMQ_ExtendedType");
                if (ext == null || !ext.equals("x-sonicmq-multipart")) break;
                return "MULTIPART";
            }
        }
        return null;
    }

    protected String getMessageID(IMgram mgram) {
        ISidebandData side = mgram.getSidebandData();
        StringBuffer id = new StringBuffer("ID:");
        id.append(Long.toHexString(side.getBrokerID())).append(':');
        id.append(Long.toHexString(side.getConnectionAndLocalID())).append(':');
        id.append(Long.toHexString(side.getTimestamp()).toUpperCase());
        return id.toString();
    }

    protected String getDeliveryMode(IMgram mgram) {
        String deliveryMode = "NON_PERSISTENT";
        if (mgram.isJMSPersistent()) {
            deliveryMode = mgram.isNonPersistentReplicated() ? "NON_PERSISTENT_REPLICATED" : "PERSISTENT";
        } else if (mgram.isDiscardable()) {
            deliveryMode = "DISCARDABLE";
        }
        return deliveryMode;
    }

    protected String getType(IMgram mgram) {
        return mgram.getSidebandData().getType();
    }

    protected String getCorrelationID(IMgram mgram) {
        return mgram.getSidebandData().getCorrelationID();
    }

    protected int getPriority(IMgram mgram) {
        return mgram.getPriority();
    }

    protected long getTimeToLive(IMgram mgram) {
        if (mgram.isTTE()) {
            return mgram.getTTE() - System.currentTimeMillis();
        }
        return 0L;
    }

    protected String getDestinationQueue(IMgram mgram) {
        ISubject s = mgram.getSubject();
        if (s.isQueue()) {
            return s.getJMSName();
        }
        return null;
    }

    protected String getDestinationTopic(IMgram mgram) {
        ISubject s = mgram.getSubject();
        if (!s.isQueue()) {
            return s.getJMSName();
        }
        return null;
    }

    protected String getReplyToQueue(IMgram mgram) {
        try {
            String subject = mgram.getSidebandData().getReplyTo();
            if (subject != null && subject.length() != 0 && subject.startsWith("$Q.")) {
                return subject.substring("$Q.".length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getReplyToTopic(IMgram mgram) {
        String subject = mgram.getSidebandData().getReplyTo();
        if (subject != null && subject.length() != 0 && !subject.startsWith("$Q.")) {
            return subject;
        }
        return null;
    }

    protected long getTimestamp(IMgram mgram) {
        return mgram.getSidebandData().getTimestamp();
    }

    protected String getNotifyUndeliv(IMgram mgram) {
        return Mgram2Http.getStringProperty(mgram, "JMS_SonicMQ_notifyUndelivered");
    }

    protected String getPreserveUndeliv(IMgram mgram) {
        return Mgram2Http.getStringProperty(mgram, "JMS_SonicMQ_preserveUndelivered");
    }

    protected String getDestinationUndeliv(IMgram mgram) {
        return Mgram2Http.getStringProperty(mgram, "JMS_SonicMQ_destinationUndelivered");
    }

    protected String getGroupID(IMgram mgram) {
        return Mgram2Http.getStringProperty(mgram, "JMSXGroupID");
    }

    protected String getGroupSeq(IMgram mgram) {
        return Mgram2Http.getStringProperty(mgram, "JMSXGroupSeq");
    }

    protected void handleMultipartContent(IMgram mgram) throws MessageHandlingException {
        try {
            MultipartMessage multiMessage = new MultipartMessage(new Envelope(new progress.message.zclient.Message(mgram.getRawBody())));
            MimeMultipart mimeMessage = new MimeMultipart("related");
            for (int i = 0; i < multiMessage.getPartCount(); ++i) {
                Part msgPart = multiMessage.getPart(i);
                byte[] partContent = this.getMsgPartBody(msgPart);
                MimeBodyPart mimePart = new MimeBodyPart(new InternetHeaders(), partContent);
                Header header = msgPart.getHeader();
                Enumeration keys = header.getHeaderFieldNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = header.getHeaderField(key);
                    mimePart.setHeader(key, value);
                }
                boolean isJMSMessage = msgPart.isMessagePart();
                if (msgPart.isMessagePart()) {
                    mimePart.setHeader("XSonicContentType", header.getContentType());
                }
                String contentType = this.mapSonicTypeToMIMEType(header.getContentType());
                mimePart.setHeader("Content-Type", contentType);
                mimeMessage.addBodyPart((BodyPart)mimePart);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)bos);
            this.setContent(bos.toByteArray(), 0, bos.size());
            this.setContentLength(bos.size());
            String contentType = this.m_contentType;
            if (contentType == null || !contentType.startsWith("multipart/")) {
                contentType = "multipart/related";
            }
            String mimeContentType = mimeMessage.getContentType();
            String boundary = null;
            String boundaryKey = "boundary=";
            int startBoundary = mimeContentType.indexOf(boundaryKey) + boundaryKey.length();
            int endBoundary = mimeContentType.indexOf(";", startBoundary);
            if (endBoundary == -1) {
                endBoundary = mimeContentType.length();
            }
            boundary = mimeContentType.substring(startBoundary, endBoundary);
            contentType = HttpHelper.resetBoundary(contentType, boundary);
            this.setProperty("Content-Type", contentType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MessageHandlingException("Multipart message content is not valid", e);
        }
    }

    private void handleSinglepartContent(IMgram mgram) throws MessageHandlingException {
        short t;
        byte[] body = mgram.getRawBody();
        if (body == null) {
            this.setContentLength(0);
            return;
        }
        ISidebandData sd = mgram.getSidebandData();
        if (sd != null && ((t = sd.getBodyType()) == 6 || t == 7)) {
            if (this.m_charset == null) {
                this.m_charset = "ISO-8859-1";
            }
            String s = null;
            try {
                progress.message.zclient.Message m = new progress.message.zclient.Message(body);
                s = m.readUTF();
                if (s == null) {
                    throw new NullPointerException("s is null at " + this.getClass().getName() + ".handleSinglepartContent(IMgram mgram)");
                }
                body = s.getBytes(this.m_charset);
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Unsupported encoding, setting to default.");
                try {
                    this.m_charset = "ISO-8859-1";
                    String newType = HttpHelper.resetCharset(this.m_contentType, this.m_charset);
                    this.setContentType(newType);
                    if (s == null) {
                        throw new NullPointerException("'s' cannot be null.");
                    }
                    body = s.getBytes("ISO-8859-1");
                }
                catch (Exception e2) {
                    this.m_charset = null;
                    String newType = HttpHelper.resetCharset(this.m_contentType, this.m_charset);
                    this.setContentType(newType);
                    if (s != null) {
                        body = s.getBytes();
                    }
                }
            }
            catch (Exception e) {
                throw new MessageHandlingException(e.getMessage(), e);
            }
        }
        this.setContent(body, 0, body.length);
        this.setContentLength(body.length);
    }

    public void handleContent(IMgram mgram) throws MessageHandlingException {
        String type = Mgram2Http.getMessageType(mgram);
        if (type != null && type.equalsIgnoreCase("MULTIPART")) {
            this.handleMultipartContent(mgram);
        } else {
            this.handleSinglepartContent(mgram);
        }
    }

    protected boolean isIgnoredJMSProperty(String key) {
        return HttpHelper.isIgnoredJMSProperty(key);
    }

    protected static boolean isGetRequest(IMgram mgram) {
        String requestMethod;
        Object value = mgram.getSidebandData().getProperties().get("X-HTTP-RequestMethod");
        return value != null && (requestMethod = ((String)value).trim()).equalsIgnoreCase("GET");
    }

    public void handleCopyAllProperties(IMgram mgram) {
        Hashtable table = mgram.getSidebandData().getProperties();
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Object value;
            String key = (String)keys.nextElement();
            if (key != null && key.equalsIgnoreCase("X-HTTP-RequestMethod")) {
                this.m_method = (String)table.get(key);
                if (this.m_method == null) continue;
                this.m_method = this.m_method.trim();
                continue;
            }
            if (key == null || this.isIgnoredJMSProperty(key) || (value = table.get(key)) == null) continue;
            if (this.isInvalidHeader(key)) {
                this.m_invalidHeaders.put(key, value);
                continue;
            }
            if (key.indexOf(":") > 0) {
                key = key.replace(':', '\u00ff');
            }
            this.setProperty(key, value.toString());
        }
    }

    public void handleContentType(IMgram mgram) {
        this.handleEncodedContentType(mgram, "ISO-8859-1");
    }

    public void handleEncodedContentType(IMgram mgram, String defaultEncoding) {
        ISidebandData side = mgram.getSidebandData();
        short bodyType = side.getBodyType();
        Hashtable table = side.getProperties();
        String contentType = (String)table.get("Content-Type");
        String contentStr = "application/octet-stream";
        if (contentType != null && !contentType.equals("")) {
            contentStr = contentType;
        } else {
            switch (bodyType) {
                case 6: {
                    contentStr = "text/plain";
                    break;
                }
                case 7: {
                    contentStr = "text/xml";
                    break;
                }
                case 1: {
                    String ext = Mgram2Http.getStringProperty(mgram, "JMS_SonicMQ_ExtendedType");
                    if (ext == null || !ext.equals("x-sonicmq-multipart")) break;
                    contentStr = "Multipart/Related";
                }
            }
        }
        if (bodyType == 6 || bodyType == 7) {
            if (contentType != null) {
                this.m_charset = HttpHelper.extractCharset(contentType);
            }
            if (this.m_charset == null) {
                this.m_charset = defaultEncoding;
            }
        }
        this.setContentType(contentStr);
    }

    public Hashtable getInvalidHeaders() {
        return this.m_invalidHeaders;
    }

    private boolean isInvalidHeader(String header) {
        int posR = header.lastIndexOf("}");
        if (posR == -1) {
            return false;
        }
        int posL = header.indexOf("{");
        if (posL == -1) {
            return false;
        }
        return posR > posL;
    }

    private String mapSonicTypeToMIMEType(String contentType) {
        String TEXT_MESSAGE_TYPE = "application/x-sonicmq-textmessage";
        String XML_MESSAGE_TYPE = "application/x-sonicmq-xmlmessage";
        String returnType = contentType;
        if (contentType != null && contentType.startsWith("application/x-sonicmq")) {
            returnType = contentType.equals("application/x-sonicmq-textmessage") ? "text/plain" : (contentType.equals("application/x-sonicmq-xmlmessage") ? "text/xml" : "application/octet-stream");
        }
        return returnType;
    }

    byte[] getMsgPartBody(Part msgPart) throws Exception {
        if (!msgPart.isMessagePart()) {
            return msgPart.getContentBytes();
        }
        MessagePart mp = (MessagePart)msgPart;
        Message jmsMsg = (Message)((Object)mp.getMessage());
        byte[] bodyWithSize = jmsMsg.getEnvelope().getMessage().getBody();
        int arraySize = bodyWithSize.length;
        byte[] body = new byte[arraySize - 4];
        System.arraycopy(bodyWithSize, 4, body, 0, body.length);
        return body;
    }
}

