/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.common;

import java.net.URL;
import java.util.Enumeration;
import javax.jms.Destination;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.util.AddressingUtils;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AddrUtil;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Topic;
import progress.message.msg.IMgram;

public class AddressBinder {
    private static final String FAULTSTO_POSTFIX = "/wsa/From/JMS";
    private static final String FROM_POSTFIX = "/wsa/From/JMS";
    private static final String ACKSTO_POSTFIX = "/wsa/From/JMS";
    private static final String REPLYTO_POSTFIX = "/wsa/From/JMS";
    public static long BROKER_ID = AddrUtil.stringToClientId(Config.BROKER_NAME, "Broker");

    public static Destination getReplyToDestination(IMgram mgram) {
        String d = mgram.getSidebandData().getReplyTo();
        return AddressBinder.internalStrToDestination(d);
    }

    public static Destination getFaultToDestination(IMgram mgram) {
        String internalFaultDest = (String)mgram.getSidebandData().getProperty("X-WS-SequenceFaultDestination");
        if (internalFaultDest == null) {
            internalFaultDest = mgram.getSidebandData().getReplyTo();
        }
        return AddressBinder.internalStrToDestination(internalFaultDest);
    }

    public static String destinationToReplyToStr(Destination d) {
        try {
            if (d == null) {
                return null;
            }
            if (d instanceof progress.message.jclient.Queue) {
                String qn = ((progress.message.jclient.Queue)d).getQueueName();
                return new Queue(qn).getSubject().getSubjectString();
            }
            String tn = ((progress.message.jclient.Topic)d).getTopicName();
            return new Topic(tn).getSubject().getSubjectString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String destinationToInternalStr(Destination d) {
        try {
            if (d == null) {
                return null;
            }
            if (d instanceof progress.message.jclient.Queue) {
                return "$Q." + ((progress.message.jclient.Queue)d).getQueueName();
            }
            return ((progress.message.jclient.Topic)d).getTopicName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Destination internalStrToDestination(String s) {
        try {
            if (s != null && s.length() != 0) {
                if (s.startsWith("$Q.")) {
                    String qprime;
                    String qprime2 = qprime = s.substring("$Q.".length());
                    int nodeSepIdx = qprime.indexOf("::");
                    if (nodeSepIdx != -1) {
                        String nodeName = qprime.substring(0, nodeSepIdx);
                        if (Config.ROUTING_NODE_NAME != null && nodeName != null && nodeName.equals(Config.ROUTING_NODE_NAME)) {
                            qprime2 = qprime.substring(nodeSepIdx + "::".length());
                        }
                    }
                    return new progress.message.jclient.Queue(qprime2);
                }
                return new progress.message.jclient.Topic(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long getWSABrokerId(String requestPath) {
        if (requestPath.startsWith("/wsa/From/JMS") || requestPath.startsWith("/wsa/From/JMS") || requestPath.startsWith("/wsa/From/JMS")) {
            int mark1 = requestPath.indexOf("/JMS/") + 5;
            int mark2 = requestPath.indexOf("/", mark1);
            return AddressBinder.notationToBrokerId(requestPath.substring(mark1, mark2));
        }
        return BROKER_ID;
    }

    public static Destination getWSADestination(String requestPath) {
        if (requestPath.startsWith("/wsa/From/JMS") || requestPath.startsWith("/wsa/From/JMS") || requestPath.startsWith("/wsa/From/JMS")) {
            int mark1 = requestPath.indexOf("/JMS/") + 5;
            int mark2 = requestPath.indexOf("/", mark1) + 1;
            return AddressBinder.notationToDest(requestPath.substring(mark2));
        }
        return null;
    }

    public static boolean isInternallyGeneratedWSAAddress(String s) {
        return s.startsWith("/wsa/From/JMS") || s.startsWith("/wsa/From/JMS") || s.startsWith("/wsa/From/JMS") || s.startsWith("/wsa/From/JMS");
    }

    public static boolean isInternallyGeneratedWSAFrom(String s) {
        return s.startsWith("/wsa/From/JMS");
    }

    public static boolean isInternallyGeneratedWSAReplyTo(String s) {
        return s.startsWith("/wsa/From/JMS");
    }

    public static boolean isInternallyGeneratedWSAFaultTo(String s) {
        return s.startsWith("/wsa/From/JMS");
    }

    public static EndpointReference bindFaultsTo(String acceptorName, Destination dest) throws Exception {
        return AddressBinder.bindAddress(acceptorName, AddressBinder.getFaultsToPath(dest));
    }

    public static EndpointReference bindFrom(String acceptorName, Destination dest) throws Exception {
        return AddressBinder.bindAddress(acceptorName, AddressBinder.getFromPath(dest));
    }

    public static EndpointReference bindAcksTo(String acceptorName) throws Exception {
        return AddressBinder.bindAddress(acceptorName, AddressBinder.getAcksToPath());
    }

    public static EndpointReference bindReplyTo(String acceptorName, Destination dest) throws Exception {
        return AddressBinder.bindAddress(acceptorName, AddressBinder.getReplyToPath(dest));
    }

    public static String getFaultsToPath(Destination dest) throws Exception {
        return "/wsa/From/JMS/" + AddressBinder.brokerIdToNotation() + "/" + AddressBinder.destToNotation(dest);
    }

    public static String getFromPath(Destination dest) throws Exception {
        return "/wsa/From/JMS/" + AddressBinder.brokerIdToNotation() + "/" + AddressBinder.destToNotation(dest);
    }

    public static String getAcksToPath() throws Exception {
        return "/wsa/From/JMS";
    }

    public static String getReplyToPath(Destination dest) throws Exception {
        return "/wsa/From/JMS/" + AddressBinder.brokerIdToNotation() + "/" + AddressBinder.destToNotation(dest);
    }

    private static String brokerIdToNotation() {
        return Long.toString(BROKER_ID);
    }

    private static long notationToBrokerId(String notn) {
        return Long.parseLong(notn);
    }

    private static String destToNotation(Destination dest) {
        if (dest == null) {
            return "UNDEFINED";
        }
        try {
            if (dest instanceof progress.message.jclient.Queue) {
                return "Q/" + ((progress.message.jclient.Queue)dest).getQueueName();
            }
            if (dest instanceof progress.message.jclient.Topic) {
                return "T/" + ((progress.message.jclient.Topic)dest).getTopicName();
            }
            return "UNDEFINED";
        }
        catch (Exception e) {
            return "UNDEFINED";
        }
    }

    private static Destination notationToDest(String notn) {
        try {
            if (notn.startsWith("Q/")) {
                return new progress.message.jclient.Queue(notn.substring(2));
            }
            return new progress.message.jclient.Topic(notn.substring(2));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EndpointReference bindAddress(String acceptorName, String path) throws Exception {
        Enumeration htae;
        if (acceptorName != null && (htae = AcceptorHolder.getAcceptorHolder().getAcceptors(acceptorName)) != null && htae.hasMoreElements()) {
            HTTPAcceptor hta = (HTTPAcceptor)htae.nextElement();
            return AddressBinder.bindURL(hta, path);
        }
        return AddressBinder.bindAnonymous();
    }

    public static EndpointReference bindAnonymous() throws Exception {
        return AddressBinder.bindURL(new URL(AddressingUtils.getAnonymousRoleURI()));
    }

    public static EndpointReference bindURL(HTTPAcceptor hta, String path) throws Exception {
        String u = hta.getExternalURL();
        if (u == null) {
            u = hta.getURL();
        }
        return AddressBinder.bindURL(u, path);
    }

    public static EndpointReference bindURL(String baseurl, String path) throws Exception {
        String a2 = baseurl + path;
        Address A2 = null;
        A2 = new Address(a2);
        return new EndpointReference(A2);
    }

    public static EndpointReference bindURL(URL fullUrl) throws Exception {
        Address A2 = null;
        A2 = new Address(fullUrl.toString());
        return new EndpointReference(A2);
    }
}

