/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.sender.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.soap.SOAPUtils;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import com.sonicsw.ws.addressing.AddressingUtils;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.rm.common.CreateOperationContext;
import com.sonicsw.ws.rm.common.OfferContext;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.Accept;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.CreateSequenceResponse;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.Expires;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.protocol.prAccessor;
import com.sonicsw.ws.rm.receiver.fsm.InitialReceiveState;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.sender.fsm.AckEvent;
import com.sonicsw.ws.rm.sender.fsm.CreateSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.CreateSequenceResponseEvent;
import com.sonicsw.ws.rm.sender.fsm.ExpiresEvent;
import com.sonicsw.ws.rm.sender.fsm.ISendState;
import com.sonicsw.ws.rm.sender.fsm.InactivityTimeoutEvent;
import com.sonicsw.ws.rm.sender.fsm.NackEvent;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import com.sonicsw.ws.rm.sender.fsm.RequestTerminateEvent;
import com.sonicsw.ws.rm.sender.fsm.RetransmitTimeoutEvent;
import com.sonicsw.ws.rm.sender.fsm.SendCompleteEvent;
import com.sonicsw.ws.rm.sender.fsm.TerminateSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.TerminateSequenceResponseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.Destination;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.axis.message.addressing.To;
import org.apache.axis.types.URI;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.msg.IMgram;

public abstract class BaseSendState
implements ISendState {
    @Override
    public void expiresTimeout(ExpiresEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        support.faultSequence(this.makeTerminateFault(support));
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public abstract void retransmitTimeout(RetransmitTimeoutEvent var1);

    @Override
    public void inactivityTimeout(InactivityTimeoutEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        support.faultSequence(this.makeTerminateFault(support));
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void terminateSequence(TerminateSequenceEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
    }

    @Override
    public void terminateSequenceResponse(TerminateSequenceResponseEvent e) {
        RMSendSequence support;
        this.traceFSM(e);
        WSHttpOutRequest request = (WSHttpOutRequest)e.getContext().getProperty("com.sonicsw.net.http.HttpOutRequest");
        if (request != null) {
            try {
                Message dummy = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants(request.getSoapVersion()));
                e.getContext().setResponseMessage(dummy);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if ((support = (RMSendSequence)e.getSequence()) == null) {
            return;
        }
        support.markForTermination(null);
        RMManager rmm = RMManager.getRMManager();
        rmm.onSequenceTermination(support.getId());
        support.faultSequence(this.makeTerminateFault(support), false, false);
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void sendCompleted(SendCompleteEvent e) {
        this.traceFSM(e);
        MessageContext mc = e.getContext();
        SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
        EndpointReference epr = null;
        try {
            epr = new EndpointReference(new Address(mc.getStrProp("transport.url")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RMSendSequence support = this.registerSendSequence(epr, capsule.getId(), mc, (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy"), true, null, Long.MAX_VALUE, false);
        ReliableMessageWrapper rmc = support.getSequenceState().retrieveMessage(capsule.getNr());
        if (rmc == null) {
            rmc = this.createSendMessageWrapper(mc, capsule);
            support.getSequenceState().setLastActivity(System.currentTimeMillis());
            support.getSequenceState().insertProducedMessage(rmc);
        } else if (this.isProducerDuplicate(rmc, mc)) {
            this.eliminateProducerDuplicate(mc, support);
            return;
        }
        rmc.setLastSentTime(System.currentTimeMillis());
        rmc.incrementTransmissionCount();
    }

    private boolean isProducerDuplicate(ReliableMessageWrapper queuedRMW, MessageContext prodMC) {
        IMgram prodMgram;
        MessageContext queuedMC = queuedRMW.getMsgContext();
        if (queuedMC == null) {
            return false;
        }
        IMgram queuedMgram = (IMgram)queuedMC.getProperty("progress.message.msg.IMgram");
        if (queuedMgram == null) {
            queuedMgram = (IMgram)queuedMC.getProperty("COM_SONIC_RESPONSEMGRAM");
        }
        return (prodMgram = BaseSendState.initProdMgram(prodMC)) != queuedMgram;
    }

    private void eliminateProducerDuplicate(MessageContext prodMC, RMSendSequence support) {
        IMgram prodMgram = BaseSendState.initProdMgram(prodMC);
        support.ack(prodMgram);
    }

    private static IMgram initProdMgram(MessageContext prodMC) {
        IMgram prodMgram = (IMgram)prodMC.getProperty("progress.message.msg.IMgram");
        if (prodMgram == null) {
            prodMgram = (IMgram)prodMC.getProperty("COM_SONIC_RESPONSEMGRAM");
        }
        return prodMgram;
    }

    @Override
    public void ack(AckEvent e) {
        this.traceFSM(e);
        MessageContext mc = e.getContext();
        SequenceAcknowledgement a = e.getAcknowledgement();
        String id = a.getIdentifier().getIdentifier();
        RMSendSequence support = this.getSendSequence(mc, id);
        if (support != null) {
            support.getSequenceState().updateAckedMessages(a, support);
            boolean anonEPR = AddressingUtils.isAnonymousURI(support.getSequenceState().getEndpointReference().getAddress().toString());
            if (support.getSequenceState().isAllAcknowledged()) {
                if (anonEPR) {
                    BrokerComponent.getComponentContext().logMessage("Issuing TerminateSequence to an anonymous destination for reliable send sequence:" + id, BrokerComponent.getLevelWarning().intValue());
                    mc.setProperty("COM_SONIC_TERMINATE_SEQUENCE_TO_ANONYMOUS", (Object)id);
                    return;
                }
                RequestTerminateEvent evt = new RequestTerminateEvent();
                evt.setSequence(support);
                evt.setContext(mc);
                support.enqueue(evt, 12);
            } else if (anonEPR) {
                mc.setProperty("COM_SONIC_RESEND_SEQUENCE_TO_ANONYMOUS", (Object)id);
                return;
            }
        }
    }

    public AxisFault makeTerminateSequenceRefusedFault(RMSequenceSupport support) {
        AxisFault terminateFault = new AxisFault();
        Constants rmc = support.getConstants();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "TerminateSequenceRefused", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, support.getId());
        terminateFault.setFaultReason(prAccessor.getString("REASON_TERMINATE_REFUSED"));
        return terminateFault;
    }

    public AxisFault makeTerminateFault(RMSequenceSupport support) {
        return SequenceFault.makeSequenceTerminatedFault(support.getConstants(), support.getId());
    }

    @Override
    public abstract void nack(NackEvent var1);

    @Override
    public void createSequence(CreateSequenceEvent e) {
        this.traceFSM(e);
        RMPolicy policy = (RMPolicy)e.getContext().getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
        if (!policy.getSequenceCreation()) {
            WSHttpOutRequest request = (WSHttpOutRequest)e.getContext().getProperty("com.sonicsw.net.http.HttpOutRequest");
            try {
                Constants RMConstants = (Constants)e.getContext().getProperty("COM_SONIC_WS_RM_CONSTANTS");
                Message m = e.getContext().getRequestMessage();
                ReliableHeaders rh = new ReliableHeaders();
                rh.fromSOAPEnvelope(m.getSOAPEnvelope());
                AddressingHeaders ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)m.getSOAPEnvelope());
                SOAPEnvelope se = ElementCreator.createCreateSequenceResponseEnvelope(ElementCreator.generateUUID(), ah, e.getContext().getSOAPConstants(), RMConstants);
                Message dummy = new Message((Object)se);
                e.getContext().setResponseMessage(dummy);
                e.getContext().setPastPivot(true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                To to;
                Constants RMConstants = (Constants)e.getContext().getProperty("COM_SONIC_WS_RM_CONSTANTS");
                AcksTo a2 = new AcksTo(RMConstants);
                OfferContext offerContext = null;
                AddressingHeaders headers = (AddressingHeaders)e.getContext().getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
                EndpointReference replyto = headers.getReplyTo();
                a2.setAddress(replyto);
                Message m = e.getContext().getRequestMessage();
                SOAPEnvelope se = m.getSOAPEnvelope();
                SOAPBody sb = (SOAPBody)se.getBody();
                SOAPHeader sh = (SOAPHeader)se.getHeader();
                SOAPBodyElement createBodyElement = null;
                MessageElement offerBodyElement = null;
                MessageElement offerIdentifierBodyElement = null;
                MessageElement offerExpiresBodyElement = null;
                MessageElement expiresBodyElement = null;
                MessageID createMessageID = headers.getMessageID();
                if (createMessageID == null) {
                    createMessageID = new MessageID(new URI(ElementCreator.generateUUID()));
                    headers.setMessageID(createMessageID);
                }
                if ((to = headers.getTo()) == null) {
                    headers.setTo(new To(e.getContext().getStrProp("transport.url")));
                }
                String offerId = null;
                createBodyElement = (SOAPBodyElement)sb.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "CreateSequence"));
                long expires = Long.MAX_VALUE;
                if (createBodyElement != null) {
                    expiresBodyElement = createBodyElement.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Expires"));
                    expires = this.retrieveOfferExpires(expiresBodyElement, (MessageElement)createBodyElement, e, RMConstants);
                    Destination internalFaultDest = null;
                    IMgram mout = (IMgram)e.getContext().getProperty("progress.message.msg.IMgram");
                    if (mout != null) {
                        internalFaultDest = AddressBinder.getFaultToDestination(mout);
                    }
                    if ((offerBodyElement = createBodyElement.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Offer"))) != null) {
                        offerIdentifierBodyElement = offerBodyElement.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Identifier"));
                        offerExpiresBodyElement = offerBodyElement.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Expires"));
                        if (offerIdentifierBodyElement != null) {
                            long offerExpires = Long.MAX_VALUE;
                            offerExpires = this.retrieveOfferExpires(offerExpiresBodyElement, offerBodyElement, e, RMConstants);
                            if (offerIdentifierBodyElement.getValue().equalsIgnoreCase("REQUEST_SYSTEM_ASSIGNED")) {
                                offerIdentifierBodyElement.setValue(ElementCreator.generateUUID());
                                offerIdentifierBodyElement.setDirty(true);
                            }
                            offerId = offerIdentifierBodyElement.getValue();
                            offerContext = new OfferContext(replyto, offerIdentifierBodyElement.getValue(), offerExpires);
                        }
                    } else {
                        e.getContext().setProperty("addressing.sendReplyTo", (Object)"true");
                    }
                    CreateOperationContext context = new CreateOperationContext(new EndpointReference((URI)to), createMessageID.toString(), policy, expires, internalFaultDest, offerContext);
                    RMManager.getRMManager().addCreateOperationContext(context);
                    a2.toSOAPEnvelope((MessageElement)createBodyElement);
                    createBodyElement.setDirty(true);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private long retrieveOfferExpires(MessageElement offerExpiresBodyElement, MessageElement offerBodyElement, CreateSequenceEvent e, Constants RMConstants) throws SOAPException {
        long offerExpires = 0L;
        if (offerExpiresBodyElement != null) {
            offerExpires = new Expires(offerExpiresBodyElement).getExpires();
        } else {
            offerExpires = this.getExpiresFromConfiguration(e.getContext());
            if (offerExpires > 0L) {
                Expires ex = new Expires(RMConstants);
                ex.setExpires(offerExpires);
                ex.toSOAPEnvelope(offerBodyElement);
            } else {
                offerExpires = Long.MAX_VALUE;
            }
        }
        return offerExpires;
    }

    @Override
    public void createSequenceResponse(CreateSequenceResponseEvent e) {
        try {
            OfferContext offered;
            Accept accept;
            long exr;
            this.traceFSM(e);
            Message m = e.getContext().getCurrentMessage();
            ReliableHeaders rh = new ReliableHeaders();
            rh.fromSOAPEnvelope(m.getSOAPEnvelope());
            CreateSequenceResponse csr = rh.getCreateSequenceResponse();
            if (csr == null) {
                BrokerComponent.getComponentContext().logMessage("Create sequence response header missing.", BrokerComponent.getLevelWarning().intValue());
                return;
            }
            long negotiatedExpiry = Long.MAX_VALUE;
            RelatesTo relatesTo = null;
            AddressingHeaders headers = (AddressingHeaders)e.getContext().getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
            if (headers == null) {
                headers = (AddressingHeaders)e.getContext().getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            }
            if (headers != null && headers.getRelatesTo() != null && !headers.getRelatesTo().isEmpty()) {
                relatesTo = (RelatesTo)headers.getRelatesTo().get(0);
            }
            if (relatesTo == null) {
                BrokerComponent.getComponentContext().logMessage("Create sequence response has no relates to.", BrokerComponent.getLevelWarning().intValue());
                return;
            }
            String mid = relatesTo.getURI().toString();
            CreateOperationContext createContext = RMManager.getRMManager().getCreateOperationContext(mid);
            if (createContext == null) {
                BrokerComponent.getComponentContext().logMessage("Create sequence response cannot be correlated. Received relates to:" + mid, BrokerComponent.getLevelWarning().intValue());
                return;
            }
            RMManager.getRMManager().removeCreateOperationContext(createContext.getMsgId());
            e.getContext().setProperty("com.sonicsw.ws.rm.common.CreateOperationContext", (Object)createContext);
            negotiatedExpiry = createContext.getExpires();
            Expires ex = rh.getCreateSequenceResponse().getExpires();
            if (ex != null && (exr = ex.getExpires()) < negotiatedExpiry) {
                negotiatedExpiry = exr;
            }
            String id = csr.getIdentifier().getIdentifier();
            RMSendSequence support = this.registerSendSequence(createContext.getEndpoint(), id, e.getContext(), createContext.getPolicy(), false, createContext.getFaultDest(), negotiatedExpiry, true);
            support.getSequenceState().setClientAssigned(false);
            support.setLocallyHomed(true);
            if (DebugObjects.getSenderFSMDebug().getDebug()) {
                DebugObjects.getSenderFSMDebug().debug(this.fdate() + "Created Outbound:" + support);
            }
            if ((accept = rh.getCreateSequenceResponse().getAccept()) != null && (offered = createContext.getOfferContext()) != null) {
                RMReceiveSequence rxsupport = new InitialReceiveState().constructReceiveSequenceFromAcceptedOffer(e.getContext(), offered, accept, id);
                if (DebugObjects.getReceiverFSMDebug().getDebug()) {
                    DebugObjects.getReceiverFSMDebug().debug(this.fdate() + "Created Inbound:" + rxsupport);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public RMSendSequence getSendSequence(MessageContext mc, String id) {
        RMManager rmm = RMManager.getRMManager();
        return rmm.getRMSendSequenceSupport(id);
    }

    public RMSendSequence registerSendSequence(EndpointReference endpoint, String id, MessageContext mc, RMPolicy policyParam, boolean clientAssigned, Destination internalFaultDest, long negotiatedExpires, boolean log) {
        RMPolicy policy = policyParam;
        RMSendSequence support = this.getSendSequence(mc, id);
        if (support == null) {
            if (policy == null) {
                policy = new RMPolicy();
            }
            support = new RMSendSequence();
            RMSequence se = new RMSequence();
            Constants RMConstants = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
            Identifier ide = new Identifier(RMConstants);
            ide.setIdentifier(id);
            se.setSequenceIdentifier(ide);
            se.setPolicy(policy);
            long configuredExpires = this.getExpiresFromConfiguration(mc);
            RMPolicy p = se.getPolicy();
            if (negotiatedExpires != Long.MAX_VALUE) {
                se.setExpires(new Date(System.currentTimeMillis() + negotiatedExpires));
            } else if (configuredExpires > 0L) {
                se.setExpires(new Date(System.currentTimeMillis() + configuredExpires));
            }
            if (p.getInactivityTimeout() < 0L) {
                long configuredInactivity = this.getInactivityFromConfiguration(mc);
                p.setInactivityTimeout(configuredInactivity);
            }
            se.setClientAssigned(clientAssigned);
            se.setEndpointReference(endpoint);
            se.setInternalFaultDestination(internalFaultDest);
            se.setRMConstants(RMConstants);
            se.setLastActivity(System.currentTimeMillis());
            support.setSequenceState(se);
            support.setConstants(RMConstants);
            support.setSOAPConstants(mc.getSOAPConstants());
            support.setWSANS((String)mc.getProperty("addressing.namespace.URI"));
            RMManager.getRMManager().addRMSequenceSupport(support, log, true);
        }
        return support;
    }

    public ReliableMessageWrapper createSendMessageWrapper(MessageContext mc, SequenceCapsule cap) {
        ReliableMessageWrapper rmc = new ReliableMessageWrapper();
        rmc.setLastSentTime(System.currentTimeMillis());
        rmc.setMsgContext(mc);
        rmc.setSequenceInfo(cap);
        return rmc;
    }

    protected String fdate() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
        String str = formatter.format(dt);
        return str;
    }

    protected void traceFSM(RMEvent e) {
        RMSequenceSupport rmss = e.getSequence();
        String seqStr = "";
        if (rmss != null) {
            seqStr = rmss.toString();
        }
        if (DebugObjects.getSenderFSMDebug().getDebug()) {
            DebugObjects.getSenderFSMDebug().debug(this.fdate() + ":" + this.toString() + " " + rmss + " " + e.toString());
        }
    }

    private long getInactivityFromConfiguration(MessageContext mc) {
        WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        if (handler == null) {
            return 0L;
        }
        RoutingConnectionInfo rci = handler.getRoutingConnectionInfo();
        long inactivity = rci.getRmIdleTimeout();
        return inactivity;
    }

    private long getExpiresFromConfiguration(MessageContext mc) {
        WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        if (handler == null) {
            return 0L;
        }
        RoutingConnectionInfo rci = handler.getRoutingConnectionInfo();
        long expires = rci.getRmSequenceExpiration();
        return expires * 1000L;
    }
}

