/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;

public class TrustManager {
    public static final String ENGINE_TYPE = "TrustManager";
    public static final String PASSWORD = "Password";
    public static final String X509 = "X509";
    private static final String PASSWORD_TM_SPI = "com.sonicsw.ws.security.PasswordTrustManager";
    private static final String X509_TM_SPI = "com.sonicsw.ws.security.X509TrustManager";
    protected String m_type = null;
    protected Provider m_provider = null;

    public static TrustManager getInstance(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objs = TrustManager.getImpl(type, provider);
        TrustManager tm = (TrustManager)objs[0];
        tm.m_type = type;
        tm.m_provider = (Provider)objs[1];
        return tm;
    }

    public static final String[] getTrustManagerTypes() {
        return new String[]{PASSWORD, X509};
    }

    public final Provider getProvider() {
        return this.m_provider;
    }

    public final String getType() {
        return this.m_type;
    }

    public String toString() {
        return new String(this.m_type + " TrustManager from " + this.m_provider.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private static Object[] getImpl(String type, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + provider);
        }
        String key = "TrustManager." + type;
        String className = provider.getProperty(key);
        if (className == null) {
            Enumeration<Object> enumeration = provider.keys();
            while (enumeration.hasMoreElements() && className == null) {
                String matchKey = (String)enumeration.nextElement();
                if (!key.equalsIgnoreCase(matchKey)) continue;
                className = provider.getProperty(matchKey);
                break;
            }
        }
        if (className == null) {
            throw new NoSuchAlgorithmException(type + " TrustManager not available from provider " + provider);
        }
        try {
            ClassLoader cl = provider.getClass().getClassLoader();
            Class<?> implClass = Class.forName(className);
            String spiClassName = null;
            Class<?> spiClass = null;
            if (type.equalsIgnoreCase(PASSWORD)) {
                spiClassName = PASSWORD_TM_SPI;
            } else if (type.equalsIgnoreCase(X509)) {
                spiClassName = X509_TM_SPI;
            }
            spiClass = Class.forName(spiClassName);
            Class<?> subclass = implClass;
            while (!subclass.equals(spiClass)) {
                if ((subclass = subclass.getSuperclass()) != null) continue;
                throw new NoSuchAlgorithmException("class configured for " + type + " TrustManager: " + className + " does not implement " + spiClassName);
            }
            return new Object[]{implClass.newInstance(), provider};
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException("class configured for TrustManager(provider: " + provider + ")cannot be found.\n" + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TrustManager(provider: " + provider + ") cannot be instantiated.\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TrustManager(provider: " + provider + ") cannot be accessed.\n" + e.getMessage());
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TrustManager(provider: " + provider + ") cannot be accessed.\n" + e.getMessage());
        }
    }
}

