/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.parser.SecurityPolicy;
import com.sonicsw.ws.security.policy.parser.processors.X509TokenProcessor;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.InitiatorToken;
import org.apache.ws.security.policy.model.RecipientToken;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class InitiatorRecipientTokenProcessor {
    private boolean initializedInitiatorToken = false;
    private boolean initializedRecipientToken = false;

    private void initializeInitiatorToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod((Object)new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    private void initializeRecipientToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod((Object)new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doInitiatorToken(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedInitiatorToken) break;
                try {
                    this.initializeInitiatorToken(spt);
                    InitiatorToken initiatorToken = (InitiatorToken)spc.readCurrentPolicyEngineData();
                    ((AsymmetricBinding)spc.readPreviousPolicyEngineData()).setInitiatorToken(initiatorToken);
                    this.initializedInitiatorToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doRecipientToken(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedRecipientToken) break;
                try {
                    this.initializeRecipientToken(spt);
                    RecipientToken recipientToken = (RecipientToken)spc.readCurrentPolicyEngineData();
                    ((AsymmetricBinding)spc.readPreviousPolicyEngineData()).setRecipientToken(recipientToken);
                    this.initializedRecipientToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }
}

