/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Date;
import java.util.Enumeration;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.IAckTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.MsgDeliveredEvt;
import progress.message.broker.SyncGuarMsgEvt;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.LinkedList;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.xonce.IMsgTracker;
import progress.message.zclient.xonce.MgramTrace;

public final class AgentGuarMsgTracker
extends DebugObject
implements IMsgTracker,
IAckTracker {
    private static volatile AgentRegistrar s_reg;
    private static volatile IndexedList s_activeList;
    private long m_tracking;
    private int m_pubSubAckCount;
    private int m_ptpAckCount;
    private GuarMsgEvt m_evt;
    private boolean m_needGuarAck;
    private boolean m_needDeliveredEvt = true;
    private boolean m_canceled = false;
    private boolean m_splitting = false;
    private boolean m_removedFromLog = false;
    private boolean m_syncGuarMsgEvtWritten = false;
    private boolean m_hasDeliveryListEvt = false;
    private boolean m_splitBatchMember = false;
    private boolean m_replicateOnly = false;

    static void initClass(AgentRegistrar reg) {
        s_reg = reg;
        s_activeList = new IndexedList();
    }

    AgentGuarMsgTracker(long tracking, GuarMsgEvt evt, int pubSubAckCount, int ptpAckCount, boolean needGuarAck, boolean startSplitting) throws EDuplicateKey {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentGuarMsgTracker " + tracking : null);
        if (this.DEBUG) {
            this.debug("created with pub/sub count " + pubSubAckCount + ", ptp count " + ptpAckCount);
        }
        this.m_tracking = tracking;
        this.m_pubSubAckCount = pubSubAckCount;
        this.m_ptpAckCount = ptpAckCount;
        this.m_evt = evt;
        this.m_needGuarAck = needGuarAck;
        this.m_splitting = startSplitting;
        if (this.m_evt != null) {
            this.m_replicateOnly = this.m_evt.getMessage() != null ? this.m_evt.getMessage().isNonPersistentReplicated() : this.m_evt.isReplicateOnly();
        }
        s_activeList.append(this.m_tracking, this);
    }

    @Override
    public GuarMsgEvt getEvent() {
        return this.m_evt;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public long getTracking() {
        return this.m_tracking;
    }

    public long getOrigSender() {
        return this.m_evt.getOrigSender();
    }

    public long getOrigTracking() {
        return this.m_evt.getOrigTracking();
    }

    @Override
    public long getRedirectAckClient() {
        return this.m_evt.getRedirectAckClient();
    }

    public boolean isTransacted() {
        return this.m_evt.isTransacted();
    }

    public boolean isBatchMessage() {
        return this.m_evt.getMessage().getType() == 27;
    }

    public int getBatchSize() {
        if (!this.isBatchMessage()) {
            throw new EAssertFailure("Not a batch message");
        }
        return this.m_evt.getMessage().getBatchHandle().getBatchSize();
    }

    public synchronized boolean isDelivered() {
        if (this.m_canceled) {
            return true;
        }
        if (this.isTransacted()) {
            return false;
        }
        if (this.m_evt.splitBatch() && !this.m_splitting) {
            return true;
        }
        if (this.m_evt.getGuarRecipients() == null) {
            return false;
        }
        return this.m_pubSubAckCount + this.m_ptpAckCount == 0;
    }

    public synchronized boolean isDeliveredToPubSub() {
        if (this.m_canceled) {
            return true;
        }
        if (this.isTransacted()) {
            return false;
        }
        if (this.m_evt.splitBatch() && !this.m_splitting) {
            return true;
        }
        if (this.m_evt.getGuarRecipients() == null) {
            return false;
        }
        return this.m_pubSubAckCount == 0;
    }

    @Override
    public boolean isReplicateOnly() {
        return this.m_replicateOnly;
    }

    public synchronized boolean needGuarAck() {
        return this.m_needGuarAck;
    }

    public void setHasDeliveryListEvt() {
        this.m_hasDeliveryListEvt = true;
    }

    public void setSplitBatchMember() {
        this.m_splitBatchMember = true;
    }

    public void setExpectedPubSubAckCount(int pubsubAckCount) {
        this.m_pubSubAckCount = pubsubAckCount;
    }

    public void setExpectedPtpAckCount(int ptpAckCount) {
        this.m_ptpAckCount = ptpAckCount;
    }

    public synchronized boolean msgAcknowledged(IClientContext cc, boolean subjectAck) {
        if (this.DEBUG) {
            this.debug("AgentGuarMsgTracker Ack of GUAR=" + this.m_tracking + " by: " + cc);
        }
        if (!subjectAck && this.m_evt.removeRecipient(cc.getId(), false)) {
            if (this.m_pubSubAckCount == 0) {
                return true;
            }
            --this.m_pubSubAckCount;
            if (this.m_pubSubAckCount <= 0) {
                this.allPubSubAcksReceived();
            }
        }
        this.removeProxyLBSRecips(cc.getId());
        return this.m_evt.isLogged() || this.m_syncGuarMsgEvtWritten || Config.REPLICATED || this.m_needGuarAck || this.m_hasDeliveryListEvt && (this.m_splitBatchMember || !this.m_evt.getDeliveredToPubSub());
    }

    synchronized void msgSaved(int numClients, boolean removed) {
        if (numClients == 0) {
            return;
        }
        if (this.DEBUG) {
            this.debug("msg saved for " + numClients + " clients");
        }
        if (removed) {
            if (this.m_pubSubAckCount == 0) {
                EAssertFailure t = new EAssertFailure("Msg " + this.m_tracking + " saved after all pub/sub acks received");
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
                return;
            }
            this.m_pubSubAckCount -= numClients;
            if (this.m_pubSubAckCount == 0) {
                this.allPubSubAcksReceived();
            }
        }
    }

    synchronized void msgSavedForXOnceClient(long clientId, boolean inDoubt) {
        if (this.DEBUG) {
            System.out.println("AgentGuarMsgTracker msg saved GUAR=" + this.m_tracking + " by: " + clientId + " indoubt=" + inDoubt);
        }
        boolean removed = this.m_evt.removeRecipient(clientId, inDoubt);
        this.msgSaved(1, removed);
    }

    public synchronized void removeProxyRecips(IClientContext proxy) {
        if (this.m_evt.removeProxyRecips(proxy.getId()) && this.DEBUG) {
            System.out.println("Removed proxy recips for: " + proxy + " trk=" + this.m_tracking);
        }
        this.tryCleanUp();
    }

    public synchronized LBSTrackingInfo getProxyLBSRecips(long recipId) {
        LongHashTable table = this.m_evt.getProxyLBSRecipsTable();
        if (table != null) {
            return (LBSTrackingInfo)table.get(recipId);
        }
        return null;
    }

    public synchronized void removeProxyLBSRecips(long proxyId) {
        if (this.m_evt.removeProxyLBSRecips(proxyId) && this.DEBUG) {
            System.out.println("Removed proxy LBS recips for: " + proxyId + " trk=" + this.m_tracking);
        }
        this.tryCleanUp();
    }

    public synchronized void qRcptAcknowledged(long tracking) {
        if (this.m_ptpAckCount == 0) {
            return;
        }
        if (this.DEBUG) {
            this.debug("acknowledged by PTP client, tracking # is " + tracking);
        }
        this.m_evt.removeQRecipient(tracking);
        --this.m_ptpAckCount;
        if (this.m_ptpAckCount + this.m_pubSubAckCount <= 0) {
            this.allAcksReceived();
        }
    }

    @Override
    public synchronized boolean guarAckDone() {
        this.m_needGuarAck = false;
        this.tryCleanUp();
        return this.m_pubSubAckCount + this.m_ptpAckCount > 0 || !this.m_removedFromLog || this.m_evt.splitBatch();
    }

    private final void allPubSubAcksReceived() {
        if (this.DEBUG) {
            this.debug("all pub/sub acks received");
        }
        this.m_evt.setDeliveredToPubSub();
        if (this.m_ptpAckCount <= 0) {
            this.allAcksReceived();
        }
        this.logMsgDeliveredEvent();
    }

    private final void allAcksReceived() {
        if (this.DEBUG) {
            this.debug("all acks received");
        }
        this.m_evt.removeAllProxyLBSRecips();
        this.tryCleanUp();
        this.logMsgDeliveredEvent();
        if (!this.m_evt.splitBatch()) {
            this.m_evt.allAcksReceived();
        }
    }

    private void logMsgDeliveredEvent() {
        if (this.m_needDeliveredEvt) {
            MsgDeliveredEvt evt = new MsgDeliveredEvt(this.m_tracking);
            evt.setReplicateOnly(this.m_replicateOnly);
            s_reg.getLogManager().addEvent(evt, false);
            this.m_needDeliveredEvt = false;
        }
    }

    private void tryCleanUp() {
        if (this.m_pubSubAckCount + this.m_ptpAckCount == 0 && !this.m_needGuarAck && (!this.m_evt.hasProxyMappings() && !this.m_evt.hasProxyLBSRecips() || this.m_canceled)) {
            if (this.DEBUG) {
                this.debug("tryCleanup: all done - cleaning up");
            }
            if (!this.m_evt.getMessage().getBrokerHandle().isTransactionalPublish() && !this.m_evt.splitBatch()) {
                s_reg.getLogManager().removeEvent(this.m_evt);
                if (this.m_evt.removedFromLog() && !this.m_syncGuarMsgEvtWritten) {
                    this.m_removedFromLog = true;
                    this.m_needDeliveredEvt = false;
                }
            }
            if (!this.m_splitting) {
                s_activeList.remove(this.m_tracking);
            }
            if (this.checkDebugFlags(64) && (this.m_evt.hasProxyMappings() || this.m_evt.hasProxyLBSRecips()) && this.m_canceled) {
                this.debug("tryCleanup: removed canceled message " + this.m_tracking + " numTrackers= " + s_activeList.count() + MgramTrace.diagnosticString("", null, this.m_evt.getMessage()));
            }
        }
    }

    public synchronized void startSplitting() {
        this.m_splitting = true;
    }

    public synchronized void endSplitting() {
        this.m_splitting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void canceled() {
        AgentGuarMsgTracker agentGuarMsgTracker = this;
        synchronized (agentGuarMsgTracker) {
            this.m_pubSubAckCount = 0;
            this.m_ptpAckCount = 0;
            this.m_canceled = true;
            this.m_evt.setDeliveredToPubSub();
            this.m_needDeliveredEvt = true;
            this.allAcksReceived();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeSyncRecord() throws ECannotFlushEvents {
        SyncGuarMsgEvt evt;
        AgentGuarMsgTracker agentGuarMsgTracker = this;
        synchronized (agentGuarMsgTracker) {
            if (this.m_removedFromLog) {
                return 0L;
            }
            this.m_syncGuarMsgEvtWritten = true;
            evt = new SyncGuarMsgEvt(this.m_evt, this.isDeliveredToPubSub(), this.m_needGuarAck, this.m_canceled);
        }
        s_reg.getLogManager().tryAddEvent(evt, false);
        return evt.memsize();
    }

    public static AgentGuarMsgTracker getTrackerIfExists(long tracking) {
        if (s_activeList == null) {
            return null;
        }
        AgentGuarMsgTracker tracker = (AgentGuarMsgTracker)s_activeList.get(tracking);
        return tracker;
    }

    public static AgentGuarMsgTracker getTracker(long tracking) throws ETrackingNumNotFound {
        AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTrackerIfExists(tracking);
        if (tracker == null) {
            throw new ETrackingNumNotFound("" + tracking);
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Enumeration getTrackers() {
        LinkedList enumList = new LinkedList();
        IndexedList indexedList = s_activeList;
        synchronized (indexedList) {
            Enumeration enu = s_activeList.elements();
            while (enu.hasMoreElements()) {
                enumList.append(enu.nextElement());
            }
        }
        return enumList.elements();
    }

    static long writeSyncEvents() throws ECannotFlushEvents {
        int totcount = 0;
        long totsize = 0L;
        int txcount = 0;
        long txsize = 0L;
        Enumeration guars = AgentGuarMsgTracker.getTrackers();
        while (guars.hasMoreElements()) {
            AgentGuarMsgTracker trk = (AgentGuarMsgTracker)guars.nextElement();
            long size = trk.writeSyncRecord();
            totsize += size;
            if (!DebugState.GLOBAL_DEBUG_ON) continue;
            if (trk.isTransacted()) {
                txsize += size;
                ++txcount;
            }
            ++totcount;
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            AgentGuarMsgTracker.class_debug("AgentGuarMsgTracker", 64, "Wrote PubSub sync Events, num= " + totcount + ", bytesize= " + totsize + ", txCount= " + txcount + ", txsize= " + txsize + " " + new Date());
        }
        return totsize;
    }
}

