/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import progress.message.broker.IDispatchList;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class DispatchListImpl
extends DebugObject
implements IDispatchList {
    private ArrayList[] m_dispatchablesList;
    private HashSet m_dispatchables;
    private long m_numAdded;
    private long m_numNotAdded;
    private long m_ct;
    private int m_currentDisp = 0;
    private long m_numIt;
    private int[] m_stats;
    private int[] m_limits = new int[]{0, 1, 2, 5, 10, 100};
    private long m_maxCount;
    private static int INITIAL_SIZE = 16;

    public DispatchListImpl(String ident) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DispatchListImpl " + ident : null);
        if (this.DEBUG && ident == null) {
            this.debugName("DispatchListImpl " + this.hashCode());
        }
        this.m_dispatchablesList = new ArrayList[2];
        this.m_dispatchablesList[0] = new ArrayList(INITIAL_SIZE);
        this.m_dispatchablesList[1] = new ArrayList(INITIAL_SIZE);
        this.m_dispatchables = new HashSet(INITIAL_SIZE);
        if (this.DEBUG) {
            this.m_stats = new int[this.m_limits.length + 1];
            this.debug("Constructed");
        }
    }

    public DispatchListImpl() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addDispatchable(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean added = false;
        DispatchListImpl dispatchListImpl = this;
        synchronized (dispatchListImpl) {
            if (!this.m_dispatchables.contains(obj)) {
                this.m_dispatchables.add(obj);
                added = true;
                this.m_dispatchablesList[1 - this.m_currentDisp].add(obj);
            }
            if (this.DEBUG) {
                this.addCounter(added);
            }
        }
        return added;
    }

    @Override
    public final synchronized Enumeration getDispatchListEnum() {
        this.swap();
        Enum it = new Enum(this.m_dispatchablesList[this.m_currentDisp]);
        if (this.DEBUG) {
            this.calcDispatchStats(this.m_dispatchablesList[this.m_currentDisp].size());
        }
        return it;
    }

    private void swap() {
        this.m_currentDisp = 1 - this.m_currentDisp;
        this.m_dispatchables.clear();
        this.m_dispatchablesList[1 - this.m_currentDisp].clear();
    }

    public final void setIdent(String ident) {
        this.debugName("DispatchList " + ident);
    }

    @Override
    public final synchronized int getPendingSize() {
        return this.m_dispatchablesList[1 - this.m_currentDisp].size();
    }

    private void addCounter(boolean added) {
        ++this.m_ct;
        if (added) {
            ++this.m_numAdded;
        } else {
            ++this.m_numNotAdded;
        }
        this.printCounts();
    }

    private void calcDispatchStats(int size) {
        ++this.m_numIt;
        boolean added = false;
        for (int i = 0; i < this.m_limits.length; ++i) {
            if (size > this.m_limits[i]) continue;
            int n = i;
            this.m_stats[n] = this.m_stats[n] + 1;
            added = true;
            break;
        }
        if (!added) {
            int n = this.m_limits.length;
            this.m_stats[n] = this.m_stats[n] + 1;
        }
        if ((long)size > this.m_maxCount) {
            this.m_maxCount = size;
        }
    }

    private void printCounts() {
        if (this.m_ct == 100000L) {
            StringBuffer buf = new StringBuffer();
            buf.append("Num adds= ");
            buf.append(this.m_ct);
            buf.append("; added= ");
            buf.append(this.m_numAdded);
            buf.append("; notAdded= ");
            buf.append(this.m_numNotAdded);
            buf.append("; numIt= ");
            buf.append(this.m_numIt);
            buf.append("; maxCCs= ");
            buf.append(this.m_maxCount);
            buf.append("\n\t");
            for (int i = 0; i <= this.m_limits.length; ++i) {
                if (i == this.m_limits.length) {
                    buf.append("; [other] ");
                    buf.append(this.m_stats[i]);
                } else {
                    buf.append("; [<=");
                    buf.append(this.m_limits[i]);
                    buf.append("] ");
                    buf.append(this.m_stats[i]);
                }
                this.m_stats[i] = 0;
            }
            this.debug(buf.toString());
            this.m_numAdded = 0L;
            this.m_numNotAdded = 0L;
            this.m_maxCount = 0L;
            this.m_numIt = 0L;
            this.m_ct = 0L;
        }
    }

    private final class Enum
    implements Enumeration {
        ArrayList list;
        int next;

        Enum(ArrayList l) {
            this.list = l;
            this.next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                return this.next < this.list.size();
            }
        }

        public Object nextElement() {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                if (this.next < this.list.size()) {
                    return this.list.get(this.next++);
                }
                throw new NoSuchElementException("");
            }
        }
    }
}

