/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.util.Properties;
import progress.message.broker.Acceptor;
import progress.message.broker.IAcceptor;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressSocketFactory;

public class SSLAcceptor
extends Acceptor
implements IAcceptor {
    static String s_DEFAULT_SSL_CERTIFICATE_CHAIN = null;
    static String s_DEFAULT_SSL_CERTIFICATE_CHAIN_FORM = null;
    static String s_DEFAULT_SSL_PRIVATE_KEY = null;
    static String s_DEFAULT_SSL_PRIVATE_KEY_PASSWORD = null;
    static String s_DEFAULT_SSL_CIPHER_SUITES = null;
    static String s_DEFAULT_SSL_CA_CERTIFICATES_DIR = null;
    static String s_DEFAULT_SSL_CLIENT_AUTHENTICATION = null;
    static String s_DEFAULT_SSL_PROVIDER_CLASS = null;

    public SSLAcceptor(String name, String url, String externalUrl, boolean dynHostBinding, String privateHost, String publicHost, Properties properties) throws ESocketConfigException {
        super(name, url, externalUrl, "ssl", dynHostBinding, privateHost, publicHost, properties);
        this.m_properties.put("PROTOCOL", "SSL");
        int socketType = ProgressSocketFactory.getType(this.m_protocol);
        this.m_socketFactory = ProgressSocketFactory.getFactory(socketType);
    }

    public static synchronized void setDefaultSSLParams(String providerClass, String certChain, String certChainForm, String privateKey, String privateKeyPassword, String cipherSuites, String caCertsDir, String clientAuth) {
        if (providerClass != null) {
            s_DEFAULT_SSL_PROVIDER_CLASS = new String(providerClass);
        }
        if (certChain != null) {
            s_DEFAULT_SSL_CERTIFICATE_CHAIN = new String(certChain);
        }
        if (certChainForm != null) {
            s_DEFAULT_SSL_CERTIFICATE_CHAIN_FORM = new String(certChainForm);
        }
        if (privateKey != null) {
            s_DEFAULT_SSL_PRIVATE_KEY = new String(privateKey);
        }
        if (privateKeyPassword != null) {
            s_DEFAULT_SSL_PRIVATE_KEY_PASSWORD = new String(privateKeyPassword);
        }
        if (cipherSuites != null) {
            s_DEFAULT_SSL_CIPHER_SUITES = new String(cipherSuites);
        }
        if (caCertsDir != null) {
            s_DEFAULT_SSL_CA_CERTIFICATES_DIR = new String(caCertsDir);
        }
        if (clientAuth != null) {
            s_DEFAULT_SSL_CLIENT_AUTHENTICATION = new String(clientAuth);
        }
    }

    @Override
    public void createServerSocket() throws IOException {
        this.m_serverSocket = this.m_socketFactory.createProgressServerSocket(this.m_principal, this.m_port, this.m_backlog, this.m_bindAddr, this.m_properties);
    }
}

