/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.parser.MessageSelector;
import progress.message.util.EAssertFailure;
import progress.message.util.LinkedList;
import progress.message.util.ListNode;

class SelectorElement {
    public static final String RECEIVER_WITHOUT_SELECTOR_STRING = "";
    private int m_numPriorities;
    private int m_prio;
    private QElement[] m_elems = null;
    private QElement[] m_reenqueueStartElems = null;
    private QElement[] m_reenqueueEndElems = null;
    private QElement[] m_queuePriorityTokens;
    private MessageSelector m_msgSelector = null;
    private boolean m_hasMultipleSelectors = false;
    private LinkedList m_msgSelectorList = null;
    private Hashtable m_msgSelectorListKey = null;
    private boolean m_hasMatchAllSelector = false;
    private String m_queueName;

    public SelectorElement(MessageSelector ms, int numPriorities, QToken[] queuePriorityTokens, String queueName) {
        this.m_msgSelector = ms;
        this.m_numPriorities = numPriorities;
        this.m_queuePriorityTokens = queuePriorityTokens;
        this.m_queueName = queueName;
        this.initializeElems();
    }

    private void initializeElems() {
        this.m_prio = -1;
        if (this.m_elems == null) {
            this.m_elems = new QElement[this.m_numPriorities];
            this.m_reenqueueStartElems = new QElement[this.m_numPriorities];
            this.m_reenqueueEndElems = new QElement[this.m_numPriorities];
        }
        for (int i = 0; i < this.m_numPriorities; ++i) {
            this.m_elems[i] = this.m_queuePriorityTokens[i + 1].m_next;
            if (this.m_elems[i] != this.m_queuePriorityTokens[i]) {
                this.m_prio = i;
            }
            this.m_reenqueueStartElems[i] = null;
            this.m_reenqueueEndElems[i] = null;
        }
    }

    public void updateCursorOnEnqueue(QElement elem) {
        if (elem instanceof QToken) {
            throw new EAssertFailure(this + ": updateCursorOnEnqueue called with QToken");
        }
        int prio = elem.getPriority();
        if (this.m_elems[prio] instanceof QToken && this.m_elems[prio] != this.m_queuePriorityTokens[prio]) {
            throw new EAssertFailure(this + ": updateCursorOnEnqueue detected invalid QToken (prio = " + prio + ")");
        }
        if (this.m_elems[prio] == this.m_queuePriorityTokens[prio]) {
            this.m_elems[prio] = elem;
            this.m_prio = prio > this.m_prio ? prio : this.m_prio;
        }
    }

    public void updateCursorOnReenqueue(QElement elem) {
        if (elem instanceof QToken) {
            throw new EAssertFailure(this + ": updateCursorOnReenqueue called with QToken");
        }
        int prio = elem.getPriority();
        if (elem != this.m_queuePriorityTokens[prio + 1].m_next) {
            throw new EAssertFailure(this + ": updateCursorOnReenqueue elem doesn't match first at this priority (prio = " + prio + ")");
        }
        if (elem == this.m_elems[prio]) {
            throw new EAssertFailure(this + ": updateCursorOnReenqueue elem matches m_elems[prio] (prio = " + prio + ")");
        }
        if (this.m_reenqueueStartElems[prio] == null != (this.m_reenqueueEndElems[prio] == null)) {
            throw new EAssertFailure(this + ": updateCursorOnReenqueue m_reenqueueStartElems[prio]=" + this.m_reenqueueStartElems[prio] + ", m_reenqueueEndElems[prio]=" + this.m_reenqueueEndElems[prio] + " (prio = " + prio + ")");
        }
        this.m_reenqueueStartElems[prio] = elem;
        if (this.m_reenqueueEndElems[prio] == null) {
            this.m_reenqueueEndElems[prio] = elem;
        }
        this.m_prio = prio > this.m_prio ? prio : this.m_prio;
    }

    public void updateCursorOnDequeue(QElement elem) {
        if (elem instanceof QToken) {
            throw new EAssertFailure(this + ": updateCursorOnDequeue called with QToken");
        }
        int prio = elem.getPriority();
        if (elem == this.m_reenqueueStartElems[prio]) {
            this.incrementReenqueueCursor(prio);
        } else if (elem == this.m_reenqueueEndElems[prio]) {
            this.m_reenqueueEndElems[prio] = elem.m_prev;
            if (this.m_reenqueueEndElems[prio] == null) {
                throw new EAssertFailure(this + ": updateCursorOnDequeue reenqueue block hit null (prio = " + prio + ")");
            }
            if (this.m_reenqueueEndElems[prio] instanceof QToken) {
                throw new EAssertFailure(this + ": updateCursorOnDequeue reenqueue block hit QToken (prio = " + prio + ")");
            }
        }
        if (elem == this.m_elems[prio]) {
            this.incrementMainCursor(prio);
        }
    }

    public void incrementCursor(int prio) {
        if (this.m_reenqueueStartElems[prio] != null) {
            this.incrementReenqueueCursor(prio);
        } else {
            this.incrementMainCursor(prio);
        }
    }

    private void incrementReenqueueCursor(int prio) {
        if (this.m_reenqueueStartElems[prio] == this.m_reenqueueEndElems[prio]) {
            this.m_reenqueueStartElems[prio] = null;
            this.m_reenqueueEndElems[prio] = null;
        } else {
            this.m_reenqueueStartElems[prio] = this.m_reenqueueStartElems[prio].m_next;
        }
        this.checkPrioritiesAndDropMPrio(prio);
    }

    private void incrementMainCursor(int prio) {
        if (this.m_elems[prio] instanceof QToken) {
            throw new EAssertFailure(this + ": incrementCursor called when already at a QToken (prio = " + prio + ")");
        }
        this.m_elems[prio] = this.m_elems[prio].m_next;
        if (this.m_elems[prio] instanceof QToken && this.m_elems[prio] != this.m_queuePriorityTokens[prio]) {
            throw new EAssertFailure(this + ": incrementCursor detected invalid QToken (prio = " + prio + ")");
        }
        this.checkPrioritiesAndDropMPrio(prio);
    }

    private void checkPrioritiesAndDropMPrio(int prio) {
        if (this.m_prio == prio && this.m_reenqueueStartElems[prio] == null && this.m_elems[prio] == this.m_queuePriorityTokens[prio]) {
            --this.m_prio;
        }
    }

    public QElement getCursorElement(int prio) {
        if (this.m_reenqueueStartElems[prio] != null) {
            return this.m_reenqueueStartElems[prio];
        }
        return this.m_elems[prio];
    }

    public int getSearchPriority() {
        return this.m_prio;
    }

    public void setSearchPriority(int prio) {
        this.m_prio = prio;
    }

    public boolean getAtEnd() {
        return this.m_prio < 0;
    }

    public void resetCursor() {
        this.initializeElems();
    }

    public void setMessageSelector(MessageSelector ms, String key) {
        if (this.m_msgSelectorList == null) {
            this.m_msgSelectorList = new LinkedList();
            this.m_msgSelectorListKey = new Hashtable();
        }
        if (this.m_msgSelector == null && !this.m_hasMatchAllSelector) {
            this.m_msgSelector = ms;
            if (key != null) {
                this.m_msgSelectorListKey.put(key, this.m_msgSelectorList.append(ms));
            }
        } else {
            this.m_hasMultipleSelectors = true;
            this.m_msgSelectorListKey.put(key, this.m_msgSelectorList.append(ms));
        }
        this.initializeElems();
    }

    public boolean removeMessageSelector(String key) {
        if (key.equals(RECEIVER_WITHOUT_SELECTOR_STRING)) {
            this.m_hasMatchAllSelector = false;
        } else if (!this.m_hasMultipleSelectors) {
            this.m_msgSelector = null;
            this.removeListNodeFromMsgSelectorList(key);
        } else {
            this.removeListNodeFromMsgSelectorList(key);
        }
        return !this.m_hasMatchAllSelector && (this.m_msgSelectorList == null || this.m_msgSelectorList.count() <= 0);
    }

    private void removeListNodeFromMsgSelectorList(String key) {
        ListNode ln;
        if (key != null && this.m_msgSelectorListKey != null && (ln = (ListNode)this.m_msgSelectorListKey.remove(key)) != null) {
            this.m_msgSelectorList.remove(ln);
        }
    }

    public MessageSelector getMessageSelector() {
        return this.m_msgSelector;
    }

    public boolean hasMultipleSelectors() {
        return this.m_hasMultipleSelectors;
    }

    public void setHasMatchAllSelector() {
        if (!this.m_hasMatchAllSelector) {
            this.m_hasMatchAllSelector = true;
            this.initializeElems();
        }
    }

    public boolean hasMatchAllSelector() {
        return this.m_hasMatchAllSelector;
    }

    public Enumeration getMessageSelectorList() {
        if (this.m_msgSelectorList != null) {
            return this.m_msgSelectorList.elements();
        }
        return null;
    }

    public void recycle() {
        this.m_prio = this.m_numPriorities - 1;
        this.m_elems = null;
        this.m_reenqueueStartElems = null;
        this.m_reenqueueEndElems = null;
        this.m_msgSelector = null;
        this.m_hasMultipleSelectors = false;
        this.m_msgSelectorList = null;
        if (this.m_msgSelectorListKey != null) {
            this.m_msgSelectorListKey.clear();
        }
        this.m_msgSelectorListKey = null;
        this.m_hasMatchAllSelector = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SelectorElement ");
        if (this.m_hasMultipleSelectors && this.m_msgSelectorList != null) {
            sb.append("with ").append(this.m_msgSelectorList.count()).append(" selectors ");
        }
        if (this.m_hasMatchAllSelector) {
            sb.append("with match-all selector ");
        }
        sb.append("on queue \"").append(this.m_queueName).append('\"');
        return sb.toString();
    }
}

