/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import progress.message.util.StreamUtil;

public class SubjectDeleteTracker {
    protected HashSet m_subjectIds = null;
    private long m_messageId = -1L;
    private long m_clientId = -1L;
    private boolean m_protected;

    public SubjectDeleteTracker() {
    }

    public SubjectDeleteTracker(long messageId, long clientId) {
        this.m_messageId = messageId;
        this.m_clientId = clientId;
        this.m_subjectIds = new HashSet();
    }

    private SubjectDeleteTracker(SubjectDeleteTracker tracker) {
        this.m_clientId = tracker.m_clientId;
        this.m_messageId = tracker.m_messageId;
        this.m_subjectIds = tracker.m_subjectIds;
    }

    public final void addDeletedSubject(short sid) {
        this.unprotect();
        this.m_subjectIds.add(new Short(sid));
    }

    public final boolean removeDeletedSubject(short sid) {
        this.unprotect();
        this.m_subjectIds.remove(new Short(sid));
        return this.m_subjectIds.isEmpty();
    }

    final SubjectDeleteTracker protectedClone() {
        SubjectDeleteTracker tracker = new SubjectDeleteTracker(this);
        this.protect();
        tracker.protect();
        return tracker;
    }

    private final void protect() {
        this.m_protected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unprotect() {
        if (this.m_protected) {
            SubjectDeleteTracker subjectDeleteTracker = this;
            synchronized (subjectDeleteTracker) {
                this.m_subjectIds = (HashSet)this.m_subjectIds.clone();
                this.m_protected = false;
            }
        }
    }

    final int serializedLength() {
        return 18 + (this.m_subjectIds != null ? this.m_subjectIds.size() * 2 : 0);
    }

    final void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_clientId, os);
        StreamUtil.writeLong(this.m_messageId, os);
        StreamUtil.writeShort((short)this.m_subjectIds.size(), os);
        Iterator i = this.m_subjectIds.iterator();
        while (i.hasNext()) {
            StreamUtil.writeShort((Short)i.next(), os);
        }
    }

    final void readFromStream(InputStream is) throws IOException {
        this.m_clientId = StreamUtil.readLong(is);
        this.m_messageId = StreamUtil.readLong(is);
        short count = StreamUtil.readShort(is);
        this.m_subjectIds = new HashSet(count);
        for (short i = 0; i < count; i = (short)(i + 1)) {
            this.m_subjectIds.add(new Short(StreamUtil.readShort(is)));
        }
    }

    public final long getClientId() {
        return this.m_clientId;
    }

    public final long getMessageId() {
        return this.m_messageId;
    }

    public final HashSet getSubjectIds() {
        return this.m_subjectIds;
    }
}

