/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import progress.message.broker.BrokerDatabase;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dbsc.data.impl.DbDupDetectData;
import progress.message.ft.FTReflectionOperation;
import progress.message.ft.RBRegistrySyncOp;
import progress.message.ft.SubscriptionSyncOp;
import progress.message.ft.UserIDMappingSyncOp;
import progress.message.gr.RouteInfo;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;

public class FTMgramFactory {
    public static final byte FT_OPERATION_VERSION = 0;
    public static final byte END_SYNCPOINT = 1;
    public static final byte REPLICATE_TXN_MGRAM = 2;
    public static final byte USERIDMAPPING_SYNC_OP = 3;
    public static final byte SUBSCRIPTION_SYNC_OP = 4;
    public static final byte TXN_SYNC_COMPLETE_OP = 5;
    public static final byte REPLICATE_DUR_MGRAM_OP = 6;
    public static final byte REPLICATE_DUP_DETECT_OP = 7;
    public static final byte RBREGISTRY_SYNC_OP = 8;
    public static final byte ROUTEINFOS_SYNC_OP = 9;
    public static final byte QUEUE_DYNAMIC_SYNC_DONE_OP = 10;
    private static final int REPLICATE_DUP_DETECT_SIZE = 20;
    public static final int s_requestUserInfoOffset = 8;
    public static final int REPLICATE_CDI_FIXED_SIZE = 37;

    public static FTReflectionOperation createReflectionOperation() {
        return new FTReflectionOperation();
    }

    public static FTReflectionOperation createReflectionOperation(IMgram reflectionMgram) throws IOException, ClassNotFoundException {
        return new FTReflectionOperation(reflectionMgram);
    }

    public static void addFTOpHeader(DataOutput output, byte subType) throws IOException {
        output.write(0);
        output.write(subType);
    }

    public static IMgram createEndSyncpointOp() {
        return FTMgramFactory.createIMgram((byte)1);
    }

    static int getDupDetectSize(List records) {
        int result = 0;
        if (records != null && !records.isEmpty()) {
            for (IDbDupDetectData data : records) {
                result += 20 + (data.getCommitID() == null ? 0 : data.getCommitID().length()) + (data.getChannelID() == null ? 0 : data.getChannelID().length());
            }
        }
        return result;
    }

    public static IMgram createReplicateDupDetectOp(List dupDetectRecords, boolean lastChunk) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, (byte)7);
            output.writeBoolean(lastChunk);
            if (dupDetectRecords == null || dupDetectRecords.isEmpty()) {
                output.writeInt(0);
                return op;
            }
            output.writeInt(dupDetectRecords.size());
            for (IDbDupDetectData data : dupDetectRecords) {
                output.writeUTF(data.getCommitID());
                output.writeLong(data.getEndOfLife());
                output.writeLong(data.getCreationTime());
                output.writeInt(data.getStatus());
                output.writeUTF(data.getChannelID());
            }
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IDbDupDetectData getDupDetectData(DataInput di) throws IOException {
        DbDupDetectData data = new DbDupDetectData(di.readUTF(), di.readLong(), di.readLong(), di.readInt(), di.readUTF());
        return data;
    }

    public static IMgram createReplicateDurMgramsOp(boolean lastChunk, List mgramList) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, (byte)6);
            output.writeBoolean(lastChunk);
            if (mgramList != null) {
                IOperationHandle handle = op.getOperationHandle();
                Iterator iter = mgramList.iterator();
                while (iter.hasNext()) {
                    handle.addMgram((IMgram)iter.next());
                }
            }
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createQueueDynamicSyncDoneOp(long lastTracking) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, (byte)10);
            output.writeLong(lastTracking);
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createReplicateTxnMgramOp(int tid, short flags) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, (byte)2);
            output.writeInt(tid);
            output.writeShort(flags);
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createTxnDynSyncCompleteOp() {
        return FTMgramFactory.createIMgram((byte)5);
    }

    private static IMgram createIMgram(byte subType) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, subType);
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createUserIdMappingSyncOp(ArrayList clients, boolean lastChunk) {
        try {
            return UserIDMappingSyncOp.createUserIDMappingSyncOpMgram(clients, lastChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createSubscriptionSyncOp(ArrayList subscribeEvts, boolean lastChunk) {
        try {
            IMgram m = SubscriptionSyncOp.createSubscriptionSyncOpMgram(subscribeEvts, lastChunk);
            return m;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createRBRegistrySyncOp(ArrayList rbds, boolean lastChunk) {
        try {
            return RBRegistrySyncOp.createRBRegistrySyncOpMgram(rbds, lastChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMgram createRouteInfosSyncOp(ArrayList routes, boolean lastChunk) {
        try {
            IMgram op = MgramFactory.getMgramFactory().buildOperationMgram(23);
            ObjectOutput output = op.getPayloadOutputStreamHandle();
            FTMgramFactory.addFTOpHeader(output, (byte)9);
            output.writeBoolean(lastChunk);
            int size = routes.size();
            output.writeInt(size);
            RouteInfo ri = null;
            for (int i = 0; i < size; ++i) {
                ri = (RouteInfo)routes.get(i);
                ri.writeToStream(output, (short)-1);
            }
            return op;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getRequestReplyTracking(IMgram m) {
        if (m.getType() != 34) {
            throw new EAssertFailure("Invalid operation on Mgram type: " + m.getType());
        }
        byte[] body = m.getRawBody();
        return ArrayUtil.readLong(body, 0);
    }

    public static byte[] createReplicateUndelRequest_V2_Payload(List clientDeliveryInfo) {
        try {
            int size = clientDeliveryInfo.size();
            if (size == 0) {
                return new byte[]{0};
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.writeInt(size, baos);
            for (BrokerDatabase.ClientDeliveryInfo cdi : clientDeliveryInfo) {
                StreamUtil.writeLong(cdi.cid, baos);
                StreamUtil.writeBoolean(cdi.expiration != null, baos);
                if (cdi.expiration != null) {
                    StreamUtil.writeLong(cdi.expiration.getTime(), baos);
                }
                StreamUtil.writeBoolean(cdi.fromRemote, baos);
                StreamUtil.writeLong(cdi.messageid, baos);
                StreamUtil.writeBoolean(cdi.persistent, baos);
                StreamUtil.writeBoolean(cdi.redelivered, baos);
                StreamUtil.writeInt(cdi.size, baos);
                StreamUtil.writeBoolean(cdi.undelSubjectIds != null, baos);
                if (cdi.undelSubjectIds == null) continue;
                StreamUtil.writeInt(cdi.undelSubjectIds.size(), baos);
                Iterator i = cdi.undelSubjectIds.iterator();
                while (i.hasNext()) {
                    StreamUtil.writeShort((Short)i.next(), baos);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List createReplicateUndelRequest_V2_List(byte[] body) {
        ArrayList<BrokerDatabase.ClientDeliveryInfo> result = new ArrayList<BrokerDatabase.ClientDeliveryInfo>();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            long replyTracking = StreamUtil.readLong(bais);
            int size = StreamUtil.readInt(bais);
            if (size == 0) {
                return result;
            }
            for (int count = 0; count < size; ++count) {
                BrokerDatabase.ClientDeliveryInfo cdi = FTMgramFactory.initClientDeliveryInfo(bais);
                boolean hasUndelSubjectIds = StreamUtil.readBoolean(bais);
                if (hasUndelSubjectIds) {
                    int szUndelSubjIds = StreamUtil.readInt(bais);
                    HashSet<Short> ids = new HashSet<Short>(szUndelSubjIds);
                    for (int i = 0; i < szUndelSubjIds; ++i) {
                        ids.add(new Short(StreamUtil.readShort(bais)));
                    }
                    cdi.undelSubjectIds = ids;
                }
                result.add(cdi);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List createReplicateUndelRequestList(byte[] body) {
        ArrayList<BrokerDatabase.ClientDeliveryInfo> result = new ArrayList<BrokerDatabase.ClientDeliveryInfo>();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            long replyTracking = StreamUtil.readLong(bais);
            int size = StreamUtil.readInt(bais);
            if (size == 0) {
                return result;
            }
            for (int count = 0; count < size; ++count) {
                BrokerDatabase.ClientDeliveryInfo cdi = FTMgramFactory.initClientDeliveryInfo(bais);
                result.add(cdi);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static BrokerDatabase.ClientDeliveryInfo initClientDeliveryInfo(ByteArrayInputStream bais) throws IOException {
        BrokerDatabase.ClientDeliveryInfo cdi = new BrokerDatabase.ClientDeliveryInfo();
        cdi.cid = StreamUtil.readLong(bais);
        boolean hasDate = StreamUtil.readBoolean(bais);
        Object date = null;
        if (hasDate) {
            long time = StreamUtil.readLong(bais);
            cdi.expiration = new Date(time);
        }
        cdi.fromRemote = StreamUtil.readBoolean(bais);
        cdi.messageid = StreamUtil.readLong(bais);
        cdi.persistent = StreamUtil.readBoolean(bais);
        cdi.redelivered = StreamUtil.readBoolean(bais);
        cdi.size = StreamUtil.readInt(bais);
        return cdi;
    }

    public static byte[] createReplicateUndelReplyPayload(List msgIds) {
        try {
            int size = msgIds.size();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.writeInt(size, baos);
            if (size == 0) {
                return baos.toByteArray();
            }
            for (Long msgId : msgIds) {
                StreamUtil.writeLong((long)msgId, baos);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List createReplicateUndelReplyList(byte[] body) {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            int size = StreamUtil.readInt(bais);
            if (size == 0) {
                return result;
            }
            for (int count = 0; count < size; ++count) {
                long id = StreamUtil.readLong(bais);
                result.add(new Long(id));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

