/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.db.EDatabaseException;
import progress.message.util.StringUtil;

public class RemoteBrokerDescriptor {
    public static final byte CURRENT_VERSION = 1;
    private long m_cid;
    private String m_url;
    private String m_ftPeerUrl;
    private String m_user;
    private String m_password;
    private String m_node;
    private String m_broker;

    public int length() {
        return 8 + StringUtil.lengthUTF(this.m_url) + 1 + (this.m_ftPeerUrl != null ? StringUtil.lengthUTF(this.m_ftPeerUrl) : 0) + 1 + (this.m_user != null ? StringUtil.lengthUTF(this.m_user) : 0) + 1 + (this.m_password != null ? StringUtil.lengthUTF(this.m_password) : 0) + StringUtil.lengthUTF(this.m_node) + StringUtil.lengthUTF(this.m_broker);
    }

    public void setClientId(long cid) {
        this.m_cid = cid;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setFtPeerUrl(String ftPeerUrl) {
        this.m_ftPeerUrl = ftPeerUrl;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setNode(String node) {
        this.m_node = node;
    }

    public void setBroker(String broker) {
        this.m_broker = broker;
    }

    public long getClientId() {
        return this.m_cid;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getFtPeerUrl() {
        return this.m_ftPeerUrl;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getNode() {
        return this.m_node;
    }

    public String getBroker() {
        return this.m_broker;
    }

    public void writeToStream(DataOutput stream, short version) throws IOException {
        stream.writeByte(version);
        stream.writeLong(this.m_cid);
        stream.writeUTF(this.m_url);
        stream.writeBoolean(this.m_ftPeerUrl != null);
        if (this.m_ftPeerUrl != null) {
            stream.writeUTF(this.m_ftPeerUrl);
        }
        stream.writeBoolean(this.m_user != null);
        if (this.m_user != null) {
            stream.writeUTF(this.m_user);
        }
        stream.writeBoolean(this.m_password != null);
        if (this.m_password != null) {
            stream.writeUTF(this.m_password);
        }
        stream.writeUTF(this.m_node);
        stream.writeUTF(this.m_broker);
    }

    public void readFromStream(DataInput stream, short version) throws IOException {
        stream.readByte();
        this.m_cid = stream.readLong();
        this.m_url = stream.readUTF();
        if (stream.readBoolean()) {
            this.m_ftPeerUrl = stream.readUTF();
        }
        if (stream.readBoolean()) {
            this.m_user = stream.readUTF();
        }
        if (stream.readBoolean()) {
            this.m_password = stream.readUTF();
        }
        this.m_node = stream.readUTF();
        this.m_broker = stream.readUTF();
    }

    public static RemoteBrokerDescriptor getRemoteBrokerDescriptor(DataInput stream, short version) throws IOException {
        RemoteBrokerDescriptor rbd = new RemoteBrokerDescriptor();
        rbd.readFromStream(stream, version);
        return rbd;
    }

    public String toString() {
        return "RemoteBrokerDescriptor [m_cid:" + this.m_cid + ", m_url:" + this.m_url + ", m_ftPeerUrl:" + this.m_ftPeerUrl + ", m_user:" + this.m_user + ", m_password:" + this.m_password + ", m_node:" + this.m_node + ", m_broker:" + this.m_broker + "]";
    }

    void addRemoteBroker(AgentRegistrar agentReg) throws EDatabaseException {
        agentReg.getBrokerDatabase().getIRoutingDBQ().addRemoteBroker(this.getClientId(), this.getUrl(), this.getFtPeerUrl(), this.getNode(), this.getBroker(), this.getUser(), this.getPassword());
    }
}

