/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server;

import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import progress.message.broker.Config;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.http.client.ProgressHttpSocket;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.http.server.tunnel.HttpConnectionSocket;

class ProgressHttpServerSocket
extends ProgressServerSocket {
    private SonicHttpServer server;

    ProgressHttpServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr) throws IOException {
        this(principal, port, 0, bindAddr, null);
    }

    ProgressHttpServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        if (Config.DS_DEBUG) {
            System.out.println("ProgressHttpServerSocket.ctor: properties = " + properties);
        }
        try {
            this.server = new SonicHttpServer(bindAddr, port, properties);
            this.server.m_server.start();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    @Override
    public final ProgressSocket accept() throws IOException {
        HttpConnectionSocket s = this.server.acceptHttpConnection();
        if (s instanceof EOFSocket) {
            throw new IOException("Socket instance of " + EOFSocket.class.getName());
        }
        return new ProgressHttpSocket(s);
    }

    @Override
    public final void close() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server.addHttpConnection(new EOFSocket());
        }
    }

    @Override
    public int getPort() {
        return this.server != null && this.server.getSonicHttpServerConnector() != null ? this.server.getSonicHttpServerConnector().getPort() : 0;
    }

    private final class EOFSocket
    extends HttpConnectionSocket {
        EOFSocket() {
            super((ProgressInetAddress)null, -1);
        }
    }
}

