/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import progress.message.client.EAlreadyInTransaction;
import progress.message.client.EChannelTransactionFailure;
import progress.message.client.EClientNotRegistered;
import progress.message.client.EEmptyEnvelope;
import progress.message.client.EEnvelopeIsNotRequest;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.EMessageTypeMismatch;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotConnected;
import progress.message.client.ENotImplemented;
import progress.message.client.ENotInTransaction;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESubjectNotSet;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionAlreadyPrepared;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.client.EUnknownTransaction;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUsage;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.ISizedEnumeration;
import progress.message.util.LongHashTable;
import progress.message.util.WrappedDataOutputStream;
import progress.message.xa.XidImpl;
import progress.message.zclient.Connection;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IJobCompletionListener;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessage;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.ISubject;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Publication;
import progress.message.zclient.Request;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subject;
import progress.message.zclient.Subscription;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.AAFJobResolver;
import progress.message.zclient.xonce.UndelJobResolver;

public class Session {
    private static final short NO_TXN = 0;
    private static final short LOCAL = 1;
    private static final short AGENT = 2;
    private static final short LOCAL_PREPARED = 3;
    private static final short PREPARED = 4;
    private static final String NULL = "null";
    private static final String TRANSACTION_FAILURE_PROPERTY_ID = "STR132";
    private static final String EMPTY_STR = "";
    protected Connection m_parent;
    private short m_txnstate;
    private int m_tid;
    private Vector m_txnSols;
    private final FastVector m_txnAcks;
    private FastVector m_txnClients;
    private boolean m_xaTxn = false;
    private LongHashTable m_envelopeAckTable = new LongHashTable();
    private boolean m_isTxnMgrUsed = false;
    private ArrayList m_txnMsgsPendingStorageAck;
    private boolean m_isClosing = false;
    private int m_minTxnEnqueuePriority = 0;
    public static final int ASYNC = 0;
    public static final int SYNC = -1;

    public Session(Connection parent) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        if (parent == null) {
            throw new EParameterIsNull("parent");
        }
        if (parent.unusable()) {
            throw new EUnusableConnection();
        }
        this.m_parent = parent;
        this.m_txnstate = 0;
        this.m_txnSols = new Vector();
        this.m_txnAcks = new FastVector();
        this.m_txnClients = new FastVector();
        parent.addSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinTxnEnqueuePriority(int prio) {
        ArrayList arrayList = this.m_txnMsgsPendingStorageAck;
        synchronized (arrayList) {
            this.m_minTxnEnqueuePriority = prio;
            this.m_txnMsgsPendingStorageAck.notifyAll();
        }
    }

    public Session(Connection parent, boolean xaTxn) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        this(parent);
        this.m_xaTxn = xaTxn;
    }

    public Session(Connection parent, int tid) throws EGeneralException, EParameterIsNull, EUnusableConnection {
        this(parent, true);
        this.m_tid = tid;
        this.m_txnstate = (short)4;
        if (tid != -1) {
            parent.addSessionTid(this, tid);
        }
    }

    public boolean isXATxn() {
        return this.m_xaTxn;
    }

    public void close() {
        this.m_parent.removeSession(this);
        this.mPrentRemoveSessionTid();
        this.m_isClosing = true;
    }

    public boolean isClosing() {
        return this.m_isClosing;
    }

    public Connection getConnection() {
        return this.m_parent;
    }

    public void publish(IMessage msg) throws EParameterIsNull, ESubjectNotSet, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.publish(msg, -1, false);
    }

    public void publish(Envelope envelope) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.publish(envelope, -1, false);
    }

    public Message request(IMessage userRequest) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, null);
    }

    private final Message request(IMessage userRequest, IJobResolver resolver) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, -1, resolver);
    }

    public Envelope requestEnvelope(IMessage userRequest) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(userRequest, null);
    }

    private Envelope requestEnvelope(IMessage userRequest, IJobResolver resolver) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.requestEnvelope(userRequest, -1, resolver);
    }

    public Message request(Envelope userRequest) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, null);
    }

    private final Message request(Envelope userRequest, IJobResolver resolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, -1, resolver);
    }

    public Solicitation solicit(IMessage userRequest, MessageHandler msgHandler) throws ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.checkNotIsSubjectSet(userRequest);
        return this.solicitInternal(this.buildDefaultEnvelope(userRequest), msgHandler, -1);
    }

    public void reply(IMessage responseMsg, Envelope request) throws EParameterIsNull, EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (!request.isRequest()) {
            throw new EEnvelopeIsNotRequest();
        }
        if (responseMsg == null) {
            throw new EParameterIsNull("reply.responseMessage");
        }
        Envelope renv = new Envelope(responseMsg, (Label)request.getLabel().clone());
        this.replyInternal(renv, request, -1, false);
    }

    public void reply(Envelope response, Envelope request) throws EEmptyEnvelope, EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (response.getMessage() == null) {
            throw new EEmptyEnvelope();
        }
        response.setTimestamp(System.currentTimeMillis());
        Envelope env = (Envelope)response.clone();
        if (response.getLabel() != null) {
            env.setLabel((Label)response.getLabel().clone());
        }
        this.replyInternal(env, request, -1, false);
    }

    public Subscription subscribe(String subject) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.subscribe(subject, null, false, 0);
    }

    public Subscription subscribe(String subject, String messageSelector, boolean isSelectorAtBroker, int flowToDisk) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (subject == null || subject.equals(EMPTY_STR)) {
            throw new EInvalidSubjectSyntax(prAccessor.getString("STR128"));
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        return this.subscribeInternal(new Subject(subject), new Label(), messageSelector, isSelectorAtBroker, false, flowToDisk, false);
    }

    public Subscription submitSubscription(String subjectExp, Label deliveryLabel) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.subscribeInternal(new Subject(subjectExp), deliveryLabel, null, false, false, 0, false);
    }

    public Subscription submitJMSSubscription(ISubject subject, Label deliveryLabel, String messageSelector, boolean isSelectorAtBroker, boolean enforceDurableMessageOrder, int flowToDisk, boolean JMSDurable) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        return this.subscribeInternal(subject, deliveryLabel, messageSelector, isSelectorAtBroker, enforceDurableMessageOrder, flowToDisk, JMSDurable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() throws EParameterIsNull, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (this.m_parent.getBrokerSessionVer() >= 28) {
            if (!this.m_parent.hierarchicallyConnected()) {
                Object object = this.m_parent.getSubscriptionMutex();
                synchronized (object) {
                    this.m_parent.getLocalSubscriptionTable().clear();
                }
                throw new ENotConnected();
            }
            Message req = new Message(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".unsubscribeAll");
            Connection resolver = this.m_parent;
            Object object = this.m_parent.getSubscriptionMutex();
            synchronized (object) {
                this.requestAdmin(req, -1, resolver);
                this.m_parent.getLocalSubscriptionTable().clear();
            }
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            Object object = this.m_parent.getSubscriptionMutex();
            synchronized (object) {
                Subscription[] subscriptions = this.m_parent.getBrokerSubscriptions();
                for (int i = 0; i < subscriptions.length; ++i) {
                    this.m_parent.removeSubscription(subscriptions[i].getSubject());
                }
                throw new ENotConnected();
            }
        }
        Object object = this.m_parent.getSubscriptionMutex();
        synchronized (object) {
            Subscription[] subscriptions = this.m_parent.getBrokerSubscriptions();
            for (int i = 0; i < subscriptions.length; ++i) {
                subscriptions[i].cancel(true);
            }
        }
    }

    public void unsubscribeDurable(String name, String clientId) throws EInvalidApplicationId, EUserAlreadyConnected, ENoSubscribersFound, EClientNotRegistered, ESubjectNotSet, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        Message rep;
        Message req = new Message();
        try {
            req.writeUTF(name);
            if (clientId == null) {
                clientId = EMPTY_STR;
            }
            req.writeUTF(clientId);
        }
        catch (IOException ioe) {
            throw new EInvalidApplicationId();
        }
        int errorCode = 104;
        if (this.m_parent.isFaultToleranceEnabled()) {
            req.setSubject(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".checkUnsubscribeDurable");
            rep = this.requestAdmin(req, -1, this.m_parent);
            errorCode = Session.retrieveErrorCode(errorCode, rep);
            switch (errorCode) {
                case 0: {
                    break;
                }
                case 157: {
                    throw new EClientNotRegistered();
                }
                case 129: {
                    throw new EUserAlreadyConnected(name);
                }
                case 109: {
                    throw new EInvalidApplicationId();
                }
                case -40: {
                    throw new EGeneralException(1408, prAccessor.getString("ERROR_BROKER_EXCEPTION"));
                }
                default: {
                    throw new EGeneralException(errorCode);
                }
            }
        }
        req.setSubject(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".unsubscribeDurable");
        rep = this.requestAdmin(req, -1, this.m_parent);
        errorCode = 104;
        errorCode = Session.retrieveErrorCode(errorCode, rep);
        switch (errorCode) {
            case 0: {
                return;
            }
            case 129: {
                throw new EUserAlreadyConnected(name);
            }
            case 157: {
                if (!this.m_parent.isFaultToleranceEnabled()) {
                    throw new EClientNotRegistered();
                }
                return;
            }
            case 109: {
                throw new EInvalidApplicationId();
            }
            case -40: {
                throw new EGeneralException(1408, prAccessor.getString("ERROR_BROKER_EXCEPTION"));
            }
        }
        throw new EGeneralException(errorCode);
    }

    private static int retrieveErrorCode(int errorCodeParam, Message rep) {
        int errorCode = errorCodeParam;
        try {
            errorCode = rep.readInt();
        }
        catch (IOException ioe) {
            EGeneralException ege = new EGeneralException(errorCode);
            ege.initCause(ioe);
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeQmsg(Envelope envelope, long clientId, Connection consumerConnection) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!envelope.isGuaranteed() || envelope.isAcked() || envelope.forwardAcknowledged()) {
            return;
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.setTxnMgrUsed(true);
        switch (this.m_txnstate) {
            case 0: {
                long guarTrackingNum = envelope.getGuarTracking();
                envelope = null;
                this.m_parent.sendSynchronousQAck(guarTrackingNum, false, 0, clientId, consumerConnection);
                break;
            }
            case 1: {
                this.startAgentTransaction();
            }
            case 2: {
                long tracking = envelope.getGuarTracking();
                FastVector fastVector = this.m_txnAcks;
                synchronized (fastVector) {
                    this.m_txnAcks.addElement(envelope);
                    this.m_txnClients.addElement(new Long(clientId));
                }
                this.m_parent.sendQAck(tracking, true, this.m_tid, clientId);
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared(EMPTY_STR);
            }
        }
    }

    public final void acknowledge(Envelope envelope) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.acknowledge(envelope, false);
    }

    public final void acknowledge(Envelope envelope, boolean dupsOk) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.acknowledge(envelope, dupsOk, -1L);
    }

    public void batchAck(Envelope e, long clientId) throws ENetworkFailure, EGeneralException {
        if (e.isAcked()) {
            return;
        }
        this.setTxnMgrUsed(true);
        if (!e.isGuaranteed()) {
            e.acknowledge(this.m_parent, false, false);
            return;
        }
        EnvelopeAckList envelopeAckList = null;
        envelopeAckList = (EnvelopeAckList)this.m_envelopeAckTable.get(clientId);
        if (envelopeAckList == null) {
            envelopeAckList = new EnvelopeAckList();
            this.m_envelopeAckTable.put(clientId, envelopeAckList);
        }
        envelopeAckList.addAck(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardBatchedAcks() {
        LongHashTable longHashTable = this.m_envelopeAckTable;
        synchronized (longHashTable) {
            this.m_envelopeAckTable.clear();
        }
    }

    public void sendBatchedAcks(boolean dupsOk) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.sendBatchedAcks(dupsOk, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBatchedAcks(boolean dupsOk, boolean txnSync) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        LongHashTable longHashTable = this.m_envelopeAckTable;
        synchronized (longHashTable) {
            try {
                this.sendBatchedAcks(this.m_envelopeAckTable, dupsOk, txnSync);
            }
            finally {
                this.m_envelopeAckTable.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatchedAcks(LongHashTable envelopeMap, boolean dupsOk, boolean txnSync) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        if (envelopeMap != null && !envelopeMap.isEmpty()) {
            IMgram ackListMgram = null;
            long ackTracking = -1L;
            ISizedEnumeration<Long> keyEnum = envelopeMap.keyList();
            while (keyEnum.hasMoreElements()) {
                long clientID = (Long)keyEnum.nextElement();
                EnvelopeAckList envelopeList = (EnvelopeAckList)envelopeMap.get(clientID);
                if (envelopeList == null || envelopeList.isEmpty()) continue;
                if (ackListMgram == null) {
                    ackListMgram = MgramFactory.getMgramFactory().buildAckList();
                    if (!dupsOk) {
                        ackTracking = this.m_parent.genPubTrackingNum();
                        ackListMgram.setGuarenteed(ackTracking);
                    }
                }
                Iterator iter = envelopeList.iterator();
                while (iter.hasNext()) {
                    Envelope envelope = (Envelope)iter.next();
                    switch (this.m_txnstate) {
                        case 0: {
                            if (!envelope.isGuaranteed()) {
                                envelope.acknowledge(this.m_parent, dupsOk, true);
                                break;
                            }
                            long tracking = envelope.getGuarTracking();
                            if (!envelope.isQueueMessage() && !envelope.pubSubMsgAckedAsQMsg()) {
                                this.handleAck(envelope, ackListMgram, tracking);
                                break;
                            }
                            this.addQAck(ackListMgram, tracking, clientID);
                            break;
                        }
                        case 1: {
                            this.startAgentTransaction();
                        }
                        case 2: {
                            long tracking = envelope.getGuarTracking();
                            FastVector fastVector = this.m_txnAcks;
                            synchronized (fastVector) {
                                this.m_txnAcks.addElement(envelope);
                                this.m_txnClients.addElement(new Long(clientID));
                            }
                            if (!envelope.isQueueMessage() && !envelope.pubSubMsgAckedAsQMsg()) {
                                if (!envelope.isSplitDeliveryPart()) {
                                    this.addAckTrackingClientID(ackListMgram, clientID, tracking);
                                    break;
                                }
                                ackListMgram.getAckListHandle().addSplitDeliveryAck(tracking, clientID, false, 0L, true, this.m_tid, this.m_parent.getChannel(), (short)envelope.getSubject().getSubjectTracking());
                                break;
                            }
                            this.ackListHandleAddQAck(ackListMgram, clientID, tracking);
                            break;
                        }
                        case 3: 
                        case 4: {
                            throw new ETransactionAlreadyPrepared(EMPTY_STR);
                        }
                    }
                }
            }
            if (ackListMgram != null) {
                if (this.m_txnstate == 0) {
                    if (dupsOk) {
                        this.m_parent.send(ackListMgram);
                        this.m_parent.getConnectionInfo().guarMsgAcked(ackListMgram);
                    } else {
                        this.m_parent.sendAnyAckSynchonous(ackTracking, ackListMgram, this.m_parent);
                    }
                } else if (!txnSync) {
                    this.m_parent.send(ackListMgram);
                } else {
                    this.m_parent.sendAnyAckSynchonous(ackTracking, ackListMgram, this.m_parent);
                }
            }
        }
    }

    void resendTransactedAcksInBatch() throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (this.m_txnAcks.m_count == 0 || this.m_txnstate != 2) {
            return;
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        IMgram ackListMgram = MgramFactory.getMgramFactory().buildAckList();
        for (int i = 0; i < this.m_txnAcks.m_count; ++i) {
            Envelope envelope = (Envelope)this.m_txnAcks.m_data[i];
            long clientID = (Long)this.m_txnClients.m_data[i];
            long tracking = envelope.getGuarTracking();
            if (!envelope.isQueueMessage() && !envelope.pubSubMsgAckedAsQMsg()) {
                this.addAckTrackingClientID(ackListMgram, clientID, tracking);
                continue;
            }
            this.ackListHandleAddQAck(ackListMgram, clientID, tracking);
        }
        this.m_parent.send(ackListMgram);
    }

    private void addAckTrackingClientID(IMgram ackListMgram, long clientID, long tracking) {
        ackListMgram.getAckListHandle().addAck(tracking, clientID, false, 0L, true, this.m_tid, this.m_parent.getChannel());
    }

    private void ackListHandleAddQAck(IMgram ackListMgram, long clientID, long tracking) {
        ackListMgram.getAckListHandle().addQAck(tracking, clientID, false, 0L, true, this.m_tid, this.m_parent.getChannel());
    }

    public void processUndeliverable(Envelope envelope, int errorCode, long clientID) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        IMgram m = null;
        if (envelope.isGuaranteed()) {
            m = MgramFactory.getMgramFactory().buildAckList();
            long tracking = envelope.getGuarTracking();
            if (envelope.isQueueMessage() || envelope.pubSubMsgAckedAsQMsg()) {
                this.addQAck(m, tracking, clientID);
            } else {
                envelope.acknowledge(this.m_parent, false, true);
                this.handleAck(envelope, m, tracking);
            }
        } else {
            throw new ENotImplemented("Session.processUndelivered for nonguaranteed mgram not implemented");
        }
        IMgram mgToSend = this.buildUndeliverableOp(errorCode, m);
        long opTrk = this.m_parent.genPubTrackingNum();
        mgToSend.setGuarenteed(opTrk);
        mgToSend.sync();
        UndelJobResolver resolver = new UndelJobResolver(mgToSend, this.m_parent);
        Publication job = new Publication(this.m_parent, null, resolver);
        this.m_parent.addJob(opTrk, job);
        this.m_parent.send(mgToSend);
        job.join();
        envelope.setUserAcked();
    }

    private void handleAck(Envelope envelope, IMgram m, long tracking) {
        if (envelope.isSplitDeliveryPart()) {
            m.getAckListHandle().addSplitDeliveryAck(tracking, this.m_parent.getChannel(), (short)envelope.getSubject().getSubjectTracking());
        } else {
            m.getAckListHandle().addAck(tracking, this.m_parent.getChannel());
        }
    }

    private void addQAck(IMgram m, long tracking, long clientID) {
        m.getAckListHandle().addQAck(tracking, clientID, false, 0L, false, 0, this.m_parent.getChannel());
    }

    private IMgram buildUndeliverableOp(int errorCode, IMgram m) {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(27);
        ObjectOutput out = mg.getPayloadOutputStreamHandle();
        try {
            out.writeShort(errorCode);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (m != null) {
            mg.getOperationHandle().addMgram(m);
        }
        return mg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acknowledge(Envelope envelope, boolean dupsOk, long clientID) throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (envelope.isAcked()) {
            return;
        }
        this.setTxnMgrUsed(true);
        if (!envelope.isGuaranteed()) {
            envelope.acknowledge(this.m_parent, dupsOk, false);
            return;
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        switch (this.m_txnstate) {
            case 0: {
                envelope.acknowledge(this.m_parent, dupsOk, false);
                break;
            }
            case 1: {
                this.startAgentTransaction();
            }
            case 2: {
                long tracking = envelope.getGuarTracking();
                FastVector fastVector = this.m_txnAcks;
                synchronized (fastVector) {
                    this.m_txnAcks.addElement(envelope);
                    this.m_txnClients.addElement(new Long(clientID));
                }
                if (!envelope.isSplitDeliveryPart()) {
                    this.m_parent.sendAck(tracking, true, this.m_tid, clientID);
                    break;
                }
                this.m_parent.sendSplitDeliveryAck(tracking, true, this.m_tid, clientID, (short)envelope.getSubject().getSubjectTracking());
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared(EMPTY_STR);
            }
        }
    }

    public void beginWork() throws EUnusableConnection, EAlreadyInTransaction, ETransactionFailure, EGeneralException {
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
        if (this.m_txnstate != 0) {
            throw new EAlreadyInTransaction();
        }
        this.startAgentTransaction();
    }

    public void rollbackWork() throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(false);
    }

    public void rollbackWork(boolean chained) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(chained, true, null);
    }

    public void rollbackWork(boolean chained, Object xid) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.rollbackWork(chained, true, xid);
    }

    public synchronized void rollbackWork(boolean chained, boolean sendRollbackToBroker, Object xid) throws EGeneralException {
        this.m_parent.removeSessionTid(this.m_tid);
        this.removeAllPendingTxnMsgs();
        String failureMessage = prAccessor.getString("STR131");
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
        TransactionStateProcessor params = new TransactionStateProcessor(chained, sendRollbackToBroker, xid, failureMessage);
        this.cancelAllSolicitationsInTransaction();
        this.clearListOfTransactionAcks();
        if (params.haveNextTx) {
            this.setNextTx(params.nextTx);
        }
    }

    private Request buildLocalAbortTransactionRequest(boolean chained) {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildAbortTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel());
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    private void checkReplyStatus(Object xid, String failureMessage, short status) throws ETransactionFailure {
        switch (status) {
            case 2: {
                if (this.m_txnstate == 4) {
                    this.m_txnstate = 0;
                    throw new EUnknownTransaction(EMPTY_STR);
                }
            }
            case 0: {
                this.m_txnstate = 0;
                break;
            }
            case 3: {
                throw new ETransactionFailure(125, prAccessor.getString(TRANSACTION_FAILURE_PROPERTY_ID));
            }
            case 12: {
                if (xid == null) {
                    throw new EXAThereIsNoXidException(NULL);
                }
                throw new EXAThereIsNoXidException(xid.toString());
            }
            case 11: {
                if (xid == null) {
                    throw new EXADuplicateXidException(NULL);
                }
                throw new EXADuplicateXidException(xid.toString());
            }
            case 6: {
                throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
            }
            default: {
                throw new ETransactionFailure(124, failureMessage);
            }
        }
    }

    private void cancelAllSolicitationsInTransaction() {
        for (int i = 0; i < this.m_txnSols.size(); ++i) {
            ((Solicitation)this.m_txnSols.elementAt(i)).cancel();
        }
        this.m_txnSols.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListOfTransactionAcks() {
        FastVector fastVector = this.m_txnAcks;
        synchronized (fastVector) {
            this.m_txnAcks.m_count = 0;
            this.m_txnClients.m_count = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prepareWork(Object transactionID) throws ENotInTransaction, ETransactionAlreadyPrepared, ETransactionRollbackByBroker, EUnusableConnection, ETransactionFailure, ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        String FAILURE_MESSAGE = prAccessor.getString("STR133");
        String ALREADY_COMMITTED = prAccessor.getString("STR134");
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
        switch (this.m_txnstate) {
            case 0: {
                throw new ENotInTransaction(prAccessor.getString(TRANSACTION_FAILURE_PROPERTY_ID));
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared(EMPTY_STR);
            }
            case 1: {
                this.m_txnstate = (short)3;
                return true;
            }
            case 2: {
                try {
                    short status;
                    if (this.isXATxn()) {
                        if (transactionID == null) {
                            throw new EParameterIsNull("xid");
                        }
                        byte[] replyBody = this.requestXATxnOperation(false, transactionID, 2);
                        int p = 0;
                        status = ArrayUtil.readShort(replyBody, p);
                    } else {
                        Message req = new Message(this.m_parent.getAdminPrefix() + ".prepareTransaction");
                        req.writeInt(this.m_tid);
                        req.writeUTF((String)transactionID);
                        Message rep = this.request((IMessage)req, (IJobResolver)this.m_parent);
                        status = rep.readShort();
                    }
                    switch (status) {
                        case 0: {
                            this.m_txnstate = (short)4;
                            return true;
                        }
                        case 2: 
                        case 4: {
                            this.m_txnstate = 0;
                            throw new ETransactionRollbackByBroker(EMPTY_STR);
                        }
                        case 3: {
                            throw new ETransactionFailure(125, ALREADY_COMMITTED);
                        }
                        case 12: {
                            if (transactionID != null) throw new EXAThereIsNoXidException(transactionID.toString());
                            throw new EXAThereIsNoXidException(NULL);
                        }
                        case 6: {
                            throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
                        }
                    }
                    throw new ETransactionFailure(124, FAILURE_MESSAGE);
                }
                catch (ENoSubscribersFound e) {
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
                }
                catch (ENotConnected e) {
                    throw e;
                }
                catch (EGeneralException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new ETransactionFailure(124, FAILURE_MESSAGE, e);
                }
            }
        }
        return true;
    }

    private byte[] requestXATxnOperation(boolean chained, Object xid, int op) throws EInterrupted, ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Connection xaTXRequestResolver = this.m_parent;
        Request request = new Request(null, xaTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildExtendedTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), (XidImpl)xid, op);
        request.setRequestMgram(requestMgram);
        request.setXonce(this.m_parent.isFaultToleranceEnabled());
        Request enqueuedListener = request;
        this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
        if (!this.m_parent.hierarchicallyConnected()) {
            this.m_parent.removeRequest(replyTracking);
            throw new ENotConnected();
        }
        request.join();
        IMgram replyMgram = request.getReplyMgram();
        byte[] replyBody = replyMgram.getRawBody();
        return replyBody;
    }

    public void commitWork() throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(false, null, -1L, null);
    }

    public synchronized void commitWork(boolean chained, String transactionId, long lifespan) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(chained, transactionId, lifespan, null);
    }

    public synchronized void commitWork(boolean chained, String transactionId, long lifespan, boolean isChannel, int channelStatus, String channelID) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(chained, transactionId, lifespan, null, isChannel, channelStatus, channelID);
    }

    public synchronized void commitWork(boolean chained, Object xid) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(chained, null, -1L, xid);
    }

    public synchronized void commitWork(boolean chained, String transactionId, long lifespan, Object xid) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.commitWork(chained, transactionId, lifespan, xid, false, 14, EMPTY_STR);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void commitWork(boolean chained, String transactionId, long lifespan, Object xid, boolean isChannel, int channelStatus, String channelID) throws ENotInTransaction, EUnusableConnection, EUnknownTransaction, ETransactionRollbackByBroker, ETransactionFailure, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        FAILURE_MESSAGE = prAccessor.getString("STR135");
        ALREADY_COMMITTED = prAccessor.getString("STR136");
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
        haveNextTx = false;
        nextTx = 0;
        switch (this.m_txnstate) {
            case 0: {
                throw new ENotInTransaction(prAccessor.getString("STR132"));
            }
            case 1: 
            case 3: {
                this.m_txnstate = 0;
                break;
            }
            case 2: 
            case 4: {
                try {
                    request = null;
                    request = this.isXATxn() != false ? this.buildGlobalCommitTransactionRequest(chained, (XidImpl)xid) : this.buildLocalCommitTransactionRequest(chained, transactionId, lifespan, isChannel, channelStatus, channelID);
                    enqueuedListener = request;
                    this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
                    request.join();
                    replyMgram = request.getReplyMgram();
                    p = 0;
                    replyBody = replyMgram.getRawBody();
                    status = ArrayUtil.readShort(replyBody, p);
                    p += 2;
                    p += 4;
                    ttl = -1L;
                    if (status == 13) {
                        ttl = ArrayUtil.readLong(replyBody, p);
                        p += 8;
                    }
                    if (chained) {
                        nextTx = ArrayUtil.readInt(replyBody, p);
                        p += 4;
                        haveNextTx = true;
                    }
                    switch (status) {
                        case 0: {
                            this.m_txnstate = 0;
                            this.setUserAcked();
                            ** break;
                        }
                        case 2: {
                            if (this.m_txnstate == 4) {
                                this.m_txnstate = 0;
                                throw new EUnknownTransaction("");
                            }
                        }
                        case 4: {
                            this.m_txnstate = 0;
                            this.cleanUp();
                            if (haveNextTx) {
                                this.setNextTx(nextTx);
                            }
                            throw new ETransactionRollbackByBroker("");
                        }
                        case 3: {
                            throw new ETransactionFailure(125, ALREADY_COMMITTED);
                        }
                        case 12: {
                            if (xid == null) {
                                throw new EXAThereIsNoXidException("null");
                            }
                            throw new EXAThereIsNoXidException(xid.toString());
                        }
                        case 11: {
                            if (xid == null) {
                                throw new EXADuplicateXidException("null");
                            }
                            throw new EXADuplicateXidException(xid.toString());
                        }
                        case 6: {
                            throw new ETransactionFailure(158, SessionConfig.ERRMSG_TXN_ACC_VIOL);
                        }
                        case 13: {
                            ttl = ttl > 0L ? System.currentTimeMillis() + ttl : System.currentTimeMillis();
                            ectf = new EChannelTransactionFailure(status, "Channel active");
                            ectf.setTime(ttl);
                            throw ectf;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.m_txnstate = 0;
                            this.cleanUp();
                            if (haveNextTx) {
                                this.setNextTx(nextTx);
                            }
                            throw new ETransactionFailure(status, "Duplicate Transaction Detection exception");
                        }
                    }
                    throw new ETransactionFailure(124, FAILURE_MESSAGE);
lbl73:
                    // 1 sources

                    break;
                }
                catch (ENoSubscribersFound e) {
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
                }
                catch (EGeneralException e) {
                    throw e;
                }
            }
        }
        this.cleanUp();
        if (haveNextTx) {
            this.setNextTx(nextTx);
        }
    }

    public int getTid() {
        return this.m_tid;
    }

    private void setNextTx(int nextTx) {
        this.mPrentRemoveSessionTid();
        this.m_tid = nextTx;
        this.m_txnstate = (short)2;
        this.m_parent.addSessionTid(this, this.m_tid);
    }

    private void mPrentRemoveSessionTid() {
        if (this.m_tid != -1) {
            this.m_parent.removeSessionTid(this.m_tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.m_txnSols.removeAllElements();
        FastVector fastVector = this.m_txnAcks;
        synchronized (fastVector) {
            for (int i = 0; i < this.m_txnAcks.m_count; ++i) {
                ((Envelope)this.m_txnAcks.m_data[i]).acknowledge(this.m_parent, false, true);
            }
            this.m_txnAcks.m_count = 0;
            this.m_txnClients.m_count = 0;
        }
        this.removeAllPendingTxnMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserAcked() {
        FastVector fastVector = this.m_txnAcks;
        synchronized (fastVector) {
            for (int i = 0; i < this.m_txnAcks.m_count; ++i) {
                ((Envelope)this.m_txnAcks.m_data[i]).setUserAcked();
            }
        }
    }

    public boolean isInWorkScope() {
        return this.m_txnstate != 0;
    }

    public int updateChannelDupDetectInfo(String uuid, String channelID, long ttl, int channelState) throws IOException {
        Request request;
        Request enqueuedListener = request = this.buildNoDupChannelUpdateTxnRequest(uuid, ttl, channelState, channelID);
        this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
        request.join();
        IMgram replyMgram = request.getReplyMgram();
        int p = 0;
        byte[] replyBody = replyMgram.getRawBody();
        short status = ArrayUtil.readShort(replyBody, p);
        p += 2;
        return status;
    }

    public int deleteChannelDupDetectInfo(String uuid, String channelID) throws IOException {
        Request request;
        Request enqueuedListener = request = this.buildNoDupChannelDeleteTxnRequest(uuid, channelID);
        this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
        request.join();
        IMgram replyMgram = request.getReplyMgram();
        int p = 0;
        byte[] replyBody = replyMgram.getRawBody();
        short status = ArrayUtil.readShort(replyBody, p);
        p += 2;
        return status;
    }

    public Publication publish(IMessage msg, int timeoutSec, boolean returnObject) throws EParameterIsNull, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (msg == null) {
            throw new EParameterIsNull(SessionConfig.PARAM_IS_NULL);
        }
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.checkNotIsSubjectSet(msg);
        Envelope publishEnvelope = new Envelope(msg, new Label());
        publishEnvelope.clearSysFields();
        return this.publishInternal(publishEnvelope, timeoutSec, returnObject, false);
    }

    public Publication publish(Envelope envelope, int timeoutSec, boolean returnObject) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        int timeoutMs = timeoutSec > 0 ? timeoutSec * 1000 : timeoutSec;
        return this.publishMs(envelope, timeoutMs, returnObject);
    }

    public Publication publishMs(Envelope envelope, int timeoutMs, boolean returnObject) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        return this.publishMs(envelope, timeoutMs, returnObject, null);
    }

    public Publication publishMs(Envelope envelope, int timeoutMs, boolean returnObject, IJobCompletionListener jobListener) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.checkEnvelopeIsNull(envelope);
        if (!this.m_parent.hierarchicallyConnected(timeoutMs)) {
            throw new ENotConnected();
        }
        Message msg = envelope.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        envelope.setTimestamp(System.currentTimeMillis());
        if (SessionConfig.IN_BROKER) {
            envelope = (Envelope)envelope.clone();
        }
        envelope.clearSysFields();
        return this.publishInternalMs(envelope, timeoutMs, returnObject, false, null, jobListener);
    }

    public final Publication publish(Envelope envelope, int timeoutSec, boolean returnObject, boolean useTxn) throws EParameterIsNull, EEmptyEnvelope, ESubjectNotSet, ETimeout, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.checkEnvelopeIsNull(envelope);
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message msg = envelope.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        envelope.setTimestamp(System.currentTimeMillis());
        envelope.clearSysFields();
        return this.publishInternal(envelope, timeoutSec, returnObject, !useTxn);
    }

    private void checkEnvelopeIsNull(Envelope envelope) throws EParameterIsNull {
        if (envelope == null) {
            throw new EParameterIsNull("envelope");
        }
    }

    public Message request(IMessage userRequest, int seconds) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, seconds, null);
    }

    public Message request(IMessage userRequest, int seconds, IJobResolver resolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.checkNotIsSubjectSet(userRequest);
        Envelope requestEnv = new Envelope(userRequest, new Label());
        IMessage ret = this.requestInternal(requestEnv, seconds, resolver);
        return (Message)ret;
    }

    public Message requestAdmin(IMessage userRequest, int seconds, IJobResolver resolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.checkNotIsSubjectSet(userRequest);
        Envelope requestEnv = new Envelope(userRequest, new Label());
        requestEnv.getLabel().setPriority((byte)12);
        IMessage ret = this.requestInternal(requestEnv, seconds, resolver);
        return (Message)ret;
    }

    private Envelope requestEnvelope(IMessage userRequest, int seconds, IJobResolver resolver) throws ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        this.checkNotIsSubjectSet(userRequest);
        Envelope requestEnv = new Envelope(userRequest, new Label());
        return new Envelope(this.requestInternal(requestEnv, seconds, resolver));
    }

    public Message request(Envelope userRequest, int seconds) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        return this.request(userRequest, seconds, null);
    }

    public Message request(Envelope userRequest, int seconds, IJobResolver resolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EMessageTypeMismatch, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message msg = userRequest.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        if (SessionConfig.DEBUG) {
            System.out.println("request: " + userRequest.toString());
        }
        userRequest.setTimestamp(System.currentTimeMillis());
        IMessage ret = this.requestInternal((Envelope)userRequest.clone(), seconds, resolver);
        return (Message)ret;
    }

    public Envelope requestEnvelope(Envelope userRequest, int seconds, IJobResolver resolver) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message msg = userRequest.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        if (SessionConfig.DEBUG) {
            System.out.println("request: " + userRequest.toString());
        }
        userRequest.setTimestamp(System.currentTimeMillis());
        return new Envelope(this.requestInternal((Envelope)userRequest.clone(), seconds, resolver));
    }

    public Solicitation solicit(Envelope userRequest, MessageHandler msgHandler) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message msg = userRequest.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        userRequest.setTimestamp(System.currentTimeMillis());
        Envelope solenv = (Envelope)userRequest.clone();
        solenv.clearSysFields();
        return this.solicitInternal(solenv, msgHandler, -1);
    }

    public Publication reply(IMessage response, Envelope request, boolean ret) throws EEnvelopeIsNotRequest, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Envelope renv = new Envelope(response, (Label)request.getLabel().clone());
        return this.replyInternal(renv, request, 0, ret);
    }

    Subscription subscribeInternal(ISubject subject, Label label, String selector, boolean isSelectorAtBroker, boolean enforceDurableMessageOrder, int flowToDisk, boolean JMSDurable) throws ENetworkFailure, ESecurityPolicyViolation, EInvalidTTLException, EGeneralException {
        Object object = this.m_parent.getSubscriptionMutex();
        synchronized (object) {
            Subscription s = this.m_parent.addSubscription(subject);
            if (selector != null) {
                s.setMessageSelector(selector);
                s.setSelectorAtBroker(isSelectorAtBroker);
            }
            s.setDurableStrictMessageOrder(enforceDurableMessageOrder);
            s.setFlowToDisk(flowToDisk);
            s.setJMSDurable(JMSDurable);
            try {
                s.setDeliveryLabel(label);
                s.setStatus(1);
                return s;
            }
            catch (EGeneralException e) {
                if (s.getStatus() == 3) {
                    s.setStatus(0);
                    this.m_parent.removeSubscription(subject);
                }
                throw e;
            }
        }
    }

    protected Message buildSubscribeRequest(ISubject subject, Label label, String messageSelector, boolean isSelectorAtBroker, boolean enforceDurableMessageOrder, int flowToDisk, boolean m_JMSDurable) throws EInvalidSubjectSyntax {
        if (this.m_parent.getBrokerSessionVer() >= 28) {
            Message req = new Message(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".subscribeP28");
            try {
                WrappedDataOutputStream out = new WrappedDataOutputStream(req);
                subject.writeToStream(out);
                label.serialize(req);
                req.writeUTF(messageSelector == null ? EMPTY_STR : messageSelector);
                req.writeInt(flowToDisk);
                byte flag = 0;
                if (isSelectorAtBroker) {
                    flag = (byte)(flag | 1);
                }
                if (enforceDurableMessageOrder) {
                    flag = (byte)(flag | 2);
                }
                if (m_JMSDurable) {
                    flag = (byte)(flag | 4);
                }
                req.write(flag);
                return req;
            }
            catch (IOException e) {
                throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{e.toString()}), e);
            }
        }
        Message req = new Message(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".subscribe");
        try {
            req.writeUTF(subject.getSubjectString());
            label.serialize(req);
            req.writeUTF(messageSelector == null ? EMPTY_STR : messageSelector);
            req.writeBoolean(isSelectorAtBroker);
            req.writeBoolean(enforceDurableMessageOrder);
            req.writeInt(flowToDisk);
            return req;
        }
        catch (IOException e) {
            throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{e.toString()}), e);
        }
    }

    protected Message buildUnsubscribeRequest(ISubject subject) throws EInvalidSubjectSyntax {
        if (this.m_parent.getBrokerSessionVer() >= 28) {
            Message req = new Message(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".unsubscribeP28");
            try {
                WrappedDataOutputStream dos = new WrappedDataOutputStream(req);
                subject.writeToStream(dos);
                return req;
            }
            catch (IOException e) {
                throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{e.toString()}), e);
            }
        }
        Message req = new Message(SessionConfig.getAdminPrefix(this.m_parent.getEffectiveUid(), this.m_parent.getApplicationId()) + ".unsubscribe");
        try {
            req.writeInt(0);
            req.writeUTF(subject.getSubjectString());
            return req;
        }
        catch (IOException e) {
            throw new EInvalidSubjectSyntax(prMessageFormat.format(prAccessor.getString("STR138"), new Object[]{e.toString()}), e);
        }
    }

    public Publication publishInternal(Envelope env, int timeoutSec, boolean ret, boolean noTxn) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        return this.publishInternal(env, timeoutSec, ret, noTxn, null);
    }

    public final Publication publishInternal(Envelope env, int timeoutSec, boolean ret, boolean noTxn, Request request) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        int timeoutMs = timeoutSec > 0 ? timeoutSec * 1000 : timeoutSec;
        return this.publishInternalMs(env, timeoutMs, ret, noTxn, request);
    }

    public final Publication publishInternalMs(Envelope env, int timeoutMs, boolean ret, boolean noTxn, Request request) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        return this.publishInternalMs(env, timeoutMs, ret, noTxn, request, null);
    }

    public final Publication publishInternalMs(Envelope env, int timeoutMs, boolean ret, boolean noTxn, Request request, IJobCompletionListener jobListener) throws EInterrupted, ETimeout, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        boolean isAckAndForward = 11 == env.getMgram().getType();
        this.checkStampEnvelopeWithTxnId(env, noTxn);
        MgramEnqueuedToSendListener enqueuedListener = new MgramEnqueuedToSendListener(request, env);
        if (this.checkRequestAsyncPublish(env, timeoutMs, ret, enqueuedListener)) {
            return null;
        }
        long tracking = this.m_parent.genPubTrackingNum();
        env.setGuaranteed(tracking);
        AAFJobResolver resolver = isAckAndForward ? new AAFJobResolver(env, this.m_parent) : null;
        Publication publication = this.createPublication(env, jobListener, resolver);
        if (isAckAndForward) {
            enqueuedListener = new MgramEnqueuedToSendListener(publication, env);
            publication.setStatus(3);
        }
        this.checkRequestOnPublication(request, publication);
        this.checkPartOfRecoveryEffort(tracking, publication);
        this.checkDisconnected(timeoutMs, tracking);
        switch (timeoutMs) {
            case -1: {
                this.sendListener(env, enqueuedListener, tracking);
                publication.join();
                break;
            }
            case 0: {
                this.sendListener(env, enqueuedListener, tracking);
                break;
            }
            default: {
                long endtime = System.currentTimeMillis() + (long)timeoutMs;
                try {
                    this.m_parent.send(env, timeoutMs, enqueuedListener);
                }
                catch (EGeneralException e) {
                    this.m_parent.removeJob(tracking);
                    throw e;
                }
                try {
                    publication.joinMillis(endtime - System.currentTimeMillis());
                    break;
                }
                catch (ETimeout et) {
                    env.getMgram().setDeliveryCancelled();
                    this.m_parent.removeJob(tracking);
                    throw et;
                }
            }
        }
        if (-3 == publication.getStatus()) {
            throw new EIntegrityCompromised();
        }
        return ret ? publication : null;
    }

    private void checkStampEnvelopeWithTxnId(Envelope env, boolean noTxn) throws EGeneralException {
        if (!noTxn) {
            switch (this.m_txnstate) {
                case 1: {
                    this.startAgentTransaction();
                }
                case 2: {
                    env.setTxn(this.m_tid);
                    break;
                }
                case 3: 
                case 4: {
                    throw new ETransactionAlreadyPrepared(EMPTY_STR);
                }
            }
        }
    }

    private boolean checkRequestAsyncPublish(Envelope env, int timeoutMs, boolean ret, IMgramEnqueuedToSendListener enqueuedListener) throws ENetworkFailure, EInterrupted, EFlowControlException {
        if (timeoutMs == 0 && !ret) {
            if (env.getRejectionTracker() != null) {
                env.setRejectable(true);
            }
            this.m_parent.send(env, enqueuedListener);
            return true;
        }
        return false;
    }

    private void checkDisconnected(int timeoutMs, long tracking) throws ETimeout, ENotConnected {
        if (!this.m_parent.hierarchicallyConnected(timeoutMs)) {
            this.m_parent.removeJob(tracking);
            throw new ENotConnected();
        }
    }

    private Publication createPublication(Envelope env, IJobCompletionListener jobListener, IJobResolver resolver) {
        Publication publication = new Publication(this.m_parent, env.getMessage().getSubject(), resolver);
        if (jobListener != null) {
            publication.setJobCompletionListener(jobListener);
        }
        if (env.getRejectionTracker() != null) {
            publication.setEnvelope(env);
        }
        return publication;
    }

    private void checkRequestOnPublication(Request request, Publication publication) {
        if (request != null) {
            request.setGuarPub(publication);
        }
    }

    private void checkPartOfRecoveryEffort(long tracking, Publication publication) throws ENotConnected {
        if (this.m_parent.isRecoveryThread()) {
            this.m_parent.addJobForRecoveryPurposes(tracking, publication);
        } else {
            this.m_parent.addJob(tracking, publication);
        }
    }

    private void sendListener(Envelope envelope, IMgramEnqueuedToSendListener enqueuedListener, long tracking) throws ENetworkFailure, EInterrupted, EFlowControlException {
        try {
            this.m_parent.send(envelope, enqueuedListener);
        }
        catch (EGeneralException e) {
            this.m_parent.removeJob(tracking);
            throw e;
        }
    }

    private Publication replyInternal(Envelope response, Envelope request, int timeout, boolean ret) throws EEnvelopeIsNotRequest, ETimeout, EInterrupted, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        response.clearSysFields();
        response.setReply(request);
        return this.publishInternal(response, timeout, ret, false);
    }

    private IMessage requestInternal(Envelope userRequest, int seconds, IJobResolver resolver) throws ETimeout, EInterrupted, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        userRequest.clearSysFields();
        Request req = new Request(userRequest, resolver);
        int tracking = this.m_parent.addRequest(req);
        userRequest.setRequest(tracking, this.m_parent.getClientAddrSubject());
        Label newLabel = (Label)userRequest.getLabel().clone();
        newLabel.setReplyPriority((byte)10);
        userRequest.setLabel(newLabel);
        boolean timeout = seconds != -1 && seconds != 0;
        long starttime = 0L;
        if (timeout) {
            starttime = System.currentTimeMillis();
        }
        this.publishInternal(userRequest, seconds, false, true, req);
        if (timeout) {
            long millis = (long)seconds * 1000L - (System.currentTimeMillis() - starttime);
            if (millis <= 0L) {
                throw new ETimeout(SessionConfig.REQ_TIMEOUT);
            }
            req.joinMillis(millis);
        } else {
            req.join();
        }
        Message ret = req.getReply().getMessage();
        return ret;
    }

    public Solicitation solicitInternal(Envelope userRequest, MessageHandler msgHandler, int timeoutSec) throws EEmptyEnvelope, ESubjectNotSet, ENoSubscribersFound, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        if (!this.m_parent.hierarchicallyConnected()) {
            throw new ENotConnected();
        }
        Message msg = userRequest.getMessage();
        if (msg == null) {
            throw new EEmptyEnvelope();
        }
        this.checkNotIsSubjectSet(msg);
        switch (this.m_txnstate) {
            case 0: {
                break;
            }
            case 1: {
                this.startAgentTransaction();
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                throw new ETransactionAlreadyPrepared(EMPTY_STR);
            }
        }
        this.m_parent.addMessageHandler(msgHandler);
        Solicitation s = this.m_parent.addSolicitation(userRequest, msgHandler);
        userRequest.setRequest(s.getTracking(), this.m_parent.getClientAddrSubject());
        if (this.m_txnstate == 2) {
            this.m_txnSols.addElement(s);
        }
        try {
            this.publishInternal(userRequest, timeoutSec, false, false);
        }
        catch (EGeneralException e) {
            s.cancel();
            throw e;
        }
        return s;
    }

    private void checkNotIsSubjectSet(IMessage msg) throws ESubjectNotSet {
        if (!msg.isSubjectSet()) {
            throw new ESubjectNotSet();
        }
    }

    protected final Envelope buildDefaultEnvelope(IMessage m) {
        return new Envelope(m, new Label());
    }

    public boolean isPublishAllowed(String subject) {
        return this.isOperationAllowed("PUBLISH", subject);
    }

    public boolean isSubscribeAllowed(String subject) {
        return this.isOperationAllowed("SUBSCRIBE", subject);
    }

    public boolean isGuaranteedAllowed(String subject) {
        return this.isOperationAllowed("GUARANTEE", subject);
    }

    private boolean isOperationAllowed(String operation, String subject) {
        boolean ret = false;
        if (this.m_parent.unusable() || !this.m_parent.hierarchicallyConnected() || subject == null || subject.compareTo(EMPTY_STR) == 0) {
            return ret;
        }
        try {
            Message req = new Message(this.m_parent.getAdminPrefix() + "." + "isOperationAllowed");
            req.writeUTF(operation);
            req.writeUTF(subject);
            Connection resolver = this.m_parent;
            Message rep = this.request((IMessage)req, (IJobResolver)resolver);
            ret = rep.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private void startAgentTransaction() throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        try {
            Request request;
            Request enqueuedListener = request = this.buildLocalBeginTransactionRequest();
            this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
            request.join();
            IMgram replyMgram = request.getReplyMgram();
            int p = 0;
            byte[] replyBody = replyMgram.getRawBody();
            ArrayUtil.readShort(replyBody, p);
            p += 2;
            this.setNextTx(ArrayUtil.readInt(replyBody, p += 4));
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (EGeneralException e) {
            throw e;
        }
    }

    private Request buildLocalBeginTransactionRequest() {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildBeginTxnRequest(this.m_parent.isFaultToleranceEnabled(), replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel());
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    private Request buildLocalCommitTransactionRequest(boolean chained, String transactionId, long lifespan, boolean isChannel, int channelStatus, String channelID) {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = null;
        requestMgram = transactionId == null ? MgramFactory.getMgramFactory().buildCommitTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel()) : (!isChannel ? MgramFactory.getMgramFactory().buildNoDupCommitTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), transactionId, lifespan) : MgramFactory.getMgramFactory().buildNoDupChannelCommitTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), transactionId, lifespan, channelStatus, channelID));
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    private Request buildGlobalCommitTransactionRequest(boolean chained, Object xid) {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildExtendedTxnRequest(this.m_parent.isFaultToleranceEnabled(), chained, this.m_tid, replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), (XidImpl)xid, 3);
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    public void setTxnMgrUsed(boolean txnMgrUsed) {
        this.m_isTxnMgrUsed = txnMgrUsed;
    }

    public boolean isTxnMgrUsed() {
        return this.m_isTxnMgrUsed;
    }

    private Request buildNoDupChannelUpdateTxnRequest(String transactionId, long lifespan, int channelStatus, String channelID) {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildNoDupChannelUpdateTxnRequest(this.m_parent.isFaultToleranceEnabled(), replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), transactionId, lifespan, channelStatus, channelID);
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    private Request buildNoDupChannelDeleteTxnRequest(String transactionId, String channelID) {
        Connection localTXRequestResolver = this.m_parent;
        Request request = new Request(null, localTXRequestResolver);
        int replyTracking = this.m_parent.addRequest(request);
        IMgram requestMgram = MgramFactory.getMgramFactory().buildNoDupChannelDeleteTxnRequest(this.m_parent.isFaultToleranceEnabled(), replyTracking, this.m_parent.getClientId(), this.m_parent.getChannel(), transactionId, channelID);
        return this.configRequestMgramAndXOnce(request, requestMgram);
    }

    private Request configRequestMgramAndXOnce(Request request, IMgram requestMgram) {
        request.setRequestMgram(requestMgram);
        request.setXonce(this.m_parent.isFaultToleranceEnabled());
        return request;
    }

    public void beginGlobalTransaction(Object xid) throws EUnusableConnection, EAlreadyInTransaction, ETransactionFailure, EXADuplicateXidException, ENotConnected, EGeneralException {
        if (!this.isXATxn()) {
            throw new EUsage(99, "non XA txn should not start by this method.");
        }
        this.checkXidAndIsUsable(xid);
        if (this.m_txnstate != 0) {
            throw new EAlreadyInTransaction();
        }
        try {
            byte[] replyBody = this.requestXATxnOperation(false, xid, 0);
            int p = 0;
            short retCode = ArrayUtil.readShort(replyBody, p);
            p += 2;
            switch (retCode) {
                case 0: {
                    this.m_tid = ArrayUtil.readInt(replyBody, p += 4);
                    this.m_txnstate = (short)2;
                    this.m_parent.addSessionTid(this, this.m_tid);
                    break;
                }
                case 11: {
                    throw new EXADuplicateXidException(xid.toString());
                }
                default: {
                    throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
                }
            }
        }
        catch (ESecurityPolicyViolation e) {
            throw e;
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (EXADuplicateXidException e) {
            throw e;
        }
        catch (EInterrupted e) {
            throw e;
        }
        catch (ENotConnected e) {
            throw e;
        }
        catch (ENetworkFailure e) {
            throw e;
        }
        catch (EGeneralException e) {
            throw e;
        }
    }

    public void resumeGlobalTransaction(Object xid) throws EUnusableConnection, ETransactionFailure, EXAThereIsNoXidException, ENotConnected, EGeneralException {
        this.checkXidAndIsUsable(xid);
        try {
            byte[] replyBody = this.requestXATxnOperation(false, xid, 5);
            int p = 0;
            short retCode = ArrayUtil.readShort(replyBody, p);
            p += 2;
            this.handleResult(retCode, xid);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (ENotConnected e) {
            throw e;
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
    }

    public void joinGlobalTransaction(Object xid) throws EUnusableConnection, ETransactionFailure, EXAThereIsNoXidException, ENotConnected, EGeneralException {
        this.checkXidAndIsUsable(xid);
        try {
            byte[] rep = this.requestXATxnOperation(false, xid, 4);
            short retCode = ArrayUtil.readShort(rep, 0);
            this.handleResult(retCode, xid);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (ENotConnected e) {
            throw e;
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
    }

    private void handleResult(short retCode, Object xid) throws ETransactionFailure {
        switch (retCode) {
            case 0: {
                this.m_txnstate = (short)2;
                break;
            }
            case 12: {
                throw new EXAThereIsNoXidException(xid.toString());
            }
            case 2: {
                throw new ETransactionFailure(126, "txn(" + this.m_tid + ") not found in broker.");
            }
            case 3: {
                throw new ETransactionFailure(126, "txn(" + this.m_tid + ") sequence error in broker.");
            }
            default: {
                throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
            }
        }
    }

    public void endGlobalTransaction(Object xid) throws EParameterIsNull, EUnusableConnection, ENotConnected, ENetworkFailure, EXAThereIsNoXidException, ETransactionFailure {
        this.checkXidAndIsUsable(xid);
        try {
            byte[] replyBody = this.requestXATxnOperation(false, xid, 1);
            int p = 0;
            short retCode = ArrayUtil.readShort(replyBody, p);
            this.handleResultCode(retCode, xid);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (ENotConnected e) {
            throw e;
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
    }

    public void suspendGlobalTransaction(Object xid) throws EParameterIsNull, EUnusableConnection, ENotConnected, ENetworkFailure, EXAThereIsNoXidException, ETransactionFailure {
        this.checkXidAndIsUsable(xid);
        try {
            byte[] rep = this.requestXATxnOperation(false, xid, 6);
            short retCode = ArrayUtil.readShort(rep, 0);
            this.handleResultCode(retCode, xid);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (ENotConnected e) {
            throw e;
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
    }

    private void handleResultCode(short retCode, Object xid) throws ETransactionFailure {
        switch (retCode) {
            case 0: {
                break;
            }
            case 12: {
                throw new EXAThereIsNoXidException(xid.toString());
            }
            case 2: {
                throw new ETransactionFailure(126, "txn(" + this.m_tid + ") not found in broker.");
            }
            case 3: {
                throw new ETransactionFailure(126, "txn(" + this.m_tid + ") sequence error in broker.");
            }
            default: {
                throw new ETransactionFailure(126, SessionConfig.INVALID_BEG_TXN_REPLY);
            }
        }
    }

    public Vector getPreparedGlobalTransactions() throws EUnusableConnection, ENetworkFailure, ETransactionFailure {
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
        Vector<Object> ret = new Vector<Object>();
        try {
            Message req = null;
            req = new Message(this.m_parent.getAdminPrefix() + ".getPreparedGlobalTransactions");
            Message rep = this.request((IMessage)req, (IJobResolver)this.m_parent);
            int totalTxnInfo = rep.readInt();
            for (int i = 0; i < totalTxnInfo; ++i) {
                ret.addElement(rep.readObject());
            }
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (ClassNotFoundException e) {
            throw new ENetworkFailure(176, "ClassNotFound from rep.readObject()", e);
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
        return ret;
    }

    public boolean isThereXid(Object xid) throws EParameterIsNull, EUnusableConnection, ENetworkFailure, ETransactionFailure {
        this.checkXidAndIsUsable(xid);
        boolean ret = false;
        try {
            Message req = null;
            req = new Message(this.m_parent.getAdminPrefix() + ".isThereXid");
            req.writeObject(xid);
            Message rep = this.request((IMessage)req, (IJobResolver)this.m_parent);
            ret = rep.readBoolean();
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
        catch (IOException e) {
            throw new ETransactionFailure(126, prAccessor.getString("INVALID_END_TXN_REPLY"), e);
        }
        return ret;
    }

    private void checkXidAndIsUsable(Object xid) throws EUnusableConnection, EParameterIsNull {
        if (xid == null) {
            throw new EParameterIsNull("xid");
        }
        if (this.m_parent.unusable()) {
            throw new EUnusableConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPendingStorageAck(Envelope env) {
        if (this.m_txnMsgsPendingStorageAck == null) {
            this.m_txnMsgsPendingStorageAck = new ArrayList();
        }
        ArrayList arrayList = this.m_txnMsgsPendingStorageAck;
        synchronized (arrayList) {
            if (SessionConfig.DEBUG) {
                System.out.println("adding " + env.getMgram().memoryLength() + " bytes to txn buffer limiter");
            }
            if (SessionConfig.DEBUG) {
                System.out.println("adding msg " + env.getGuarTracking() + " of txn " + env.getMgram().getTxnId() + " to pending storage ack list");
            }
            this.m_txnMsgsPendingStorageAck.add(new Long(env.getGuarTracking()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivedStorageAck(long storageTracking) {
        Vector<Long> acksToProcess = new Vector<Long>();
        ArrayList arrayList = this.m_txnMsgsPendingStorageAck;
        synchronized (arrayList) {
            int count = this.m_txnMsgsPendingStorageAck.indexOf(new Long(storageTracking));
            for (int i = 0; i <= count; ++i) {
                long tracking = (Long)this.m_txnMsgsPendingStorageAck.remove(0);
                acksToProcess.add(new Long(tracking));
            }
        }
        for (int p = 0; p < acksToProcess.size(); ++p) {
            long tracking = (Long)acksToProcess.elementAt(p);
            if (SessionConfig.DEBUG) {
                System.out.println("receivedStorageAck(): removing msg " + tracking + " from pending storage ack list");
            }
            IMgram m = this.m_parent.getConnectionInfo().ack(tracking, null);
            this.m_parent.terminateJob(tracking, 0);
            if (m == null || !SessionConfig.DEBUG) continue;
            System.out.println("receivedStorageAck(): subtracting " + m.memoryLength() + " from txn buffer limiter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllPendingTxnMsgs() {
        if (!this.m_parent.isFaultToleranceEnabled() || this.m_txnMsgsPendingStorageAck == null) {
            return;
        }
        ArrayList arrayList = this.m_txnMsgsPendingStorageAck;
        synchronized (arrayList) {
            if (this.m_txnMsgsPendingStorageAck.isEmpty()) {
                return;
            }
            Iterator iter = this.m_txnMsgsPendingStorageAck.iterator();
            while (iter.hasNext()) {
                IMgram m;
                long tracking = (Long)iter.next();
                iter.remove();
                if (SessionConfig.DEBUG) {
                    System.out.println("removeAllPendingTxnMsgs(): removing msg " + tracking + " from pending storage ack list");
                }
                if ((m = this.m_parent.getConnectionInfo().ack(tracking, null)) == null || !SessionConfig.DEBUG) continue;
                System.out.println("removeAllPendingTxnMsgs(): subtracting " + m.memoryLength() + " from txn buffer limiter");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePendingTxnMsg(long tracking, IMgram m) {
        ArrayList arrayList = this.m_txnMsgsPendingStorageAck;
        synchronized (arrayList) {
            this.m_txnMsgsPendingStorageAck.remove(new Long(tracking));
        }
    }

    private class TransactionStateProcessor {
        private boolean haveNextTx;
        private int nextTx;

        private TransactionStateProcessor(boolean chained, boolean sendRollbackToBroker, Object xid, String failureMessage) throws EGeneralException {
            switch (Session.this.m_txnstate) {
                case 0: {
                    throw new ENotInTransaction(prAccessor.getString(Session.TRANSACTION_FAILURE_PROPERTY_ID));
                }
                case 2: 
                case 4: {
                    if (!sendRollbackToBroker) {
                        Session.this.m_txnstate = (short)0;
                        break;
                    }
                    try {
                        short status = this.resolveTransactionStatus(chained, xid);
                        Session.this.checkReplyStatus(xid, failureMessage, status);
                        break;
                    }
                    catch (ENoSubscribersFound e) {
                        throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
                    }
                    catch (EGeneralException e) {
                        throw e;
                    }
                }
                case 1: 
                case 3: {
                    Session.this.m_txnstate = (short)0;
                    break;
                }
            }
        }

        private short resolveTransactionStatus(boolean chained, Object xid) throws EGeneralException {
            short status;
            if (Session.this.isXATxn()) {
                if (xid == null) {
                    throw new EParameterIsNull("xid");
                }
                byte[] replyBody = Session.this.requestXATxnOperation(chained, xid, 7);
                status = ArrayUtil.readShort(replyBody, 0);
                if (status == 0 && chained) {
                    this.nextTx = ArrayUtil.readInt(replyBody, 6);
                    this.haveNextTx = true;
                }
            } else {
                Request request;
                Request enqueuedListener = request = Session.this.buildLocalAbortTransactionRequest(chained);
                Session.this.m_parent.send(request.getRequestMgram(), (IMgramEnqueuedToSendListener)enqueuedListener);
                request.join();
                IMgram replyMgram = request.getReplyMgram();
                byte[] replyBody = replyMgram.getRawBody();
                status = ArrayUtil.readShort(replyBody, 0);
                if (chained) {
                    this.nextTx = ArrayUtil.readInt(replyBody, 6);
                    this.haveNextTx = true;
                }
            }
            return status;
        }
    }

    private class EnvelopeAckList {
        private ArrayList m_ackedEnvs = new ArrayList();
        private LongHashTable m_splitDeliveryAcks = new LongHashTable();

        private EnvelopeAckList() {
        }

        private final void addAck(Envelope ackedEnv) {
            if (ackedEnv.isSplitDeliveryPart()) {
                ArrayList<Envelope> acks = (ArrayList<Envelope>)this.m_splitDeliveryAcks.get(ackedEnv.getGuarTracking());
                if (acks == null) {
                    acks = new ArrayList<Envelope>(ackedEnv.getUnackedSplitDeliveryCount());
                    this.m_splitDeliveryAcks.put(ackedEnv.getGuarTracking(), acks);
                }
                acks.add(ackedEnv);
            } else {
                this.m_ackedEnvs.add(ackedEnv);
            }
        }

        private boolean isEmpty() {
            return this.m_ackedEnvs.isEmpty() && this.m_splitDeliveryAcks.isEmpty();
        }

        private Iterator iterator() {
            Enumeration e = this.m_splitDeliveryAcks.elements();
            block0: while (e.hasMoreElements()) {
                ArrayList acks = (ArrayList)e.nextElement();
                for (int i = 0; i < acks.size(); ++i) {
                    Envelope ack = (Envelope)acks.get(i);
                    if (i == 0 && ack.getUnackedSplitDeliveryCount() <= acks.size()) {
                        if (SessionConfig.DEBUG) {
                            System.out.println("Substituting split delivery parent for batched ack of: subject: " + ack.getSubject().getSubjectString() + " trk: " + ack.getGuarTracking() + " p sub: " + ack.getSplitDeliveryParent().getSubject().getSubjectString() + " p trk: " + ack.getSplitDeliveryParent().getGuarTracking());
                        }
                        this.m_ackedEnvs.add(ack.getSplitDeliveryParent());
                        continue block0;
                    }
                    if (SessionConfig.DEBUG) {
                        System.out.println("Adding split delivery ack to batch list for  subject: " + ack.getSubject().getSubjectString() + " trk: " + ack.getGuarTracking());
                    }
                    this.m_ackedEnvs.add(ack);
                }
            }
            this.m_splitDeliveryAcks.clear();
            return this.m_ackedEnvs.iterator();
        }
    }

    class MgramEnqueuedToSendListener
    implements IMgramEnqueuedToSendListener {
        private Job m_job = null;
        private Envelope m_env = null;

        MgramEnqueuedToSendListener(Job job, Envelope envelope) {
            this.m_job = job;
            this.m_env = envelope;
        }

        @Override
        public void enqueuedToSend(IMgram m) {
            if (Session.this.m_parent.isFaultToleranceEnabled() && m.hasTxn()) {
                Session.this.addToPendingStorageAck(this.m_env);
            }
            if (this.m_job != null) {
                this.m_job.setStatus(1);
            }
        }
    }
}

