/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.UTFDataFormatException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.util.ArrayUtil;
import progress.message.util.LongHashTable;
import progress.message.util.StringUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.prAccessor;

public class SubjectUtil {
    public static final boolean DEBUG_CRACK_ADDR = false;
    private static LongHashTable s_crackTable;
    private static final char[] INVALID_GROUP_CHARS;
    public static final int MAX_GROUP_LEN = 64;
    public static final String TOPIC_GROUP_OPEN_PREFIX = "[[";
    public static final String TOPIC_GROUP_CLOSE_PREFIX = "]]";
    public static final int TOPIC_GROUP_INVALID_ROUTING_COMBINATION = -1;
    public static final int TOPIC_GROUP_NAME_TOO_LONG = -3;
    public static final int TOPIC_GROUP_INVALID_CHARS = -4;
    public static final int TOPIC_GROUP_INVALID_NAME = -9999;
    public static final String MULTITOPIC_DELIMITER = "||";
    public static final String MULTITOPIC_PREFIX = "MULTITOPIC:";
    public static final String ROUTING_DELIMITER = "::";

    private SubjectUtil() {
    }

    public static int[] computeMatchVector(String subjectExp, boolean checkWilds) {
        return SubjectUtil.computeMatchVector(subjectExp, checkWilds, null);
    }

    private static int[] computeMatchVector(String subjectExp, boolean checkWilds, LongHashTable mappingTable) {
        int startPos = 0;
        int tempCapacity = 32;
        int[] tempArray = new int[tempCapacity];
        int numLevels = 0;
        boolean finalLevel = false;
        while (startPos < subjectExp.length()) {
            int sep = subjectExp.indexOf(46, startPos);
            if (sep < 0) {
                sep = subjectExp.length();
            } else if (sep == subjectExp.length() - 1) {
                finalLevel = true;
            }
            if (numLevels == tempCapacity) {
                int[] t = new int[tempCapacity *= 2];
                System.arraycopy(tempArray, 0, t, 0, numLevels);
                tempArray = t;
            }
            tempArray[numLevels++] = checkWilds && subjectExp.charAt(startPos) == '*' && sep - startPos == 1 ? -2 : (checkWilds && subjectExp.charAt(startPos) == '#' && sep - startPos == 1 ? -1 : SubjectUtil.computeSCode(subjectExp, startPos, sep - startPos, mappingTable));
            startPos = sep + 1;
        }
        if (finalLevel) {
            ++numLevels;
        }
        int[] results = new int[numLevels];
        System.arraycopy(tempArray, 0, results, 0, numLevels);
        return results;
    }

    public static boolean isSubset(int[] target, int[] pattern) throws EInvalidSubjectSyntax {
        if (SubjectUtil.compareWildVectors(pattern, target, 0, 0)) {
            return true;
        }
        if (pattern.length > 1) {
            int i;
            if (pattern[0] == -1) {
                for (i = 1; i < pattern.length && pattern[i] == -2; ++i) {
                }
                if (i == pattern.length) {
                    int[] newPattern = new int[pattern.length];
                    System.arraycopy(pattern, 1, newPattern, 0, pattern.length - 1);
                    newPattern[newPattern.length - 1] = -1;
                    return SubjectUtil.compareWildVectors(newPattern, target, 0, 0);
                }
            }
            if (pattern[pattern.length - 1] == -1) {
                for (i = pattern.length - 2; i >= 0 && pattern[i] == -2; --i) {
                }
                if (i == -1) {
                    int[] newPattern = new int[pattern.length];
                    System.arraycopy(pattern, 0, newPattern, 1, pattern.length - 1);
                    newPattern[0] = -1;
                    return SubjectUtil.compareWildVectors(newPattern, target, 0, 0);
                }
            }
        }
        return false;
    }

    private static boolean compareWildVectors(int[] pcode, int[] tcode, int pposParam, int tpos) throws EInvalidSubjectSyntax {
        int ppos = pposParam;
        if (tpos == tcode.length) {
            return ppos == pcode.length;
        }
        if (ppos == pcode.length) {
            return false;
        }
        if (pcode[ppos] == -2 && tcode[tpos] != -1) {
            return SubjectUtil.compareWildVectors(pcode, tcode, ++ppos, ++tpos);
        }
        if (pcode[ppos] == -1) {
            if (ppos == pcode.length - 1) {
                return tpos != tcode.length;
            }
            if (ppos != 0) {
                throw new EInvalidSubjectSyntax(prAccessor.getString("STR175"));
            }
            return SubjectUtil.compareWildSharps(pcode, tcode);
        }
        if (pcode[ppos++] == tcode[tpos++]) {
            return SubjectUtil.compareWildVectors(pcode, tcode, ppos, tpos);
        }
        return false;
    }

    private static boolean compareWildSharps(int[] pcode, int[] tcode) {
        if (pcode.length > tcode.length) {
            return false;
        }
        int i = pcode.length - 1;
        for (int j = tcode.length - 1; i > 0 && j >= 0 && (pcode[i] == tcode[j] || pcode[i] == -2 && tcode[j] != -1); --i, --j) {
        }
        return i == 0;
    }

    public static String crackDestAddr(byte[] da, int off) {
        StringBuffer ret = new StringBuffer();
        int p = off + 2;
        int levels = ArrayUtil.readShort(da, off);
        int i = 0;
        while (i < levels) {
            SubjectUtil.appendDot(i, ret);
            int scode = ArrayUtil.readInt(da, p);
            ret.append("[" + scode + "]");
            ++i;
            p += 4;
        }
        return ret.toString();
    }

    public static String crackMatchVector(int[] mv) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < mv.length; ++i) {
            SubjectUtil.appendDot(i, ret);
            ret.append("[" + mv[i] + "]");
        }
        return ret.toString();
    }

    private static void appendDot(int i, StringBuffer ret) {
        if (i > 0) {
            ret.append('.');
        }
    }

    public static int computeSCode(String s, int startPos, int len) {
        return SubjectUtil.computeSCode(s, startPos, len, null);
    }

    private static int computeSCode(String s, int startPos, int len, LongHashTable mappingTable) {
        int fhash = 0;
        int bhash = 0;
        int h = 1;
        int fpos = startPos;
        int bpos = startPos + len - 1;
        char[] cc = s.toCharArray();
        int i = 0;
        while (i < len) {
            char fc = cc[fpos];
            char bc = cc[bpos];
            fhash += fc * h;
            bhash += bc * h;
            h *= 37;
            ++i;
            --bpos;
            ++fpos;
        }
        int result = fhash & 0xFFFF | (bhash & 0xFFFF) << 16;
        if (mappingTable != null) {
            mappingTable.put(result, s.substring(startPos, startPos + len));
        }
        return result;
    }

    public static int[] computeMatchVector(String subjectExp) {
        return SubjectUtil.computeMatchVector(subjectExp, false);
    }

    public static int[] convertVarFmtToMatchVector(byte[] subject, int off) {
        return SubjectUtil.convertVarFmtToMatchVector(subject, off, 0);
    }

    public static int[] convertVarFmtToMatchVector(byte[] subject, int offParam, int trim) {
        int off = offParam;
        int numlevels = (subject[off++] & 0xFF) << 8 | subject[off++] & 0xFF;
        int[] hashSubject = new int[numlevels - trim];
        for (int i = 0; i < hashSubject.length; ++i) {
            hashSubject[i] = ArrayUtil.readInt(subject, off);
            off += 4;
        }
        return hashSubject;
    }

    public static byte[] convertMatchVectorToVarFmt(int[] mv) {
        byte[] varFmt = new byte[mv.length * 4 + 2];
        varFmt[0] = (byte)(varFmt.length >> 10);
        varFmt[1] = (byte)(varFmt.length >> 2);
        for (int i = 0; i < mv.length; ++i) {
            ArrayUtil.writeInt(varFmt, 2 + i * 4, mv[i]);
        }
        return varFmt;
    }

    public static final int[] convertAddressToMatchVector(byte[] address, int af, boolean stripTracking) {
        switch (af) {
            case 3: {
                return SubjectUtil.convertVarFmtToMatchVector(address, 0, stripTracking ? 1 : 0);
            }
            case 2: {
                return new int[]{ArrayUtil.readInt(address, 0)};
            }
            case 1: {
                try {
                    return SubjectUtil.computeMatchVector(StringUtil.UTFToString(address, 0));
                }
                catch (UTFDataFormatException ex) {
                    SessionConfig.logMessage("Error converting UTF address", ex, SessionConfig.SEVERE);
                }
            }
        }
        return null;
    }

    public static boolean Equal(int[] a1, int[] a2) {
        if (a1.length == a2.length) {
            int i = a1.length;
            while (i-- > 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] IntToByte(int[] addr) {
        byte[] RetAddr = new byte[4 * addr.length + 2];
        ArrayUtil.writeShort(RetAddr, 0, (short)addr.length);
        for (int i = 0; i < addr.length; ++i) {
            ArrayUtil.writeInt(RetAddr, i * 4 + 2, addr[i]);
        }
        return RetAddr;
    }

    public static final ISubject computeIntersectSubject(String subject1, ISubject subject2) {
        return SubjectUtil.computeIntersectSubject(new Subject(subject1), subject2);
    }

    public static final ISubject computeIntersectSubject(ISubject subject1, ISubject subject2) {
        LongHashTable mappingTable = new LongHashTable();
        int[] vector1 = SubjectUtil.computeMatchVector(subject1.getLookupName(), true, mappingTable);
        int[] vector2 = SubjectUtil.computeMatchVector(subject2.getLookupName(), true, mappingTable);
        int[] intersectVec = null;
        if (vector1.length == vector2.length) {
            intersectVec = SubjectUtil.computeIntersectvVector(vector1, vector2);
        } else if (vector1.length < vector2.length) {
            if (vector1[0] == -1 || vector1[vector1.length - 1] == -1) {
                intersectVec = SubjectUtil.computeIntersectvVector(SubjectUtil.padWildSharps(vector1, vector2.length), vector2);
            }
        } else if (vector2.length < vector1.length && (vector2[0] == -1 || vector2[vector2.length - 1] == -1)) {
            intersectVec = SubjectUtil.computeIntersectvVector(SubjectUtil.padWildSharps(vector2, vector1.length), vector1);
        }
        String s = intersectVec == null ? null : SubjectUtil.convertVectorToString(intersectVec, mappingTable);
        return s == null ? null : new Subject(s);
    }

    private static int[] computeIntersectvVector(int[] vector1, int[] vector2) {
        if (vector2.length != vector1.length) {
            return null;
        }
        int vecSize = vector1.length;
        int[] tmpVector = new int[vecSize];
        for (int i = 0; i < vecSize; ++i) {
            if (vector1[i] == vector2[i]) {
                tmpVector[i] = vector1[i];
                continue;
            }
            if (vector1[i] == -1) {
                tmpVector[i] = vector2[i];
                continue;
            }
            if (vector2[i] == -1) {
                tmpVector[i] = vector1[i];
                continue;
            }
            if (vector1[i] == -2) {
                tmpVector[i] = vector2[i];
                continue;
            }
            if (vector2[i] == -2) {
                tmpVector[i] = vector1[i];
                continue;
            }
            return null;
        }
        return tmpVector;
    }

    private static int[] padWildSharps(int[] vector, int finalSize) {
        if (finalSize <= vector.length) {
            return vector;
        }
        int[] tmpVector = new int[finalSize];
        if (vector[0] == -1) {
            int i = tmpVector.length - 1;
            for (int j = vector.length - 1; i > 0 && j >= 0; --i, --j) {
                tmpVector[i] = vector[j];
            }
            int diff = finalSize - vector.length;
            for (i = 0; i < diff; ++i) {
                tmpVector[i] = -1;
            }
            return tmpVector;
        }
        if (vector[vector.length - 1] == -1) {
            int i;
            for (i = 0; i < vector.length; ++i) {
                tmpVector[i] = vector[i];
            }
            for (i = vector.length; i < finalSize; ++i) {
                tmpVector[i] = -1;
            }
            return tmpVector;
        }
        return vector;
    }

    private static String convertVectorToString(int[] vector, LongHashTable mapping) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < vector.length; ++i) {
            if (i > 0) {
                ret.append('.');
            }
            if (vector[i] == -1) {
                ret.append("#");
                continue;
            }
            if (vector[i] == -2) {
                ret.append("*");
                continue;
            }
            ret.append((String)mapping.get(vector[i]));
        }
        return ret.toString();
    }

    public static boolean isSubset(String target, String pattern) throws EInvalidSubjectSyntax {
        return SubjectUtil.isSubset(SubjectUtil.computeMatchVector(target, true), SubjectUtil.computeMatchVector(pattern, true));
    }

    public static int validateGroupName(String topicName) {
        if (!topicName.startsWith(TOPIC_GROUP_OPEN_PREFIX)) {
            return 0;
        }
        int pos = topicName.lastIndexOf(TOPIC_GROUP_CLOSE_PREFIX);
        if (pos <= 2 || pos + 2 == topicName.length()) {
            return -9999;
        }
        if (topicName.lastIndexOf(ROUTING_DELIMITER, pos) != -1) {
            return -1;
        }
        String groupPrefix = topicName.substring(2, pos);
        return SubjectUtil.validateGroupPrefix(groupPrefix);
    }

    public static int validateGroupPrefix(String groupPrefix) {
        if (groupPrefix.length() > 64) {
            return -3;
        }
        if (groupPrefix.lastIndexOf(ROUTING_DELIMITER) != -1) {
            return -1;
        }
        for (int i = 0; i < INVALID_GROUP_CHARS.length; ++i) {
            if (groupPrefix.indexOf(INVALID_GROUP_CHARS[i]) == -1) continue;
            return -4;
        }
        return 0;
    }

    public static String getSubjectGroup(String subject) {
        if (subject.startsWith(TOPIC_GROUP_OPEN_PREFIX)) {
            return subject;
        }
        return null;
    }

    public static String getSubjectGroupPrefix(String subject) {
        if (subject == null || subject.length() == 0) {
            return null;
        }
        if (!subject.startsWith(TOPIC_GROUP_OPEN_PREFIX)) {
            return null;
        }
        if (SubjectUtil.validateGroupName(subject) != 0) {
            return null;
        }
        int pos = subject.lastIndexOf(TOPIC_GROUP_CLOSE_PREFIX);
        String groupPrefix = subject.substring(2, pos);
        return groupPrefix;
    }

    public static String getSubjectTopic(String subject) {
        int pos = subject.indexOf(TOPIC_GROUP_CLOSE_PREFIX);
        if (pos > 0 && subject.startsWith(TOPIC_GROUP_OPEN_PREFIX)) {
            return subject.substring(pos + 2);
        }
        return subject;
    }

    public static String wrapSubjectGroupPrefix(String groupname) {
        return TOPIC_GROUP_OPEN_PREFIX + groupname + TOPIC_GROUP_CLOSE_PREFIX;
    }

    public static void main(String[] argv) {
        SubjectUtil producer = new SubjectUtil();
    }

    static {
        INVALID_GROUP_CHARS = new char[]{'$', '\\', '.', '*', '#', '[', ']', '|'};
    }
}

