/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.prAccessor;
import com.sonicsw.security.pass.broker.ConnectionException;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.util.debug.Debug;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import progress.message.security.ENoAuthService;

public class ExternalDomainAuthSPIConfig {
    static final boolean DEBUG_PASS_CPP = true;
    static final boolean DEBUG_PASS_ASPI_EVENTS = true;
    public static final boolean DEBUG_PASS_ASPI_RUNTIME = true;
    private static final String AUTHENTICATION_SPI = "Authentication SPI ";
    private static final String CLASS_CAST_ERROR = "CLASS_CAST_ERROR";
    private static final String CLASS_NOT_FOUND = "CLASS_NOT_FOUND";
    private static final String CANNOT_INST_CLASS = "CANNOT_INST_CLASS";
    private static final String ACCESS_ERROR = "ACCESS_ERROR";
    private static final String SECURITY_ERROR = "SECURITY_ERROR";
    private static final String AUTH_SPI_EXCEPTION = "AUTH_SPI_EXCEPTION";
    private static final String LOAD_CLASS_FAILED = "LOAD_CLASS_FAILED";
    private static boolean m_isExternalDomain;
    private static volatile String m_domainName;
    private static Map m_groupMap;
    private static volatile String m_authSPIReferenceName;
    private static volatile String m_authSPIName;
    private static volatile String m_className;
    private static List m_classpath;
    private static HashMap m_attributeSettings;

    final void setReferenceName(String referenceName) {
        m_authSPIReferenceName = referenceName;
    }

    final void setClassName(String className) {
        m_className = this.debugName(className);
    }

    final void setClasspath(ArrayList classpath) {
        m_classpath = classpath;
    }

    final void setAttributeSettings(HashMap attributeSettings) {
        m_attributeSettings = attributeSettings;
    }

    final String getAuthSPIName() {
        return m_authSPIName;
    }

    final void setAuthSPIName(String name) {
        m_authSPIName = this.debugName(name);
    }

    public final Map getGroupMap() {
        return m_groupMap;
    }

    final void setGroupMap(HashMap groupMap) {
        m_groupMap = Collections.synchronizedMap(groupMap);
    }

    final void setExternalDomainFlag(boolean externalDomain) {
        m_isExternalDomain = externalDomain;
    }

    final void setExternalDomainName(String externalDomainName) {
        m_domainName = this.debugName(externalDomainName);
    }

    private String debugName(String name) {
        String m_authSPIName = name;
        return m_authSPIName;
    }

    public final IAuthentication getNewInstance() {
        try {
            if (m_authSPIName == null) {
                return null;
            }
            if (m_className == null || (m_className = m_className.trim()).length() == 0) {
                String error = "[-2000] Authentication SPI " + progress.message.client.prAccessor.getString(CLASS_NOT_FOUND);
                BrokerComponent.getComponentContext().logMessage(error, 1);
                return null;
            }
            if (m_classpath.isEmpty()) {
                String error = "[-2005] Authentication SPI " + progress.message.client.prAccessor.getString("CLASSPATH_NOT_FOUND");
                BrokerComponent.getComponentContext().logMessage(error, 2);
            }
            URL[] urls = new URL[m_classpath.size()];
            for (int i = 0; i < urls.length; ++i) {
                String path = (String)m_classpath.get(i);
                File file = new File(path);
                urls[i] = file.exists() ? file.toURL() : new URL(path);
            }
            URLClassLoader urlLoader = new URLClassLoader(urls, ((Object)((Object)BrokerComponent.getBrokerComponent())).getClass().getClassLoader());
            Class<?> c = urlLoader.loadClass(m_className);
            Object o = c.newInstance();
            if (!(o instanceof IAuthentication)) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("DYNAMIC_CLASS_LOADING_OF_AUTHENTICATION_SPI_FAILURE"), 2);
                c = Class.forName(m_className);
                o = c.newInstance();
            }
            IAuthentication spi = (IAuthentication)o;
            spi.setConfigInfo(m_attributeSettings);
            spi.init();
            return spi;
        }
        catch (ClassCastException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2001, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(CLASS_CAST_ERROR) + m_className);
        }
        catch (ClassNotFoundException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2001, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(CLASS_NOT_FOUND) + m_className);
        }
        catch (InstantiationException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2002, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(CANNOT_INST_CLASS) + m_className);
        }
        catch (IllegalAccessException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2003, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(ACCESS_ERROR) + m_className);
        }
        catch (SecurityException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2006, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(SECURITY_ERROR) + m_className);
        }
        catch (ConnectionException e) {
            ExternalDomainAuthSPIConfig.handleException(e, -2008, progress.message.client.prAccessor.getString(AUTH_SPI_EXCEPTION) + m_className);
        }
        catch (Throwable e) {
            ExternalDomainAuthSPIConfig.handleException(e, -1, AUTHENTICATION_SPI + progress.message.client.prAccessor.getString(LOAD_CLASS_FAILED) + m_className + " due to exception " + e);
        }
        return null;
    }

    private static void handleException(Throwable throwable, int errorId, String errorMsg) {
        ENoAuthService eNoAuthService = new ENoAuthService(errorId, errorMsg);
        eNoAuthService.initCause(throwable);
        BrokerComponent.getComponentContext().logMessage(eNoAuthService.getMessage(), (Throwable)eNoAuthService, 1);
    }

    static void verbose() {
    }

    private static Map traceGroupMapItems() {
        Map map = m_groupMap;
        if (map != null) {
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                Debug.trace((String)("\tKey: " + key + ", value: " + value));
            }
        }
        return map;
    }

    static {
        m_classpath = Collections.synchronizedList(new ArrayList());
    }
}

