/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.XmlConfigFileReader;
import com.sonicsw.net.http.XmlConfigReader;
import com.sonicsw.net.http.prAccessor;
import com.sonicsw.net.http.ws.WSHttpConfigInfo;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.broker.HTTPDirectOutboundEntry;
import progress.message.broker.HTTPDirectOutboundHolder;
import progress.message.broker.HTTPDirectOutboundProtocolHolder;
import progress.message.resources.prMessageFormat;

public class HttpConfigManager {
    private String m_managerName = null;
    private Hashtable m_table = new Hashtable();
    private boolean m_initialized = false;
    private AcceptorHolder m_acceptorHolder = AcceptorHolder.getAcceptorHolder();
    private HTTPAcceptor m_acceptor = null;
    private Hashtable m_inboundContentMap = null;

    public HttpConfigManager(Properties properties, String type, String protocol) {
        Object obj = null;
        if (properties != null && type.equals("INBOUND")) {
            obj = properties.get("HTTP_INBOUND_HOLDER");
            if (Config.DS_DEBUG) {
                System.out.println("HttpConfigManager.ctor: inbound config, vector of inbound entries = " + obj);
            }
        } else if (properties != null && type.equals("OUTBOUND")) {
            obj = properties.get("HTTP_OUTBOUND_HOLDER");
            if (Config.DS_DEBUG) {
                System.out.println("HttpConfigManager.ctor: outbound config, outbound holder = " + obj);
            }
        } else if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.ctor: either props null or not inbound/outbound, type = " + type + ", props = " + properties + ", returning from ctor...");
        }
        if (Config.HTTP_DEBUG != null && "TRUE".equalsIgnoreCase(Config.HTTP_DEBUG)) {
            HttpConstants.DEBUG = true;
        }
        if (obj == null) {
            this.m_initialized = true;
            return;
        }
        if (type.equals("INBOUND")) {
            HTTPDirectInboundProtocolHolder ph = (HTTPDirectInboundProtocolHolder)obj;
            this.m_acceptor = (HTTPAcceptor)this.m_acceptorHolder.getAcceptor(ph.getAcceptorID());
            this.m_managerName = ph.getEntryName();
            Hashtable maps = ph.getContentMappings();
            if (maps != null) {
                this.m_inboundContentMap = this.processWildcardContentTypes(maps);
            }
            Vector vec = ph.getHTTPDirectInboundEntries();
            Enumeration entries = vec.elements();
            String url = null;
            Object props = null;
            Object config = null;
            while (entries.hasMoreElements()) {
                HTTPDirectInboundEntry entry = (HTTPDirectInboundEntry)entries.nextElement();
                this.addInboundEntry(entry, null);
                if (!Config.DS_DEBUG) continue;
                System.out.println("HttpConfigManager.ctor: added new inbound entry for url = " + url);
            }
            vec.clear();
        } else {
            this.m_managerName = "HttpConfigManagerOutBound_" + protocol;
            HTTPDirectOutboundHolder oh = (HTTPDirectOutboundHolder)obj;
            Enumeration entries = oh.getHTTPDirectOutboundProtocolHolders();
            while (entries.hasMoreElements()) {
                HTTPDirectOutboundProtocolHolder nh = (HTTPDirectOutboundProtocolHolder)entries.nextElement();
                String protocolType = nh.getProtocol();
                if (!protocolType.equalsIgnoreCase(protocol)) continue;
                String factoryName = nh.getOutboundFactory();
                Vector vec = nh.getHTTPDirectOutboundEntries();
                Enumeration outs = vec.elements();
                Object node = null;
                Object props = null;
                Object config = null;
                while (outs.hasMoreElements()) {
                    HTTPDirectOutboundEntry entry = (HTTPDirectOutboundEntry)outs.nextElement();
                    this.addOutboundEntry(entry);
                }
            }
        }
        this.m_initialized = true;
    }

    public HttpConfigInfo getByName(String name) {
        return (HttpConfigInfo)this.m_table.get(name);
    }

    public HttpConfigInfo getBestByName(String name) {
        HttpConfigInfo bestConfig = null;
        int bestLength = 0;
        StringTokenizer st = new StringTokenizer(name, "/\\");
        int count = st.countTokens();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = st.nextToken();
        }
        Enumeration entries = this.m_table.elements();
        while (entries.hasMoreElements()) {
            HttpConfigInfo config = (HttpConfigInfo)entries.nextElement();
            count = config.checkBestMatch(names);
            if (count <= bestLength) continue;
            bestLength = count;
            bestConfig = config;
        }
        return bestConfig;
    }

    public void printAllUrl() {
        System.out.println("Contents in the HttpConfigManger: " + this.m_managerName);
        Enumeration entries = this.m_table.keys();
        while (entries.hasMoreElements()) {
            String url = (String)entries.nextElement();
            System.out.println("\turl = " + url);
        }
    }

    public XmlConfigReader createReader(String name) throws ConfigurationException {
        XmlConfigReader reader = null;
        String configURL = Config.getProperty("HTTP_CONFIGURATION_URL");
        if (configURL != null && !"".equals(configURL)) {
            HttpConstants.DEBUG("Reading configuration from UMF", 1);
            String readerClassname = Config.getProperty("HTTP_CONFIGURATION_READER");
            if (readerClassname != null && !"".equals(readerClassname)) {
                try {
                    Class<?> readerClass = Class.forName(readerClassname);
                    reader = (XmlConfigReader)readerClass.newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    Object[] obj = new Object[]{readerClassname, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    String msg = prAccessor.getString("HTTP_DIRECT_CLASS_NOT_FOUND");
                    throw new ConfigurationException(prMessageFormat.format(msg, obj));
                }
                catch (Exception e) {
                    Object[] obj = new Object[]{readerClassname, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    String msg = prAccessor.getString("HTTP_DIRECT_CLASS_LOAD_ERROR");
                    throw new ConfigurationException(prMessageFormat.format(msg, obj));
                }
            }
        } else {
            reader = new XmlConfigFileReader();
        }
        return reader;
    }

    public Properties getSendProperties(HTTPDirectInboundEntry entry) {
        String deliveryMode;
        String username;
        Properties props = new Properties();
        String dest_type = entry.getDestinationType();
        String dest_name = entry.getDestinationName();
        if (dest_type != null && dest_name != null) {
            if ("QUEUE".equalsIgnoreCase(dest_type)) {
                props.put("DestinationQueue", dest_name);
            } else if ("TOPIC".equalsIgnoreCase(dest_type)) {
                props.put("DestinationTopic", dest_name);
            } else {
                props.put("DestinationURL", dest_name);
            }
        }
        if ((username = entry.getUsername()) != null) {
            props.put("User", entry.getUsername());
        }
        if ((deliveryMode = entry.getDeliveryMode()) != null) {
            props.put("DeliveryMode", deliveryMode);
        }
        props.put("TimeToLive", Long.toString(entry.getTTL()));
        props.put("Priority", Integer.toString(entry.getPriority()));
        String type = entry.getType();
        if (type != null) {
            props.put("Type", type);
        }
        props.put("NotifyUndelivered", Boolean.valueOf(entry.getNotifyUndelivered()).toString());
        props.put("PreserveUndelivered", Boolean.valueOf(entry.getPreserveUndelivered()).toString());
        if (entry.getPreserveUndelivered()) {
            props.put("UNDELIVERED_DESTINATION_TYPE", entry.getUndeliveredDestinationType());
            props.put("UNDELIVERED_DESTINATION_NAME", entry.getUndeliveredDestinationName());
        }
        this.configAuthentication(props, entry);
        props.put("DuplicateDetect", Boolean.valueOf(entry.getDuplicateDetect()).toString());
        return props;
    }

    public HttpConfigInfo sendOnewayConfig(String url, HTTPDirectInboundEntry entry) {
        Properties props = this.getSendProperties(entry);
        props.put("RequestMode", "Oneway");
        return new HttpConfigInfo(url, props);
    }

    public HttpConfigInfo sendReplyConfig(String url, HTTPDirectInboundEntry entry) {
        Properties props = this.getSendProperties(entry);
        props.put("RequestMode", "ContentReply");
        props.put("ContentReplyTimeout", Long.toString(entry.getTimeout()));
        return new HttpConfigInfo(url, props);
    }

    public HttpConfigInfo wsConfig(String url, HTTPDirectInboundEntry entry) {
        Properties props = this.getSendProperties(entry);
        props.put("RequestMode", "WS");
        props.put("ContentReplyTimeout", Long.toString(entry.getTimeout()));
        if (entry.getSOAPRoles() != null) {
            props.put("SOAP_ROLES", entry.getSOAPRoles());
        }
        HttpConfigManager.putWsdlLocation(entry, props);
        WSHttpConfigInfo wsConfigInfo = new WSHttpConfigInfo(url, props, entry);
        wsConfigInfo.setHTTPAccptor(this.m_acceptor);
        AgentRegistrar.getWSDLCache();
        return wsConfigInfo;
    }

    public HttpConfigInfo receiveConfig(String url, HTTPDirectInboundEntry entry) {
        String username;
        Properties props = new Properties();
        props.put("RequestMode", "Receive");
        String dest_type = entry.getDestinationType();
        String dest_name = entry.getDestinationName();
        if (dest_type != null && dest_name != null) {
            if ("QUEUE".equalsIgnoreCase(dest_type)) {
                props.put("ReceiveQueue", dest_name);
            } else {
                props.put("ReceiveURL", dest_name);
            }
        }
        if ((username = entry.getUsername()) != null) {
            props.put("User", username);
        }
        this.configAuthentication(props, entry);
        props.put("ContentReplyTimeout", Long.toString(entry.getTimeout()));
        HttpConfigManager.putWsdlLocation(entry, props);
        return new HttpConfigInfo(url, props);
    }

    private static void putWsdlLocation(HTTPDirectInboundEntry entry, Properties props) {
        if (entry.getWSDLLocation() != null) {
            props.put("WSDL_LOCATION", entry.getWSDLLocation());
        }
    }

    private void configAuthentication(Properties props, HTTPDirectInboundEntry entry) {
        props.put("HTTP_BASIC", Boolean.valueOf(entry.getBasicAuthentication()).toString());
        props.put("SSL_CERTIFICATE", Boolean.valueOf(entry.getCertificateAuthentication()).toString());
        props.put("CONFIG_USER", Boolean.valueOf(entry.getUserPreconfigured()).toString());
        props.put("HTTP_HEADER", Boolean.valueOf(entry.getHeaderAuthentication()).toString());
    }

    public final void addInboundEntry(HTTPDirectInboundEntry entry, Hashtable contentMap) {
        if (entry == null) {
            return;
        }
        HttpConfigInfo config = null;
        String url = entry.getURL();
        if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.addInboundEntry: url = " + url + ", entry = " + entry);
        }
        if (this.m_table.containsKey(url)) {
            return;
        }
        String requestMode = entry.getRequestMode();
        config = requestMode.equalsIgnoreCase("Oneway") ? this.sendOnewayConfig(url, entry) : (requestMode.equalsIgnoreCase("ContentReply") ? this.sendReplyConfig(url, entry) : (requestMode.equalsIgnoreCase("WS") ? this.wsConfig(url, entry) : this.receiveConfig(url, entry)));
        if (this.m_inboundContentMap == null && contentMap != null) {
            this.m_inboundContentMap = this.processWildcardContentTypes(contentMap);
        }
        config.setContentMappings(this.m_inboundContentMap);
        this.m_table.put(url, config);
    }

    public void updateInboundEntryURL(HTTPDirectInboundEntry entry, String newURL) {
        if (entry == null) {
            return;
        }
        String url = entry.getURL();
        if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.updateInboundEntryURL: existing url = " + url + ", entry = " + entry + " new URL = " + newURL);
        }
        if (!this.m_table.containsKey(url)) {
            return;
        }
        HttpConfigInfo config = (HttpConfigInfo)this.m_table.get(url);
        if (config == null) {
            return;
        }
        this.m_table.remove(url);
        config.resetUrl(newURL);
        this.m_table.put(newURL, config);
        entry.setURL(newURL);
    }

    public void removeInboundEntry(HTTPDirectInboundEntry entry) {
        if (entry == null) {
            return;
        }
        String url = entry.getURL();
        if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.removeInboundEntry: url = " + url);
        }
        if (this.m_table.containsKey(url)) {
            this.m_table.remove(url);
        }
    }

    public void removeOutboundEntry(String nodeName) {
        if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.removeOutboundEntry: node = " + nodeName + " this configManager : " + this.getManagerName());
        }
        if (this.m_table.containsKey(nodeName)) {
            this.m_table.remove(nodeName);
        }
    }

    private Hashtable processWildcardContentTypes(Hashtable configMap) {
        Hashtable<String, String> processedMap = new Hashtable<String, String>();
        Enumeration keys = configMap.keys();
        while (keys.hasMoreElements()) {
            int index;
            String key = (String)keys.nextElement();
            String value = (String)configMap.get(key);
            if (value == null) continue;
            if (!key.equals("*/*") && (index = key.indexOf("/*")) > 0) {
                key = key.substring(0, index);
            }
            processedMap.put(key, value);
        }
        return processedMap;
    }

    public void onDeleted() {
        this.m_acceptor.unregisterConfigManager(this.m_managerName);
        this.m_table.clear();
        this.m_managerName = "DELETED";
    }

    public boolean isActive() {
        return !this.m_table.isEmpty() && this.m_managerName != null && !"DELETED".equals(this.m_managerName);
    }

    public String getManagerName() {
        return this.m_managerName;
    }

    public final void addOutboundEntry(HTTPDirectOutboundEntry entry) {
        String node = entry.getNodeName();
        if (Config.DS_DEBUG) {
            System.out.println("HttpConfigManager.ctor: node = " + node + ", entry = " + entry);
        }
        if (!this.m_table.containsKey(node)) {
            Properties props = new Properties();
            props.put("NODE", node);
            props.put("PROTOCOL", entry.getProtocol());
            String requestMode = entry.getRequestMode();
            props.put("RequestMode", requestMode);
            if (requestMode == "Oneway") {
                props.put("OnewayTimeout", Integer.toString(entry.getTimeout()));
                props.put("OnewayRetries", Integer.toString(entry.getRetryCount()));
            } else {
                String contentReplyUser = entry.getContentReplyUserName();
                if (contentReplyUser != null) {
                    props.put("ContentReplyUser", entry.getContentReplyUserName());
                }
                props.put("ContentReplyTimeout", Integer.toString(entry.getContentReplyTimeout()));
                props.put("ContentReplyRetries", Integer.toString(entry.getContentReplyRetryCount()));
            }
            props.put("RetryInterval", Integer.toString(entry.getRetryInterval()));
            HttpConfigInfo config = new HttpConfigInfo(node, props);
            Hashtable maps = entry.getContentMappings();
            if (maps != null) {
                config.setContentMappings(this.processWildcardContentTypes(maps));
            }
            this.m_table.put(node, config);
            if (Config.DS_DEBUG) {
                System.out.println("HttpConfigManager.ctor: added new outbound entry for node = " + node);
            }
        }
    }
}

