/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutRequest;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.direct.DirectHttpOutboundHandler;
import com.sonicsw.net.http.soap.SOAPUtils;
import com.sonicsw.net.http.soap.SoapHttpOutRequest;
import com.sonicsw.net.http.soap.SoapHttpOutResponse;
import com.sonicsw.net.http.soap.prAccessor;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.zclient.ISidebandData;

public class SoapHttpOutboundHandler
extends DirectHttpOutboundHandler {
    WSHttpOutboundHandler m_wsDelegate = null;

    public SoapHttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config) throws ConfigurationException, HttpServiceException {
        super(connectInfo, config, true);
        this.addSOAP12ContentMap();
        this.m_wsDelegate = new WSHttpOutboundHandler(connectInfo, config);
    }

    public SoapHttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config, boolean suppressDelegate) throws ConfigurationException, HttpServiceException {
        super(connectInfo, config, suppressDelegate);
        this.addSOAP12ContentMap();
        if (!suppressDelegate) {
            this.m_wsDelegate = new WSHttpOutboundHandler(connectInfo, config);
        }
    }

    @Override
    public HttpOutRequest getHttpOutRequest(IMgram m) {
        if (this.delegatesToWS(m)) {
            return this.m_wsDelegate.getHttpOutRequest(m);
        }
        return new SoapHttpOutRequest();
    }

    @Override
    public HttpOutResponse getHttpOutResponse(IMgram m) {
        if (this.delegatesToWS(m)) {
            return this.m_wsDelegate.getHttpOutResponse(m);
        }
        return new SoapHttpOutResponse();
    }

    @Override
    public void buildErrorResponse(HttpLock lock, IMgram mgram, URLConnection connection, HttpOutResponse response) {
        if (this.delegatesToWS(mgram)) {
            this.m_wsDelegate.buildErrorResponse(lock, mgram, connection, response);
            return;
        }
        if (!this.shouldReplyFault(lock, mgram)) {
            return;
        }
        int httpCode = lock.getErrorType();
        response.setResponseCode(httpCode);
        try {
            String faultResponse = this.formatHTTPErrorAsSOAPFault(lock);
            ((SoapHttpOutResponse)response).assignInternalFault(faultResponse);
        }
        catch (IOException e) {
            lock.setError(610);
            lock.setMessage(e.getMessage());
        }
        try {
            response.buildResponse(response, connection, this);
        }
        catch (HttpServiceException e) {
            lock.setError(610);
            lock.setMessage(e.getMessage());
        }
    }

    @Override
    public void sendMgram(IMgram m, Thread dispatchThread) {
        if (this.delegatesToWS(m)) {
            this.m_wsDelegate.sendMgram(m, dispatchThread);
        } else {
            super.sendMgram(m, dispatchThread);
        }
    }

    @Override
    public boolean shouldReplyFault(HttpLock lock, IMgram m) {
        if (this.delegatesToWS(m)) {
            return this.m_wsDelegate.shouldReplyFault(lock, m);
        }
        return lock.getContentReplyExpected() && lock.getErrorType() != 612;
    }

    protected String formatHTTPErrorAsSOAPFault(HttpLock lock) throws IOException {
        String msg = lock.getMessage();
        String faultResponse = null;
        switch (lock.getErrorType()) {
            case 400: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_BAD_REQUEST");
                break;
            }
            case 401: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_AUTH_FAILURE");
                break;
            }
            case 404: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_FILE_NOT_FOUND");
                break;
            }
            case 408: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_TIMEOUT");
                break;
            }
            case 413: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_MESSAGE_TOO_LARGE");
                break;
            }
            case 500: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_SERVICE_UNAVAILABLE");
                break;
            }
            case 501: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_PROTOCOL_NOT_SUPPORTED");
                break;
            }
            case 503: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_SERVICE_UNAVAILABLE");
                break;
            }
            case 611: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_HOST_UNREACHABLE");
                break;
            }
            case 612: {
                Object[] obj = new Object[]{this.m_nodeName};
                msg = prMessageFormat.format(com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_INVALID_REPLYTO_USER"), obj);
                break;
            }
            case 613: {
                Object[] obj = new Object[]{this.m_nodeName};
                msg = prMessageFormat.format(com.sonicsw.net.http.prAccessor.getString("HTTP_ROUTING_UNSUPPORTED_JMS_MESSAGE_TYPE"), obj);
                break;
            }
            case 615: {
                if (msg != null) break;
                msg = prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT");
                break;
            }
            case 616: {
                faultResponse = msg;
                break;
            }
            default: {
                if (msg != null) break;
                msg = com.sonicsw.net.http.prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_GENERAL");
            }
        }
        if (faultResponse == null) {
            faultResponse = SOAPUtils.writeFaultResponse(msg);
        }
        return faultResponse;
    }

    private void addSOAP12ContentMap() {
        Hashtable<String, String> contentMaps = this.getContentMappings();
        String soap12ContentType = SOAPUtils.getSOAP12ContentType();
        if (contentMaps == null) {
            this.m_contentMaps = contentMaps = new Hashtable<String, String>();
        }
        contentMaps.put(soap12ContentType, "XML");
        Enumeration e = contentMaps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String string = (String)contentMaps.get(key);
        }
    }

    private boolean delegatesToWS(IMgram m) {
        if (this.m_wsDelegate == null || m == null) {
            return false;
        }
        ISidebandData sd = m.getSidebandData();
        if (sd == null) {
            return false;
        }
        return sd.getProperty("X-WS-MessagePolicy") != null || sd.getProperty("X-WS-MessagePolicy-Out") != null || sd.getProperty("X-WS-MessagePolicy-Fault") != null;
    }
}

