/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.common;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpClientContextManager;
import com.sonicsw.net.http.soap.SonicSoapVerifier;
import com.sonicsw.net.http.ws.ForwardedWSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpProtocolHandler;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.sender.fsm.AckEvent;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.IClientContext;
import progress.message.client.ENetworkFailure;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerSession;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.Session;

class RMClusteringHelper {
    public static final short VERSION = 0;
    public static final String RM_SUBJECT_PREFIX = "$ISYS.RM.";
    public static final String RM_OUTBOUND_SEQUENCE_TERMINATION_SUBJECT = "$ISYS.RM.sequenceTermination";
    public static final String RM_OUTBOUND_MESSAGE_ACKS_SUBJECT = "$ISYS.RM.outboundMessageAck";
    public static final String RM_SEQUENCE_FAULT_SUBJECT = "$ISYS.RM.sequenceFault";
    public static final String RM_INBOUND_MESSAGE_SUBJECT = "$ISYS.RM.inboundMessage";
    public static final int RM_OUTBOUND_MESSAGE_ACKS = 1;
    public static final int RM_OUTBOUND_SEQ_TERMINATION = 2;
    public static final int RM_SEQUENCE_FAULT = 3;
    private RMManager m_rmm;
    private InterbrokerSession m_ssn;
    private int m_localId;

    RMClusteringHelper(RMManager rmm) {
        this.m_rmm = rmm;
        this.m_localId = Config.BROKER_NAME.hashCode();
    }

    void subscribePropagationSubjects() throws IOException {
        this.m_ssn = Interbroker.getInterbroker().getIBSession();
        Label reliablelab = new Label();
        reliablelab.setPersistent(true);
        Label unreliablelab = new Label();
        unreliablelab.setGuaranteed(false);
        unreliablelab.setPersistent(false);
        this.m_ssn.submitSubscription(RM_OUTBOUND_MESSAGE_ACKS_SUBJECT, unreliablelab);
        this.m_ssn.submitSubscription(RM_OUTBOUND_SEQUENCE_TERMINATION_SUBJECT, reliablelab);
        this.m_ssn.submitSubscription(RM_SEQUENCE_FAULT_SUBJECT, reliablelab);
        this.m_ssn.submitSubscription(RM_INBOUND_MESSAGE_SUBJECT, unreliablelab);
    }

    void setupPropagationHandlers() throws IOException {
        AgentAdminConnection conn = AgentRegistrar.getAgentRegistrar().getAdminConnection();
        MessageHandler mh = new MessageHandler(new IMessageHandler(){

            @Override
            public void handleMessage(Session s, Envelope env) {
            }
        });
        mh.setName("WS-RM clustering handler");
        mh.bind(RM_OUTBOUND_MESSAGE_ACKS_SUBJECT, (IMessageHandler)new RMOutboundMessageAckHandler());
        mh.bind(RM_OUTBOUND_SEQUENCE_TERMINATION_SUBJECT, (IMessageHandler)new RMOutboundSequenceTerminationHandler());
        mh.bind(RM_SEQUENCE_FAULT_SUBJECT, (IMessageHandler)new RMSequenceFaultHandler());
        mh.bind(RM_INBOUND_MESSAGE_SUBJECT, (IMessageHandler)new RMInboundMessageHandler());
        mh.setGuaranteed(true);
        conn.addMessageHandler(mh);
    }

    public static void soapToSonicMessage(org.apache.axis.Message soap, Message sonic) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        soap.writeTo((OutputStream)bos);
        byte[] msg = bos.toByteArray();
        sonic.writeInt(msg.length);
        sonic.write(msg);
    }

    public static org.apache.axis.Message soapFromSonicMessage(Message sonic) throws Exception {
        String contentType = "text/xml";
        byte[] data = new byte[sonic.readInt()];
        sonic.read(data);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        SonicSoapVerifier verifier = new SonicSoapVerifier(bin, contentType);
        SOAPMessage sm = verifier.getSoapMessage();
        SOAPConstants sc = verifier.getSoapConstants();
        org.apache.axis.Message axisMsg = new org.apache.axis.Message((Object)sm.getSOAPPart().getEnvelope());
        MessageContext mctx = new MessageContext((AxisEngine)new AxisClient());
        mctx.setSOAPConstants(sc);
        mctx.setRequestMessage(axisMsg);
        return axisMsg;
    }

    void broadcast(int op, Message m) {
        try {
            if (op == 1) {
                m.setSubject(RM_OUTBOUND_MESSAGE_ACKS_SUBJECT);
            } else if (op == 2) {
                m.setSubject(RM_OUTBOUND_SEQUENCE_TERMINATION_SUBJECT);
            } else if (op == 3) {
                m.setSubject(RM_SEQUENCE_FAULT_SUBJECT);
            } else {
                throw new RuntimeException("RM message not broadcast - unknown op type " + op);
            }
            try {
                this.m_ssn.publish(m);
            }
            catch (ENetworkFailure enf) {
                if (!Broker.isInShutdown()) {
                    throw enf;
                }
            }
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    boolean isNeighbor(long brokerId) {
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(brokerId);
            return cc != null && cc.isInterbroker();
        }
        catch (Exception e) {
            return false;
        }
    }

    void forward(long brokerId, Message msg) {
        block2: {
            try {
                msg.setSubject(RM_INBOUND_MESSAGE_SUBJECT);
                this.m_ssn.publish(brokerId, msg, 0, true);
            }
            catch (Exception ex) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }

    class RMInboundMessageHandler
    implements IMessageHandler {
        RMInboundMessageHandler() {
        }

        private WSHttpProtocolHandler locateHandler(HttpServletRequest req, String hostUrl) throws IOException {
            Enumeration e = AcceptorHolder.getAcceptorHolder().getAcceptors();
            while (e.hasMoreElements()) {
                Hashtable ht = (Hashtable)e.nextElement();
                Enumeration e2 = ht.elements();
                while (e2.hasMoreElements()) {
                    HttpConnectionHandler han;
                    IHttpRequestHandler hndlr;
                    Acceptor a = (Acceptor)e2.nextElement();
                    if (!(a instanceof HTTPAcceptor)) continue;
                    HTTPAcceptor ha = (HTTPAcceptor)a;
                    String u = ha.getExternalURL();
                    if (u == null) {
                        u = ha.getURL();
                    }
                    if (!hostUrl.startsWith(u) || (hndlr = (han = ha.getHttpConnectionHandler()).loadMatchingHandler(null, req, null, null)) == null || !(hndlr instanceof WSHttpProtocolHandler)) continue;
                    return (WSHttpProtocolHandler)hndlr;
                }
            }
            return null;
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            Object rh = null;
            RMReceiveSequence support = null;
            String ID = null;
            try {
                env.getMessage().readShort();
                String origin = env.getMessage().readUTF();
                if (origin.equalsIgnoreCase(Config.BROKER_NAME)) {
                    return;
                }
                ID = env.getMessage().readUTF();
                if (ID == null || (support = RMClusteringHelper.this.m_rmm.getRMReceiveSequenceSupport(ID)) == null) {
                    return;
                }
                Message me = env.getMessage();
                String hostURL = me.readUTF();
                String path = me.readUTF();
                int contentLength = me.readInt();
                String characterEncoding = me.readUTF();
                String contentType = me.readUTF();
                String method = me.readUTF();
                String action = me.readUTF();
                Hashtable ht = WSHttpProtocolHandler.readPropertySetFromStream(me);
                ClientSecurityContext csc = ClientSecurityContext.getClientSecurityContext(env.getMessage(), (short)-1);
                org.apache.axis.Message axisMsg = RMClusteringHelper.soapFromSonicMessage(env.getMessage());
                ProgressPasswordUser ppu = AgentRegistrar.getAgentRegistrar().getSecurityBean() == null ? new ProgressPasswordUser(csc.getUid(), "") : AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(csc.getUid());
                HttpClientContext hctx = HttpClientContextManager.getInstance().connect(ppu);
                if (hctx == null) {
                    return;
                }
                Request req = new Request(null, null);
                req.setServletPath(hostURL);
                req.setMethod(method);
                req.setContentType(contentType);
                req.getHttpFields().add(HttpHeader.CONTENT_LENGTH, "" + contentLength);
                req.setCharacterEncoding(characterEncoding);
                Enumeration flds = ht.keys();
                while (flds.hasMoreElements()) {
                    String key = (String)flds.nextElement();
                    req.getHttpFields().add(key, (String)ht.get(key));
                }
                WSHttpProtocolHandler ph = this.locateHandler((HttpServletRequest)req, support.getSequenceState().getEndpointReference().getAddress().toString());
                if (ph != null) {
                    String SOAPVER = "SOAP 1.1";
                    if (axisMsg.getMessageContext().getSOAPConstants() instanceof SOAP12Constants) {
                        SOAPVER = "SOAP 1.2";
                    }
                    ForwardedWSHttpInRequest wsreq = new ForwardedWSHttpInRequest((HttpServletRequest)req, (SOAPMessage)axisMsg, SOAPVER, action);
                    MessageContext mc = ph.establishContext();
                    mc.setRequestMessage(axisMsg);
                    mc.setProperty("COM_SONIC_WSS_SUPRESS", (Object)"true");
                    Destination dest = null;
                    dest = AddressBinder.isInternallyGeneratedWSAAddress(path) ? AddressBinder.getWSADestination(path) : wsreq.getJMSDestination(ph.config, path);
                    mc.setProperty("DEST", (Object)dest);
                    mc.setProperty("com.sonicsw.net.http.HttpClientContext", (Object)hctx);
                    mc.setProperty("com.sonicsw.net.http.HttpInRequest", (Object)wsreq);
                    mc.setSOAPActionURI(action);
                    ph.sendToSOAPStack(mc, hctx);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }

    class RMSequenceFaultHandler
    implements IMessageHandler {
        RMSequenceFaultHandler() {
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            Object rh = null;
            RMSendSequence support = null;
            String ID = null;
            try {
                env.getMessage().readShort();
                String origin = env.getMessage().readUTF();
                if (origin.equalsIgnoreCase(Config.BROKER_NAME)) {
                    return;
                }
                ID = env.getMessage().readUTF();
                if (ID == null || (support = RMClusteringHelper.this.m_rmm.getRMSendSequenceSupport(ID)) == null) {
                    return;
                }
                org.apache.axis.Message axisMsg = null;
                try {
                    axisMsg = RMClusteringHelper.soapFromSonicMessage(env.getMessage());
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                support.markForTermination(null);
                support.faultSequence(axisMsg, axisMsg != null, false);
                RMClusteringHelper.this.m_rmm.removeRMSequenceSupport(support);
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage("Failure in RMClusteringHelper:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
                return;
            }
        }
    }

    class RMOutboundSequenceTerminationHandler
    implements IMessageHandler {
        RMOutboundSequenceTerminationHandler() {
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            String id = null;
            boolean normal = true;
            try {
                env.getMessage().readShort();
                String origin = env.getMessage().readUTF();
                if (origin.equalsIgnoreCase(Config.BROKER_NAME)) {
                    return;
                }
                id = env.getMessage().readUTF();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            RMSendSequence support = null;
            if (id == null || (support = RMClusteringHelper.this.m_rmm.getRMSendSequenceSupport(id)) == null) {
                return;
            }
            support.markForTermination(null);
            support.uncirculateSequence(normal);
            RMClusteringHelper.this.m_rmm.removeRMSequenceSupport(support);
        }
    }

    class RMOutboundMessageAckHandler
    implements IMessageHandler {
        RMOutboundMessageAckHandler() {
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            Message m = env.getMessage();
            RMSendSequence support = null;
            SequenceAcknowledgement sa = null;
            try {
                m.readShort();
                String origin = m.readUTF();
                if (origin.equalsIgnoreCase(Config.BROKER_NAME)) {
                    return;
                }
                String id = m.readUTF();
                support = RMClusteringHelper.this.m_rmm.getRMSendSequenceSupport(id);
                if (support == null) {
                    return;
                }
                org.apache.axis.Message axisMsg = RMClusteringHelper.soapFromSonicMessage(m);
                ReliableHeaders rh = new ReliableHeaders();
                rh.fromSOAPEnvelope(axisMsg.getSOAPEnvelope());
                sa = (SequenceAcknowledgement)rh.getSequenceAcknowledgements().firstElement();
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage("Failure in RMClusteringHelper:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
                return;
            }
            AckEvent ae = new AckEvent();
            ae.setSequence(support);
            ae.setAcknowledgement(sa);
            ae.execute();
        }
    }
}

