/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.EInvalidClientAddress;
import progress.message.broker.IClientContext;
import progress.message.util.ArrayUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SubjectUtil;

public final class AddrUtil {
    static boolean SUBJECT_CACHE_LOADED = false;
    static int s_ISYS = 0;
    static int s_USERS = 0;
    static int s_broker = 0;
    static byte[] s_sCode = null;

    static byte[] directedAddr(long id, int operation, byte[] reuseAddrParam) {
        byte[] reuseAddr = reuseAddrParam;
        if (!SUBJECT_CACHE_LOADED) {
            SUBJECT_CACHE_LOADED = true;
            s_ISYS = SubjectUtil.computeSCode("$ISYS", 0, "$ISYS".length());
            s_USERS = SubjectUtil.computeSCode("USERS", 0, "USERS".length());
            s_broker = SubjectUtil.computeSCode(Config.BROKER_UID, 0, Config.BROKER_UID.length());
        }
        if (reuseAddr == null) {
            reuseAddr = new byte[30];
            ArrayUtil.writeShort(reuseAddr, 0, (short)7);
            ArrayUtil.writeInt(reuseAddr, 2, s_ISYS);
            ArrayUtil.writeInt(reuseAddr, 6, s_USERS);
            ArrayUtil.writeInt(reuseAddr, 26, s_broker);
        }
        int UserId = AddrUtil.clientIdToUid(id);
        int AppId = AddrUtil.clientIdToAppid(id);
        ArrayUtil.writeInt(reuseAddr, 10, operation);
        ArrayUtil.writeInt(reuseAddr, 14, UserId);
        ArrayUtil.writeInt(reuseAddr, 18, AppId);
        ArrayUtil.writeInt(reuseAddr, 22, AgentRegistrarHolder.AGENT_REGISTRAR.getCollectiveSCode());
        return reuseAddr;
    }

    public static final long stringToClientId(String uid, String appid) {
        return SessionConfig.stringToClientId(uid, appid);
    }

    static int getUidFromAdmin(ISubject s) throws EInvalidAdminAddress {
        try {
            return s.getMatchVector()[2];
        }
        catch (IndexOutOfBoundsException e) {
            throw new EInvalidAdminAddress();
        }
    }

    static long getIdFromAdmin(ISubject s) throws EInvalidAdminAddress {
        int[] mv = s.getMatchVector();
        try {
            return (long)mv[3] << 32 | (long)mv[2] & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            throw new EInvalidAdminAddress();
        }
    }

    public static long getIdFromDirectedSubject(ISubject sub) throws EInvalidClientAddress {
        int[] mv = sub.getMatchVector();
        try {
            return (long)mv[4] << 32 | (long)mv[3] & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            throw new EInvalidClientAddress();
        }
    }

    public static int clientIdToUid(long clientId) {
        return (int)clientId;
    }

    public static int clientIdToAppid(long clientId) {
        return (int)(clientId >>> 32);
    }

    public static final String getSwizzleString(long clientId) throws EClientNotRegistered {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        IClientContext cc = reg.getClient(clientId);
        return SessionConfig.getDirectedSubject(cc.getUid(), cc.getAppid(), reg.getCollective(), Config.BROKER_UID, "Swizzle");
    }

    private static class AgentRegistrarHolder {
        private static final AgentRegistrar AGENT_REGISTRAR = AgentRegistrar.getAgentRegistrar();

        private AgentRegistrarHolder() {
        }
    }
}

