/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class CommitGlobalTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    CommitGlobalTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block14: {
            Message rep = new Message();
            try {
                Message req = env.getMessage();
                long clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                Object xid = req.readObject();
                int tid = req.readInt();
                boolean startTx = req.readBoolean();
                this.m_reg.getTransactionMgr().commitTxn(tid, xid, clientId);
                rep.writeShort(0);
                if (startTx) {
                    int newTx = 0;
                    ISubject subj = req.getSubject();
                    String uid = subj.extractSubjectLevel(2);
                    String appid = subj.extractSubjectLevel(3);
                    newTx = this.m_reg.getTransactionMgr().beginTxn(uid, appid, xid);
                    rep.writeInt(newTx);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (EInvalidAdminAddress e) {
                rep.writeShort(1);
            }
            catch (ClassNotFoundException e) {
                rep.writeShort(1);
            }
            catch (EXAThereIsNoXidException e) {
                rep.writeShort(12);
            }
            catch (ETxnNotFound e) {
                rep.writeShort(2);
            }
            catch (ETxnSequenceError e) {
                rep.writeShort(3);
            }
            catch (ETxnAborted e) {
                rep.writeShort(4);
            }
            catch (ETxnAccessViolation e) {
                rep.writeShort(6);
            }
            catch (EXADuplicateXidException e) {
                rep.writeShort(11);
            }
            catch (IOException e) {
                rep.writeShort(1);
            }
            try {
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (Broker.isInShutdown()) break block14;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

