/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.PublishLimiter;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class InitRestoreFlowController
extends DebugObject {
    Hashtable ht = new Hashtable();
    boolean DEBUG1 = this.checkDebugFlags(64);

    public InitRestoreFlowController() {
        super(DebugState.GLOBAL_DEBUG_ON ? "InitRestoreFlowController" : null);
        if (this.DEBUG) {
            this.debug("Config.THROTTLE_PUBS_DURING_RESTORE= " + Config.THROTTLE_PUBS_DURING_RESTORE);
            this.debug("Config.RESTORE_MSGS_FC_COUNT= " + Config.RESTORE_MSGS_FC_COUNT);
        }
    }

    protected void updatePubCount(IClientContext cc, PublishLimiter pubLimiter, int number) {
        Long client_id = new Long(cc.getId());
        FCData fcdat = (FCData)this.ht.get(client_id);
        if (fcdat != null) {
            boolean throttle = fcdat.updatePub(number);
            if (throttle) {
                if (this.DEBUG) {
                    this.debug("cc= " + cc + fcdat.getDebugInfo() + " FC: Stopping Pubs ");
                }
                cc.initRestoreFlowControlPublisher(pubLimiter);
            }
            if (this.DEBUG1 && fcdat.m_pubTotCt % 5000L == 0L) {
                this.debug("cc= " + cc + fcdat.getDebugInfo());
            }
        } else if (this.DEBUG) {
            this.debug("updatePubCount: cc not found " + cc);
        }
    }

    protected void updateSubCount(IClientContext cc) {
        Long client_id = new Long(cc.getId());
        FCData fcdat = (FCData)this.ht.get(client_id);
        if (fcdat != null) {
            boolean release = fcdat.updateSub(1);
            if (release) {
                if (this.DEBUG) {
                    this.debug("cc= " + cc + fcdat.getDebugInfo() + " FC: Releasing Pubs");
                }
                cc.releaseInitRestoreBlockedPublishers();
            }
            if (this.DEBUG1 && fcdat.m_subTotCt % 5000L == 0L) {
                this.debug("cc= " + cc + fcdat.getDebugInfo());
            }
        } else {
            fcdat = new FCData();
            fcdat.updateSub(1);
            this.ht.put(client_id, fcdat);
        }
    }

    protected void removeCC(IClientContext cc) {
        FCData fcdat = (FCData)this.ht.remove(new Long(cc.getId()));
        cc.releaseInitRestoreBlockedPublishers();
        if (this.DEBUG1) {
            if (fcdat != null) {
                this.debug("cc= " + cc + fcdat.getDebugInfo() + " FC: RemovingCC; Releasing Pubs");
            } else {
                this.debug("cc= " + cc + " FC: RemovingCC; Releasing Pubs");
            }
        }
    }

    private class FCData {
        long m_pubCt;
        long m_pubTotCt;
        double m_pubGoal;
        long m_subCt;
        long m_subTotCt;
        double m_subGoal;
        boolean m_throttling = false;
        double subIncrement;
        long m_numThrottle;
        long m_numRelease;

        FCData() {
            this.reset();
        }

        private void reset() {
            this.m_throttling = false;
            if (this.m_pubTotCt == 0L) {
                this.m_subTotCt = 0L;
            }
            this.m_subGoal = Config.RESTORE_MSGS_FC_COUNT;
            this.m_subCt = 0L;
            this.m_pubGoal = 0.8 * (double)Config.RESTORE_MSGS_FC_COUNT;
            this.m_pubCt = 0L;
            this.subIncrement = 1.25;
        }

        boolean updatePub(int ct) {
            this.m_pubCt += (long)ct;
            this.m_pubTotCt += (long)ct;
            if ((double)this.m_pubCt > this.m_pubGoal) {
                this.m_subGoal += (double)ct * this.subIncrement;
                if (!this.m_throttling) {
                    ++this.m_numThrottle;
                }
                this.m_throttling = true;
            }
            return this.m_throttling;
        }

        boolean updateSub(int ct) {
            boolean needRelease = false;
            ++this.m_subCt;
            ++this.m_subTotCt;
            if ((double)this.m_subCt >= this.m_subGoal) {
                if (this.m_throttling) {
                    this.m_throttling = false;
                    needRelease = true;
                    ++this.m_numRelease;
                }
                this.reset();
            }
            return needRelease;
        }

        String getDebugInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(" numSent ");
            buf.append(this.m_subTotCt);
            buf.append("; numNew= ");
            buf.append(this.m_pubTotCt);
            buf.append("; numThrottle= ");
            buf.append(this.m_numThrottle);
            buf.append("; numRelease= ");
            buf.append(this.m_numRelease);
            buf.append("; ");
            return buf.toString();
        }
    }
}

