/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.IGSPropagationRule;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class GSPropagationRule
extends DebugObject
implements Cloneable,
Serializable,
IGSPropagationRule {
    private int m_id = -1;
    private String m_topic = null;
    private String m_toNodeListString = null;
    private Vector m_toNodeList;
    private boolean m_isToNodeListDirty;
    private boolean m_toAllNodes = false;

    public GSPropagationRule() {
        super(DebugState.GLOBAL_DEBUG_ON ? "GSPropagationRule" : null);
    }

    public GSPropagationRule clone() throws CloneNotSupportedException {
        return (GSPropagationRule)super.clone();
    }

    public GSPropagationRule(String topic, String toNodeList) {
        super(DebugState.GLOBAL_DEBUG_ON ? "GSPropagationRule" : null);
        this.m_topic = topic.trim();
        if (toNodeList != null) {
            this.m_toNodeListString = toNodeList.trim();
            this.m_isToNodeListDirty = true;
            if ("#".equals(this.m_toNodeListString)) {
                this.m_toAllNodes = true;
            }
        }
    }

    GSPropagationRule(int id, String topic, String toNodeList, String fromNodeList) {
        this(topic, toNodeList);
        this.setID(id);
    }

    @Override
    public int getID() {
        return this.m_id;
    }

    public final void setID(int id) {
        this.m_id = id;
    }

    @Override
    public String getTopic() {
        return this.m_topic;
    }

    public void setTopic(String topic) {
        this.m_topic = topic;
    }

    @Override
    public String getToNodeListString() {
        return this.m_toNodeListString;
    }

    public void setToNodeListString(String nodesParam) {
        String nodes = nodesParam;
        if (this.DEBUG) {
            this.debug("#setToNodeListString: old list = [" + this.m_toNodeListString + "], new list = [" + nodes + "]");
        }
        if (nodes != null) {
            nodes = nodes.trim();
        }
        this.m_toNodeListString = nodes;
        this.m_isToNodeListDirty = true;
    }

    public boolean isToAllNodes() {
        return this.m_toAllNodes;
    }

    public void setToAllNodes(boolean toAllNodes) {
        this.m_toAllNodes = toAllNodes;
    }

    @Override
    public Vector getToNodeList() {
        if (this.m_isToNodeListDirty) {
            this.convertNodeListString(true);
        }
        if (this.m_toNodeList == null) {
            this.m_toNodeList = new Vector();
        }
        if (!this.isToAllNodes()) {
            this.m_isToNodeListDirty = false;
        }
        return this.m_toNodeList;
    }

    void addMoreToNodes(String nodeList) {
        if (nodeList == null) {
            return;
        }
        StringBuffer newS = new StringBuffer();
        if (this.m_toNodeListString != null && !"".equals(this.m_toNodeListString)) {
            newS.append(this.m_toNodeListString);
            newS.append(',');
        }
        newS.append(nodeList.trim());
        this.m_toNodeListString = newS.toString();
        this.m_isToNodeListDirty = true;
    }

    private void convertNodeListString(boolean expandWildCard) {
        String sourceString = this.m_toNodeListString;
        Vector<String> target = this.m_toNodeList = new Vector<String>();
        if (sourceString == null || "".equals(sourceString)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(sourceString, ",");
        while (st.hasMoreTokens()) {
            String newNode = st.nextToken().trim();
            if (newNode == null || "".equals(newNode)) continue;
            if ("#".equals(newNode)) {
                this.m_toAllNodes = true;
                if (!expandWildCard) continue;
                this.addAllConfiguredNodes(target);
                continue;
            }
            if (!target.isEmpty() && target.contains(newNode.intern())) continue;
            target.addElement(newNode.intern());
        }
        if (this.DEBUG) {
            this.debug("[.convertToVector] " + sourceString);
            Enumeration vec = target.elements();
            while (vec.hasMoreElements()) {
                this.debug(" " + vec.nextElement());
            }
        }
    }

    private void addAllConfiguredNodes(Vector target) {
        Enumeration configuredNodes = GSManager.getAllRoutingNodes().elements();
        while (configuredNodes.hasMoreElements()) {
            String aNode = (String)configuredNodes.nextElement();
            if (target.contains(aNode.intern())) continue;
            target.add(aNode.intern());
        }
    }

    boolean isToNodeListContains(String node) {
        Vector toNodes = this.getToNodeList();
        return toNodes.contains(node.intern());
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeInt(this.getID());
        output.writeUTF(this.getTopic());
        output.writeUTF(this.getToNodeListString());
    }

    public void unserialize(DataInput input) throws IOException {
        this.setID(input.readInt());
        if (this.DEBUG) {
            this.debug("[RuleNum] " + this.getID());
        }
        this.setTopic(input.readUTF());
        if (this.DEBUG) {
            this.debug("[Topic] " + this.getTopic());
        }
        this.setToNodeListString(input.readUTF());
        if (this.DEBUG) {
            this.debug("[ToNodeList] " + this.getToNodeListString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("GSPropagationRule");
        }
        this.unserialize(in);
    }

    @Override
    public String toString() {
        return "[GSRule] -  [RuleNum] " + this.m_id + " [Topic] " + this.m_topic + " [ToNodeList] " + this.m_toNodeListString;
    }
}

