/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.OutputStream;
import progress.message.broker.mqtt.MqttBrokerConnection;
import progress.message.broker.mqtt.codec.MqttEncoder;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.broker.mqtt.proto.PublishMessage;
import progress.message.strm.StreamFactory;
import progress.message.util.Queue;
import progress.message.util.server.IByteBuffer;
import progress.message.zclient.Sender;

public class MqttSender
extends Sender {
    private final MqttBrokerConnection m_connection;
    private final Queue m_queue;
    private boolean startDelivery = false;

    public MqttSender(MqttBrokerConnection connection) throws IOException {
        super(connection);
        this.m_connection = connection;
        this.m_queue = new Queue();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MqttMessage message) throws IOException {
        this.m_connection.messageSent(message);
        IByteBuffer writeBuffer = MqttEncoder.encode(message);
        byte[] data = writeBuffer.data();
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            this.m_out.write(data);
            this.m_out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.logDebug(128, "Starting MQTT Sender");
            }
            while (!this.isShuttingDown()) {
                Object object = this.m_enqueuedLock;
                synchronized (object) {
                    Queue queue = this.m_queue;
                    synchronized (queue) {
                        if (this.startDelivery) {
                            while (!this.m_queue.isEmpty()) {
                                PublishMessage message = (PublishMessage)this.m_queue.dequeue();
                                this.send(message);
                            }
                            this.m_msgEnqueued = false;
                        }
                    }
                    this.m_enqueuedLock.wait(this.m_connection.getKeepAliveInterval());
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            if (this.isShuttingDown()) return;
            this.m_connection.fatalError();
            return;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            if (this.DEBUG) {
                this.debug("Caught " + ex);
            }
            this.m_connection.fatalError();
        }
    }

    private void initialize() throws IOException {
        this.m_out = StreamFactory.getSenderOutputStream(this.m_connection.getSocket(), this.m_connection.getMaxSendBufferSize(), this.m_connection.getMinSendBufferSize(), this.m_connection.getInitialSendBufferSize(), false);
        if (this.DEBUG) {
            this.logDebug(64, "Created OutputStream " + this.m_out);
        }
    }

    @Override
    public void setMinSendPriority(int priority, int channel) {
        throw new UnsupportedOperationException("This method should not be called in MQTT protocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(PublishMessage message) {
        Queue queue = this.m_queue;
        synchronized (queue) {
            this.m_queue.enqueue(message);
        }
        this.notifySender();
    }

    public Queue getQueue() {
        return this.m_queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reEnqueue(Queue queue) {
        Queue queue2 = this.m_queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                PublishMessage message = (PublishMessage)queue.dequeue();
                this.m_queue.enqueue(message);
            }
        }
    }

    public void setStartDelivery(boolean start) {
        this.startDelivery = start;
    }
}

