/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import progress.message.crypto.DES;
import progress.message.crypto.DESString;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.SHA;

public class PBETool {
    private static boolean DEBUG = false;
    private static String ENCRYPT_MODE = "encrypt";
    private static String DECRYPT_MODE = "decrypt";
    private int m_mode = -1;
    private String m_cleartextfile = null;
    private String m_encryptedfile = null;
    private String m_clear_keyphrase = null;
    private boolean m_encrypt_pwd = false;
    private static volatile String PREFIX = "";
    private static StringEncrypter desStringEncrypter = new StringEncrypter();

    public static void main(String[] args) {
        PBETool pbetool = new PBETool();
        pbetool.verifyparams(args);
        pbetool.start();
    }

    void start() {
        byte[] filedata = null;
        try {
            if (this.m_mode == 2) {
                filedata = PBETool.readPBEStream(this.m_encryptedfile, this.m_clear_keyphrase);
            } else {
                if (this.m_cleartextfile != null) {
                    filedata = PBETool.readStream(this.m_cleartextfile, this.m_clear_keyphrase);
                }
                if (this.m_encrypt_pwd) {
                    System.out.println(desStringEncrypter.encrypt(this.m_clear_keyphrase));
                }
            }
        }
        catch (IOException ioe) {
            PBETool.printErrorAndExit("Error: Unable to open file: " + (this.m_mode == 2 ? this.m_encryptedfile : this.m_cleartextfile) + ": " + ioe.getMessage());
        }
        if (filedata == null) {
            return;
        }
        try {
            PBETool.debugMessage("Opening output file: " + (this.m_mode == 1 ? this.m_encryptedfile : this.m_cleartextfile));
            FileOutputStream fos = new FileOutputStream(this.m_mode == 1 ? this.m_encryptedfile : this.m_cleartextfile);
            fos.write(filedata);
            fos.close();
        }
        catch (IOException ioe) {
            if (DEBUG) {
                ioe.printStackTrace();
            }
            PBETool.printErrorAndExit("Error: Unable to open file: " + (this.m_mode == 1 ? this.m_encryptedfile : this.m_cleartextfile) + ": " + ioe.getMessage());
        }
    }

    public static byte[] readPBEStream(String infile, String clear_key_phrase) throws IOException {
        PBETool.debugMessage("Opening input file: " + infile);
        FileInputStream in = new FileInputStream(infile);
        byte[] retData = PBETool.decryptPBEDataStream(in, clear_key_phrase);
        in.close();
        return retData;
    }

    public static byte[] readPBEStream(byte[] pbeData, String clear_key_phrase) throws IOException {
        PBETool.debugMessage("Opening byte array input stream");
        ByteArrayInputStream in = new ByteArrayInputStream(pbeData);
        byte[] retData = PBETool.decryptPBEDataStream(in, clear_key_phrase);
        in.close();
        return retData;
    }

    private static byte[] decryptPBEDataStream(InputStream pbeData, String clear_key_phrase) throws IOException {
        int len;
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] dataRead = new byte[1024];
        while ((nRead = pbeData.read(dataRead, 0, dataRead.length)) != -1) {
            buffer.write(dataRead, 0, nRead);
        }
        buffer.flush();
        byte[] base64Bytes = buffer.toByteArray();
        String base64String = new String(base64Bytes).replaceAll("\\s", "");
        byte[] tmp_data = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream bais = new ByteArrayInputStream(tmp_data);
        DataInputStream dis = new DataInputStream(bais);
        int datasize = dis.readInt();
        if (datasize < 0) {
            throw new IOException("Unable to decrypt data.  Verify that the data is encrypted.");
        }
        int pad = DES.computePad(datasize);
        PBETool.debugMessage("Decrypting: Block size is: " + datasize + " pad is: " + pad);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        int dataremaining = datasize + pad;
        byte[] data = new byte[1024];
        do {
            if (dataremaining < 1024) {
                data = new byte[dataremaining];
            }
            if ((len = dis.read(data)) <= 0) break;
            bos.write(data, 0, len);
        } while ((dataremaining -= len) > 0);
        if (dataremaining != 0) {
            throw new IOException("Encrypted data has been corrupted, and cannot be decrypted.");
        }
        data = bos.toByteArray();
        bos.close();
        byte[] embeddedMac = new byte[20];
        int sha_size = dis.read(embeddedMac);
        dis.close();
        if (sha_size != 20) {
            throw new IOException("Encrypted data has been corrupted, SHA hash data could not be read.");
        }
        byte[] key = PBETool.makeKey(clear_key_phrase.getBytes());
        tmp_data = PBETool.doDES(2, key, data);
        SHA sha = new SHA();
        sha.add(tmp_data);
        byte[] hash = sha.digest();
        if (hash.length != 20 || embeddedMac.length != 20) {
            throw new IOException("Error: SHA Message Digest Hash information not available.");
        }
        for (int i = 0; i < 20; ++i) {
            if (hash[i] != embeddedMac[i]) {
                PBETool.debugMessage("HASH:     " + hash);
                PBETool.debugMessage("EMBEDDED: " + embeddedMac);
                throw new IOException("Error: SHA Message Digest Hash does not match original source.  Verify Password used.");
            }
            PBETool.debugMessage("Comparing hash[" + i + "] = " + hash[i] + " embedded[" + i + "] = " + embeddedMac[i]);
        }
        data = new byte[datasize];
        System.arraycopy(tmp_data, 0, data, 0, datasize);
        tmp_data = null;
        return data;
    }

    public static byte[] readStream(String infile, String clear_key_phrase) throws IOException {
        PBETool.debugMessage("Encrypting input file: " + infile);
        FileInputStream in = new FileInputStream(infile);
        byte[] retData = PBETool.encryptDataStream(in, clear_key_phrase);
        in.close();
        return retData;
    }

    public static byte[] readStream(byte[] clearData, String clear_key_phrase) throws IOException {
        PBETool.debugMessage("Encrypting clearData byte array ");
        ByteArrayInputStream in = new ByteArrayInputStream(clearData);
        byte[] retData = PBETool.encryptDataStream(in, clear_key_phrase);
        in.close();
        return retData;
    }

    private static byte[] encryptDataStream(InputStream clearData, String clear_key_phrase) throws IOException {
        int datasize = clearData.available();
        int pad = DES.computePad(datasize);
        PBETool.debugMessage("Encrypting: Block size is: " + datasize + " pad is: " + pad);
        byte[] input = new byte[datasize + pad];
        clearData.read(input);
        clearData.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(datasize);
        PBETool.debugMessage("Encryption: writing block size: " + datasize);
        byte[] key = PBETool.makeKey(clear_key_phrase.getBytes());
        dos.write(PBETool.doDES(1, key, input));
        SHA sha = new SHA();
        sha.add(input);
        byte[] hash = sha.digest();
        dos.write(hash);
        return Base64.getEncoder().encodeToString(baos.toByteArray()).getBytes();
    }

    static byte[] makeKey(byte[] pwd) throws IOException {
        byte[] key = new byte[8];
        try {
            System.arraycopy(PBETool.doSHA(pwd), 6, key, 0, 8);
        }
        catch (Exception e) {
            throw new IOException("error: creating encryption key: " + e.toString());
        }
        return key;
    }

    private static byte[] doDES(int mode, byte[] key, byte[] input) {
        DES des = new DES();
        des.init(mode, key);
        byte[] output = new byte[input.length];
        des.doFinal(input, 0, input.length, output, 0);
        return output;
    }

    private static byte[] doSHA(byte[] pwd) throws Exception {
        byte[] hash = null;
        SHA md = new SHA();
        hash = MessageDigest.hash(pwd, (MessageDigest)md);
        return hash;
    }

    private void verifyparams(String[] args) {
        PREFIX = File.separator.equals("/") ? "-" : "/";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals(PREFIX + "m")) {
                if (i == args.length - 1 || args[i + 1].startsWith(PREFIX)) {
                    PBETool.printErrorAndExit("error: missing mode option");
                }
                if (args[++i].equalsIgnoreCase(ENCRYPT_MODE)) {
                    this.m_mode = 1;
                } else if (args[i].equalsIgnoreCase(DECRYPT_MODE)) {
                    this.m_mode = 2;
                } else {
                    PBETool.printErrorAndExit("error: invalid mode option specified: " + args[i]);
                }
                PBETool.debugMessage("Mode is set to: " + this.m_mode);
                continue;
            }
            if (arg.equals(PREFIX + "c")) {
                if (i == args.length - 1 || args[i + 1].startsWith(PREFIX)) {
                    PBETool.printErrorAndExit("error: missing clear-text file name");
                }
                this.m_cleartextfile = args[++i];
                PBETool.debugMessage("Input is set to: " + this.m_cleartextfile);
                continue;
            }
            if (arg.equals(PREFIX + "e")) {
                if (i == args.length - 1 || args[i + 1].startsWith(PREFIX)) {
                    PBETool.printErrorAndExit("error: missing encrypted file name");
                }
                this.m_encryptedfile = args[++i];
                PBETool.debugMessage("Output is set to: " + this.m_encryptedfile);
                continue;
            }
            if (arg.equals(PREFIX + "p")) {
                if (i == args.length - 1 || args[i + 1].startsWith(PREFIX)) {
                    PBETool.printErrorAndExit("error: missing encryption key phrase");
                }
                this.m_clear_keyphrase = args[++i];
                continue;
            }
            if (arg.equals(PREFIX + "x")) {
                this.m_encrypt_pwd = true;
                continue;
            }
            if (arg.equals(PREFIX + "h")) {
                PBETool.printUsage();
                System.exit(1);
            }
            System.err.println("error: unexpected argument: " + arg);
            PBETool.printUsage();
            System.exit(1);
        }
        if (this.m_mode == -1) {
            PBETool.printUsage();
            PBETool.printErrorAndExit("error: Must specify ENCRYPT or DECRYPT for mode.");
        }
        if (this.m_clear_keyphrase == null) {
            PBETool.printUsage();
            PBETool.printErrorAndExit("error: Must specify encryption key phrase.");
        }
        if (this.m_cleartextfile == null && this.m_encryptedfile != null || this.m_cleartextfile != null && this.m_encryptedfile == null) {
            PBETool.printUsage();
            PBETool.printErrorAndExit("error: Must specify both a clear-text file name and an encrypted file name.");
        }
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("usage: java progress.message.crypto.PBETool (options) ...\n\n");
        use.append("options:\n");
        use.append("  " + PREFIX + "m <mode>              Indicate the mode to run the PBETool.  \n");
        use.append("                         Mode options are:\n");
        use.append("                         " + ENCRYPT_MODE + " (default) or " + DECRYPT_MODE + "\n");
        use.append("  " + PREFIX + "c <clear-text-file>   Specify the name of clear-text file.\n");
        use.append("  " + PREFIX + "e <encrypted-file>    Specify the name of encrypted file.\n");
        use.append("  " + PREFIX + "p <pwd-phrase>        Specify the encryption key phrase.\n");
        use.append("  " + PREFIX + "x                     Encrypt pwd-phrase, and send encrypted \n");
        use.append("                         version to standard output.\n");
        use.append("  " + PREFIX + "h                     This help screen.\n");
        System.err.println(use);
    }

    private static void printErrorAndExit(String errmsg) {
        System.err.println(errmsg);
        if (DEBUG) {
            Exception e = new Exception(errmsg);
            e.printStackTrace(System.err);
        }
        System.exit(1);
    }

    private static void debugMessage(String diagnosticMsg) {
        if (DEBUG) {
            System.err.println(diagnosticMsg);
        }
    }

    private static final class StringEncrypter
    extends DESString {
        private static final byte[] s_data = new byte[]{21, 89, -63, 38, 64, -94, -40, 3, 5, 35, 69, 103, -119, -85, -51, -17};

        private StringEncrypter() {
        }

        @Override
        protected byte[] getSalt() {
            return s_data;
        }

        final String encrypt(String encoded_string) throws IOException {
            return this.DESEncrypt(encoded_string);
        }
    }
}

