/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.jdbc;

public class SyncLock {
    private Thread m_currentOwner;
    private int m_nesting;

    public synchronized void acquire() {
        Thread t = Thread.currentThread();
        if (this.m_currentOwner == t) {
            ++this.m_nesting;
            return;
        }
        boolean interrupted = false;
        while (this.m_currentOwner != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.m_currentOwner = t;
        this.m_nesting = 1;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void release() {
        if (this.m_currentOwner == Thread.currentThread()) {
            --this.m_nesting;
            if (this.m_nesting == 0) {
                this.m_currentOwner = null;
                this.notifyAll();
            }
        } else {
            throw new IllegalMonitorStateException("SyncLock.release currentThread not owner " + Thread.currentThread());
        }
    }

    public boolean hasLock() {
        return Thread.currentThread() == this.m_currentOwner;
    }
}

