/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.MgramSerializer;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IDbBatchMessageCleaner;
import progress.message.dbq.IDbMsgDeleteListener;
import progress.message.dbq.IDbUndelMsgDeleteListener;
import progress.message.dbq.IPubSubDBQ;
import progress.message.dbq.IQueryCancelCheck;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbq.pse.MsgRestoreQueries;
import progress.message.dbsc.data.IDbRef;
import progress.message.dbsc.data.impl.DbUndelMsg;
import progress.message.dbsc.pse.DbSchemaCheckPubSub;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.IPSECounters;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessages;
import progress.message.dbsc.pse.pc.pubsub.IPSEUndelMsg;
import progress.message.dbsc.pse.pc.pubsub.PSECounters;
import progress.message.dbsc.pse.pc.pubsub.v2.PSEClientUndelMsgs2;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.server.ByteBufferOutputStream;
import progress.message.util.server.EpochClock;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class PubSubDBQImplPSE
extends DBQPSEBase
implements IPubSubDBQ,
IDbBatchMessageCleaner {
    private PSEBrokerDb m_pseDb;
    private MsgRestoreQueries m_restoreQueries = null;

    public PubSubDBQImplPSE(PSEBrokerDb db) {
        super("PubSubDBQImplPSE");
        this.m_pseDb = db;
    }

    public PubSubDBQImplPSE(PSEBrokerDb db, PSEDbContext dbctx) {
        this(db);
        this.m_dbCtx = dbctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws EDatabaseException {
        block11: {
            if (this.m_dbCtx == null) {
                this.m_dbCtx = this.m_pseDb.getCtx(3);
            }
            this.m_restoreQueries = new MsgRestoreQueries();
            this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
            this.m_opCtxRead = new OpContext(1, 2, this.m_dbCtx);
            this.m_opCtxDirtyRead = new OpContext(1, 1, this.m_dbCtx);
            this.m_restoreQueries.initQueries();
            this.acquireLock(this.m_opCtxUpdate);
            try {
                boolean DEBUG1;
                IPSECounters rootCounters = this.getRootCounters();
                if (rootCounters == null) {
                    rootCounters = new PSECounters();
                    this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("Counters"), (Object)rootCounters);
                    this.commit();
                }
                if (!(DEBUG1 = this.isDebugLevel1())) break block11;
                this.debug("init: dbctx= " + this.m_dbCtx);
                if (DebugState.get("DbSchemaCheck") || DebugState.get("DbSchemaCheckPubSub")) {
                    try {
                        Logger logger = new Logger(this);
                        DbSchemaCheckPubSub dbchecker = new DbSchemaCheckPubSub(this.m_dbCtx.getDatabase(), logger);
                        dbchecker.checkDb();
                        break block11;
                    }
                    catch (ObjectStoreException ex) {
                        this.debug("Db corruption detected; exiting...");
                        throw ex;
                    }
                }
                for (IPSEClientUndelMsgs cmsgs : this.getRootClients()) {
                    this.debug("IPSEClientUndelMsgs cid= " + cmsgs.getClientId() + " count = " + cmsgs.getUndelCount() + " size= " + cmsgs.getTotalSize());
                }
                this.debug("IPSEMessages: count= " + this.getRootMessages().getCount());
            }
            catch (ObjectStoreException e) {
                this.m_dbCtx.handlePSEException(e);
            }
            finally {
                this.releaseLock(this.m_opCtxUpdate);
            }
        }
    }

    @Override
    public Collection getMgramsFromPosTx(long client_id, long tracking, long seq, int maxReturn) throws InterruptedIOException, EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMgramsFromPosTx starting; cid= " + client_id + ", trk= " + tracking + ", maxReturn= " + maxReturn);
        }
        this.checkUpdateLock();
        ArrayList<BrokerDatabase.MgramInfo> result = new ArrayList<BrokerDatabase.MgramInfo>();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return result;
            }
            Iterator it = this.m_restoreQueries.getRestoreIterator(cmsgs, tracking, seq, false);
            long lastMid = -1L;
            for (int count = 0; it.hasNext() && count < maxReturn; ++count) {
                IPSEUndelMsg undel = (IPSEUndelMsg)it.next();
                long messageId = undel.getMessageId();
                long seqno = undel.getSequenceNumber();
                int size = undel.getMessageSize();
                Date timestamp = undel.getTimestamp();
                BrokerDatabase.MgramInfo mi = new BrokerDatabase.MgramInfo(seqno, messageId, size, timestamp);
                result.add(mi);
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return result;
    }

    @Override
    public BrokerDatabase.CountSizeUpdateInfo getCountSizeFromPosTx(long clientId, long minMessageId, long maxMessageId, int maxReturn) throws InterruptedIOException, EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("getCountSizeFromPosTx starting; cid= " + clientId + ", minMid= " + minMessageId + ", maxMessageId= " + maxMessageId + ", maxReturn= " + maxReturn);
        }
        this.checkUpdateLock();
        try {
            IPSEUndelMsg msg;
            int ct;
            long maxInDb;
            long size = 0L;
            long lastMessageId = -1L;
            if (minMessageId < 0L && (maxInDb = this.getRootMessages().getMaxMessageId()) <= maxMessageId) {
                IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(clientId);
                if (cmsgs != null) {
                    ct = cmsgs.getUndelCount();
                    size = cmsgs.getTotalSize();
                    lastMessageId = maxInDb;
                }
                if (DEBUG) {
                    this.debug("getCountSizeFromPosTx performed expedited query; cid= " + clientId + ", count= " + ct + ", size= " + size + ", lastMessageId= " + lastMessageId);
                }
                return new BrokerDatabase.CountSizeUpdateInfo(size, ct, true, lastMessageId);
            }
            long start = minMessageId >= 0L ? minMessageId + 1L : minMessageId;
            Iterator it = this.getUndelIterator(clientId, minMessageId);
            for (ct = 0; it != null && it.hasNext() && ct < maxReturn && (msg = (IPSEUndelMsg)it.next()).getMessageId() <= maxMessageId; ++ct) {
                size += (long)msg.getMessageSize();
                lastMessageId = msg.getMessageId();
            }
            if (ct < maxReturn) {
                return new BrokerDatabase.CountSizeUpdateInfo(size, ct, true, lastMessageId);
            }
            return new BrokerDatabase.CountSizeUpdateInfo(size, ct, false, lastMessageId);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
            return null;
        }
    }

    @Override
    public BrokerDatabase.ClientDeliveryInfo getClientInfofromJMSMessageIDTx(String JMSMessageID, long clientId) throws EDatabaseException, InterruptedIOException {
        if (this.getDebug()) {
            this.debug("getClientInfofromJMSMessageIDTx starting; cid= " + clientId + ", jmsid= " + JMSMessageID);
        }
        this.checkUpdateLock();
        BrokerDatabase.ClientDeliveryInfo info = null;
        try {
            IPSEUndelMsg undel = null;
            IndexIterator it = null;
            try {
                it = this.getRootMessages().getJMSIdIterator(JMSMessageID);
            }
            catch (Exception jex) {
                if (this.isDebugLevel1()) {
                    this.debug("getClientInfofromJMSMessageIDTx: exception getting Iterator; JMSMessageID= " + JMSMessageID + " " + jex.toString(), jex);
                }
                return info;
            }
            while (it.hasNext()) {
                it.advance();
                String key = (String)it.currentKey();
                if (key.equals(JMSMessageID)) {
                    IPSEMessage msg = (IPSEMessage)it.currentValue();
                    long mid = msg.getMessageId();
                    undel = this.getUndel(clientId, mid);
                    if (undel == null) continue;
                    info = new BrokerDatabase.ClientDeliveryInfo();
                    info.cid = clientId;
                    info.seqno = undel.getSequenceNumber();
                    info.redelivered = undel.getRedelivery();
                    info.expiration = undel.getExpiration();
                    info.messageid = mid;
                    info.timestamp = undel.getTimestamp();
                    info.undelSubjectIds = undel.getUndelSubjectIds();
                }
                break;
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return info;
    }

    @Override
    public BrokerDatabase.MgramInfo getMgramInfoFromJMSMessageIDtx(String JMSMessageID) throws EDatabaseException, InterruptedIOException {
        if (this.getDebug()) {
            this.debug("getMgramInfoFromJMSMessageIDtx starting; jmsid= " + JMSMessageID);
        }
        this.checkUpdateLock();
        try {
            IPSEMessage msg = null;
            try {
                msg = this.getRootMessages().get(JMSMessageID);
            }
            catch (Exception jex) {
                if (this.isDebugLevel1()) {
                    this.debug("getMgramInfoFromJMSMessageIDtx: exception getting message; JMSMessageID= " + JMSMessageID + " " + jex.toString(), jex);
                }
                msg = null;
            }
            if (msg == null) {
                return null;
            }
            long mid = msg.getMessageId();
            long seq = msg.getSequenceNumber();
            int size = msg.getMessageSize();
            Date timestamp = msg.getTimestamp();
            return new BrokerDatabase.MgramInfo(seq, mid, size, timestamp);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongHashTable getAllUndelMessageIDs() throws EDatabaseException {
        boolean DEBUG = this.debugGetAllUndelMessageIDs();
        LongHashTable<Long> trackingNums = new LongHashTable<Long>();
        this.acquireLock(this.m_opCtxRead);
        try {
            OSTreeSet allClients = this.getRootClients();
            for (IPSEClientUndelMsgs cmsgs : allClients) {
                IndexIterator cmsgIt = cmsgs.getUndelIterator();
                while (cmsgIt.hasNext()) {
                    IPSEUndelMsg msg = (IPSEUndelMsg)cmsgIt.next();
                    long mid = msg.getMessageId();
                    trackingNums.put(mid, new Long(mid));
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return this.debugTrackingNums(DEBUG, trackingNums);
    }

    @Override
    public void updateDeliveryInfoTx(long message_id, long client_id, boolean redelivered, long seqno, Date exp, Date timestamp, int size, boolean fromRemote, boolean persistent, Collection undelSubjectIds) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("updateDeliveryInfoTx starting; cid= " + client_id + " mid= " + message_id);
        }
        this.checkUpdateLock();
        try {
            IPSEUndelMsg undel = this.getUndel(client_id, message_id);
            if (undel != null) {
                undel.setRedelivery(redelivered);
                undel.setSequenceNumber(seqno);
                undel.setFromRemote(fromRemote);
                undel.setPersistent(persistent);
                undel.setUndelSubjectIds(undelSubjectIds);
            } else if (this.isDebugLevel1()) {
                this.debug("UpdateDeliveryInfo: cid/mid not found " + client_id + " " + message_id);
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getJmsRedelivered(long cid, long tracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getJmsRedelivered starting cid= " + cid + ", tracking= " + tracking);
        }
        boolean value = false;
        this.acquireLock(this.m_opCtxRead);
        try {
            IPSEUndelMsg msg = this.getUndel(cid, tracking);
            if (msg == null) {
                throw new EAssertFailure("Assertion failure: undelivered  record not found for CID:" + cid + ", TRK:" + tracking);
            }
            value = msg.getRedelivery();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return false;
    }

    @Override
    public int delUndelMsgsCidTx(long client_id) throws EDatabaseException {
        boolean DEBUG1 = this.isDebugLevel1();
        if (DEBUG1) {
            this.debug("delUndelMsgsCidTx(long client_id) starting; cid= " + client_id);
        }
        int deleted = 0;
        this.checkUpdateLock();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return 0;
            }
            OSTreeSet allClients = this.getRootClients();
            allClients.remove((Object)cmsgs);
            deleted = cmsgs.getUndelCount();
            ObjectStore.destroy((Object)cmsgs);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        if (DEBUG1) {
            this.debug("delUndelMsgsCidTx(long client_id) completed; cid= " + client_id + " ctDeleted= " + deleted);
        }
        return deleted;
    }

    @Override
    public int delUndelMsgsCidTx(long client_id, long messageId, int batchSize) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delUndelMsgsCidTx starting; cid= " + client_id + " trk= " + messageId);
        }
        this.checkUpdateLock();
        int ct = 0;
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return 0;
            }
            ct = cmsgs.deleteUndelLE(messageId, batchSize);
            if (cmsgs.getUndelCount() == 0) {
                this.removeCmsgs(cmsgs);
            } else if (this.checkDebugFlags(64) && batchSize == 0) {
                this.debug("delUndelMsgsCidTx;  completed Deletes; cid= " + client_id + " maxMsgId= " + messageId + " ctRemaining= " + cmsgs.getUndelCount());
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("delUndelMsgsCidTx completed; cid= " + client_id + " trk= " + messageId + " ctDeleted= " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMsgRefCount(long tracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMsgRefCount starting; trk= " + tracking);
        }
        this.acquireLock(this.m_opCtxRead);
        int ct = 0;
        try {
            IPSEMessage msg = this.getRootMessages().get(tracking);
            if (msg != null) {
                ct = msg.getRecipientCount();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongHashTable getMsgRefCount(long minTracking, long maxTracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMsgRefCount starting; mintrk= " + minTracking + " maxTrk= " + maxTracking);
        }
        LongHashTable<Long> ids = new LongHashTable<Long>();
        this.acquireLock(this.m_opCtxRead);
        try {
            IndexIterator it = this.getRootMessages().getIterator(minTracking);
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long id = msg.getMessageId();
                if (id > maxTracking) {
                    break;
                }
                if (!msg.hasRecipients()) continue;
                ids.put(id, new Long(id));
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongHashTable getUndelClientsByMsg(long tracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getUndelClientsByMsg starting; mid= " + tracking);
        }
        LongHashTable<BrokerDatabase.ClientDeliveryInfo> clients = new LongHashTable<BrokerDatabase.ClientDeliveryInfo>();
        this.acquireLock(this.m_opCtxRead);
        try {
            IPSEMessage msg = this.getRootMessages().get(tracking);
            Iterator itr = null;
            if (msg != null && (itr = msg.getRecipients()) != null) {
                long mid = msg.getMessageId();
                while (itr.hasNext()) {
                    Long cidL = (Long)itr.next();
                    long cid = cidL;
                    IPSEUndelMsg undel = this.getUndel(cid, mid);
                    BrokerDatabase.ClientDeliveryInfo info = new BrokerDatabase.ClientDeliveryInfo();
                    info.cid = cid;
                    info.seqno = undel.getSequenceNumber();
                    info.redelivered = undel.getRedelivery();
                    info.messageid = mid;
                    info.expiration = undel.getExpiration();
                    info.timestamp = undel.getTimestamp();
                    info.size = undel.getMessageSize();
                    info.undelSubjectIds = undel.getUndelSubjectIds();
                    clients.put(new Long(info.cid), info);
                }
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return clients;
    }

    @Override
    public LongHashTable getUndelClientsByMsgTx(long tracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getUndelClientsByMsgTx starting; mid= " + tracking);
        }
        LongHashTable<BrokerDatabase.ClientDeliveryInfo> clients = new LongHashTable<BrokerDatabase.ClientDeliveryInfo>();
        this.checkUpdateLock();
        try {
            IPSEMessage msg = this.getRootMessages().get(tracking);
            Iterator itr = null;
            if (msg != null && (itr = msg.getRecipients()) != null) {
                long mid = msg.getMessageId();
                while (itr.hasNext()) {
                    Long cidL = (Long)itr.next();
                    long cid = cidL;
                    IPSEUndelMsg undel = this.getUndel(cid, mid);
                    BrokerDatabase.ClientDeliveryInfo info = new BrokerDatabase.ClientDeliveryInfo();
                    info.cid = cid;
                    info.seqno = undel.getSequenceNumber();
                    info.redelivered = undel.getRedelivery();
                    info.messageid = mid;
                    info.expiration = undel.getExpiration();
                    info.timestamp = undel.getTimestamp();
                    info.size = undel.getMessageSize();
                    info.undelSubjectIds = undel.getUndelSubjectIds();
                    clients.put(new Long(info.cid), info);
                }
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllMessageIDs(long messageId, int count) throws EDatabaseException {
        Vector<Long> message_ids = new Vector<Long>(5, 10);
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("getAllMessageIDs: MessageId is: " + messageId);
        }
        this.acquireLock(this.m_opCtxRead);
        try {
            IndexIterator it = this.getRootMessages().getIterator(messageId >= 0L ? messageId + 1L : -1L);
            int i = 0;
            while (it.hasNext()) {
                it.advance();
                Long x = (Long)it.currentKey();
                message_ids.addElement(new Long(x));
                if (++i != count) continue;
                break;
            }
            if (DEBUG) {
                this.debug("getAllMessageIDs; returning " + i + " messageIds");
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return message_ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getExpMessageIDs(long messageId, int count) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getExpMessageIds starting; mid= " + messageId + ", count= " + count);
        }
        Vector<Long> ids = new Vector<Long>();
        this.acquireLock(this.m_opCtxRead);
        long currentTime = EpochClock.getTime();
        try {
            IndexIterator it = this.getRootMessages().getIterator(messageId >= 0L ? messageId + 1L : -1L);
            int ct = 0;
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                if (msg.isExpired(currentTime)) {
                    ids.addElement(new Long(msg.getMessageId()));
                }
                if (++ct != count) continue;
                break;
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ids;
    }

    @Override
    public int delUndelMsgTrkTx(long tracking) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delUndelMsgTrkTx: id= " + tracking);
        }
        int ct = 0;
        this.checkUpdateLock();
        try {
            IPSEMessage msg = this.getRootMessages().get(tracking);
            if (msg != null && msg.hasRecipients()) {
                ct = this.delUndelMsgsForPSEMessage(msg, null);
                if (DEBUG) {
                    this.debug("delUndelMsgTrkTx; deleted undel message: mid= " + tracking + " ctUndelDeleted= " + ct);
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getMaxIDFromCounters() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMaxIDFromCounters starting;");
        }
        Long result = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            long max = this.getRootCounters().getMessageId();
            result = new Long(max);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return result;
    }

    @Override
    public Long getMaxValueInUndelMsgs() throws EDatabaseException {
        return this.getMaxIDFromCounters();
    }

    @Override
    public int getMessageCount() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMessageCount starting;");
        }
        int ct = 0;
        this.acquireLock(this.m_opCtxRead);
        try {
            ct = this.getRootMessages().getCount();
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerDatabase.SavedMsgStats getMessageCountAndSize(long client_id) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getMessageCountAndSize starting; cid= " + client_id);
        }
        BrokerDatabase.SavedMsgStats stats = new BrokerDatabase.SavedMsgStats();
        this.acquireLock(this.m_opCtxRead);
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs != null) {
                stats.count = cmsgs.getUndelCount();
                stats.size = cmsgs.getTotalSize();
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return stats;
    }

    @Override
    public void updateCountersTx(long seqno, long size, long messageId) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("updateCountersTx starting; seq= " + seqno + " size= " + size + " messageId= " + messageId);
        }
        this.checkUpdateLock();
        try {
            IPSECounters rootCounters = this.getRootCounters();
            rootCounters.setSequenceNumber(seqno);
            rootCounters.setTopicDBSize(size);
            rootCounters.setMessageId(messageId);
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCounters(long seqno, long size, long messageId) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("updateCounters starting; seq= " + seqno + " size= " + size);
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            IPSECounters rootCounters = this.getRootCounters();
            rootCounters.setSequenceNumber(seqno);
            rootCounters.setTopicDBSize(size);
            rootCounters.setMessageId(messageId);
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSeqnoCounter() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getSeqnoCounter starting;");
        }
        this.acquireLock(this.m_opCtxRead);
        long value = 0L;
        try {
            value = this.getRootCounters().getSequenceNumber();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTopicDBSize() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getTopicDBSize starting;");
        }
        this.acquireLock(this.m_opCtxRead);
        long size = 0L;
        try {
            size = this.getRootCounters().getTopicDBSize();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMessageTx(IMgram message, long tracking, long sequence, Date timestamp, String JMSMessageID) throws EDatabaseException, IOException {
        if (this.getDebug()) {
            this.debug("addMessageTx starting; trk= " + tracking + " seq= " + sequence);
        }
        this.checkUpdateLock();
        Date exp = null;
        if (message.isTTE()) {
            exp = new Date(message.getTTE());
        }
        int msgSize = message.getBrokerHandle().getTrackedSize();
        ByteBufferOutputStream t = null;
        IMgram iMgram = message;
        synchronized (iMgram) {
            int serializedSize = msgSize;
            if (message.getBrokerHandle().isTrackedSizeSet()) {
                serializedSize = message.serializedLength();
            }
            try {
                t = new ByteBufferOutputStream(serializedSize);
                MgramSerializer.getMgramSerializer().serialize(t, message, false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            if (this.isDebugLevel1() && serializedSize < t.size()) {
                this.debug("message.serializedLength()= " + msgSize + " ; written to Db " + t.size());
            }
        }
        boolean added = false;
        try {
            added = this.getRootMessages().addMessage(tracking, sequence, msgSize, exp, timestamp, JMSMessageID, t.getBuffer());
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return added;
    }

    @Override
    public boolean addUndelMsgTx(long cid, long tracking, long seqno, boolean redelivered, Date exp, Date timestamp, int size, boolean fromRemoteBroker, boolean persistent, Collection undelSubjectIds) throws EDatabaseException {
        boolean result = false;
        if (this.getDebug()) {
            this.debug("addUndelMsgTx starting; trk= " + tracking + " seq= " + seqno);
        }
        this.checkUpdateLock();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(cid);
            if (cmsgs == null) {
                cmsgs = new PSEClientUndelMsgs2(this.m_dbCtx.getDatabase(), cid);
                OSTreeSet clientStreams = this.getRootClients();
                clientStreams.add((Object)cmsgs);
            }
            IPSEMessage msg = this.getRootMessages().getMessage(tracking, seqno, size, exp, timestamp);
            int msize = msg.getMessageSize();
            if (this.isDebugLevel1() && msize != size) {
                this.debug("addUndelMsgTx; sizeparam= " + size + " realSize= " + msize);
            }
            result = cmsgs.addUndel(tracking, seqno, msize, redelivered, exp, fromRemoteBroker, persistent, undelSubjectIds, msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return result;
    }

    @Override
    public boolean delUndelMsgSubjectCidTx(long client_id, long tracking, short subject_tracking) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delUndelMsgSubjectCidTx, client_id is " + client_id + " tracking is " + tracking + " subject_tracking is " + subject_tracking);
        }
        boolean removed = false;
        this.checkUpdateLock();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return false;
            }
            IPSEUndelMsg undel = cmsgs.getUndelMsg(tracking);
            if (undel == null) {
                return false;
            }
            HashSet undelSIds = undel.getUndelSubjectIds();
            if (undelSIds != null) {
                undelSIds.remove(new Short(subject_tracking));
                if (undelSIds.isEmpty()) {
                    return true;
                }
            } else {
                return true;
            }
            undel.setUndelSubjectIds(undelSIds);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        if (DEBUG) {
            this.debug("delUndelMsgSubjectCidTx, client_id is " + client_id + " tracking is " + tracking + " subject_tracking is " + subject_tracking + " removed= " + removed);
        }
        return false;
    }

    @Override
    public LongHashTable retrieveSubjectAckMappingsTx(long client_id, long highestIndoubt) throws EDatabaseException {
        boolean DEBUG = this.debugGetAllUndelMessageIDs();
        LongHashTable<Long> trackingNums = new LongHashTable<Long>();
        this.checkUpdateLock();
        try {
            IPSEUndelMsg msg;
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return trackingNums;
            }
            IndexIterator cmsgIt = cmsgs.getUndelIterator();
            while (cmsgIt.hasNext() && (msg = (IPSEUndelMsg)cmsgIt.next()).getMessageId() <= highestIndoubt) {
                HashSet sids;
                long mid = msg.getMessageId();
                boolean redel = msg.getRedelivery();
                if (!redel || (sids = msg.getUndelSubjectIds()) == null || sids.isEmpty()) continue;
                Iterator i = sids.iterator();
                while (i.hasNext()) {
                    trackingNums.put(mid + (long)((Short)i.next()).shortValue(), new Long(mid));
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return this.debugTrackingNums(DEBUG, trackingNums);
    }

    private LongHashTable debugTrackingNums(boolean DEBUG, LongHashTable trackingNums) {
        if (DEBUG) {
            this.debug("getAllUndelMessageIDs returning; count= " + trackingNums.size());
        }
        return trackingNums;
    }

    private boolean debugGetAllUndelMessageIDs() {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("getAllUndelMessageIDs starting");
        }
        return DEBUG;
    }

    @Override
    public int delUndelMsgCidTrkTx(long client_id, long tracking) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delUndelMsgCidTrkTx, client_id is " + client_id + " tracking is " + tracking);
        }
        int delcount = 0;
        this.checkUpdateLock();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return 0;
            }
            if (cmsgs.deleteUndel(tracking)) {
                delcount = 1;
            }
            this.removeCMsgs(cmsgs);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        if (DEBUG) {
            this.debug("delUndelMsgCidTrkTx, client_id is " + client_id + " tracking is " + tracking + " delcount= " + delcount);
        }
        return delcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List restoreMsgs(IQueryCancelCheck cancel, long client_id, MsgRestorePos pos, int count, boolean returnMsgBodies, int maxBodySize) throws EDatabaseException, InterruptedIOException, InterruptedException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("restoreMsgs called: Client " + client_id + " tracking= " + pos.getMessageId() + " seq= " + pos.getSeqno() + " count= " + count);
        }
        List c = null;
        this.acquireLock(this.m_opCtxRead, true);
        try {
            cancel.beginDbWork();
            if (cancel.cancelQuery()) {
                if (this.checkDebugFlags(64)) {
                    this.debug("restoreMsgs (IQueryCancelCheck); query cancelled; throwing InterruptedException " + Thread.currentThread().getName());
                }
                throw new InterruptedException();
            }
            c = this.restoreMsgsInternal(cancel, client_id, pos.getMessageId(), pos.getSeqno(), count, returnMsgBodies, maxBodySize);
        }
        finally {
            cancel.endDbWork();
            this.releaseLock(this.m_opCtxRead);
        }
        int ct = PubSubDBQImplPSE.retrieveCt(c);
        if (DEBUG) {
            this.debug("restoreMsgs returning: Client " + client_id + " countReturned= " + ct);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List restoreMsgsForSMODurable(IQueryCancelCheck cancel, long client_id, boolean doRemoteOnly, MsgRestorePos localPos, MsgRestorePos remotePos, int count, boolean returnMsgBodies, int maxBodySize) throws EDatabaseException, InterruptedIOException, InterruptedException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("restoreMsgsForSMODurable called: Client " + client_id + " doRemoteOnly: " + doRemoteOnly + " remoteTracking= " + remotePos.getMessageId() + " remoteSeq= " + remotePos.getSeqno() + " localTracking= " + localPos.getMessageId() + " localSeq= " + localPos.getSeqno() + " count= " + count);
        }
        this.acquireLock(this.m_opCtxRead, true);
        List c = null;
        try {
            cancel.beginDbWork();
            if (cancel.cancelQuery()) {
                if (this.checkDebugFlags(64)) {
                    this.debug("restoreMsgsForSMODurable (IQueryCancelCheck); querey canceled; throwing InterruptedException " + Thread.currentThread().getName());
                }
                throw new InterruptedException();
            }
            c = this.restoreMsgsInternalForSMODurable(cancel, client_id, doRemoteOnly, localPos.getMessageId(), localPos.getSeqno(), remotePos.getMessageId(), remotePos.getSeqno(), count, returnMsgBodies, maxBodySize);
        }
        finally {
            cancel.endDbWork();
            this.releaseLock(this.m_opCtxRead);
        }
        int ct = PubSubDBQImplPSE.retrieveCt(c);
        if (DEBUG) {
            this.debug("restoreMsgsForSMODurable returning: Client " + client_id + " countReturned= " + ct);
        }
        return c;
    }

    private static int retrieveCt(List c) {
        int ct = 0;
        if (c != null) {
            ct = c.size();
        }
        return ct;
    }

    private IPSEClientUndelMsgs getClientUndelMsgs(long cid) {
        Long key = new Long(cid);
        return (IPSEClientUndelMsgs)this.getRootClients().getFromPrimaryIndex((Object)key);
    }

    private OSTreeSet getRootClients() {
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("ClientUndelMsgs"));
    }

    private IPSEMessages getRootMessages() {
        return (IPSEMessages)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("Messages"));
    }

    private IPSECounters getRootCounters() {
        return (IPSECounters)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("Counters"));
    }

    private IPSEUndelMsg getUndel(long cid, long mid) {
        IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(cid);
        if (cmsgs == null) {
            return null;
        }
        IPSEUndelMsg undelmsg = cmsgs.getUndelMsg(mid);
        return undelmsg;
    }

    private Iterator getUndelIterator(long cid, long mid) {
        IndexIterator it = null;
        IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(cid);
        if (cmsgs != null) {
            it = cmsgs.getUndelIterator(mid);
        }
        return it;
    }

    List restoreMsgsInternal(IQueryCancelCheck cancel, long client_id, long tracking, long seq, int count, boolean returnMsgBodies, int maxBodySize) throws EDatabaseException, InterruptedIOException, InterruptedException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("call into restoreMsgs, client_id is" + client_id + " tracking= " + tracking);
        }
        ArrayList<DbUndelMsg> result = new ArrayList<DbUndelMsg>();
        int i = 0;
        try {
            int sk;
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return null;
            }
            this.checkIsCancelQuery(cancel);
            Iterator it = this.m_restoreQueries.getRestoreIterator(cmsgs, tracking, seq, true);
            long lastMid = -1L;
            long lastSeq = -1L;
            int bodySize = 0;
            while (it.hasNext()) {
                this.checkIsCancelQuery(cancel);
                IPSEUndelMsg undel = (IPSEUndelMsg)it.next();
                long thisMid = undel.getMessageId();
                if (this.isDebugLevel1() && i > 0 && thisMid < lastMid) {
                    this.debug("*********** restoreMsgs: Out of order thisMid= " + thisMid + " lastMid= " + lastMid + " thisSeq= " + undel.getSequenceNumber() + " lastSeq= " + lastSeq + " restoreParms: tracking= " + tracking + " seq= " + seq + " nonexpired= true ");
                }
                lastMid = thisMid;
                lastSeq = undel.getSequenceNumber();
                IPSEMessage msg = undel.getMessage();
                IMgram mg = null;
                if (returnMsgBodies && bodySize + undel.getMessageSize() < maxBodySize) {
                    mg = msg.getMgram();
                    msg = null;
                    bodySize += undel.getMessageSize();
                }
                DbUndelMsg umsg = new DbUndelMsg(client_id, undel.getMessageId(), undel.getSequenceNumber(), undel.getMessageSize(), undel.getRedelivery(), undel.getExpiration(), undel.getFromRemoteBroker(), msg, undel.getUndelSubjectIds());
                umsg.setMgram(mg);
                result.add(umsg);
                if (++i != count) continue;
                break;
            }
            if (DEBUG && (sk = ((MsgRestoreQueries.RestoreIterator)it).skipped) > 0) {
                this.debug("restoreMsgsInternal: client_id is" + client_id + " tracking= " + tracking + " seq= " + seq + "count= " + count + " it= " + it.getClass().getName() + " Returning " + i + " skipped " + sk);
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return result;
    }

    List restoreMsgsInternalForSMODurable(IQueryCancelCheck cancel, long client_id, boolean doRemoteOnly, long localTracking, long localSeq, long remoteTracking, long remoteSeq, int count, boolean returnMsgBodies, int maxBodySize) throws EDatabaseException, InterruptedIOException, InterruptedException {
        if (this.getDebug()) {
            this.debug("call into restoreMsgs, client_id is" + client_id);
        }
        ArrayList<DbUndelMsg> result = new ArrayList<DbUndelMsg>();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return null;
            }
            this.checkIsCancelQuery(cancel);
            Iterator it = this.m_restoreQueries.getRestoreIteratorForSMODurable(cmsgs, doRemoteOnly, localTracking, localSeq, remoteTracking, remoteSeq);
            int i = 0;
            long lastMid = -1L;
            long lastSeq = -1L;
            int bodySize = 0;
            while (it.hasNext()) {
                this.checkIsCancelQuery(cancel);
                IPSEUndelMsg undel = (IPSEUndelMsg)it.next();
                long thisMid = undel.getMessageId();
                long thisSeq = undel.getSequenceNumber();
                if (this.isDebugLevel1() && i > 0 && thisMid < lastMid) {
                    this.debug("*********** restoreMsgsforSMO: Out of order thisMid= " + thisMid + " lastMid= " + lastMid + " thisSeq= " + thisSeq + " lastSeq= " + lastSeq + " restoreParms: doRemoteOnly= " + doRemoteOnly + " localtracking= " + localTracking + " localseq= " + localSeq + " remotetracking= " + remoteTracking + " remoteseq= " + remoteSeq);
                }
                lastMid = thisMid;
                lastSeq = thisSeq;
                IPSEMessage msg = undel.getMessage();
                IMgram mg = null;
                if (returnMsgBodies && bodySize + undel.getMessageSize() < maxBodySize) {
                    mg = msg.getMgram();
                    msg = null;
                    bodySize += undel.getMessageSize();
                }
                DbUndelMsg umsg = new DbUndelMsg(client_id, undel.getMessageId(), undel.getSequenceNumber(), undel.getMessageSize(), undel.getRedelivery(), undel.getExpiration(), undel.getFromRemoteBroker(), msg, undel.getUndelSubjectIds());
                umsg.setMgram(mg);
                result.add(umsg);
                if (++i != count) continue;
                break;
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return result;
    }

    private void checkIsCancelQuery(IQueryCancelCheck cancel) throws InterruptedException {
        if (cancel.cancelQuery()) {
            throw new InterruptedException();
        }
    }

    @Override
    public IMgram getOffloadedMgram(long tracking, long clientId) throws EDatabaseException, InterruptedIOException {
        HashSet undelSubjects;
        boolean DEBUG = this.getDebug();
        IMgram m = this.retrieveMgram(DEBUG, tracking);
        if (m != null && m.hasSubject() && m.getSubject().isMultiSubject() && (undelSubjects = this.getUndeliveredSubjects(clientId, tracking)) != null) {
            m.getBrokerHandle().addSubjectFilter(clientId, new TrackedSubjectFilter(undelSubjects));
        }
        return this.debugAndRetrieveIMgram(DEBUG, m, tracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getUndeliveredSubjects(long clientId, long msgId) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("getUndeliveredSubjects starting cid= " + clientId + ", tracking= " + msgId);
        }
        this.acquireLock(this.m_opCtxRead);
        try {
            IPSEUndelMsg msg = this.getUndel(clientId, msgId);
            if (msg != null) {
                HashSet hashSet = msg.getUndelSubjectIds();
                return hashSet;
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return null;
    }

    @Override
    public IMgram getMgram(long message_id) throws EDatabaseException, InterruptedIOException {
        boolean DEBUG = this.getDebug();
        IMgram m = this.retrieveMgram(DEBUG, message_id);
        return this.debugAndRetrieveIMgram(DEBUG, m, message_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMgram retrieveMgram(boolean DEBUG, long message_id) throws EDatabaseException {
        if (DEBUG) {
            this.debug("getMgram: MessageId is: " + message_id);
        }
        IMgram m = null;
        this.acquireLock(this.m_opCtxDirtyRead);
        try {
            m = this.getMgramInternal(message_id);
        }
        finally {
            this.releaseLock(this.m_opCtxDirtyRead);
        }
        return m;
    }

    private IMgram debugAndRetrieveIMgram(boolean DEBUG, IMgram m, long tracking) {
        if (DEBUG && m == null) {
            this.debug("getMgram: MessageId is: " + tracking + " returning null");
        }
        return m;
    }

    @Override
    public IMgram getMgramTx(long message_id) throws EDatabaseException, InterruptedIOException {
        if (this.getDebug()) {
            this.debug("getMgramTx: MessageId is: " + message_id);
        }
        IMgram m = null;
        this.checkUpdateLock();
        m = this.getMgramInternal(message_id);
        return m;
    }

    private IMgram getMgramInternal(long message_id) throws EDatabaseException {
        IMgram m = null;
        try {
            IPSEMessage msg = this.getRootMessages().get(message_id);
            if (msg != null) {
                m = msg.getMgram();
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram getMgram(IQueryCancelCheck cancel, IDbRef ref) throws EDatabaseException, InterruptedException, InterruptedIOException {
        IMgram mg;
        boolean DEBUG1;
        block10: {
            DEBUG1 = this.isDebugLevel1();
            mg = null;
            this.acquireLock(this.m_opCtxDirtyRead, true);
            long mid = -1L;
            try {
                cancel.beginDbWork();
                if (cancel.cancelQuery()) {
                    if (this.checkDebugFlags(64)) {
                        this.debug("getMgram (IQueryCancelCheck, IdbRef); query canceled; throwing InterruptedException " + Thread.currentThread().getName());
                    }
                    throw new InterruptedException();
                }
                if (ref instanceof IPSEMessage) {
                    IPSEMessage msg = (IPSEMessage)ref;
                    mg = msg.getMgram();
                    break block10;
                }
                throw new EAssertFailure("getMgram (ref) -- unknown ref type " + ref.getClass().getName());
            }
            catch (ObjectStoreException ex) {
                if (DEBUG1) {
                    ex.printStackTrace();
                }
                this.m_dbCtx.handlePSEException(ex);
            }
            finally {
                cancel.endDbWork();
                this.releaseLock(this.m_opCtxDirtyRead);
            }
        }
        if (DEBUG1 && mg == null) {
            this.debug("*****************getMgram (dbref): returning null");
        }
        return mg;
    }

    @Override
    public IMgram getMgramTx(IDbRef ref) throws EDatabaseException, InterruptedIOException {
        IMgram mg = null;
        this.checkUpdateLock();
        if (ref instanceof IPSEMessage) {
            IPSEMessage msg = (IPSEMessage)ref;
            if (this.getDebug()) {
                this.debug("getMgramTx (ref) : MessageId is: " + msg.getMessageId());
            }
            try {
                mg = msg.getMgram();
            }
            catch (ObjectStoreException ex) {
                this.m_dbCtx.handlePSEException(ex);
            }
        } else {
            throw new EAssertFailure("getMgramTx (ref) -- unknown ref type " + ref.getClass().getName());
        }
        return mg;
    }

    @Override
    public void updateRedeliveryTx(long message_id, long client_id, boolean redelivered) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("updateRedeliveryTx: Setting Redelivery_Flag for Client " + client_id + " MessageId is: " + message_id);
        }
        this.checkUpdateLock();
        int ct = this.updateRedeliveryInternal(message_id, client_id, redelivered);
        if (DEBUG) {
            this.debug("executed updateRedelivery, row count is: " + ct);
        }
    }

    private int updateRedeliveryInternal(long message_id, long client_id, boolean redelivered) throws EDatabaseException {
        int result = 0;
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return 0;
            }
            IPSEUndelMsg undel = cmsgs.getUndelMsg(message_id);
            if (undel != null) {
                undel.setRedelivery(redelivered);
                result = 1;
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return result;
    }

    public long expireUndelBatchTx(long strt, long end, int count, IDbUndelMsgDeleteListener listener) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("expireUndelBatchTx: strt= " + strt + "; end= " + end + "; count= " + count);
        }
        this.checkUpdateLock();
        long lastId = -1L;
        try {
            IndexIterator it = this.getRootMessages().getIterator(strt >= 0L ? strt : -1L);
            int i = 0;
            int numDeleted = 0;
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long currentId = msg.getMessageId();
                if (end > -1L && currentId > end) break;
                if (msg.isExpired(EpochClock.getTime()) && msg.hasRecipients()) {
                    int deleted = this.delUndelMsgsForPSEMessage(msg, listener);
                    numDeleted += deleted;
                }
                lastId = currentId;
                if (++i != count) continue;
                break;
            }
            if (DEBUG) {
                this.debug("expireUndelBatchTx; MsgsProcessed= " + i + "; undelMsgsDeleted= " + numDeleted + " lastIdProcessed= " + lastId);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return lastId;
    }

    @Override
    public long[] expireAndCleanMsgsBatchTx(long strt, long end, int count, long maxsize, IDbUndelMsgDeleteListener undelListener, IDbMsgDeleteListener msgListener) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("expireAndCleanMsgsBatchTx: strt= " + strt + "; end= " + end + "; count= " + count + " maxsize= " + maxsize);
        }
        this.checkUpdateLock();
        long[] result = new long[3];
        long lastId = -1L;
        int i = 0;
        boolean quit = false;
        try {
            IndexIterator it = this.getRootMessages().getIterator(strt);
            int numUndelDeleted = 0;
            int numMsgDeleted = 0;
            long delSize = 0L;
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long currentId = msg.getMessageId();
                if (end > -1L && currentId > end) break;
                boolean deleteMsg = msg.isExpired(EpochClock.getTime());
                if (!deleteMsg && Config.FLOW_TO_DISK_DISCARDABLE) {
                    deleteMsg = msg.getMgram().isDiscardable();
                }
                if (deleteMsg && msg.hasRecipients()) {
                    int numRecips = msg.getRecipientCount();
                    int deleted = this.delUndelMsgsForPSEMessage(msg, undelListener);
                    numUndelDeleted += deleted;
                    if (deleted != numRecips) {
                        if (SessionConfig.DBCLEANER_ASSERTION_RECOVERY) {
                            if (deleted > 0) {
                                SessionConfig.logMessage("expireAndCleanMsgsBatchTx: Msg " + currentId + " deleted != numRecips; numRecips= " + numRecips + " deleted= " + deleted + " - attempting to recover (phase 1)", SessionConfig.WARNING);
                            } else {
                                SessionConfig.logMessage("expireAndCleanMsgsBatchTx: Msg " + currentId + " deleted != numRecips; numRecips= " + numRecips + " deleted= " + deleted + " - attempting to recover (phase 2)", SessionConfig.WARNING);
                                msg.removeAllRecipients();
                            }
                        } else {
                            throw new EAssertFailure("Msg " + currentId + " deleted != numRecips; numRecips= " + numRecips + " deleted= " + deleted);
                        }
                    }
                }
                if (!msg.hasRecipients()) {
                    try {
                        this.getRootMessages().removingMsg(msg);
                    }
                    catch (Exception ex) {
                        if (this.isDebugLevel1()) {
                            this.debug("Exception removing Message from JMSMessageId index; id= " + currentId + " jmsId= " + msg.getJMSMessageId(), ex);
                            ex.printStackTrace();
                        }
                        quit = true;
                    }
                    if (!quit) {
                        int msize = msg.getMessageSize();
                        it.remove();
                        if (msgListener != null) {
                            msgListener.onMsgDelete(currentId, msize);
                        }
                        ObjectStore.destroy((Object)msg);
                        ++numMsgDeleted;
                        delSize += (long)msize;
                    }
                }
                lastId = currentId;
                if (delSize <= maxsize && ++i != count && !quit) continue;
                break;
            }
            if (DEBUG) {
                this.debug("expireAndCleanMsgsBatchTx; MsgsProcessed= " + i + "; undelMsgsDeleted= " + numUndelDeleted + "; MsgsDeleted= " + numMsgDeleted + "; delSize= " + delSize + "; lastIdProcessed= " + lastId);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        result[0] = i;
        result[1] = lastId;
        if (quit) {
            result[2] = 1L;
        }
        return result;
    }

    public long cleanMsgsBatchTx(long strt, long end, int count, IDbMsgDeleteListener listener) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("cleanMsgsBatchTx: strt= " + strt + "; end= " + end + "; count= " + count);
        }
        this.checkUpdateLock();
        long lastId = -1L;
        try {
            IndexIterator it = this.getRootMessages().getIterator(strt);
            int i = 0;
            int numDeleted = 0;
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long currentId = msg.getMessageId();
                if (end > -1L && currentId > end) break;
                if (!msg.hasRecipients()) {
                    int size = msg.getMessageSize();
                    this.getRootMessages().removingMsg(msg);
                    it.remove();
                    listener.onMsgDelete(currentId, size);
                    ObjectStore.destroy((Object)msg);
                    ++numDeleted;
                }
                lastId = currentId;
                if (++i != count) continue;
                break;
            }
            if (DEBUG) {
                this.debug("cleanMsgsBatchTx; MsgsProcessed= " + i + "; MsgsDeleted= " + numDeleted + " lastIdProcessed= " + lastId);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return lastId;
    }

    @Override
    public int getMessageSizeTx(long tracking) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("getMessageSizeTx: id= " + tracking);
        }
        this.checkUpdateLock();
        int size = 0;
        try {
            IPSEMessage msg = this.getRootMessages().get(tracking);
            if (msg != null) {
                size = msg.getMessageSize();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG) {
            this.debug("getMessageSizeTx returning: id= " + tracking + " size= " + size);
        }
        return size;
    }

    @Override
    public boolean delMessageTx(long tracking) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("delMessageTx: id= " + tracking);
        }
        this.checkUpdateLock();
        boolean deleted = false;
        try {
            deleted = this.getRootMessages().deleteIfNoRecips(tracking);
            if (deleted && DEBUG) {
                this.debug("delMessageTx; deleted message: id= " + tracking);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getUndelExpIdsBatch(long minTracking, long maxTracking) throws EDatabaseException {
        Vector<Long> result = new Vector<Long>(5, 10);
        this.acquireLock(this.m_opCtxRead);
        try {
            if (this.getDebug()) {
                this.debug("call into getUndelExpIdsBatch, mintracking is" + minTracking + " maxTracking " + maxTracking);
            }
            IndexIterator it = this.getRootMessages().getIterator(minTracking);
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long currentId = msg.getMessageId();
                if (currentId > maxTracking) {
                    break;
                }
                if (!msg.isExpired(EpochClock.getTime()) || !msg.hasRecipients()) continue;
                result.addElement(new Long(currentId));
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerDatabase.MessageIDClientDeliveryInfo getUndelExpCIdsBatch(long minTracking, long maxTracking) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("call into getUndelExpCIdsBatch, mintracking is" + minTracking + " maxTracking " + maxTracking);
        }
        BrokerDatabase.MessageIDClientDeliveryInfo cdiResult = new BrokerDatabase.MessageIDClientDeliveryInfo();
        this.acquireLock(this.m_opCtxRead);
        try {
            IndexIterator it = this.getRootMessages().getIterator(minTracking);
            while (it.hasNext()) {
                IPSEMessage msg = (IPSEMessage)it.next();
                long currentId = msg.getMessageId();
                if (currentId > maxTracking) {
                    break;
                }
                if (!msg.isExpired(EpochClock.getTime()) || !msg.hasRecipients()) continue;
                Iterator itr = msg.getRecipients();
                while (itr.hasNext()) {
                    Long cidL = (Long)itr.next();
                    long cid = cidL;
                    IPSEUndelMsg undelmsg = this.getUndel(cid, currentId);
                    BrokerDatabase.ClientDeliveryInfo info = PubSubDBQImplPSE.initInfo(cid, currentId, undelmsg);
                    cdiResult.addAssociation(new Long(currentId), info);
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return cdiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllUndelClients() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getAllUndelClients");
        }
        Vector<Long> allUndelClients = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            OSTreeSet allClients = this.getRootClients();
            if (!allClients.isEmpty()) {
                Iterator clientIt = allClients.iterator();
                allUndelClients = new Vector<Long>(allClients.size());
                while (clientIt.hasNext()) {
                    IPSEClientUndelMsgs cmsgs = (IPSEClientUndelMsgs)clientIt.next();
                    allUndelClients.add(new Long(cmsgs.getClientId()));
                }
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getAllUndelClients");
        }
        return allUndelClients;
    }

    private int delUndelMsgsForPSEMessage(IPSEMessage msg, IDbUndelMsgDeleteListener undelListener) throws EDatabaseException {
        int numDeleted = 0;
        try {
            if (msg.hasRecipients()) {
                long[] cids = msg.getRecipsArray();
                for (int i = 0; i < cids.length; ++i) {
                    int deleted = this.delUndelMsgCidTrkTx(cids[i], msg.getMessageId());
                    if (deleted > 0 && undelListener != null) {
                        undelListener.onUndelMsgDelete(cids[i], msg.getMessageId(), msg.getMessageSize());
                    }
                    numDeleted += deleted;
                }
            }
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return numDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mgamExistsTx(long tracking) throws EDatabaseException, IOException {
        if (this.getDebug()) {
            this.debug("mgamExistsTx " + tracking + " starting;");
        }
        boolean exists = false;
        this.checkUpdateLock();
        try {
            exists = this.getRootMessages().messageExists(tracking);
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSyncUndelMessagesTx(long lotracking, long hitracking, int fixedSize, int maxSize) throws EDatabaseException, InterruptedIOException {
        if (this.getDebug()) {
            this.debug("getUndelMessagesTx starting; lotracking= " + lotracking + ", hitracking= " + hitracking + ", fixedSize= " + fixedSize + ", maxSize= " + maxSize);
        }
        this.checkUpdateLock();
        ArrayList<BrokerDatabase.ClientDeliveryInfo> al = new ArrayList<BrokerDatabase.ClientDeliveryInfo>();
        BrokerDatabase.MessageIDClientDeliveryInfo cdiResult = new BrokerDatabase.MessageIDClientDeliveryInfo();
        int size = 0;
        try {
            IPSEMessage msg;
            long currentId;
            IndexIterator it = this.getRootMessages().getIterator(lotracking);
            while (it.hasNext() && size < maxSize && (currentId = (msg = (IPSEMessage)it.next()).getMessageId()) <= hitracking) {
                if (!msg.hasRecipients()) continue;
                Iterator itr = msg.getRecipients();
                while (itr.hasNext()) {
                    Long cidL = (Long)itr.next();
                    long cid = cidL;
                    IPSEUndelMsg undelmsg = this.getUndel(cid, currentId);
                    if (!undelmsg.getPersistent()) continue;
                    BrokerDatabase.ClientDeliveryInfo info = PubSubDBQImplPSE.initInfo(cid, currentId, undelmsg);
                    info.fromRemote = undelmsg.getFromRemoteBroker();
                    info.persistent = undelmsg.getPersistent();
                    info.undelSubjectIds = undelmsg.getUndelSubjectIds();
                    size += fixedSize;
                    if (info.undelSubjectIds != null) {
                        size += info.undelSubjectIds.size() * 2;
                    }
                    al.add(info);
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        return al;
    }

    private static BrokerDatabase.ClientDeliveryInfo initInfo(long cid, long currentId, IPSEUndelMsg undelmsg) {
        BrokerDatabase.ClientDeliveryInfo info = new BrokerDatabase.ClientDeliveryInfo();
        info.cid = cid;
        info.messageid = currentId;
        info.seqno = undelmsg.getSequenceNumber();
        info.redelivered = undelmsg.getRedelivery();
        info.size = undelmsg.getMessageSize();
        info.expiration = undelmsg.getExpiration();
        info.timestamp = undelmsg.getTimestamp();
        return info;
    }

    @Override
    public int delAllUndelMsgs(int maxTxnSize) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        int uncommitedRecords = 0;
        if (DEBUG1) {
            this.debug("delAllUndelMsgs starting");
        }
        this.checkUpdateLock();
        try {
            IndexIterator iter = this.getRootMessages().getIterator();
            while (iter.hasNext()) {
                IPSEMessage msg = (IPSEMessage)iter.next();
                if ((uncommitedRecords += msg.removeAllRecipients()) < maxTxnSize) continue;
                this.commit();
                uncommitedRecords = 0;
            }
            if (uncommitedRecords > 0) {
                this.commit();
                uncommitedRecords = 0;
            }
            OSTreeSet allClients = this.getRootClients();
            Iterator it = allClients.iterator();
            while (it.hasNext()) {
                IPSEClientUndelMsgs cmsgs = (IPSEClientUndelMsgs)it.next();
                if (DEBUG) {
                    this.debug("delAllUndelMsgs cid= " + cmsgs.getClientId() + " count = " + cmsgs.getUndelCount() + " size= " + cmsgs.getTotalSize());
                }
                uncommitedRecords += cmsgs.deleteUndelAllNoCleanup(maxTxnSize);
                if (cmsgs.getUndelCount() == 0) {
                    it.remove();
                    ObjectStore.destroy((Object)cmsgs);
                }
                if (uncommitedRecords < maxTxnSize) continue;
                return uncommitedRecords;
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG1) {
            this.debug("delAllUndelMsgs completed; deleted " + uncommitedRecords);
        }
        return uncommitedRecords;
    }

    @Override
    public BrokerDatabase.SavedMsgStats trimUndelMsgsCidTx(long client_id, long messageId, int batchSize) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("delUndelMsgsCidTx starting; cid= " + client_id);
        }
        BrokerDatabase.SavedMsgStats stats = new BrokerDatabase.SavedMsgStats();
        this.checkUpdateLock();
        try {
            IPSEClientUndelMsgs cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                stats.count = 0L;
                stats.size = 0L;
                return stats;
            }
            stats.count = cmsgs.getUndelCount();
            stats.size = cmsgs.getTotalSize();
            int ct = cmsgs.deleteUndelLE(messageId, batchSize);
            this.removeCMsgs(cmsgs);
            cmsgs = this.getClientUndelMsgs(client_id);
            if (cmsgs == null) {
                return stats;
            }
            stats.count -= (long)cmsgs.getUndelCount();
            stats.size -= cmsgs.getTotalSize();
        }
        catch (ObjectStoreException ex) {
            this.m_dbCtx.handlePSEException(ex);
        }
        return stats;
    }

    private void removeCMsgs(IPSEClientUndelMsgs cmsgs) {
        if (cmsgs.getUndelCount() == 0) {
            this.removeCmsgs(cmsgs);
        }
    }

    private void removeCmsgs(IPSEClientUndelMsgs cmsgs) {
        OSTreeSet allClients = this.getRootClients();
        allClients.remove((Object)cmsgs);
        ObjectStore.destroy((Object)cmsgs);
    }

    @Override
    public long determineMaxMessageIdForTrimOpTx(long cid, long datetime) throws EDatabaseException {
        long trimDate;
        long maxMessageId = -1L;
        long minMessageId = -1L;
        long maxMessageDate = trimDate = datetime;
        long minMessageDate = trimDate;
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("determineMaxMessageIdForTrimOp starting; cid= " + cid + " datetime = " + trimDate);
        }
        this.checkUpdateLock();
        try {
            IndexIterator maxcheckmsgs;
            IPSEUndelMsg lowest;
            IndexIterator lowermsgs;
            IPSEClientUndelMsgs undelmsgs = this.getClientUndelMsgs(cid);
            if (undelmsgs == null) {
                return -1L;
            }
            maxMessageId = undelmsgs.getMaxMessageId();
            IPSEUndelMsg msg = undelmsgs.getUndelMsg(maxMessageId);
            if (msg != null) {
                if (DEBUG) {
                    this.debug("PubSubDBQImplPSE.determineMaxMessageIdForTrimOp checking max message for user\nmsg.id =  " + msg.getMessageId() + "\nmsg.timestamp = " + msg.getTimestamp().getTime());
                }
                if ((maxMessageDate = msg.getTimestamp().getTime()) <= trimDate) {
                    return maxMessageId;
                }
            }
            if ((lowermsgs = undelmsgs.getUndelIterator()).hasNext() && (lowest = (IPSEUndelMsg)lowermsgs.next()) != null) {
                if (DEBUG) {
                    this.debug("PubSubDBQImplPSE.determineMaxMessageIdForTrimOp checking low message for user\nmsg.id =  " + lowest.getMessageId() + "\nmsg.timestamp = " + lowest.getTimestamp().getTime());
                }
                if (lowest.getTimestamp().getTime() > trimDate) {
                    return -1L;
                }
                minMessageId = lowest.getMessageId();
                minMessageDate = lowest.getTimestamp().getTime();
            }
            while (minMessageId < maxMessageId) {
                IndexIterator testmsgs;
                long testMessageId = (maxMessageId + minMessageId) / 2L;
                if (DEBUG) {
                    this.debug("PubSubDBQImplPSE.determineMaxMessageIdForTrimOp \nmaxMessageId  =  " + maxMessageId + "\nminMessageId = " + minMessageId + "\ntestMessageId = " + testMessageId);
                }
                if (!(testmsgs = undelmsgs.getUndelIterator(testMessageId)).hasNext()) continue;
                IPSEUndelMsg testUndel = (IPSEUndelMsg)testmsgs.next();
                if (testUndel != null) {
                    if (DEBUG) {
                        this.debug("PubSubDBQImplPSE.determineMaxMessageIdForTrimOp \ntestMsg =  " + testUndel.getMessageId() + "\ntestMsg time = " + testUndel.getTimestamp().getTime());
                    }
                    if (testUndel.getMessageId() == minMessageId) {
                        if (DEBUG) {
                            this.debug(" testMsg id = minMessageId, setting maxMessageId to that and ending search");
                        }
                        maxMessageId = minMessageId;
                        break;
                    }
                    if (testUndel.getMessageId() == maxMessageId) {
                        if (DEBUG) {
                            this.debug(" testMsg id = maxMessageId, ending search");
                        }
                        --maxMessageId;
                        break;
                    }
                    if (testUndel.getTimestamp().getTime() <= trimDate) {
                        if (DEBUG) {
                            this.debug(" " + testUndel.getTimestamp().getTime() + " is before ||== " + trimDate + " raising minid ");
                        }
                        minMessageId = testUndel.getMessageId();
                        minMessageDate = testUndel.getTimestamp().getTime();
                        continue;
                    }
                    if (DEBUG) {
                        this.debug(" " + testUndel.getTimestamp().getTime() + " is after " + trimDate + " lowering maxid ");
                    }
                    maxMessageId = testUndel.getMessageId();
                    maxMessageDate = testUndel.getTimestamp().getTime();
                    continue;
                }
                if (!DEBUG) break;
                this.debug("PubSubDBQImplPSE.determineMaxMessageIdForTrimOp testMsg IS NULL");
                break;
            }
            if ((maxcheckmsgs = undelmsgs.getUndelIterator(maxMessageId)).hasNext()) {
                IPSEUndelMsg maxcheck = (IPSEUndelMsg)maxcheckmsgs.next();
                if (maxcheck != null && DEBUG) {
                    this.debug("maxcheck for user\nmsg.id =  " + maxcheck.getMessageId() + "\nmsg.timestamp = " + maxcheck.getTimestamp().getTime() + "\ntrim = " + trimDate);
                }
                if (maxcheck.getTimestamp().getTime() == trimDate) {
                    maxMessageId = maxcheck.getMessageId();
                }
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return maxMessageId;
    }

    private class Logger
    implements ILog {
        DebugObject m_obj;

        private Logger(DebugObject obj) {
            this.m_obj = obj;
        }

        @Override
        public void logln(String s) {
            SessionConfig.logMessage(s, SessionConfig.getLevelInfo());
        }
    }
}

