/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.tools.dbdump.DBCopy;
import com.odi.tools.dbdump.IStopIndicator;
import com.odi.tools.dbdump.LogTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import progress.message.db.EDatabaseException;
import progress.message.zclient.DebugObject;

public class DBCompact
extends DebugObject
implements IStopIndicator {
    private String workingDir;
    private LogTarget logTarget;
    private File orig;
    private File origLog;
    private File newDbFile;
    private File newDbFileLog;
    private File linkFile;
    private File linkTargetDb;
    private File linkTargetLog;
    private String linkContent;
    boolean linkPresent;
    boolean backupPresent;
    boolean originalPresent;
    DBCopy dbc;
    boolean performCopyCleanup = false;
    boolean deleteNew = false;
    boolean copyNew = false;
    CompactState state;
    private boolean stop = false;

    public DBCompact(String workingDir, LogTarget lt) {
        this.workingDir = workingDir;
        this.logTarget = lt;
    }

    public DBCompact() {
    }

    public void setWorkingDir(String workingDirectory) {
        this.workingDir = workingDirectory;
    }

    public void setLogTarget(LogTarget lt) {
        this.logTarget = lt;
    }

    public void restore(String sourceDbFullName, String dbIdent) throws IOException {
        this.computeFileLocations(sourceDbFullName, dbIdent);
        if (this.originalPresent) {
            if (this.linkPresent) {
                this.linkFile.delete();
            }
            return;
        }
        if (!this.backupPresent) {
            return;
        }
        this.restore();
    }

    public void compact(String sourceDbFullName, String dbIdent) throws EDatabaseException {
        Throwable thrown = null;
        try {
            this.computeFileLocations(sourceDbFullName, dbIdent);
            this.state = CompactState.RESTORE;
            if (!this.restore()) {
                this.state = CompactState.DB_COPY_INIT;
                if (this.CALLBACK) {
                    this.callback(this.state.name, this.state.id, new Object[]{this});
                }
                this.initCompactDb();
                this.state = CompactState.DB_COPY;
                if (this.CALLBACK) {
                    this.callback(this.state.name, this.state.id, new Object[]{this});
                }
                this.dbc.copy();
                this.createLinkFile();
                this.state = CompactState.DELETE_ORIG;
                if (this.CALLBACK) {
                    this.callback(this.state.name, this.state.id, new Object[]{this});
                }
                this.deleteOriginal();
                this.state = CompactState.COPY_COMPACT;
                if (this.CALLBACK) {
                    this.callback(this.state.name, this.state.id, new Object[]{this});
                }
                this.renameCompacted();
                this.state = CompactState.CLEANUP;
                if (this.CALLBACK) {
                    this.callback(this.state.name, this.state.id, new Object[]{this});
                }
                this.logTarget.log("result", "deleting link file: " + this.linkFile.getAbsolutePath());
                this.linkFile.delete();
            }
        }
        catch (Throwable t) {
            thrown = t;
        }
        if (thrown != null) {
            String excDescr = this.describeException(thrown);
            this.logTarget.log("result", "caught exception in stage:" + this.state.name + " exception details:" + excDescr);
            switch (this.state.getId()) {
                case 1: {
                    break;
                }
                case 3: {
                    this.logTarget.log("result", "starting deletion of partially compacted files :" + this.newDbFile.getAbsolutePath());
                    this.newDbFile.delete();
                    this.newDbFileLog.delete();
                    this.logTarget.log("result", "deleted partially compacted files");
                }
                case 2: {
                    this.logTarget.log("result", "Starting cleanup of partial copy artifacts");
                    this.dbc.cleanup();
                    this.logTarget.log("result", "done cleanup of partial copy artifacts");
                    break;
                }
                case 4: 
                case 5: {
                    try {
                        this.computeFileLocations(sourceDbFullName, dbIdent);
                        this.restore();
                    }
                    catch (IOException io) {
                        this.logTarget.log("fatal error", "failed in attempts to recover the compacted database from:" + this.newDbFile.getAbsolutePath());
                    }
                    break;
                }
                case 6: {
                    break;
                }
            }
            throw new EDatabaseException("failed to compact at state:'" + this.state.name + "' of:" + dbIdent + " " + excDescr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeFileLocations(String sourceDbFullName, String dbIdent) {
        this.orig = new File(sourceDbFullName);
        this.origLog = new File(sourceDbFullName.replaceAll(".odb$", ".log"));
        this.newDbFile = new File(this.workingDir, dbIdent);
        this.newDbFileLog = new File(this.workingDir, dbIdent.replaceAll(".odb$", ".log"));
        if (this.orig.exists() && this.origLog.exists()) {
            this.originalPresent = true;
        }
        this.linkFile = new File(this.orig.getParent(), dbIdent + "_link");
        if (this.linkFile.exists()) {
            this.linkPresent = true;
            BufferedReader src = null;
            try {
                src = new BufferedReader(new FileReader(this.linkFile));
                this.linkContent = src.readLine();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (src != null) {
                        src.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.linkContent != null) {
                this.linkTargetDb = new File(this.linkContent);
                this.linkTargetLog = new File(this.linkTargetDb.getAbsolutePath().replaceAll(".odb$", ".log"));
                if (this.linkTargetDb.exists() && this.linkTargetLog.exists()) {
                    this.backupPresent = true;
                }
            }
        }
    }

    private void createLinkFile() throws IOException {
        FileWriter writer = new FileWriter(this.linkFile);
        writer.write(this.newDbFile.getAbsolutePath());
        writer.close();
        this.logTarget.log("result", "Created link:" + this.linkFile.getAbsolutePath());
    }

    private boolean restore() throws IOException {
        if (this.originalPresent) {
            if (this.linkPresent) {
                this.linkFile.delete();
            }
            return false;
        }
        if (!this.backupPresent) {
            this.logTarget.log("result", "no backup to restore from, bailing");
            throw new EDatabaseException("No database file, and no backup to restore from");
        }
        boolean ret = false;
        try {
            this.logTarget.log("result", "attempting to restore db from:" + this.linkContent);
            File restoredOrig = this.renameOrMove(this.linkTargetDb, this.orig, true);
            this.logTarget.log("result", "copied :" + this.linkTargetDb.getAbsolutePath() + " to " + (restoredOrig != null ? restoredOrig.getAbsolutePath() : this.orig.getAbsolutePath()));
            File restoredOrigLog = this.renameOrMove(this.linkTargetLog, this.origLog, true);
            this.logTarget.log("result", "copied :" + this.linkTargetLog.getAbsolutePath() + " to " + (restoredOrigLog != null ? restoredOrigLog.getAbsolutePath() : this.origLog.getAbsolutePath()));
            if (restoredOrig != null) {
                this.renameOrMove(restoredOrig, this.orig, false);
                this.logTarget.log("result", "renaming :" + restoredOrig.getAbsolutePath() + " to:" + this.orig.getAbsolutePath());
            }
            if (restoredOrigLog != null) {
                this.renameOrMove(restoredOrigLog, this.origLog, false);
                this.logTarget.log("result", "renaming :" + restoredOrigLog.getAbsolutePath() + " to:" + this.origLog.getAbsolutePath());
            }
            this.logTarget.log("result", "restore successfull");
            this.linkFile.delete();
            this.logTarget.log("result", "deleted link file");
            ret = true;
        }
        catch (IOException e) {
            String excdescr = this.describeException(e);
            this.logTarget.log("fatal error", " while restoring files from:" + this.linkContent + " exception:" + excdescr);
            throw e;
        }
        return ret;
    }

    private String describeException(Throwable thrown) {
        StringBuffer sb = new StringBuffer();
        sb.append(thrown.getClass().getName()).append(":");
        sb.append(thrown.getMessage()).append(" ");
        StackTraceElement[] stack = thrown.getStackTrace();
        if (stack.length > 0) {
            sb.append("at:").append(stack[0].getClassName()).append(".");
            sb.append(stack[0].getMethodName()).append("#").append(stack[0].getLineNumber());
        } else {
            sb.append("no stack info");
        }
        return sb.toString();
    }

    private void deleteOriginal() {
        this.logTarget.log("result", "Deleting original files: " + this.orig.getAbsolutePath());
        this.orig.delete();
        this.origLog.delete();
    }

    private void renameCompacted() throws IOException {
        this.logTarget.log("result", "renaming compacted files to original names");
        File tempNew = null;
        File tempNewLog = null;
        try {
            tempNew = this.renameOrMove(this.newDbFile, this.orig, true);
            tempNewLog = this.renameOrMove(this.newDbFileLog, this.origLog, true);
        }
        catch (IOException ioe) {
            if (tempNew != null && tempNew.exists()) {
                tempNew.delete();
            }
            if (tempNewLog != null && tempNewLog.exists()) {
                tempNewLog.delete();
            }
            this.logTarget.log("result", "renaming failed");
            throw ioe;
        }
        this.logTarget.log("result", "renaming successful");
    }

    private void initCompactDb() {
        this.logTarget.log("result", "starting compaction to: " + this.newDbFile.getAbsolutePath());
        this.dbc = new DBCopy(this.orig.getAbsolutePath(), this.newDbFile.getAbsolutePath(), this.workingDir);
        this.dbc.setLogger(this.logTarget);
        this.dbc.setStopper((IStopIndicator)this);
        this.dbc.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File renameOrMove(File source, File dest, boolean allowCopy) throws IOException {
        boolean renameOk = source.renameTo(dest);
        if (renameOk) {
            return null;
        }
        if (allowCopy) {
            File tempDest = File.createTempFile("compact", "", dest.getParentFile());
            FileChannel sourceChannel = new FileInputStream(source).getChannel();
            FileChannel destinationChannel = new FileOutputStream(tempDest).getChannel();
            try {
                sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                boolean result = tempDest.renameTo(dest);
                if (!result) {
                    throw new IOException("could not rename temporary file in-place from:" + tempDest.getAbsoluteFile() + " to:" + dest.getAbsoluteFile());
                }
                source.delete();
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destinationChannel != null) {
                    destinationChannel.close();
                }
            }
            return tempDest;
        }
        throw new IOException("Could not rename the file(" + source.getAbsolutePath() + ", and not allowed to copy it");
    }

    private void debugThrow() {
        boolean throwMe = false;
        if (throwMe) {
            throw new RuntimeException("Test restore..", null);
        }
    }

    private static LogTarget getDefaultLogTarget() {
        LogTarget lt = new LogTarget(){

            public void log(String type, String message) {
                System.out.println(type + ":" + message);
            }
        };
        return lt;
    }

    public static void main(String[] args) throws EDatabaseException {
        String fullDbName = null;
        String dbFileName = null;
        if (args.length < 1) {
            System.out.println("Must specify db name");
            return;
        }
        fullDbName = args[0];
        File f = new File(fullDbName);
        dbFileName = f.getName();
        LogTarget lt = DBCompact.getDefaultLogTarget();
        DBCompact dbc = new DBCompact(".", lt);
        dbc.compact(fullDbName, dbFileName);
    }

    public boolean shouldStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
    }

    static class CompactState {
        String name;
        int id;
        public static final int RESTORE_ID = 1;
        public static final CompactState RESTORE = new CompactState("restore", 1);
        public static final int DB_COPY_INIT_ID = 2;
        public static final CompactState DB_COPY_INIT = new CompactState("db copy init", 2);
        public static final int DB_COPY_ID = 3;
        public static final CompactState DB_COPY = new CompactState("db copy in progress", 3);
        public static final int DELETE_ORIG_ID = 4;
        public static final CompactState DELETE_ORIG = new CompactState("deleting original files", 4);
        public static final int COPY_COMPACT_ID = 5;
        public static final CompactState COPY_COMPACT = new CompactState("copying compacted files", 5);
        public static final int CLEANUP_ID = 6;
        public static final CompactState CLEANUP = new CompactState("cleaning up", 6);

        CompactState(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

