/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.ptp;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import progress.message.dbsc.pse.pc.PSEByteArrayWrapper;
import progress.message.dbsc.pse.pc.ptp.PSEQueue;

public class PSEQMessage
implements IPersistent,
IPersistentHooks {
    private long _MessageId;
    private long _Expiration;
    private int _MsgSize;
    private int _Priority;
    private boolean _Persistent;
    private boolean _Redelivery;
    private PSEQueue _Queue;
    private PSEByteArrayWrapper _MessageBody;
    protected transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSEQMessage.getClassInfoInstance();

    public PSEQMessage(long id, long expiration, int size, int priority, boolean persistent, boolean redelivery, PSEQueue queue, byte[] body) {
        this._MessageId = id;
        this._Expiration = expiration;
        this._MsgSize = size;
        this._Priority = priority;
        this._Persistent = persistent;
        this._Redelivery = redelivery;
        this._Queue = queue;
        this._MessageBody = new PSEByteArrayWrapper(body);
    }

    public long getMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageId;
    }

    public long getExpiration() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Expiration;
    }

    public int getMsgSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MsgSize;
    }

    public int getPriority() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Priority;
    }

    public boolean getPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Persistent;
    }

    public boolean getRedelivery() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Redelivery;
    }

    public PSEQueue getQueue() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Queue;
    }

    public byte[] getMessageBody() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageBody.getBytes();
    }

    public void preFlushContents() {
        if (!ObjectStore.isPersistent((Object)this)) {
            return;
        }
        if (this._MessageBody != null) {
            if (!ObjectStore.isPersistent((Object)this._MessageBody)) {
                ObjectStore.migrate((Object)this._MessageBody, (Placement)Database.of((Object)this), (boolean)false);
            }
            ObjectStore.evict((Object)this._MessageBody, (int)2);
        }
    }

    public void preDestroyPersistent() {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        ObjectStore.destroy((Object)this._MessageBody);
        this._MessageBody = null;
        this._Queue = null;
    }

    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEQMessage: ");
        buf.append("\tMid: " + this.getMessageId());
        buf.append("\tExp: " + this.getExpiration());
        buf.append("\tSize: " + this.getMsgSize());
        buf.append("\tPrio: " + this.getPriority());
        buf.append("\tPers: " + this.getPersistent());
        buf.append("\tRed: " + this.getRedelivery());
        return buf.toString();
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEQMessage)super.clone()).ODIref = null;
        ((PSEQMessage)super.clone()).ODIObjectState = 0;
        return (PSEQMessage)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._MessageId = genericObject.getLongField(1, classInfo);
        this._Expiration = genericObject.getLongField(2, classInfo);
        this._MsgSize = genericObject.getIntField(3, classInfo);
        this._Priority = genericObject.getIntField(4, classInfo);
        this._Persistent = genericObject.getBooleanField(5, classInfo);
        this._Redelivery = genericObject.getBooleanField(6, classInfo);
        this._Queue = (PSEQueue)genericObject.getClassField(7, classInfo);
        this._MessageBody = (PSEByteArrayWrapper)genericObject.getClassField(8, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this._MessageId, classInfo);
        genericObject.setLongField(2, this._Expiration, classInfo);
        genericObject.setIntField(3, this._MsgSize, classInfo);
        genericObject.setIntField(4, this._Priority, classInfo);
        genericObject.setBooleanField(5, this._Persistent, classInfo);
        genericObject.setBooleanField(6, this._Redelivery, classInfo);
        genericObject.setClassField(7, (Object)this._Queue, classInfo);
        genericObject.setClassField(8, (Object)this._MessageBody, classInfo);
    }

    public void clearContents() {
        this._MessageId = 0L;
        this._Expiration = 0L;
        this._MsgSize = 0;
        this._Priority = 0;
        this._Persistent = false;
        this._Redelivery = false;
        this._Queue = null;
        this._MessageBody = null;
    }

    public PSEQMessage(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEQMessage.class);
    }
}

