/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.client.Credentials;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENotConnected;
import progress.message.ft.ConnectionManager;
import progress.message.ft.FailoverConfig;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationSessionContext;
import progress.message.ft.TempMessageHandler;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.ProgressSecureRandom;

final class ReplicationConnect
extends Connection {
    private static final String PARAMETER_ABSENT = ReplicationConnect.class.getName() + " - parameter absent in message: ";
    private byte m_mark;
    private ConnectionManager m_connMgr = null;
    private ReplicationChannel m_channel = null;
    private boolean DEBUG1 = false;

    ReplicationConnect(ReplicationChannel channel, ConnectionManager cm) throws EGeneralException {
        super("FailoverBroker connect", new Credentials(Config.BROKER_NAME, Config.BROKER_PWD), new TempMessageHandler());
        this.m_connMgr = cm;
        this.m_channel = channel;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("ReplicationConnect " + this.m_channel.getName());
        }
        this.DEBUG1 = this.checkDebugFlags(64);
        Hashtable properties = new Hashtable();
        Config.getConnectionProperties(properties);
        this.setProperties(properties);
        ReplicationChannel.setConnectionProperties(properties);
        this.setStandbyBrokerConnectAllowed(true);
        super.setSocketConnectTimeout(Config.FT_CONNECT_TIMEOUT);
        super.setConnectTimeout((int)Config.FT_CONNECT_TIMEOUT);
    }

    @Override
    public String toString() {
        return "ReplicationConnect " + this.m_connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseListener(long token) throws ENotConnected, InterruptedException {
        if (this.DEBUG) {
            this.debug("ReplicationConnect: Pause Listening, token = " + token);
        }
        IMgram request = this.m_connMgr.buildInitConvertRequest(this.getChannel(), token);
        ReplicationConnect replicationConnect = this;
        synchronized (replicationConnect) {
            if (this.m_mark == -1) {
                throw new ENotConnected();
            }
            this.m_mark = 1;
        }
        if (this.DEBUG) {
            this.debug("sending mgram of type " + request.getType() + ", length of request is " + request.networkLength());
        }
        this.getSender().send(request);
        if (this.DEBUG) {
            this.debug("sent FT_CONVERT mgram to initiate passive convert on the paired FT broker");
        }
        replicationConnect = this;
        synchronized (replicationConnect) {
            while (this.m_mark == 1) {
                this.wait();
            }
            if (this.m_mark == -1) {
                throw new ENotConnected();
            }
        }
        if (this.DEBUG) {
            this.debug("ReplicationConnect: ClientListener paused");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pauseIfMark() {
        ReplicationConnect replicationConnect = this;
        synchronized (replicationConnect) {
            if (this.m_mark != 1) {
                return;
            }
            if (this.DEBUG) {
                this.debug("ReplicationConnect: About to pause the listener");
            }
            this.m_mark = (byte)2;
            this.notifyAll();
        }
        Thread.currentThread().stop();
    }

    @Override
    protected synchronized void connDroppedIBHook() {
        if (this.DEBUG) {
            this.debug("ReplicationConnect: connection dropped by " + Thread.currentThread() + ", setting m_mark to -1");
        }
        this.m_mark = (byte)-1;
        this.notifyAll();
    }

    boolean convert() throws EGeneralException {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        long token = 0L;
        String remoteAppID = null;
        String peerURL = null;
        if (this.m_channel == null) {
            return false;
        }
        peerURL = this.m_channel.getRemoteURL();
        try {
            if (this.DEBUG) {
                this.debug("ReplicationConnect: Connecting to " + peerURL + " using id = " + this.m_connMgr.getConnectID());
            }
            this.connect(peerURL);
            if (this.DEBUG1) {
                this.debug("ReplicationConnect.convert: Connected " + peerURL + " partnerSessionVer= " + this.getBrokerSessionVer() + " partnerProductVer= " + this.getPartnerProductVersion());
            }
            Label local = new Label();
            local.setRouteLimit(1);
            Message msg = new Message(FailoverConfig.addPrefix("CONVERT"));
            msg.write((byte)1);
            boolean isLocalActive = this.m_connMgr.getReplicationManager().isAssertingActive() || BrokerStateManager.getBrokerStateManager().isActive() || this.m_connMgr.getReplicationManager().getBrokerState() == 6;
            this.m_connMgr.getReplicationManager().setLocalBrokerRole(isLocalActive);
            msg.writeBoolean(isLocalActive);
            msg.writeInt(this.m_connMgr.getReplicationManager().getRecoveredState());
            msg.writeBoolean(this.m_connMgr.getReplicationManager().hasReceivedConnections());
            msg.writeLong(this.m_connMgr.getReplicationManager().getStandaloneConnectionCount());
            msg.writeLong(this.m_connMgr.getReplicationManager().getFailoverMetricsDifference());
            Message respMsg = this.getDefaultSession().request(new Envelope(msg, local));
            if (this.DEBUG) {
                this.debug("ReplicationConnect: Received reply for the GET_TOKEN convert request");
            }
            try {
                token = respMsg.readLong();
                remoteAppID = this.m_connMgr.setRemoteAppID(respMsg.readInt());
                boolean isPeerActive = respMsg.readBoolean();
                int peerRecoveredState = respMsg.readInt();
                boolean peerHasClientConnected = respMsg.readBoolean();
                long peerConnectionCount = 0L;
                if (respMsg.available() > 0) {
                    peerConnectionCount = respMsg.readLong();
                } else {
                    Config.logMessage(PARAMETER_ABSENT + "peerConnectionCount", 2);
                }
                long peerFailoverMetricsDifference = 0L;
                if (respMsg.available() > 0) {
                    peerFailoverMetricsDifference = respMsg.readLong();
                } else {
                    Config.logMessage(PARAMETER_ABSENT + "peerFailoverMetricsDifference", 2);
                }
                this.m_connMgr.setRemoteBrokerState(isPeerActive, peerRecoveredState, peerHasClientConnected, peerConnectionCount, peerFailoverMetricsDifference);
                this.m_connMgr.validateDirectionOfReplication(this.getBrokerSessionVer(), this.getPartnerProductVersion());
            }
            catch (EBrokerVersionMismatch e) {
                if (this.DEBUG) {
                    this.debug("ReplicationConnect: BrokerVersionMismatch from the paired FT broker : " + e, e);
                }
                this.cleanUp();
                return false;
            }
            catch (EOFException e) {
                if (this.DEBUG) {
                    this.debug("ReplicationConnect: Paired FT broker rejected convert request: no token returned", e);
                }
                this.cleanUp();
                return false;
            }
            catch (IOException e) {
                if (this.DEBUG) {
                    this.debug("ReplicationConnect: Error reading convert reply from the paired FT broker : " + e, e);
                }
                this.cleanUp();
                return false;
            }
            if (this.DEBUG) {
                this.debug("ReplicationConnect: Received token from the paired FT broker, token = " + token);
            }
            this.pauseListener(token);
            if (this.DEBUG) {
                this.debug("ReplicationConnect: Listener paused");
            }
        }
        catch (EGeneralException e) {
            this.cleanUp();
            throw e;
        }
        catch (InterruptedException e) {
            this.cleanUp();
            throw new EInterrupted();
        }
        catch (Exception e) {
            this.cleanUp();
            e.printStackTrace();
        }
        this.getClientSender().kill(true, this.getChannel(), false);
        ClientSecurityContext csc = (ClientSecurityContext)this.getSecurityContext().clone();
        String uid = Config.BROKER_NAME;
        csc.setUidAppid(uid, remoteAppID);
        if (Config.ENABLE_SECURITY) {
            csc.setPrincipal(reg.getSecurityBean().getUser(uid));
            if (csc.getPrincipal() == null) {
                if (this.DEBUG) {
                    this.debug("Conversion stop due to principal is not set in the client security context");
                }
                this.cleanUp();
                return false;
            }
        }
        ReplicationSessionContext sc = new ReplicationSessionContext(token, this.getBrokerSessionVer(), csc, this.getPartnerProductVersion());
        if (!this.m_channel.connect(this.getSocket(), ProgressSecureRandom.theSecureRandom().nextLong(), sc, true)) {
            this.cleanUp();
            return false;
        }
        this.m_state = 1;
        this.cleanUp();
        try {
            reg.connect(this.m_connMgr.getRemoteID(), this.m_connMgr.getConnection(), false);
            this.m_connMgr.activate();
        }
        catch (EClientNotRegistered e) {
            this.m_channel.close();
            throw new ENotConnected();
        }
        catch (EGeneralException e) {
            this.m_channel.close();
            throw new EInterrupted();
        }
        catch (IOException e) {
            this.m_channel.close();
            throw new EInterrupted();
        }
        catch (InterruptedException e) {
            this.m_channel.close();
            throw new EInterrupted();
        }
        this.m_channel.startListener();
        IMgram request = this.m_connMgr.buildFinalConvertRequest(this.getChannel(), token);
        if (this.DEBUG) {
            this.debug("ReplicationConnect: Sending FT_CONVERT mgram to complete passive convert on the paired FT broker");
        }
        try {
            this.m_channel.getAgentSender().sendThrough(request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.m_connMgr.postConnect();
        if (this.DEBUG) {
            this.debug("ReplicationConnect: Connected!!!!!!!!!!!!!!!");
        }
        return true;
    }

    @Override
    public byte selectSessionVer(byte defaultSessionVer, byte ServerSessionVer) {
        return this.m_connMgr.selectSessionVer(defaultSessionVer, ServerSessionVer);
    }
}

