/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import progress.message.net.ssl.CRLCache;
import progress.message.net.ssl.CRLStore;
import progress.message.net.ssl.InvalidCRLStoreParametersException;
import progress.message.net.ssl.LDAPCRLStoreParameters;
import progress.message.net.ssl.prAccessor;
import progress.message.zclient.SessionConfig;

public class LDAPCRLStore
extends CRLStore {
    private static final boolean DEBUG = LDAPCRLStoreParameters.DEBUG;
    public static final String JNDI_LDAP_AUTH_NONE = "none";
    public static final String JNDI_LDAP_AUTH_SIMPLE = "simple";
    public static final String JNDI_LDAP_AUTH_EXTERNAL = "EXTERNAL";
    private LDAPCRLStoreParameters m_primaryConfig = null;
    private LDAPCRLStoreParameters m_backupConfig = null;
    CRLCache m_cache = null;
    boolean m_init = false;

    public void setPrimaryCRLStoreParameters(LDAPCRLStoreParameters storeConfig) {
        if (DEBUG) {
            System.out.println("Primary LDAP config: " + storeConfig);
        }
        this.m_primaryConfig = storeConfig;
    }

    public void setBackupCRLStoreParameters(LDAPCRLStoreParameters storeConfig) {
        if (DEBUG) {
            System.out.println("Backup LDAP config: " + storeConfig);
        }
        this.m_backupConfig = storeConfig;
    }

    @Override
    public void init() throws InvalidCRLStoreParametersException {
        if (this.m_primaryConfig.getAuthType() == 2 && (this.m_primaryConfig.getPrincipal() == null || this.m_primaryConfig.getCredentials() == null)) {
            throw new InvalidCRLStoreParametersException(prAccessor.getString("LDAP_CONFIG_ERROR_NO_USER_PASSWORD") + this.m_primaryConfig.getURL());
        }
        if (this.m_backupConfig != null && this.m_backupConfig.getAuthType() == 2 && (this.m_backupConfig.getPrincipal() == null || this.m_backupConfig.getCredentials() == null)) {
            throw new InvalidCRLStoreParametersException(prAccessor.getString("LDAP_CONFIG_ERROR_NO_USER_PASSWORD") + this.m_backupConfig.getURL());
        }
        try {
            SessionConfig.logMessage(prAccessor.getString("LDAP_SERVER_INFO_CONNECTING") + this.m_primaryConfig.getURL(), SessionConfig.getLevelInfo());
            this.connect();
        }
        catch (NamingException ex) {
            throw new InvalidCRLStoreParametersException(prAccessor.getString("LDAP_SERVERS_UNREACHABLE_ERROR"));
        }
        if (this.m_cache != null) {
            this.m_cache.reset();
        }
    }

    @Override
    public synchronized void cleanup() {
        if (this.m_cache == null) {
            return;
        }
        this.m_cache.reset();
    }

    @Override
    public synchronized void bind(CRLCache cache) {
        this.m_cache = cache;
        if (DEBUG) {
            this.m_cache.setDebug(true);
        }
    }

    @Override
    public byte[] getCRLByIssuer(String issuerName) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public byte[] getCRLByDP(String distributionPoint) {
        if (DEBUG) {
            System.out.println("Retrieving CRL from " + distributionPoint);
        }
        try {
            DirContext ctx = this.connect();
            Attributes attrs = ctx.getAttributes(distributionPoint);
            int size = attrs.size();
            if (DEBUG) {
                System.out.println("Total number of attributes from DirContext.getAttributes(" + distributionPoint + ") = " + size);
                int i = 0;
                NamingEnumeration<String> iter = attrs.getIDs();
                while (iter.hasMore()) {
                    System.out.println("attributes[" + i++ + "]: " + iter.next());
                }
            }
            Attribute crlAttr = null;
            if (size > 0) {
                String attrName = "certificateRevocationList;binary";
                crlAttr = attrs.get(attrName);
                if (crlAttr == null) {
                    if (DEBUG) {
                        System.out.println("CRL attribute \"" + attrName + "\" not found, try again w/o the binary option...");
                    }
                    attrName = "certificateRevocationList";
                    crlAttr = attrs.get(attrName);
                }
                if (crlAttr == null) {
                    if (DEBUG) {
                        System.out.println("Failed to obtain the CRL attribute from " + distributionPoint);
                    }
                    return null;
                }
            }
            if (crlAttr == null) {
                throw new NullPointerException("'crlAttr' is null at " + LDAPCRLStore.class.getName() + ".getCRLByDP(String distributionPoint)");
            }
            byte[] crl = (byte[])crlAttr.get();
            if (DEBUG && crl == null) {
                System.out.println("Empty (null) CRL from " + distributionPoint);
            }
            return crl;
        }
        catch (NamingException ex) {
            if (DEBUG) {
                System.out.println("Failed to retrieve CRL using DN " + distributionPoint + " : " + ex.getMessage());
            }
            return null;
        }
    }

    private DirContext connect() throws NamingException {
        Object ctx = null;
        try {
            return this.connect(this.m_primaryConfig);
        }
        catch (NamingException ex) {
            SessionConfig.logMessage(prAccessor.getString("LDAP_SERVER_INFO_CONNECT_ERROR") + this.m_primaryConfig.getURL(), SessionConfig.getLevelWarning());
            if (this.m_backupConfig == null) {
                throw ex;
            }
            try {
                SessionConfig.logMessage(prAccessor.getString("LDAP_SERVER_INFO_CONNECTING") + this.m_backupConfig.getURL(), SessionConfig.getLevelInfo());
                return this.connect(this.m_backupConfig);
            }
            catch (NamingException ex2) {
                SessionConfig.logMessage(prAccessor.getString("LDAP_SERVER_INFO_CONNECT_ERROR") + this.m_backupConfig.getURL(), SessionConfig.getLevelSevere());
                throw ex2;
            }
        }
    }

    private DirContext connect(LDAPCRLStoreParameters configuration) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", configuration.getURL());
        if (configuration.getProtocol() != null) {
            env.put("java.naming.security.protocol", configuration.getProtocol());
            configuration.populateSSLProperties();
        }
        if (configuration.getAuthType() == 1) {
            env.put("java.naming.security.authentication", JNDI_LDAP_AUTH_NONE);
        } else if (configuration.getAuthType() == 2) {
            env.put("java.naming.security.authentication", JNDI_LDAP_AUTH_SIMPLE);
            env.put("java.naming.security.principal", configuration.getPrincipal());
            env.put("java.naming.security.credentials", configuration.getCredentials());
        } else if (configuration.getAuthType() == 3) {
            env.put("java.naming.security.authentication", JNDI_LDAP_AUTH_EXTERNAL);
        }
        return new InitialDirContext(env);
    }
}

