/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Hashtable;
import progress.message.util.ICompressionFactory;
import progress.message.zclient.SessionConfig;

public final class CompressionFactory {
    private static Hashtable m_factoriesByName = null;

    public static ICompressionFactory getInstance(String implClass) {
        ICompressionFactory cf = null;
        try {
            String className = implClass.trim();
            cf = (ICompressionFactory)m_factoriesByName.get(className);
            if (cf == null) {
                cf = (ICompressionFactory)Class.forName(className).newInstance();
                m_factoriesByName.put(className, cf);
            }
        }
        catch (Exception ex) {
            SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
        }
        return cf;
    }

    static {
        m_factoriesByName = new Hashtable();
        m_factoriesByName.put(SessionConfig.COMPRESSION_FACTORY, CompressionFactory.getInstance(SessionConfig.COMPRESSION_FACTORY));
    }
}

