/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import progress.message.util.EnumList;
import progress.message.util.ISizedEnumeration;
import progress.message.util.ListItem;

public class LongHashTable<V>
extends Dictionary<Long, V>
implements Cloneable,
Serializable {
    private static final int INITIAL_CAPACITY = 101;
    private static final float LOAD_FACTOR = 0.75f;
    private int m_init_capacity;
    private float m_loadfactor;
    private int m_ceiling;
    private int size = 0;
    int m_capacity;
    ListItem<V>[] HTab;
    private ListItem<V> recycle_bin;
    private int recycle_length = 0;

    public LongHashTable() {
        this(101, 0.75f);
    }

    public LongHashTable(int capacity) {
        this(capacity, 0.75f);
    }

    public LongHashTable(int capacity, float loadfactor) {
        this.m_init_capacity = this.m_capacity = this.findPower(capacity);
        this.m_loadfactor = loadfactor;
        this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
        this.HTab = null;
    }

    public synchronized void clear() {
        this.size = 0;
        this.m_capacity = this.m_init_capacity;
        this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
        this.HTab = null;
    }

    public synchronized Object clone() {
        if (this.HTab == null || this.size == 0) {
            return new LongHashTable<V>(this.m_init_capacity, this.m_loadfactor);
        }
        LongHashTable<V> tablecopy = new LongHashTable<V>(this.m_capacity, this.m_loadfactor);
        ListItem[] copy = new ListItem[this.m_capacity];
        for (int i = 0; i < this.m_capacity; ++i) {
            ListItem<V> item = this.HTab[i];
            copy[i] = (ListItem)(item != null ? item.clone() : null);
        }
        tablecopy.HTab = copy;
        tablecopy.size = this.size;
        return tablecopy;
    }

    public synchronized boolean contains(Object obj) {
        if (this.HTab == null) {
            return false;
        }
        for (int i = 0; i < this.m_capacity; ++i) {
            ListItem<V> arrayptr;
            ListItem<V> listptr = arrayptr = this.HTab[i];
            while (listptr != null) {
                if (listptr.data.equals(obj)) {
                    return true;
                }
                listptr = listptr.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public boolean containsKey(int key) {
        return this.containsKey((long)key);
    }

    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKey((Long)key);
        }
        return this.containsKey(key.hashCode());
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return new EnumList(this, false);
    }

    public synchronized ISizedEnumeration<V> elementList() {
        return new EnumList(this, false);
    }

    public synchronized V get(long key) {
        if (this.HTab == null) {
            return null;
        }
        int bucket = (int)((key >>> 32 ^ key) & (long)(this.m_capacity - 1));
        ListItem<V> item = this.HTab[bucket];
        item = this.HTab[bucket];
        while (item != null) {
            if (item.keysMatch(key)) {
                return item.data;
            }
            item = item.next;
        }
        return null;
    }

    public V get(int key) {
        return this.get((long)key);
    }

    @Override
    public V get(Object key) {
        if (key instanceof Long) {
            return this.get((Long)key);
        }
        return this.get(key.hashCode());
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized Enumeration<Long> keys() {
        return new EnumList(this, true);
    }

    public synchronized ISizedEnumeration<Long> keyList() {
        return new EnumList(this, true);
    }

    @Override
    public synchronized V put(long key, V o) {
        if (this.HTab == null) {
            this.HTab = new ListItem[this.m_capacity];
        }
        if (this.size > this.m_ceiling) {
            int last_capacity = this.m_capacity;
            this.m_capacity <<= 1;
            this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
            this.rehash(last_capacity);
            return this.put(key, o);
        }
        int bucket = (int)((key >>> 32 ^ key) & (long)(this.m_capacity - 1));
        ListItem<V> head = this.HTab[bucket];
        if (head == null) {
            this.HTab[bucket] = this.recycleCreate(key, null, o);
            ++this.size;
            return null;
        }
        ListItem<V> item = head;
        while (item != null) {
            if (item.keysMatch(key)) {
                Object ret = item.data;
                item.data = o;
                return ret;
            }
            item = item.next;
        }
        this.HTab[bucket] = this.recycleCreate(key, head, o);
        ++this.size;
        return null;
    }

    @Override
    public V put(int key, V o) {
        return this.put((long)key, o);
    }

    @Override
    public V put(Long key, V o) {
        if (key instanceof Long) {
            return this.put((long)key, o);
        }
        return this.put(key.hashCode(), o);
    }

    public synchronized V remove(long key) {
        if (this.HTab == null) {
            return null;
        }
        if (this.size < this.m_ceiling / 4 && this.size >= this.m_init_capacity << 1) {
            int last_capacity = this.m_capacity;
            this.m_capacity >>= 1;
            this.m_ceiling = (int)((float)this.m_capacity * this.m_loadfactor);
            this.rehash(last_capacity);
            return this.remove(key);
        }
        int bucket = (int)((key >>> 32 ^ key) & (long)(this.m_capacity - 1));
        ListItem<V> prev = null;
        ListItem<V> item = this.HTab[bucket];
        while (item != null) {
            if (item.keysMatch(key)) {
                if (prev == null) {
                    this.HTab[bucket] = item.next;
                } else {
                    prev.next = item.next;
                }
                --this.size;
                Object result = item.data;
                item.data = null;
                item.next = null;
                if (this.recycle_length < this.size / 8) {
                    item.next = this.recycle_bin;
                    this.recycle_bin = item;
                    ++this.recycle_length;
                }
                return result;
            }
            prev = item;
            item = item.next;
        }
        return null;
    }

    public V remove(int key) {
        return this.remove((long)key);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Long) {
            return this.remove((Long)key);
        }
        return this.remove(key.hashCode());
    }

    public final synchronized void view() {
        if (this.HTab != null) {
            for (int i = 0; i < this.m_capacity; ++i) {
                ListItem<V> bucket = this.HTab[i];
                if (bucket == null) continue;
                System.out.print("\nBucket " + i + ":");
                ListItem<V> item = bucket;
                while (item != null) {
                    System.out.print(" " + item.key);
                    item = item.next;
                }
            }
        }
        System.out.println("\nSize = " + this.size + " (" + this.m_capacity + " buckets)");
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    public synchronized String toString() {
        Enumeration<Long> keys = this.keys();
        Enumeration<V> data = this.elements();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(keys.nextElement());
            sb.append("=");
            sb.append(data.nextElement());
        }
        sb.append("}");
        return sb.toString();
    }

    private void rehash(int last_capacity) {
        ListItem<V>[] temp = this.HTab;
        ListItem[] newitems = new ListItem[this.m_capacity];
        this.HTab = newitems;
        for (int i = 0; i < last_capacity; ++i) {
            ListItem<V> item = temp[i];
            while (item != null) {
                ListItem<V> copy = item;
                item = item.next;
                long hkey = copy.key;
                int index = (int)((hkey >>> 32 ^ hkey) & (long)(this.m_capacity - 1));
                copy.next = newitems[index];
                newitems[index] = copy;
            }
        }
    }

    private int findPower(int closeto) {
        int i = 2;
        while ((i *= 2) < closeto) {
        }
        return i;
    }

    private ListItem<V> recycleCreate(long rkey, ListItem<V> rnext, V rdata) {
        if (this.recycle_bin != null) {
            ListItem<V> item = this.recycle_bin;
            this.recycle_bin = this.recycle_bin.next;
            --this.recycle_length;
            item.key = rkey;
            item.next = rnext;
            item.data = rdata;
            return item;
        }
        return new ListItem<V>(rkey, rnext, rdata);
    }
}

