/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.license;

import progress.message.util.license.Random16;

final class LicenseCommon {
    static final int PASSLEN = 9;
    static final int SIZE_LICENSE = 4;
    static final int SIZE_PROD = 2;
    static final int SIZE_COUNT = 2;
    static final int SIZE_CRC = 1;
    static final boolean bTraceEvents = false;

    LicenseCommon() {
    }

    static void _encrypt(byte[] b, Random16 r) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(b[i] ^ r.nextInt() & 0xFF);
        }
    }

    static void _arraycopy(byte[] src, byte[] dst, int pos) {
        int srcPos = 0;
        int dstPos = pos;
        int len = src.length;
        if (len > dst.length) {
            srcPos = pos;
            dstPos = 0;
            len = dst.length;
        }
        System.arraycopy(src, srcPos, dst, dstPos, len);
    }

    static byte _getCRC(byte[] b, byte crcParam) {
        byte crc = crcParam;
        for (int i = b.length - 1; i >= 0; --i) {
            crc = (byte)(crc + b[i] + i);
        }
        return crc;
    }

    static long _fromBytes(byte[] b) {
        long n = 0L;
        for (int i = b.length - 1; i >= 0; --i) {
            int j = b[i] & 0xFF;
            n = (n << 8) + (long)j;
        }
        return n;
    }

    static byte[] _toBytes(long nParam, int len) {
        long n = nParam;
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)(n & 0xFFL);
            n >>>= 8;
        }
        return b;
    }

    static String _toDecString(byte[] b) {
        String s = "";
        if (b == null) {
            return s;
        }
        int len = b.length;
        if (len == 0) {
            return s;
        }
        for (int i = 0; i < len; ++i) {
            s = s + (b[i] & 0xFF);
            if (i >= len - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    static String _toHexString(byte[] b) {
        String s = "";
        if (b == null) {
            return s;
        }
        int len = b.length;
        if (len == 0) {
            return s;
        }
        for (int i = 0; i < len; ++i) {
            int j = b[i] & 0xFF;
            String ch = Integer.toString(j, 16);
            s = j < 16 ? s + "0" + Integer.toString(j, 16) : s + Integer.toString(j, 16);
        }
        return s;
    }

    static int getSeed(String version) throws Exception {
        int len;
        if (version == null) {
            throw new Exception("Version is mandatory");
        }
        for (len = version.length() - 1; len >= 0; --len) {
            if (!Character.isDigit(version.charAt(len))) continue;
            ++len;
            break;
        }
        float f = Float.valueOf(version.substring(0, len)).floatValue();
        return (int)(f * 10.0f);
    }
}

