/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.applet.Applet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.client.Anonymous;
import progress.message.client.Credentials;
import progress.message.client.EAlreadyConnected;
import progress.message.client.EAnonymousConnectionDisallowed;
import progress.message.client.EBrokerFailoverRedirected;
import progress.message.client.EBrokerRedirected;
import progress.message.client.EBrokerStateDiscarded;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.ECredentialInUse;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInauthenticClient;
import progress.message.client.EInterrupted;
import progress.message.client.EInterruptedByFailover;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidCompressionFactory;
import progress.message.client.EInvalidPort;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESessionLimitExceeded;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionFailure;
import progress.message.client.EUnknownBrokerHost;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.EUserAlreadyConnectedPendingReconnect;
import progress.message.msg.IAckHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.MgramFactory;
import progress.message.net.ESocketConnectTimeout;
import progress.message.net.ISocket;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;
import progress.message.net.ProgressSocketFactory;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.AutoVec;
import progress.message.util.CompressionFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.ICompressionFactory;
import progress.message.util.IMetricsListener;
import progress.message.util.LongHashTable;
import progress.message.util.VersionData;
import progress.message.zclient.AcknowledgementListener;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.BrokerURL;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ClientData;
import progress.message.zclient.ClientListener;
import progress.message.zclient.ClientQopCache;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ClientSender;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.ConnectionFailoverStateManager;
import progress.message.zclient.ConnectionInfo;
import progress.message.zclient.DefaultSocketDropHandlerChainFactory;
import progress.message.zclient.DirectedMsgHandler;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.Envelope;
import progress.message.zclient.HandlerIHandlerContainer;
import progress.message.zclient.IErrorCodes;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.IQop;
import progress.message.zclient.IRejectionListener;
import progress.message.zclient.ISocketDropHandlerChainFactory;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Listener;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.MessageSorter;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.Publication;
import progress.message.zclient.ReconnectHelper;
import progress.message.zclient.Request;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.Sender;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SessionSubjectTable;
import progress.message.zclient.SocketDropHandler;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectSpace;
import progress.message.zclient.Subscription;
import progress.message.zclient.SynchronousAck;
import progress.message.zclient.api.IConnection;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.ConnectionSyncData;
import progress.message.zclient.xonce.IConnectionSyncHandler;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IIDRTransport;
import progress.message.zclient.xonce.IRecoveryMutex;

public class Connection
extends BaseConnection
implements IErrorCodes,
IJobResolver,
IMetricsListener,
IConnection {
    static final boolean DEBUG_SECURITY = false;
    private String m_hostPrefix = null;
    protected ClientSecurityContext m_csc;
    protected MessageSorter m_msgSorter;
    protected MessageHandler m_defMsgHandler;
    protected MessageHandler m_dirMsgHandler;
    protected SubjectSpace m_subjects;
    protected String m_clientAddrSubject;
    protected volatile int m_state;
    private volatile Thread m_recoveryThread = null;
    private IRecoveryMutex m_recoveryMutex = null;
    private final Object m_stateMutex = new Object();
    protected boolean m_deliveryStarted = true;
    private long m_pubTrackHiBits;
    private int m_nextPubTracking;
    private final Vector m_handlers;
    protected Session m_defaultSession;
    private final Vector m_sessions;
    private final LongHashTable m_sessionByTid;
    protected Session m_internalSession;
    private String m_appid;
    protected Principal m_principal;
    private int m_errcode;
    private int m_errinfo;
    private Throwable m_error;
    private Throwable m_socketDropCause;
    private final Hashtable m_jobs;
    private final Hashtable m_subscriptions;
    private boolean m_disconnectReplyReceived = false;
    private int m_connectTimeout = 0;
    private boolean m_isAuthenticationSPIEnabled;
    private IHttpProxyConfig m_httpProxyConfig;
    private int m_returnDbLimitExceptions = 0;
    private boolean m_ping = false;
    private boolean m_asyncPing = false;
    private long m_pingInterval = -1L;
    private boolean m_brokerRetainsJMSNonDurableState = false;
    protected ClientQopCache m_qopcache;
    private final ConnectionFailoverStateManager m_connectionFailoverStateManager;
    private ReconnectHelper m_reconnector = null;
    private final Object m_subscriptionMutex;
    private String m_host = null;
    private String m_resolvedHost = null;
    protected String m_hostArg = null;
    private int m_portNum = -1;
    public static final int MAX_CHANNELS = 0x40000000;
    protected AutoVec m_brethren = null;
    private static long s_counter;
    private int m_channel;
    private boolean m_disableFlowControl = false;
    protected SocketDropHandler m_dropHandler = null;
    private ConnectionContext m_context = null;
    private long m_lastSocketId = 0L;
    private Connection m_conZero = null;
    private long m_parentID = -1L;
    private boolean m_enableLoadBalancing = false;
    private boolean m_enableFaultTolerance = false;
    private boolean m_NPReplUpgrade = false;
    private long m_failoverReconnectTimeout = 60000L;
    private long m_initialConnectTimeout = 30000L;
    private long m_txBufferSize = 0L;
    boolean m_standbyBrokerConnectAllowed = false;
    boolean m_disableConnectException = false;
    private boolean m_followRedirect = false;
    private ClientData m_clientData;
    private ClientConnectParms m_clientConnectParms;
    private String m_redirectedHost;
    private String m_routingNodeName = null;
    private ISocketDropHandlerChainFactory m_socketDropHandlerChainFactory;
    private AcknowledgementListener m_ackListener;
    private IIDRTransport m_idrTransport;
    private IConnectionSyncHandler m_connectionSyncHandler;
    private int m_monitorIntervalSecs = -999;
    private short m_ackMode = (short)-1;
    private long m_socketConnectTimeout = 0L;
    private int m_qopCacheSize = 128;
    private IRejectionListener m_rejectionListener = null;
    private int m_maxSendBufferSize = SessionConfig.MAX_SEND_IO_BUFFER_SIZE;
    private int m_maxRcvBufferSize = SessionConfig.MAX_RCV_IO_BUFFER_SIZE;
    private int m_minSendBufferSize = SessionConfig.MIN_SEND_IO_BUFFER_SIZE;
    private int m_minRcvBufferSize = SessionConfig.MIN_RCV_IO_BUFFER_SIZE;
    private int m_initialSendBufferSize = SessionConfig.INITIAL_SEND_IO_BUFFER_SIZE;
    private int m_initialRcvBufferSize = SessionConfig.INITIAL_RCV_IO_BUFFER_SIZE;
    private long m_deliveryCloseTimeout = 0L;
    private boolean m_connDropped = false;
    private VersionData m_partnerProductVersion;
    protected BrokerConnectParms m_brokerConnectParms = null;
    private boolean m_isLGInstrumented = false;
    private int m_downStreamLGNodeType = -1;
    private ICompressionFactory m_compressionFactory = null;
    private IMetricsListener m_metricsListener = null;
    public static final int CONNECTED = 0;
    public static final int UNCONNECTED = 1;
    public static final int UNUSABLE = 2;
    public static final int CONNECTING = 3;
    public static final int DISCONNECTING = 4;
    private Object m_props;
    private ConnectionInfo m_connectionInfo = null;
    private boolean m_allowRecoveryJobs = false;
    private static volatile Connection s_adminConnection;
    private static char[] map;
    IDoubtResolver m_applicationResolver = null;
    private TunnelRequest m_pendingTunnelRequest = null;

    public Hashtable getLocalSubscriptionTable() {
        return this.m_subscriptions;
    }

    public void setConnectTimeout(int timeout) {
        this.m_connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    void setBrokerConnectParms(BrokerConnectParms parms) {
        this.m_brokerConnectParms = parms;
    }

    public final void setAuthenticationSPIEnabled(boolean flag) {
        this.m_isAuthenticationSPIEnabled = flag;
    }

    final boolean isAuthenticationSPIEnabled() {
        return this.m_isAuthenticationSPIEnabled;
    }

    public String getClientAddrSubject() {
        return this.m_clientAddrSubject;
    }

    protected ConnectionContext getContext() {
        if (this.m_channel == 0) {
            return this.m_context;
        }
        if (this.m_conZero == null) {
            return null;
        }
        return this.m_conZero.getContext();
    }

    @Override
    public Sender getSender() {
        return this.getClientSender();
    }

    @Override
    public Listener getListener() {
        return this.getClientListener();
    }

    public ClientSender getClientSender() {
        ConnectionContext context = this.getContext();
        if (context == null) {
            return null;
        }
        return context.getClientSender();
    }

    public ClientListener getClientListener() {
        ConnectionContext context = this.getContext();
        if (context == null) {
            return null;
        }
        return context.getClientListener();
    }

    public void setApplet(Applet applet) {
        this.m_props = applet;
    }

    public void setProperties(Hashtable props) {
        this.m_props = props;
    }

    public boolean isAppletConnection() {
        return this.m_props != null && this.m_props instanceof Applet;
    }

    public synchronized void setSyncPingInterval(long interval) {
        this.m_ping = true;
        this.m_asyncPing = false;
        this.m_pingInterval = interval;
        if (this.getClientSender() != null) {
            this.getClientSender().setAsyncPingInterval(0L);
            this.getClientSender().setSyncPingInterval(interval);
        }
    }

    public synchronized void setAsyncPingInterval(long interval) {
        this.m_ping = true;
        this.m_asyncPing = true;
        this.m_pingInterval = interval;
        if (this.getClientSender() != null) {
            this.getClientSender().setAsyncPingInterval(interval);
        }
    }

    public void setEnableLoadBalancing(boolean t) {
        this.m_enableLoadBalancing = t;
    }

    boolean isLoadBalancingEnabled() {
        return this.m_enableLoadBalancing;
    }

    public void setEnableFaultTolerance(boolean t) {
        this.m_enableFaultTolerance = t;
    }

    public boolean isFaultToleranceEnabled() {
        return this.m_enableFaultTolerance;
    }

    public boolean getNPReplUpgrade() {
        return this.m_NPReplUpgrade;
    }

    public void setFailoverReconnectTimeout(long l) {
        this.m_failoverReconnectTimeout = l;
    }

    long getFailoverReconnectTimeout() {
        return this.m_failoverReconnectTimeout;
    }

    public void setInitialConnectTimeout(long timeout) {
        this.m_initialConnectTimeout = timeout;
    }

    long getInitialConnectTimeout() {
        return this.m_initialConnectTimeout;
    }

    public void setTxBufferSize(long l) {
        this.m_txBufferSize = l;
    }

    long getTxBufferSize() {
        return this.m_txBufferSize;
    }

    protected void setStandbyBrokerConnectAllowed(boolean t) {
        this.m_standbyBrokerConnectAllowed = t;
    }

    boolean standbyBrokerConnectAllowed() {
        return this.m_standbyBrokerConnectAllowed;
    }

    public void setDisableConnectException(boolean t) {
        this.m_disableConnectException = t;
    }

    public void setClientData(ClientData c) {
        this.m_clientData = c;
    }

    public String getRoutingNodeName() {
        return this.m_routingNodeName;
    }

    ClientData getClientData() {
        return this.m_clientData;
    }

    ClientConnectParms getClientConnectParms() {
        return this.m_clientConnectParms;
    }

    void setRedirectedHost(String nh) {
        this.m_redirectedHost = nh;
    }

    public long getParentId() {
        return this.m_parentID;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_connectionInfo;
    }

    public void setFollowRedirect(boolean t) {
        this.m_followRedirect = t;
    }

    public boolean getFollowRedirect() {
        return this.m_followRedirect;
    }

    public boolean getDeliveryStarted() {
        return this.m_deliveryStarted;
    }

    public short getAckMode() {
        return this.m_ackMode;
    }

    public void setAckMode(short ackMode) {
        this.m_ackMode = ackMode;
    }

    public void setLastSocketId(long lastSocketId) {
        this.m_lastSocketId = lastSocketId;
    }

    public long getLastSocketId() {
        return this.m_lastSocketId;
    }

    public void setSocketConnectTimeout(long timeout) {
        this.m_socketConnectTimeout = timeout;
    }

    public long getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public void setQOPCacheSize(int size) {
        this.m_qopCacheSize = size;
    }

    public int getQOPCacheSize() {
        return this.m_qopCacheSize;
    }

    public final void setRejectionListener(IRejectionListener listener) {
        this.m_rejectionListener = listener;
    }

    public void setPartnerProductVersion(VersionData dat) {
        this.m_partnerProductVersion = dat;
    }

    public VersionData getPartnerProductVersion() {
        return this.m_partnerProductVersion;
    }

    public void setReturnDbLimitExceptions(int value) {
        this.m_returnDbLimitExceptions = value;
    }

    public void setProtocolDefaults(String[] urls) {
        String url = urls[0];
        if (url == null) {
            return;
        }
        if (url.length() >= 7 && "http://".equalsIgnoreCase(url.substring(0, 7))) {
            this.m_maxSendBufferSize = SessionConfig.HTTP_MAX_SEND_IO_BUFFER_SIZE;
            this.m_minSendBufferSize = SessionConfig.HTTP_MIN_SEND_IO_BUFFER_SIZE;
            this.m_initialSendBufferSize = SessionConfig.HTTP_INITIAL_SEND_IO_BUFFER_SIZE;
            this.m_maxRcvBufferSize = SessionConfig.HTTP_MAX_RCV_IO_BUFFER_SIZE;
            this.m_minRcvBufferSize = SessionConfig.HTTP_MIN_RCV_IO_BUFFER_SIZE;
            this.m_initialRcvBufferSize = SessionConfig.HTTP_INITIAL_RCV_IO_BUFFER_SIZE;
        }
    }

    @Override
    public void setMaxSendBufferSize(int size) {
        this.m_maxSendBufferSize = size;
    }

    @Override
    public void setMaxRcvBufferSize(int size) {
        this.m_maxRcvBufferSize = size;
    }

    @Override
    public void setMinSendBufferSize(int size) {
        this.m_minSendBufferSize = size;
    }

    @Override
    public void setMinRcvBufferSize(int size) {
        this.m_minRcvBufferSize = size;
    }

    @Override
    public void setInitialSendBufferSize(int size) {
        this.m_initialSendBufferSize = size;
    }

    @Override
    public void setInitialRcvBufferSize(int size) {
        this.m_initialRcvBufferSize = size;
    }

    @Override
    public int getMaxSendBufferSize() {
        return this.m_maxSendBufferSize;
    }

    @Override
    public int getMinSendBufferSize() {
        return this.m_minSendBufferSize;
    }

    @Override
    public int getMaxRcvBufferSize() {
        return this.m_maxRcvBufferSize;
    }

    @Override
    public int getMinRcvBufferSize() {
        return this.m_minRcvBufferSize;
    }

    @Override
    public int getInitialSendBufferSize() {
        return this.m_initialSendBufferSize;
    }

    @Override
    public int getInitialRcvBufferSize() {
        return this.m_initialRcvBufferSize;
    }

    public long getKeepAliveTimeout() {
        if (this.m_socket != null) {
            return this.m_socket.getKeepAliveTimeout();
        }
        return 0L;
    }

    public long getNegotiatedTxBufferSize() {
        if (this.m_txBufferSize == 0L && this.m_brokerConnectParms != null) {
            return this.m_brokerConnectParms.getBrokerTransactionBufferSize();
        }
        return this.m_txBufferSize;
    }

    public Connection(String appId, Principal principal, MessageHandler defaultMessageHandler) throws EGeneralException, EDefaultHandlerNotSet, EInvalidApplicationId, EInvalidUserId {
        this(appId, principal, defaultMessageHandler, false);
    }

    public Connection(String appId, Principal principal, MessageHandler defaultMessageHandler, boolean useSingleMessageLimiter) throws EGeneralException, EDefaultHandlerNotSet, EInvalidApplicationId, EInvalidUserId {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("Connection");
        }
        if (defaultMessageHandler == null) {
            throw new EDefaultHandlerNotSet();
        }
        if (this.DEBUG) {
            this.debug("Connection: principal = " + principal);
            if (principal != null) {
                this.debug("Connection: principal name = " + principal.getName());
            }
            this.debug("Connection: appId = " + appId);
        }
        if (this.DEBUG) {
            this.debug("Connection: appId = " + appId);
        }
        if (appId == null || "".equals(appId)) {
            appId = SessionConfig.REQUEST_TMP_APPID;
        }
        if (appId.indexOf(".") != -1 || appId.indexOf("*") != -1 || appId.indexOf("#") != -1) {
            throw new EInvalidApplicationId();
        }
        if (principal != null && principal.getName() != null && (principal.getName().indexOf(".") != -1 || principal.getName().indexOf("*") != -1 || principal.getName().indexOf("#") != -1)) {
            throw new EInvalidUserId();
        }
        if (!SessionConfig.CONFIGURED) {
            SessionConfig.sessionLoadConfig();
        }
        this.m_subjects = new SessionSubjectTable();
        this.m_subscriptionMutex = new Object();
        this.m_state = 1;
        this.m_handlers = new Vector();
        this.m_sessions = new Vector();
        this.m_sessionByTid = new LongHashTable();
        this.m_jobs = new Hashtable();
        this.m_subscriptions = new Hashtable();
        this.m_principal = principal;
        this.m_appid = appId;
        this.m_defMsgHandler = defaultMessageHandler;
        this.m_defaultSession = new Session(this);
        this.m_internalSession = new Session(this);
        this.m_brethren = new AutoVec();
        this.m_msgSorter = new MessageSorter(this, this.m_subjects, useSingleMessageLimiter);
        do {
            this.m_pubTrackHiBits = ((long)ProgressSecureRandom.theSecureRandom().nextInt() & 0xFFFFL) << 32;
        } while (this.m_pubTrackHiBits == 0L);
        this.m_nextPubTracking = 0;
        this.m_msgSorter.defaultHandler(defaultMessageHandler);
        this.addMessageHandler(defaultMessageHandler);
        boolean noThread = defaultMessageHandler.isJMS();
        this.m_dirMsgHandler = new DirectedMsgHandler(noThread);
        this.m_connectionFailoverStateManager = new ConnectionFailoverStateManager(this);
        this.m_reconnector = new ReconnectHelper(this);
        this.addMessageHandler(this.m_dirMsgHandler);
        this.m_socketDropHandlerChainFactory = new DefaultSocketDropHandlerChainFactory();
    }

    public String getHost() {
        String host = this.m_host == null ? ProgressInetAddress.getLocalHostName() : this.m_host;
        return host;
    }

    public int getPort() {
        if (this.m_portNum != -1) {
            return this.m_portNum;
        }
        throw new EAssertFailure(prAccessor.getString("STR018"));
    }

    public byte getBrokerSessionVer() {
        ConnectionContext context = this.getContext();
        if (context == null) {
            return 32;
        }
        ClientListener listener = context.getClientListener();
        return listener == null ? (byte)32 : (byte)listener.getBrokerSessionVer();
    }

    public String getBrokerURL() {
        return this.getPrefix() + this.getHost() + ":" + this.getPort();
    }

    public String[] getStandbyBrokerURLs() {
        return this.m_reconnector.getStandbyBrokerURLs();
    }

    public String[] getLocalBrokerURLs() {
        return this.m_reconnector.getLocalBrokerURLs();
    }

    public Credentials getCredentials() {
        if (this.m_principal instanceof Credentials) {
            return (Credentials)this.m_principal;
        }
        return null;
    }

    public long getPingInterval() {
        return this.m_pingInterval;
    }

    public boolean pingEnabled() {
        return this.m_ping;
    }

    public boolean isPingAsync() {
        return this.m_asyncPing;
    }

    public boolean connect(String host) throws EAlreadyConnected, EUnusableConnection, EParameterIsNull, ECredentialInUse, EUnknownBrokerHost, EUserAlreadyConnected, EBrokerVersionMismatch, EInauthenticClient, EInauthenticBroker, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ENetworkFailure, EPasswordExpired, ESecurityPolicyViolation, ESecurityGeneralException, EBrokerRedirected, EGeneralException, ESocketConnectTimeout {
        this.m_clientConnectParms = new ClientConnectParms(this.m_txBufferSize, this.m_failoverReconnectTimeout, -1L, -1L, this.m_monitorIntervalSecs);
        boolean rc = ReconnectHelper.connectAndChaseSingleFailoverRedirect(this, host, false);
        if (rc) {
            this.performPostConnectOperations(false);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connectWithRecoveryOpt(String host, boolean recovery) throws EAlreadyConnected, EUnusableConnection, EParameterIsNull, ECredentialInUse, EUnknownBrokerHost, EUserAlreadyConnected, EBrokerVersionMismatch, EInauthenticClient, EInauthenticBroker, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ENetworkFailure, EPasswordExpired, ESecurityPolicyViolation, ESecurityGeneralException, EBrokerRedirected, EGeneralException, ESocketConnectTimeout {
        this.m_hostArg = host;
        this.debug("Connection" + (recovery ? "(recovery)" : "") + "m: connect = " + host);
        Connection connection = this;
        synchronized (connection) {
            String socketType;
            block62: {
                if (host == null) {
                    throw new EParameterIsNull("brokerHostName");
                }
                if (this.m_principal == null) {
                    throw new EParameterIsNull("userCredentials");
                }
                if (!recovery) {
                    this.waitForAnotherConnectComplete();
                }
                if (this.m_principal instanceof Anonymous) {
                    throw new EAnonymousConnectionDisallowed();
                }
                this.m_channel = 0;
                this.m_brethren.setElementAt(this, this.m_channel);
                socketType = this.parseHost(host, this.m_disableConnectException);
                if (socketType == null) {
                    return false;
                }
                ConnectionContext cc = null;
                try {
                    this.m_dropHandler = this.m_socketDropHandlerChainFactory.create(this);
                    this.m_socket = this.openSocket(socketType, this.m_resolvedHost, this.m_portNum);
                    this.m_dirMsgHandler.bind(SessionConfig.getDirectedSubject(this.getEffectiveUid(), this.m_appid, "*", "#", "*"));
                    this.debug("Connection: got socket entering handshake");
                    this.initConnectionInfo(recovery);
                    this.m_socket.startProgressHandshake();
                    ClientSender sender = new ClientSender(this);
                    ClientListener listener = new ClientListener(this);
                    this.m_context = cc = new ConnectionContext(this.m_socket, sender, listener);
                    cc.setConnectInProgress();
                    listener.setConnectionContext(cc);
                    sender.setConnectionContext(cc);
                    sender.start();
                    listener.start();
                    this.m_state = 3;
                    try {
                        if (this.DEBUG || SessionConfig.DEBUG) {
                            String errMsg = "Connecting over opened socket to " + this.m_hostArg + ", connect timeout = " + this.m_connectTimeout + ", socket connect timeout = " + this.m_socketConnectTimeout;
                            SessionConfig.logMessage(errMsg, SessionConfig.getLevelWarning());
                        }
                        if (this.m_connectTimeout == 0) {
                            this.waitConnecting();
                        } else {
                            long startTime = System.currentTimeMillis();
                            long endTime = startTime + (long)(this.m_connectTimeout * 1000);
                            while (this.m_state == 3 && startTime < endTime) {
                                this.wait(endTime - startTime);
                                startTime = System.currentTimeMillis();
                            }
                            if (this.m_state == 3) {
                                cc.close();
                                listener.interrupt();
                                sender.interrupt();
                                throw new ETimeout(prAccessor.getString("CONNECT_TIMEOUT") + ": " + this.m_hostArg);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        cc.close();
                        listener.interrupt();
                        sender.interrupt();
                        throw new EInterrupted();
                    }
                    if (this.m_state == 0) {
                        sender.setThreadName();
                        listener.setThreadName();
                        if (this.m_brokerConnectParms == null) break block62;
                        int brokerVal = this.m_brokerConnectParms.getClientFCMonitorInterval();
                        this.m_monitorIntervalSecs = brokerVal == -999 ? this.m_monitorIntervalSecs : brokerVal;
                        int n = this.m_monitorIntervalSecs = this.m_monitorIntervalSecs < 0 ? 0 : this.m_monitorIntervalSecs;
                        if (this.m_monitorIntervalSecs > 0) {
                            sender.setMonitorInterval(this.m_monitorIntervalSecs);
                        }
                        break block62;
                    }
                    if (this.m_errcode == -34 && this.m_followRedirect) {
                        throw new EBrokerRedirected(this.m_redirectedHost);
                    }
                    if (this.m_errcode == -37) {
                        throw new EBrokerFailoverRedirected(this.m_redirectedHost);
                    }
                    this.cleanUp(1);
                    switch (this.m_errcode) {
                        case -15: {
                            throw new EBrokerVersionMismatch(prAccessor.getString("STR019"), this.m_errinfo, 26);
                        }
                        case -16: {
                            throw new EBrokerVersionMismatch(prAccessor.getString("STR020"), this.m_errinfo, 32);
                        }
                        case -17: {
                            throw new EUserAlreadyConnected(this.m_principal.getName());
                        }
                        case -40: {
                            throw new EUserAlreadyConnectedPendingReconnect(this.m_principal.getName());
                        }
                        case -39: {
                            EConnectionNotResumable ecnr = new EConnectionNotResumable();
                            if (this.m_errinfo == 126) {
                                ecnr = new EConnectionNotResumable(prAccessor.getString("STR156"), new EBrokerStateDiscarded());
                                throw ecnr;
                            }
                            ecnr = new EConnectionNotResumable();
                            throw ecnr;
                        }
                        case -18: {
                            throw new EConnectionLimitExceeded(SessionConfig.CONNECT_MAX_EXCEEDED);
                        }
                        case -35: {
                            throw new EConnectionLimitExceeded(SessionConfig.IP_ADDRESS_MAX_EXCEEDED);
                        }
                        case -5: {
                            ENetworkFailure enf = new ENetworkFailure(153, SessionConfig.CONNECT_REJECTED);
                            throw this.initNetworkFailureCause(enf);
                        }
                        case -22: {
                            ENetworkFailure enf = new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION);
                            throw this.initNetworkFailureCause(enf);
                        }
                        case -25: {
                            throw new EInauthenticClient();
                        }
                        case -26: {
                            throw new EInauthenticBroker();
                        }
                        case -23: {
                            throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
                        }
                        case -27: {
                            throw new ENetworkFailure(104, prAccessor.getString("STR021"));
                        }
                        case -34: {
                            throw new EBrokerRedirected(this.m_redirectedHost);
                        }
                        case -37: {
                            throw new EBrokerFailoverRedirected(this.m_redirectedHost);
                        }
                        case -44: {
                            String errMsg = prAccessor.getString("CONNECT_TIMEOUT") + ": " + this.m_hostArg;
                            if (!this.DEBUG) {
                                if (!SessionConfig.DEBUG) throw new ESocketConnectTimeout(errMsg);
                            }
                            SessionConfig.logMessage(errMsg, SessionConfig.getLevelWarning());
                            throw new ESocketConnectTimeout(errMsg);
                        }
                    }
                    ENetworkFailure enf = new ENetworkFailure(152, SessionConfig.CONNECT_LOW_LEVEL_ERR + ": " + this.m_errcode + "/" + this.m_errinfo);
                    throw this.initNetworkFailureCause(enf);
                }
                catch (UnknownHostException e) {
                    if (this.DEBUG || SessionConfig.DEBUG) {
                        SessionConfig.logMessage(e.toString(), e, SessionConfig.getLevelWarning());
                    }
                    if (!this.m_disableConnectException) throw new EUnknownBrokerHost(e.toString() + ": " + this.m_hostArg);
                    boolean listener = false;
                    return listener;
                }
                catch (ESocketConnectTimeout e) {
                    if (!this.m_disableConnectException) throw e;
                    boolean listener = false;
                    return listener;
                }
                catch (IOException e) {
                    if (e instanceof EConnectionLimitExceeded && this.m_disableConnectException) {
                        boolean listener = false;
                        return listener;
                    }
                    if (e instanceof EGeneralException) {
                        throw (EGeneralException)e;
                    }
                    if (e instanceof SocketException && this.m_disableConnectException) {
                        boolean listener = false;
                        return listener;
                    }
                    if (this.DEBUG || SessionConfig.DEBUG) {
                        SessionConfig.logMessage(e.toString() + ":" + this.m_hostArg, SessionConfig.getLevelInfo());
                    }
                    ENetworkFailure enf = new ENetworkFailure(104, e + ": " + this.m_hostArg);
                    enf.initCause(e);
                    throw enf;
                }
                catch (NumberFormatException e) {
                    if (!this.DEBUG) {
                        if (!SessionConfig.DEBUG) throw new EUnknownBrokerHost(SessionConfig.BAD_HOST_FORMAT + ": " + this.m_hostArg);
                    }
                    SessionConfig.logMessage(e.toString() + ":" + this.m_hostArg, SessionConfig.getLevelWarning());
                    throw new EUnknownBrokerHost(SessionConfig.BAD_HOST_FORMAT + ": " + this.m_hostArg);
                }
                finally {
                    if (cc != null) {
                        cc.clearConnectInProgress();
                    }
                }
            }
            if ("http".equals(socketType) && !SessionConfig.USE_EVS_HTTP || "https".equals(socketType)) {
                this.getClientSender().setFlushOnWrite(true);
            }
            if (this.pingEnabled()) {
                if (this.isPingAsync()) {
                    this.getClientSender().setAsyncPingInterval(this.getPingInterval());
                } else {
                    this.getClientSender().setSyncPingInterval(this.getPingInterval());
                }
            }
        }
        this.debug(this + " end of connect");
        return true;
    }

    private ENetworkFailure initNetworkFailureCause(ENetworkFailure enf) {
        if (this.m_error != null) {
            enf.initCause(this.m_error);
        }
        return enf;
    }

    public void performPostConnectOperations(boolean recovery) throws EGeneralException {
        if (this.m_isLGInstrumented) {
            this.publishLGSetting(this.m_isLGInstrumented, this.m_downStreamLGNodeType, true);
        }
        if (this.m_deliveryStarted && !recovery) {
            this.startDelivery();
        }
        if (!("".equals(this.m_hostArg) || this.m_routingNodeName != null && this.isEnterpriseEdition())) {
            this.requestRoutingNodeName();
        }
    }

    public void requestRoutingNodeName() throws EGeneralException {
        Message req = new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".getRoutingNodeName");
        int timeout = this.m_connectTimeout > 0 ? this.m_connectTimeout : -1;
        Message rep = null;
        try {
            rep = this.m_defaultSession.requestAdmin(req, timeout, this);
        }
        catch (ETimeout e) {
            this.close();
            this.getListener().interrupt();
            throw new ETimeout(prAccessor.getString("CONNECT_TIMEOUT"), e);
        }
        String errmsg = null;
        try {
            boolean success = rep.readBoolean();
            if (success) {
                this.m_routingNodeName = rep.readUTF();
            } else {
                errmsg = rep.readUTF();
            }
        }
        catch (IOException e) {
            throw new ENetworkFailure(2154, errmsg, e);
        }
    }

    public synchronized void setMonitorInterval(int secs) {
        this.m_monitorIntervalSecs = secs;
    }

    public synchronized int getMonitorInterval() {
        return this.m_monitorIntervalSecs;
    }

    private String parseHost(String hostName, boolean disableConnectException) throws EUnknownBrokerHost {
        BrokerURL brokerURL;
        try {
            brokerURL = new BrokerURL(hostName);
        }
        catch (MalformedURLException e) {
            throw new EUnknownBrokerHost(e);
        }
        String socketType = brokerURL.getBrokerProtocol();
        this.m_resolvedHost = this.m_host = brokerURL.getBrokerHostName();
        this.m_portNum = brokerURL.getBrokerPort();
        try {
            boolean needToResolveHost = true;
            if ("http".equalsIgnoreCase(socketType) || "https".equalsIgnoreCase(socketType)) {
                String host_map_key = "HTTP_MAP_HOST_TO_IP";
                String host_map_value = null;
                if (this.m_props == null) {
                    try {
                        host_map_value = System.getProperty(host_map_key);
                    }
                    catch (SecurityException securityException) {}
                } else if (this.m_props instanceof Hashtable) {
                    host_map_value = (String)((Hashtable)this.m_props).get(host_map_key);
                } else if (this.m_props instanceof Applet) {
                    host_map_value = ((Applet)this.m_props).getParameter(host_map_key);
                }
                if (host_map_value != null && !new Boolean(host_map_value).booleanValue()) {
                    needToResolveHost = false;
                }
            }
            if (needToResolveHost) {
                this.resolveHostName(socketType);
            }
        }
        catch (UnknownHostException e) {
            if (SessionConfig.DEBUG) {
                SessionConfig.logMessage(e.toString(), e, SessionConfig.getLevelWarning());
            }
            if (disableConnectException) {
                return null;
            }
            EUnknownBrokerHost ex = new EUnknownBrokerHost(e.toString() + " (broker url: " + hostName + ")");
            ex.initCause(e);
            throw ex;
        }
        return socketType;
    }

    public boolean connect(String host, boolean deliveryStarted) throws EAlreadyConnected, EUnusableConnection, EParameterIsNull, ECredentialInUse, EUnknownBrokerHost, EUserAlreadyConnected, EBrokerVersionMismatch, EInauthenticClient, EInauthenticBroker, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ENetworkFailure, EPasswordExpired, ESecurityPolicyViolation, ESecurityGeneralException, EBrokerRedirected, EGeneralException {
        this.m_deliveryStarted = deliveryStarted;
        return this.connect(host);
    }

    public void connect(String[] hosts, boolean enableLoadBalancing, boolean enableRandomize, int[] randomFactors, ClientData clientData, IHttpProxyConfig pConfig) throws EAlreadyConnected, EUnusableConnection, EParameterIsNull, ECredentialInUse, EUnknownBrokerHost, EUserAlreadyConnected, EBrokerVersionMismatch, EInauthenticClient, EInauthenticBroker, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ENetworkFailure, EPasswordExpired, ESecurityPolicyViolation, ESecurityGeneralException, EBrokerRedirected, EGeneralException, ESocketConnectTimeout {
        if (this.DEBUG) {
            String bl = "";
            if (hosts != null) {
                for (int i = 0; i < hosts.length; ++i) {
                    bl = bl + hosts[i] + ",";
                }
            } else {
                bl = "null";
            }
            String fac = "";
            if (randomFactors != null) {
                for (int i = 0; i < randomFactors.length; ++i) {
                    bl = bl + randomFactors[i] + ";";
                }
            }
            this.debug("connect: broker list = " + bl + ";LB = " + enableLoadBalancing + ";Rnd = " + enableRandomize + (randomFactors != null ? ";Factors = " + fac : "") + (clientData != null ? ";CDdata = " + clientData : ""));
        }
        this.m_enableLoadBalancing = enableLoadBalancing;
        this.m_deliveryStarted = false;
        this.m_clientData = clientData;
        this.m_clientConnectParms = new ClientConnectParms(this.m_txBufferSize, this.m_failoverReconnectTimeout, -1L, -1L, this.m_monitorIntervalSecs);
        if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
            this.m_httpProxyConfig = pConfig;
        }
        int numHosts = hosts.length;
        int startHost = 0;
        if (numHosts > 1 && enableRandomize) {
            startHost = this.computeWeightedRandom(randomFactors, numHosts);
        }
        this.m_reconnector.notifyInitialChoices(hosts, startHost);
        if (this.m_reconnector.connect(false)) {
            this.performPostConnectOperations(false);
        }
    }

    private int computeWeightedRandom(int[] factorList, int len) {
        int i;
        if (factorList == null) {
            long t = System.currentTimeMillis();
            int random = (int)(t / 100L % (long)len);
            if (this.DEBUG) {
                this.debug("connect: non-weighted random t=" + t + " [0" + (len - 1) + "] = " + random);
            }
            return random;
        }
        int[] factors = new int[len];
        for (i = 0; i < len; ++i) {
            factors[i] = 1;
        }
        int numFactors = factorList.length;
        if (numFactors > len) {
            numFactors = len;
        }
        for (i = 0; i < numFactors; ++i) {
            factors[i] = factorList[i];
        }
        int tot = 0;
        for (i = 0; i < len; ++i) {
            tot += factors[i];
        }
        long t = System.currentTimeMillis();
        int totRandom = (int)(t / 100L % (long)tot) + 1;
        if (this.DEBUG) {
            this.debug("connect: weighted random: totRandom = " + totRandom + " [1 - " + tot + "]");
        }
        tot = 0;
        for (i = 0; i < len && (tot += factors[i]) < totRandom; ++i) {
        }
        int random = i;
        if (this.DEBUG) {
            this.debug("connect: weighted random = " + random);
        }
        return random;
    }

    public void connect(Connection con) throws EAlreadyConnected, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, EGeneralException, ENetworkFailure, ENoSubscribersFound, ESecurityPolicyViolation, EUserAlreadyConnected {
        this.m_deliveryStarted = this.m_appid.indexOf("$QR$") >= 0 && con.getDeliveryStarted();
        this.connectWithRecoveryOpt(con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void connectWithRecoveryOpt(Connection con, boolean recovery) throws EAlreadyConnected, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ESessionLimitExceeded, EGeneralException, ENetworkFailure, ENoSubscribersFound, ESecurityPolicyViolation, EUserAlreadyConnected {
        block47: {
            String errmsg;
            int errcode;
            this.m_conZero = con;
            this.m_principal = con.m_principal;
            this.m_enableFaultTolerance = con.m_enableFaultTolerance;
            this.m_NPReplUpgrade = con.m_NPReplUpgrade;
            this.m_brokerConnectParms = con.m_brokerConnectParms;
            this.m_txBufferSize = con.m_txBufferSize;
            this.m_httpProxyConfig = con.m_httpProxyConfig;
            if (!recovery) {
                AutoVec autoVec = con.m_brethren;
                // MONITORENTER : autoVec
                if (con.m_brethren.size() >= 0x40000000) {
                    throw new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION);
                }
                // MONITOREXIT : autoVec
                this.waitForAnotherConnectComplete();
            }
            if (this.m_principal instanceof Anonymous) {
                throw new EAnonymousConnectionDisallowed();
            }
            this.m_state = 3;
            this.initConnectionInfo(recovery);
            this.m_brethren = con.m_brethren;
            this.m_dropHandler = con.m_dropHandler;
            this.m_routingNodeName = con.getRoutingNodeName();
            String baseAppid = this.m_appid;
            if (!recovery) {
                this.assignChannelAddresses(con);
            }
            ClientSecurityContext csc = null;
            Connection connection = this;
            // MONITORENTER : connection
            long presentedSocketId = 0L;
            while (true) {
                TunnelRequest request = null;
                boolean success = false;
                errcode = 0;
                errmsg = null;
                presentedSocketId = con.getSocketId();
                Message req = new Message(SessionConfig.getAdminPrefix(con.getEffectiveUid(), con.getApplicationId()) + ".tunnelingChannel");
                req.writeLong(presentedSocketId);
                req.writeUTF(con.getEffectiveUid());
                req.writeUTF(this.getApplicationId());
                req.writeInt(this.getChannel());
                req.writeLong(this.m_parentID);
                int flags = 0;
                if (recovery) {
                    flags = (short)(flags | 4);
                }
                flags = (short)(flags | this.m_returnDbLimitExceptions);
                req.writeShort(flags);
                req.writeShort(this.m_ackMode);
                Label local = new Label();
                local.setPriority((byte)10);
                local.setRouteLimit(1);
                Envelope requestEnv = new Envelope(req, local);
                request = new TunnelRequest(requestEnv, con);
                int replyTracking = con.addRequest(request);
                requestEnv.setRequest(replyTracking, con.getClientAddrSubject());
                this.setPendingTunnelRequest(request);
                con.m_defaultSession.publishInternal(requestEnv, -1, false, true, request);
                TunnelRequest tunnelRequest = request;
                // MONITORENTER : tunnelRequest
                request.join();
                ConnectionSyncData csd = request.getConnectionSyncData();
                Message rep = null;
                if (csd == null) {
                    rep = request.getReply().getMessage();
                }
                if (csd != null) {
                    boolean bl = success = csd.getState() == 0;
                    if (success) {
                        csc = csd.getClientSecurityContext();
                    } else {
                        errcode = -33;
                        errmsg = "Unable to connect during failover sync";
                    }
                } else {
                    success = rep.readBoolean();
                    if (success) {
                        csc = ClientSecurityContext.getClientSecurityContext(rep, (short)-1);
                    } else {
                        block46: {
                            errcode = rep.readInt();
                            try {
                                boolean result;
                                boolean collision;
                                byte version;
                                errmsg = rep.readUTF();
                                if ((errcode == -17 || errcode == -40) && !recovery && (version = rep.readByte()) == 1 && (collision = rep.readBoolean()) && (result = this.makeConnectionAppid(con, baseAppid))) {
                                    // MONITOREXIT : tunnelRequest
                                    this.setPendingTunnelRequest(null);
                                    continue;
                                }
                            }
                            catch (IOException ioe) {
                                if (errmsg != null) break block46;
                                errmsg = "Unable to create connection tunneling channel";
                            }
                        }
                        if (errcode == -38 && this.getSocketId() != presentedSocketId) {
                            // MONITOREXIT : tunnelRequest
                            this.setPendingTunnelRequest(null);
                            continue;
                        }
                    }
                }
                if (success) {
                    this.configQOP(csc);
                    // MONITOREXIT : tunnelRequest
                    this.setPendingTunnelRequest(null);
                    break block47;
                }
                this.cleanupConnectionAndNotify();
                try {
                    // MONITOREXIT : tunnelRequest
                }
                catch (ENoSubscribersFound e) {
                    this.cleanupConnectionAndNotify();
                    throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
                }
                catch (IOException e) {
                    this.cleanupConnectionAndNotify();
                    throw new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION, e);
                }
                if (!success) break;
            }
            switch (errcode) {
                case -17: {
                    throw new EUserAlreadyConnected(errmsg);
                }
                case -40: {
                    throw new EUserAlreadyConnectedPendingReconnect(errmsg);
                }
                case -18: {
                    throw new EConnectionLimitExceeded(SessionConfig.CONNECT_MAX_EXCEEDED);
                }
                case -41: {
                    throw new ESessionLimitExceeded(errmsg);
                }
                case -35: {
                    throw new EConnectionLimitExceeded(SessionConfig.IP_ADDRESS_MAX_EXCEEDED);
                }
                case -33: {
                    throw new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION + ": " + errmsg);
                }
                case -23: {
                    throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
                }
            }
            throw new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION + ": " + errmsg);
        }
        // MONITOREXIT : connection
        this.m_dirMsgHandler.bind(SessionConfig.getDirectedSubject(this.getEffectiveUid(), this.m_appid, "*", "#", "*"));
        if (this.m_deliveryStarted && !recovery && this.m_appid.indexOf("$QR$") == -1) {
            this.startDelivery();
        }
        this.debug(this + "(child of " + con + ") end of subchannel - connect");
    }

    private void cleanupConnectionAndNotify() {
        this.cleanupConnectingBrethren();
        this.m_state = 1;
        this.notifyStateChange();
        this.notifyAll();
    }

    private void initConnectionInfo(boolean recovery) {
        if (!recovery) {
            this.m_connectionInfo = new ConnectionInfo(this);
            this.m_recoveryMutex = this.m_connectionInfo;
        }
    }

    public void connect(Connection con, long parentID) throws EAlreadyConnected, EUnusableConnection, EParameterIsNull, ECredentialInUse, EUnknownBrokerHost, EUserAlreadyConnected, EBrokerVersionMismatch, EInauthenticClient, EInauthenticBroker, EAnonymousConnectionDisallowed, EConnectionLimitExceeded, ENetworkFailure, EPasswordExpired, ESecurityPolicyViolation, ESecurityGeneralException, EGeneralException {
        this.m_parentID = parentID;
        this.connect(con);
    }

    public synchronized void setConnectionDropped() {
        this.m_connDropped = true;
    }

    public synchronized boolean getConnectionDropped() {
        return this.m_connDropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAnotherConnectComplete() throws EAlreadyConnected, EInterrupted, EUnusableConnection {
        try {
            Connection connection = this;
            synchronized (connection) {
                this.waitConnecting();
            }
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
        if (this.m_state == 0) {
            throw new EAlreadyConnected();
        }
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
    }

    private void waitConnecting() throws InterruptedException {
        while (this.m_state == 3) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assignChannelAddresses(Connection parent) {
        AutoVec autoVec = this.m_brethren = parent.m_brethren;
        synchronized (autoVec) {
            if (this.m_appid.indexOf("$SESSION$") >= 0 && !this.m_appid.endsWith("$")) {
                if (this.m_channel <= 0) {
                    this.m_channel = this.m_brethren.getFirstEmpty();
                }
            } else {
                this.m_channel = this.m_brethren.getFirstEmpty();
            }
            this.m_brethren.setElementAt(this, this.m_channel);
        }
        this.makeConnectionAppid(parent, this.m_appid);
    }

    private boolean makeConnectionAppid(Connection parent, String baseAppid) {
        String connAppid = parent.m_appid;
        if (connAppid.endsWith("$CONNECTION$")) {
            connAppid = connAppid.substring(0, connAppid.lastIndexOf("$CONNECTION$"));
        }
        if (baseAppid.equals("$QR$") || baseAppid.equals("$CC$$QR$") || baseAppid.startsWith("$SESSION$") && baseAppid.endsWith("$") || baseAppid.equals("$QB$") || baseAppid.startsWith("$CC$") || baseAppid.equals("$NONDURABLE$")) {
            this.m_appid = connAppid + baseAppid + Connection.getNextCounter();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnectingBrethren() {
        AutoVec autoVec = this.m_brethren;
        synchronized (autoVec) {
            boolean lastManOut;
            int before = this.m_brethren.size();
            this.m_brethren.setElementAt(null, this.m_channel);
            int after = this.m_brethren.size();
            boolean bl = lastManOut = before == 1 && after == 0;
            if (lastManOut) {
                this.removeConnectionResources();
            }
        }
    }

    public final ClientSecurityContext getSecurityContext() {
        return this.m_csc;
    }

    public final boolean isAuthenticated() {
        return this.m_csc != null;
    }

    public void flowControlMgramReceived(IMgram m) {
        if (SessionConfig.FLOW_DEBUG) {
            System.out.println("Client " + this.m_csc.getUid() + "/" + this.m_csc.getAppid() + " got flow control mgram, prio " + m.getRawBody()[0]);
        }
        this.getSender().setMinSendPriority(m.getFlowControlHandle().getMinPriority(), m.getChannel());
    }

    public void disconnect(boolean forceUnsubscribeAll) throws ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        try {
            this.disconnectInternal(forceUnsubscribeAll, -1);
        }
        finally {
            this.cleanUp();
        }
    }

    public final synchronized MessageHandler setDefaultMessageHandler(MessageHandler defMsgHandler) throws EUnusableConnection, EGeneralException {
        if (this.unusable()) {
            throw new EUnusableConnection();
        }
        MessageHandler oldHandler = this.m_defMsgHandler;
        if (defMsgHandler != null) {
            this.m_defMsgHandler = defMsgHandler;
            this.m_msgSorter.defaultHandler(defMsgHandler);
            this.addMessageHandler(defMsgHandler);
        }
        return oldHandler;
    }

    public final MessageHandler getDefaultMessageHandler() throws EUnusableConnection {
        if (this.unusable()) {
            throw new EUnusableConnection();
        }
        return this.m_defMsgHandler;
    }

    public void setFlowControlDisabled(boolean disabled) {
        this.m_disableFlowControl = disabled;
    }

    public boolean isFlowControlDisabled() {
        return this.m_disableFlowControl;
    }

    public String getApplicationId() {
        return this.m_appid;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public Session getDefaultSession() {
        return this.m_defaultSession;
    }

    public Session getInternalSession() {
        if (this.m_internalSession.isInWorkScope()) {
            throw new EAssertFailure("getInternalSession called while inWorkScope() is true");
        }
        return this.m_internalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void addMessageHandler(MessageHandler mh) throws EParameterIsNull, EUnusableConnection, EGeneralException {
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
        if (mh == null) {
            throw new EParameterIsNull("MessageHandler");
        }
        Vector vector = this.m_handlers;
        synchronized (vector) {
            if (!this.m_handlers.contains(mh)) {
                this.m_handlers.addElement(mh);
                mh.assignConnection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeMessageHandler(MessageHandler mh) throws EUnusableConnection, EDefaultHandlerNotSet, EGeneralException {
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
        if (mh == this.m_defMsgHandler) {
            throw new EDefaultHandlerNotSet();
        }
        Vector vector = this.m_handlers;
        synchronized (vector) {
            if (this.m_handlers.removeElement(mh)) {
                mh.deassignConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageHandler[] getMessageHandlers() throws EUnusableConnection, EGeneralException {
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
        Vector vector = this.m_handlers;
        synchronized (vector) {
            int origSize;
            int numHandlers = origSize = this.m_handlers.size();
            for (int i = 0; i < origSize; ++i) {
                if (((MessageHandler)this.m_handlers.elementAt(i)).isVisible()) continue;
                --numHandlers;
            }
            MessageHandler[] handlers = new MessageHandler[numHandlers];
            int j = 0;
            for (int i = 0; i < origSize; ++i) {
                MessageHandler mh = (MessageHandler)this.m_handlers.elementAt(i);
                if (!mh.isVisible()) continue;
                handlers[j++] = mh;
            }
            return handlers;
        }
    }

    public void cleanUp() {
        this.cleanUp(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(int nextState) {
        if (this.m_state == 2) {
            return;
        }
        if (this.isConnected()) {
            try {
                this.disconnectInternal(false, 30);
            }
            catch (EGeneralException eGeneralException) {
                // empty catch block
            }
        }
        if (nextState == 2) {
            Vector vector = this.m_handlers;
            synchronized (vector) {
                int numHandlers = this.m_handlers.size();
                for (int i = 0; i < numHandlers; ++i) {
                    ((MessageHandler)this.m_handlers.elementAt(i)).deassignConnection();
                }
            }
        }
        this.m_state = nextState;
        this.notifyStateChange();
    }

    public Subscription[] getBrokerSubscriptions() throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return this.getSubscriptions(new Subject("#"), false);
    }

    public Subscription[] getSubscriptions(ISubject subject, boolean fullInfo) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Object object = this.m_subscriptionMutex;
        synchronized (object) {
            if (this.m_state == 1) {
                throw new ENotConnected();
            }
            try {
                int count;
                Message req = null;
                req = fullInfo ? new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".getSubscriptionsInfo") : new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".getSubscriptions");
                try {
                    req.writeUTF(subject.getSubjectString());
                }
                catch (IOException e) {
                    throw new EInvalidSubjectSyntax(subject + ", " + e, e);
                }
                Message rep = this.m_defaultSession.requestAdmin(req, -1, this);
                if (count == -1) {
                    throw new EInvalidSubjectSyntax(subject.getSubjectString());
                }
                Vector<Subscription> subscriptions = new Vector<Subscription>(count);
                for (count = rep.readInt(); count > 0; --count) {
                    String sub = rep.readUTF();
                    Label lbl = Label.unserialize(rep);
                    String selector = null;
                    boolean isSelectorAtBroker = false;
                    String subName = null;
                    boolean enforceStrictMessageOrder = false;
                    int flowToDisk = 0;
                    if (fullInfo) {
                        if (rep.readBoolean()) {
                            selector = rep.readUTF();
                        }
                        isSelectorAtBroker = rep.readBoolean();
                        if (rep.readBoolean()) {
                            subName = rep.readUTF();
                        }
                    }
                    enforceStrictMessageOrder = rep.readBoolean();
                    flowToDisk = rep.readInt();
                    if (sub.startsWith("$ISYS")) continue;
                    Subscription s = this.addSubscription(new Subject(sub, true));
                    s.setStatus(1);
                    s.setDeliveryLabelInternal(lbl);
                    if (fullInfo) {
                        s.setMessageSelector(selector);
                        s.setSelectorAtBroker(isSelectorAtBroker);
                        s.setSubscriptionName(subName);
                    }
                    s.setDurableStrictMessageOrder(enforceStrictMessageOrder);
                    s.setFlowToDisk(flowToDisk);
                    subscriptions.addElement(s);
                }
                Object[] result = new Subscription[subscriptions.size()];
                subscriptions.copyInto(result);
                return result;
            }
            catch (ENoSubscribersFound e) {
                throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
            }
            catch (EGeneralException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ENetworkFailure(177, SessionConfig.SUB_REQ_ERROR + ": " + e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Solicitation[] getSolicitations() throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
        if (!this.connected()) {
            throw new ENotConnected();
        }
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            int count = 0;
            Enumeration enu = this.m_jobs.elements();
            while (enu.hasMoreElements()) {
                if (!(enu.nextElement() instanceof Solicitation)) continue;
                ++count;
            }
            Solicitation[] ret = new Solicitation[count];
            int i = 0;
            enu = this.m_jobs.elements();
            while (enu.hasMoreElements()) {
                Object o = enu.nextElement();
                if (!(o instanceof Solicitation)) continue;
                ret[i++] = (Solicitation)o;
            }
            return ret;
        }
    }

    public void stopDelivery() throws EUnusableConnection, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.checkStateIsUsable();
        this.m_deliveryStarted = false;
        if (!this.isConnected()) {
            return;
        }
        try {
            this.getInternalSession().requestAdmin(new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".stopDelivery"), -1, this);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
    }

    public void startDelivery() throws EUnusableConnection, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.checkStateIsUsable();
        this.m_deliveryStarted = true;
        if (!this.isConnected()) {
            return;
        }
        try {
            this.getInternalSession().requestAdmin(new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".startDelivery"), -1, this);
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD, e);
        }
    }

    private void checkStateIsUsable() throws EUnusableConnection {
        if (this.m_state == 2) {
            throw new EUnusableConnection();
        }
    }

    public boolean isConnected() {
        try {
            return this.isConnected(0L);
        }
        catch (ETimeout e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected(long timeoutMs) throws ETimeout {
        if (this.m_recoveryMutex == null || this.isRecoveryThread()) {
            return this.m_state == 0;
        }
        IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
        synchronized (iRecoveryMutex) {
            if (this.m_recoveryMutex.isRecovering() && this.DEBUG) {
                this.debug("Spinning in isConnected");
            }
            try {
                this.waitForRecovery(timeoutMs);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return this.m_state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRecovery(long timeoutMs) throws ETimeout, InterruptedException {
        long timeoutEnd = System.currentTimeMillis() + timeoutMs;
        while (this.m_recoveryMutex.isRecovering()) {
            long waitTime = 0L;
            if (timeoutMs > 0L && (waitTime = timeoutEnd - System.currentTimeMillis()) <= 0L) {
                throw new ETimeout("Timeout while waiting for FT reconnect");
            }
            IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
            synchronized (iRecoveryMutex) {
                this.m_recoveryMutex.wait(waitTime);
            }
        }
    }

    private void waitForRecovery() throws InterruptedException {
        try {
            this.waitForRecovery(0L);
        }
        catch (ETimeout eTimeout) {
            // empty catch block
        }
    }

    protected int getState() {
        return this.m_state;
    }

    Object getSubscriptionMutex() {
        return this.m_subscriptionMutex;
    }

    MessageSorter getMsgSorter() {
        return this.m_msgSorter;
    }

    public final void setDeliveryCloseTimeout(long timeout) {
        this.m_deliveryCloseTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectInternal(boolean forceUnsubscribeAll, int timeout) throws ENotConnected, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Object object = this.m_subscriptionMutex;
        synchronized (object) {
            try {
                if (forceUnsubscribeAll) {
                    this.m_internalSession.unsubscribeAll();
                }
                if (!this.hierarchicallyConnected()) {
                    throw new ENotConnected();
                }
            }
            catch (EGeneralException ege) {
                if (this.m_connectionInfo != null) {
                    if (this.m_connDropped) {
                        this.m_connectionInfo.rejectUndeliveredMessages(-5);
                    } else {
                        this.m_connectionInfo.rejectUndeliveredMessages(-17);
                    }
                }
                throw ege;
            }
            Object object2 = this.m_stateMutex;
            synchronized (object2) {
                if (this.m_state != 1) {
                    this.m_state = 4;
                }
            }
        }
        this.m_connectionInfo.setClosing();
        if ((this.m_deliveryCloseTimeout > 0L || this.m_deliveryCloseTimeout == -1L) && this.m_connectionInfo.waitForMessageDelivery(this.m_deliveryCloseTimeout)) {
            this.m_connectionInfo.rejectUndeliveredMessages(-42);
        }
        this.m_connectionInfo.cancelUnsentMessages();
        IMgram m = MgramFactory.getMgramFactory().buildDisconnectRequest(this.getChannel(), true);
        m.setPriority((byte)11);
        this.send(m);
        if (timeout == -1) {
            this.waitState(1);
        } else {
            this.waitState(1, timeout);
        }
        if (this.m_state != 1) {
            this.disconnectReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean disconnectReply() {
        if (this.m_connectionInfo != null) {
            this.m_connectionInfo.rejectUndeliveredMessages(-17);
        }
        this.terminateSyncOps(-17);
        AutoVec autoVec = this.m_brethren;
        synchronized (autoVec) {
            boolean noneLeft;
            Connection conn = (Connection)this.m_brethren.elementAt(this.m_channel);
            if (conn != null) {
                conn.getConnectionInfo().setClosed();
            }
            this.m_brethren.setElementAt(null, this.m_channel);
            boolean bl = noneLeft = this.m_brethren.numElements() == 0;
            if (this.m_disconnectReplyReceived) {
                return !noneLeft;
            }
            this.m_disconnectReplyReceived = true;
            if (noneLeft) {
                this.removeConnectionResources();
            } else if (this.getChannel() == 0) {
                if (this.DEBUG) {
                    this.debug("Connection.disconnectReply for channel 0 but there are m_brethren entries: " + this.m_brethren.numElements());
                }
                this.removeConnectionResources();
            }
            if (this.isAuthenticated()) {
                this.getSecurityContext().reset();
            }
            this.m_state = 1;
            this.notifyStateChange();
            this.notifyAll();
            return !noneLeft;
        }
    }

    private void removeConnectionResources() {
        ClientListener listener = this.getClientListener();
        ClientSender sender = this.getClientSender();
        if (listener != null && Thread.currentThread() != listener) {
            listener.interrupt();
        }
        if (sender != null) {
            sender.kill(false, this.getChannel(), false);
        }
        try {
            ISocket s = this.getSocket();
            if (s != null) {
                s.close();
            }
        }
        catch (InterruptedIOException e) {
            try {
                this.getSocket().close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            SessionConfig.logMessage(e.toString(), e, SessionConfig.getLevelWarning());
        }
    }

    public Solicitation getSolicitation(Envelope reply) {
        Solicitation s = null;
        try {
            Job j = this.getJob((long)reply.getReplyTracking() & 0xFFFFFFFFL);
            if (j instanceof Solicitation) {
                s = (Solicitation)j;
            }
        }
        catch (ENoTrackingNum eNoTrackingNum) {
            // empty catch block
        }
        return s;
    }

    public Request getRequest(long replyTracker) {
        Request r = null;
        Job j = this.getJob(replyTracker);
        if (j != null && j instanceof Request) {
            r = (Request)j;
        }
        return r;
    }

    public Publication getPublication(long guarTracker) {
        Publication p = null;
        Job j = this.getJob(guarTracker);
        if (j != null && j instanceof Publication) {
            p = (Publication)j;
        }
        return p;
    }

    void addSession(Session child) {
        this.m_sessions.addElement(child);
    }

    void removeSession(Session child) {
        this.m_sessions.removeElement(child);
    }

    void addSessionTid(Session s, int tid) {
        this.m_sessionByTid.put(tid, s);
    }

    void removeSessionTid(int tid) {
        this.m_sessionByTid.remove(tid);
    }

    Session getSessionByTid(int tid) {
        return (Session)this.m_sessionByTid.get(tid);
    }

    protected boolean connected() {
        return this.isConnected();
    }

    public boolean hierarchicallyConnected() {
        try {
            return this.hierarchicallyConnected(0);
        }
        catch (ETimeout e) {
            return false;
        }
    }

    public boolean hierarchicallyConnected(int timeoutMs) throws ETimeout {
        if (this.getChannel() == 0) {
            return this.isConnected(timeoutMs);
        }
        Connection primary = (Connection)this.m_brethren.elementAt(0);
        if (primary != null) {
            return primary.isConnected(timeoutMs) && this.isConnected(timeoutMs);
        }
        return this.isConnected(timeoutMs);
    }

    public synchronized void connectSuccess(ClientSecurityContext csc) {
        this.m_csc = csc;
        if (this.m_brokerConnectParms == null) {
            this.m_enableFaultTolerance = false;
        } else {
            if (!this.m_brokerConnectParms.getFaultTolerantBroker()) {
                this.m_enableFaultTolerance = false;
            }
            if (this.m_brokerConnectParms.getNPReplUpgrade()) {
                this.m_NPReplUpgrade = true;
            }
        }
        this.m_clientAddrSubject = csc.getDirectedAddrString();
        if (csc.isSecurityEnabled() && csc.isQopSecurityEnabled()) {
            this.createQopCache();
        }
        try {
            if (!this.m_appid.equals(csc.getAppid()) || !this.m_principal.getName().equals(csc.getUid())) {
                this.m_dirMsgHandler.unbind(SessionConfig.getDirectedSubject(this.getEffectiveUid(), this.m_appid, "*", "#", "*"));
                this.m_appid = csc.getAppid();
                this.m_dirMsgHandler.bind(SessionConfig.getDirectedSubject(this.getEffectiveUid(), this.m_appid, "*", "#", "*"));
            }
            if (this.isFaultToleranceEnabled()) {
                this.m_dirMsgHandler.unbind("$ISYS.acceptor.*");
                this.m_dirMsgHandler.bind("$ISYS.acceptor.*", (IMessageHandler)new AcceptorUpdateHandler(this.getReconnector()));
            }
        }
        catch (EGeneralException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        this.m_errcode = 0;
        this.m_errinfo = 0;
        this.m_error = null;
        this.m_socketDropCause = null;
        this.m_state = 0;
        this.m_connDropped = false;
        if (this.m_channel == 0) {
            this.m_context.getClientSender().connectSuccess();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectFailure(int errcode, int errinfo, ISocket socket, Throwable thrown) {
        if (socket != this.m_socket) {
            return;
        }
        this.m_connectionInfo.dumpOutQueue();
        Connection connection = this;
        synchronized (connection) {
            this.m_errcode = errcode;
            this.m_errinfo = errinfo;
            this.m_state = 1;
            this.m_error = thrown;
            this.notifyStateChange();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnconnected() {
        Object object = this.m_stateMutex;
        synchronized (object) {
            int previous_state = this.m_state;
            if (previous_state == 0 || previous_state == 4) {
                this.m_state = 1;
                this.notifyStateChange();
            }
        }
    }

    void terminateSyncOps(int statcode) {
        this.terminateSyncOps(statcode, true);
    }

    public void terminateSyncOps(int statcode, boolean includeRecoverables) {
        Hashtable h = (Hashtable)this.m_jobs.clone();
        Enumeration enu = h.keys();
        while (enu.hasMoreElements()) {
            Long jid = (Long)enu.nextElement();
            Job j = (Job)this.m_jobs.get(jid);
            if (!(j instanceof Publication) && !(j instanceof Request) && !(j instanceof SynchronousAck) || !includeRecoverables && !j.getUnrecoverable()) continue;
            this.m_jobs.remove(jid);
            j.setStatus(statcode);
        }
    }

    List getPendingXONCERequests() {
        ArrayList<Long> v = new ArrayList<Long>();
        Enumeration enu = this.m_jobs.keys();
        while (enu.hasMoreElements()) {
            Request req;
            Long jid = (Long)enu.nextElement();
            Job j = (Job)this.m_jobs.get(jid);
            if (!(j instanceof Request) || !(req = (Request)j).getXonce()) continue;
            v.add(jid);
        }
        return v;
    }

    public void resendTransactedAcksInBatch() throws ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        Enumeration enu = this.m_sessions.elements();
        while (enu.hasMoreElements()) {
            Session zsess = (Session)enu.nextElement();
            zsess.resendTransactedAcksInBatch();
        }
    }

    synchronized void dropConnection(int errcode, int errinfo) {
        this.connectionDropped(errcode, errinfo, 0);
    }

    synchronized void connectionDropped(int errcode, int errinfo) {
        this.connectionDropped(errcode, errinfo, this.m_state);
    }

    public synchronized void connectionDropped(int errcode, int errinfo, int previous_state) {
        this.setUnconnected();
        int statcode = -5;
        if (this.m_connectionInfo != null) {
            this.m_connectionInfo.rejectUndeliveredMessages(statcode);
        }
        this.terminateSyncOps(statcode);
        if (this.getConnectionInfo() != null) {
            this.getConnectionInfo().notifyConnectionDropped();
        }
        if (previous_state == 0 || previous_state == 4) {
            this.m_state = 1;
            Message m = new Message(SessionConfig.getClientPrefix() + "brokerConnectionDropped");
            m.writeByte(errcode);
            m.writeInt(errinfo);
            this.m_msgSorter.dispatchLocalEnv(new Envelope(m));
        }
        this.connDroppedIBHook();
        this.notifyStateChange();
    }

    public final Throwable getSocketDropCause() {
        return this.m_socketDropCause;
    }

    void socketDropped(int errcode, int errinfo, ConnectionContext context, Throwable cause) {
        SocketDropHandler handler;
        if (context != this.m_context) {
            return;
        }
        if (cause != null && this.m_socketDropCause == null) {
            this.m_socketDropCause = cause;
        }
        if ((handler = this.m_dropHandler) != null) {
            handler.socketDropped(errcode, errinfo, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEndOfRecovery(boolean success) {
        this.debug("ABOUT TO END RECOVERY STATE ! ");
        IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
        synchronized (iRecoveryMutex) {
            this.m_recoveryMutex.setRecovering(false);
            this.m_recoveryThread = null;
            this.m_recoveryMutex.notifyAll();
        }
        this.getConnectionInfo().notifyEndOfRecovery();
        if (success && this.m_channel == 0) {
            Message m = new Message(SessionConfig.getClientPrefix() + "brokerConnectionReconnected");
            this.m_msgSorter.dispatchLocalEnv(new Envelope(m));
        }
    }

    protected void notifyStartOfRecovery() {
        Message m;
        this.debug("ENTERING RECOVERY STATE ! ");
        boolean browser = this.m_appid.indexOf("$QB$") >= 0;
        this.m_recoveryThread = Thread.currentThread();
        this.m_recoveryMutex.setRecovering(true);
        this.getConnectionInfo().notifyStartOfRecovery();
        if (browser && this.m_state == 0) {
            m = new Message(SessionConfig.getClientPrefix() + "brokerConnectionReconnecting");
            this.m_msgSorter.dispatchLocalEnv(new Envelope(m));
            this.m_state = 4;
        }
        if (this.m_channel == 0) {
            m = new Message(SessionConfig.getClientPrefix() + "brokerConnectionReconnecting");
            this.m_msgSorter.dispatchLocalEnv(new Envelope(m));
        }
    }

    public boolean inRecoveryState() {
        return this.m_recoveryMutex.isRecovering();
    }

    protected boolean isRecoveryThread() {
        Thread t = Thread.currentThread();
        return t == this.m_recoveryThread || t == this.getClientListener();
    }

    boolean isRecoveryInitiatingThread(Thread t) {
        return t == this.m_recoveryThread;
    }

    protected IRecoveryMutex getRecoveryMutex() {
        return this.m_recoveryMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChange() {
        Object object = this.m_stateMutex;
        synchronized (object) {
            this.m_stateMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitState(int value) {
        Object object = this.m_stateMutex;
        synchronized (object) {
            while (this.m_state != value) {
                try {
                    this.m_stateMutex.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitState(int value, long timeout) {
        Object object = this.m_stateMutex;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeout * 1000L;
            while (this.m_state != value && startTime < endTime) {
                try {
                    this.m_stateMutex.wait(endTime - startTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                startTime = System.currentTimeMillis();
            }
        }
    }

    protected ISocket openSocket(String socketTypeName, String host, int port) throws IOException {
        this.initHostPrefix(socketTypeName);
        int socketType = ProgressSocketFactory.getType(socketTypeName);
        if (port < 0 || port > 65535) {
            throw new EInvalidPort(prAccessor.getString("INVALID_PORT") + port);
        }
        ProgressSocketFactory sf = ProgressSocketFactory.getFactory(socketType);
        ProgressSocket socket = sf.createProgressSocket(this.m_principal, host, port, this.m_props, this.m_httpProxyConfig, this.m_socketConnectTimeout);
        return socket;
    }

    public String getPrefix() {
        return this.m_hostPrefix;
    }

    protected void addSubject(ISubject s, HandlerIHandlerContainer hih) throws EGeneralException, EInvalidSubjectSyntax {
        this.m_subjects.put(s, (ISubjectMatchObject)hih);
    }

    void removeSubject(ISubject s, HandlerIHandlerContainer hih) {
        this.m_subjects.removeSubjectObject(s, (ISubjectMatchObject)hih);
    }

    public long getClientId() {
        ClientSecurityContext csc = this.getSecurityContext();
        if (csc != null) {
            return csc.getClientId();
        }
        return 0L;
    }

    boolean unusable() {
        return this.m_state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveJobs() {
        Hashtable beforeImage;
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            beforeImage = (Hashtable)this.m_jobs.clone();
        }
        Enumeration jobs = beforeImage.elements();
        while (jobs.hasMoreElements()) {
            Job job = (Job)jobs.nextElement();
            job.resolve();
        }
    }

    public void allowRecoveryJobs() {
        this.m_allowRecoveryJobs = true;
    }

    public void disallowRecoveryJobs() {
        this.m_allowRecoveryJobs = false;
    }

    public boolean allowedRecoveryJobs() {
        if (this.m_channel > 0) {
            return this.m_conZero.allowedRecoveryJobs();
        }
        return this.m_allowRecoveryJobs;
    }

    public void addJobForRecoveryPurposes(long jid, Job j) throws ENotConnected {
        j.setUnrecoverable(true);
        this.m_jobs.put(new Long(jid), j);
        if (!this.allowedRecoveryJobs()) {
            this.m_jobs.remove(new Long(jid));
            throw new ENotConnected();
        }
    }

    public void addJob(long jid, Job j) {
        this.m_jobs.put(new Long(jid), j);
    }

    protected Job getJob(long jid) {
        return (Job)this.m_jobs.get(new Long(jid));
    }

    public Job removeJob(long jid) {
        return (Job)this.m_jobs.remove(new Long(jid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object removeJobClass(long jid, Class c) {
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            Long Jid = new Long(jid);
            Object j = this.m_jobs.remove(Jid);
            if (j == null) {
                return null;
            }
            if (j.getClass() == c) {
                return j;
            }
            this.m_jobs.put(Jid, j);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Solicitation addSolicitation(Envelope env, MessageHandler mh) {
        Solicitation s = new Solicitation(this, env, mh);
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            int tracking = this.addRequest(s);
            s.setTracking(tracking);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addRequest(Job req) {
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            Long key;
            int tracking;
            do {
                tracking = ProgressSecureRandom.theSecureRandom().nextInt();
                key = new Long((long)tracking & 0xFFFFFFFFL);
            } while (tracking == 0 || this.m_jobs.containsKey(key));
            if (this.isRecoveryThread()) {
                req.setUnrecoverable(true);
            }
            this.m_jobs.put(key, req);
            return tracking;
        }
    }

    Job removeRequest(int reqTracking) {
        Long key = new Long((long)reqTracking & 0xFFFFFFFFL);
        return (Job)this.m_jobs.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long genPubTrackingNum() {
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            long trk = (long)this.m_nextPubTracking++ & 0xFFFFFFFFL | this.m_pubTrackHiBits;
            return trk;
        }
    }

    void removeSubscription(ISubject subject) {
        Subscription s = (Subscription)this.m_subscriptions.get(subject);
        if (s != null && s.decrementCount() < 1) {
            this.m_subscriptions.remove(subject);
        }
    }

    Subscription addSubscription(ISubject subject) {
        Subscription s = (Subscription)this.m_subscriptions.get(subject);
        if (s == null) {
            s = new Subscription(this, subject);
            this.m_subscriptions.put(subject, s);
        } else {
            s.incrementCount();
        }
        return s;
    }

    void idrReceived(IMgram idr) throws IOException {
        try {
            this.m_idrTransport.handleIDR(idr);
        }
        catch (IOException ex) {
            SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
            throw ex;
        }
    }

    void connectionSyncReceived(IMgram connectionSync) throws IOException {
        try {
            this.m_connectionSyncHandler.handleConnectionSync(connectionSync);
        }
        catch (IOException ex) {
            SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
            throw ex;
        }
    }

    void txnReplyReceived(IMgram reply) {
        int replyTracking = ArrayUtil.readInt(reply.getRawBody(), 2);
        long jid = (long)replyTracking & 0xFFFFFFFFL;
        Job j = this.getJob(jid);
        if (j instanceof Request) {
            this.removeJob(jid);
            ((Request)j).setReplyMgram(reply);
        }
        if (reply.isGuarenteed()) {
            this.sendAck(reply.getGuarenteedTrackingNum());
        }
    }

    public void setAckListener(AcknowledgementListener l) {
        this.m_ackListener = l;
    }

    public AcknowledgementListener getAckListener() {
        return this.m_ackListener;
    }

    public void setIDRTransport(IIDRTransport t) {
        this.m_idrTransport = t;
    }

    public IIDRTransport getIDRTransport() {
        return this.m_idrTransport;
    }

    public void setConnectionSyncHandler(IConnectionSyncHandler t) {
        this.m_connectionSyncHandler = t;
    }

    public IConnectionSyncHandler getConnectionSyncHandler() {
        return this.m_connectionSyncHandler;
    }

    protected void ackReceived(IMgram m) {
        Session s;
        if (this.DEBUG) {
            this.debug(this.m_appid + " Ack Received: tracking: " + m.getAckHandle().getTrackingNumber() + " channel: " + m.getChannel());
        }
        ClientSender sender = this.getClientSender();
        if (this.m_ackListener != null) {
            this.m_ackListener.ackReceived(m);
        }
        IAckHandle ackHandle = m.getAckHandle();
        long tracking = ackHandle.getTrackingNumber();
        boolean qNack = false;
        boolean queueMessage = false;
        IMgram ackedMgram = null;
        if (m != null && (m.getType() == 14 || m.getType() == 3)) {
            ackedMgram = sender.ack(tracking, m);
        } else if (m != null && m.getType() == 20) {
            if (this.isFlowControlDisabled()) {
                qNack = true;
                boolean async = sender.isAsyncDelivery(tracking, m);
                PayloadWrapper payload = null;
                if (async) {
                    payload = (PayloadWrapper)this.m_connectionInfo.getPTPFlowControlHandler().handleNack(m);
                    sender.notifyBlockedSenders(m.getChannel());
                    return;
                }
                payload = sender.removeNackedMsg(tracking, m);
                if (payload != null) {
                    queueMessage = payload.isQueueMessage();
                }
            } else {
                this.m_connectionInfo.getPTPFlowControlHandler().handleNack(m);
                return;
            }
        }
        int errno = 0;
        errno = qNack ? (queueMessage ? -18 : -23) : ackHandle.getErr();
        this.terminateJob(tracking, errno);
        if (errno != 0 && this.isFaultToleranceEnabled() && ackedMgram != null && (s = this.getSessionByTid(ackedMgram.getTxnId())) != null) {
            s.removePendingTxnMsg(tracking, ackedMgram);
        }
    }

    protected void windowAckReceived(IMgram m) {
        Session s;
        IWindowAckHandle ackHandle = m.getWindowAckHandle();
        long receiptTracking = ackHandle.getReceiptTrackingNumber();
        long storageTracking = ackHandle.getStorageTrackingNumber();
        int tid = ackHandle.getTxnId();
        short errno = ackHandle.getErr();
        if (this.DEBUG) {
            this.debug(this.m_appid + " Window ack Received: tid = " + tid + ", receipt tracking: " + receiptTracking + ", storage tracking: " + storageTracking);
        }
        this.terminateJob(receiptTracking, errno);
        if (storageTracking != -1L && (s = this.getSessionByTid(tid)) != null) {
            s.receivedStorageAck(storageTracking);
        }
        this.send(MgramFactory.getMgramFactory().buildWindowAck(receiptTracking, storageTracking, (short)0, false, -1L, false, tid, this.m_channel));
    }

    public void terminateJob(long tracking, int status) {
        this.terminateJob(tracking, status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateJob(long tracking, int status, String message) {
        Job j;
        Hashtable hashtable = this.m_jobs;
        synchronized (hashtable) {
            j = this.removeJob(tracking);
            if (j == null) {
                return;
            }
            if (!(j instanceof Publication) && !(j instanceof SynchronousAck)) {
                this.addJob(tracking, j);
                return;
            }
        }
        j.setStatus(status, message);
    }

    public void send(Envelope env) throws ENetworkFailure, EInterrupted, EFlowControlException {
        this.send(env, null);
    }

    public void send(Envelope env, IMgramEnqueuedToSendListener listener) throws ENetworkFailure, EInterrupted, EFlowControlException {
        if (!this.isRecoveryThread()) {
            IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
            synchronized (iRecoveryMutex) {
                if (this.m_recoveryMutex.isRecovering() && this.DEBUG) {
                    this.debug("Spinning in send(env)");
                }
                while (true) {
                    try {
                        this.waitForRecovery();
                    }
                    catch (InterruptedException ie) {
                        throw new EInterrupted();
                    }
                    try {
                        if (!this.isConnected()) {
                            throw new ENotConnected();
                        }
                        this.m_connectionInfo.send(env, listener, false);
                        return;
                    }
                    catch (EInterruptedByFailover eInterruptedByFailover) {
                        continue;
                    }
                    break;
                }
            }
        }
        this.m_connectionInfo.send(env, listener, true);
    }

    public void send(IMgram m) {
        try {
            this.send(m, null);
        }
        catch (EFlowControlException fcE) {
            fcE.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMgram m, IMgramEnqueuedToSendListener listener) throws EFlowControlException {
        if (!this.isRecoveryThread()) {
            IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
            synchronized (iRecoveryMutex) {
                if (this.m_recoveryMutex.isRecovering() && this.DEBUG) {
                    this.debug("Spinning in send(m)");
                }
                try {
                    this.waitForRecovery();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.m_connectionInfo.send(m, listener, false);
                return;
            }
        }
        this.m_connectionInfo.send(m, listener, true);
    }

    public void preemptFTReconnect() {
        this.m_reconnector.preemptFTReconnect();
    }

    public void send(Envelope env, long timeoutMillis, IMgramEnqueuedToSendListener listener) throws ENetworkFailure, ETimeout, EInterrupted, EFlowControlException {
        if (!this.isRecoveryThread()) {
            IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
            synchronized (iRecoveryMutex) {
                if (this.m_recoveryMutex.isRecovering() && this.DEBUG) {
                    this.debug("Spinning in send(env, timeoutMillis)");
                }
                while (true) {
                    try {
                        this.waitForRecovery(timeoutMillis);
                    }
                    catch (InterruptedException ie) {
                        throw new EInterrupted();
                    }
                    try {
                        if (!this.isConnected()) {
                            throw new ENotConnected();
                        }
                        this.m_connectionInfo.send(env, timeoutMillis, listener, false);
                        return;
                    }
                    catch (EInterruptedByFailover eInterruptedByFailover) {
                        continue;
                    }
                    break;
                }
            }
        }
        this.m_connectionInfo.send(env, timeoutMillis, listener, true);
    }

    IMgram sendAck(long tracking) {
        return this.sendAck(tracking, false, 0, -1L);
    }

    IMgram sendSplitDeliveryAck(long tracking, short subjectTracking) {
        return this.sendSplitDeliveryAck(tracking, false, 0, -1L, subjectTracking);
    }

    IMgram sendSplitDeliveryAck(long tracking, boolean txn, int tid, long clientID, short subjectTracking) {
        IMgram ack = MgramFactory.getMgramFactory().buildSplitDeliveryAck(tracking, clientID, (short)0, false, 0L, txn, tid, this.m_channel, subjectTracking);
        this.send(ack);
        return ack;
    }

    IMgram sendAck(long tracking, boolean txn, int tid, long clientID) {
        IMgram ack = MgramFactory.getMgramFactory().buildAck(tracking, clientID, (short)0, false, 0L, txn, tid, this.m_channel);
        this.send(ack);
        return ack;
    }

    void sendQAck(long tracking, boolean txn, int tid, long clientID) {
        this.send(MgramFactory.getMgramFactory().buildQAck(tracking, clientID, (short)0, false, 0L, txn, tid, this.m_channel));
    }

    void sendSynchronousAck(long tracking, boolean txn, int tid, Connection consumerConnection) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        long ackTracking = this.genPubTrackingNum();
        IMgram ack = MgramFactory.getMgramFactory().buildAck(tracking, (short)0, true, ackTracking, txn, tid, this.m_channel);
        this.sendAnyAckSynchonous(ackTracking, ack, consumerConnection);
    }

    void sendSyncSplitDeliveryAck(long tracking, boolean txn, int tid, Connection consumerConnection, short subjectTracking) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        long ackTracking = this.genPubTrackingNum();
        IMgram ack = MgramFactory.getMgramFactory().buildSplitDeliveryAck(tracking, -1L, (short)0, true, ackTracking, txn, tid, this.m_channel, subjectTracking);
        this.sendAnyAckSynchonous(ackTracking, ack, consumerConnection);
    }

    void sendSynchronousQAck(long tracking, boolean txn, int tid, Connection consumerConnection) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.sendSynchronousQAck(tracking, txn, tid, -1L, consumerConnection);
    }

    void sendSynchronousQAck(long tracking, boolean txn, int tid, long clientId, Connection consumerConnection) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        long ackTracking = this.genPubTrackingNum();
        IMgram ack = MgramFactory.getMgramFactory().buildQAck(tracking, clientId, (short)0, true, ackTracking, txn, tid, this.m_channel);
        this.sendAnyAckSynchonous(ackTracking, ack, consumerConnection);
    }

    void sendAnyAckSynchonous(long ackTracking, IMgram m, Connection consumerConnection) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (!this.isConnected()) {
            this.removeJob(ackTracking);
            throw new ENotConnected();
        }
        SynchronousAck ackjob = new SynchronousAck(m, this);
        this.addJob(ackTracking, ackjob);
        m.getJMSClientHandle().setConnection(consumerConnection);
        this.send(m);
        if (this.CALLBACK) {
            this.callback("sabotageConnection", 0, new Object[]{this});
        }
        ackjob.join();
    }

    @Override
    public void resolveJob(Job job) {
        if (job instanceof SynchronousAck) {
            this.send(((SynchronousAck)job).getAck());
            return;
        }
        if (job instanceof Request) {
            Request req = (Request)job;
            if (req.getPendingResponse()) {
                this.debug("Leaving request unresolved, response pending in broker: " + req);
                return;
            }
            Envelope requestEnv = ((Request)job).getRequest();
            IMgram m = ((Request)job).getRequestMgram();
            IMgram requestMgram = null;
            requestMgram = requestEnv != null ? requestEnv.getMgram() : m;
            if (job.isRunning()) {
                if (requestMgram != null && requestMgram.isGuarenteed()) {
                    IMgram iMgram = this.m_connectionInfo.removeMsgPendingAck(requestMgram.getGuarenteedTrackingNum(), false);
                }
            } else if (job.isComplete()) {
                IMgram oldmg = null;
                long replyTracking = 0L;
                Job j = null;
                if (requestMgram != null) {
                    if (requestMgram.isGuarenteed()) {
                        oldmg = this.m_connectionInfo.removeMsgPendingAck(requestMgram.getGuarenteedTrackingNum(), true);
                    }
                    if (requestMgram.getReplySubject() != null) {
                        replyTracking = requestMgram.getReplySubject().getSubjectTracking() & 0xFFFFFFFFL;
                        j = this.removeJob(replyTracking);
                    }
                }
            }
            if (!job.isRunning()) {
                return;
            }
            try {
                if (requestEnv != null) {
                    requestEnv.syncAll(this, this.getClientSender().getMessageProtection());
                    this.send(requestEnv.getMgram());
                } else if (m != null) {
                    if (m.isSecure()) {
                        m.setMgramSecure(this.getClientSender().getMessageProtection());
                        m.sync();
                    }
                    this.send(m);
                }
            }
            catch (IOException ioe) {
                SessionConfig.logMessage(ioe, SessionConfig.getLevelWarning());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFlowControlMgram(int priority) {
        IRecoveryMutex iRecoveryMutex = this.m_recoveryMutex;
        synchronized (iRecoveryMutex) {
            if (this.m_recoveryMutex.isRecovering()) {
                if (this.DEBUG) {
                    this.debug("Skipped sending a flow control mgram of priority " + priority);
                }
                return;
            }
        }
        this.send(MgramFactory.getMgramFactory().buildFlowControlMgram((byte)priority, this.m_channel));
    }

    void sendIntegrityFailure(long tracking) {
        this.send(MgramFactory.getMgramFactory().buildAck(tracking, (short)-3, this.m_channel));
    }

    public final String getEffectiveUid() {
        if (this.m_csc != null) {
            return this.m_csc.getUid();
        }
        if (!(this.m_principal instanceof Anonymous)) {
            return this.m_principal.getName();
        }
        String host = ProgressInetAddress.getLocalHostName();
        int port = ProgressSecureRandom.theSecureRandom().nextInt();
        return String.valueOf(port) + "@" + host;
    }

    public String getAdminPrefix() {
        return SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.m_appid);
    }

    public void initCon0Data(String host) {
        this.m_hostArg = host;
        this.m_channel = 0;
        this.m_brethren.setElementAt(this, this.m_channel);
        try {
            String socketType = this.parseHost(host, true);
            this.initHostPrefix(socketType);
        }
        catch (EUnknownBrokerHost eUnknownBrokerHost) {
            // empty catch block
        }
        this.m_connectionInfo = new ConnectionInfo(this);
        this.m_recoveryMutex = this.m_connectionInfo;
    }

    private void initHostPrefix(String socketTypeName) {
        this.m_hostPrefix = "tcp".equalsIgnoreCase(socketTypeName) ? "" : socketTypeName + "://";
    }

    public static Connection getAdminConnection() {
        return s_adminConnection;
    }

    public static void setAdminConnection(Connection c) {
        s_adminConnection = c;
    }

    protected void pauseIfMark() {
    }

    protected void connDroppedIBHook() {
    }

    public byte getInternalQop(ISubject subject) {
        byte Public = 0;
        IQop subjectQop = this.m_qopcache.find(subject);
        if (subjectQop == null) {
            return SecurityLogic.getQueryAttribs();
        }
        Public = (byte)subjectQop.getProtection();
        try {
            return SecurityLogic.AttribsFromPublic((byte)1, Public);
        }
        catch (ESecurityInvalidLogistics log) {
            throw new EAssertFailure(prAccessor.getString("STR025"), log);
        }
    }

    public ClientQopCache getQopCache() {
        return this.m_qopcache;
    }

    public ConnectionFailoverStateManager getConnectionFailoverStateManager() {
        return this.m_connectionFailoverStateManager;
    }

    public ReconnectHelper getReconnector() {
        return this.m_reconnector;
    }

    protected void createQopCache() {
        if (this.m_conZero != null) {
            this.m_qopCacheSize = this.m_conZero.getQOPCacheSize();
        }
        this.m_qopcache = new ClientQopCache(this.m_qopCacheSize);
    }

    private static char[] convert(char[] rep, int num) {
        int i = 8;
        while (i-- > 0) {
            rep[i] = map[num & 0xF];
            num >>>= 4;
        }
        return rep;
    }

    public static StringBuffer convert(int[] subject) {
        StringBuffer sub = new StringBuffer(subject.length * 9 + 2);
        char[] num = new char[8];
        sub.append('[');
        for (int i = 0; i < subject.length; ++i) {
            if (i > 0) {
                sub.append('.');
            }
            sub.append(Connection.convert(num, subject[i]));
        }
        sub.append(']');
        return sub;
    }

    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public ISocket getSocket() {
        ConnectionContext ctx = this.getContext();
        if (ctx != null) {
            return ctx.getSocket();
        }
        return null;
    }

    public long getSocketId() {
        return this.getContext().getSocketId();
    }

    public void setSocketId(long id) {
        this.getContext().setSocketId(id);
    }

    @Override
    public String toString() {
        return this.m_appid + " " + this.getEffectiveUid();
    }

    private void resolveHostName(String socketType) throws UnknownHostException {
        try {
            this.m_resolvedHost = ProgressInetAddress.getByName(this.m_host).getHostAddress(true);
        }
        catch (UnknownHostException e) {
            UnknownHostException uex = e;
            int idx = this.m_host.indexOf(".");
            String hostName = idx != -1 ? this.m_host.substring(0, idx) : this.m_host;
            String domainSuffixSearchOrder = null;
            if (this.m_props != null) {
                if (this.m_props instanceof Hashtable) {
                    domainSuffixSearchOrder = (String)((Hashtable)this.m_props).get("DOMAIN_SUFFIX_SEARCH_ORDER");
                } else if (this.m_props instanceof Applet) {
                    domainSuffixSearchOrder = ((Applet)this.m_props).getParameter("DOMAIN_SUFFIX_SEARCH_ORDER");
                }
            }
            if (domainSuffixSearchOrder != null) {
                StringTokenizer stz = new StringTokenizer(domainSuffixSearchOrder, ";");
                String[] list = new String[stz.countTokens()];
                for (int i = 0; i < list.length; ++i) {
                    try {
                        String name = hostName + "." + list[i];
                        ProgressInetAddress inet = ProgressInetAddress.getByName(name);
                        this.m_host = inet.getHostName();
                        this.m_resolvedHost = inet.getHostAddress(true);
                        return;
                    }
                    catch (UnknownHostException e2) {
                        uex = e2;
                        continue;
                    }
                }
            }
            throw uex;
        }
    }

    public AutoVec cloneBrethren() {
        return (AutoVec)this.m_brethren.clone();
    }

    public boolean isSecure() {
        return this.getSecurityContext().isSecurityEnabled();
    }

    public ISocketDropHandlerChainFactory getSocketDropHandlerChainFactory() {
        return this.m_socketDropHandlerChainFactory;
    }

    public void setSocketDropHandlerChainFactory(ISocketDropHandlerChainFactory factory) {
        this.m_socketDropHandlerChainFactory = factory;
    }

    public void setApplicationLevelResolver(IDoubtResolver resolver) {
        this.m_applicationResolver = resolver;
    }

    public IDoubtResolver getApplicationLevelResolver() {
        return this.m_applicationResolver;
    }

    public void setConnected() {
        this.m_state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsConnectionSynchronization() {
        TunnelRequest pending = this.getPendingTunnelRequest();
        if (pending == null) {
            return this.m_state == 0 || this.m_state == 4;
        }
        TunnelRequest tunnelRequest = pending;
        synchronized (tunnelRequest) {
            if (this.m_state == 0 || this.m_state == 4) {
                return true;
            }
            return this.m_state == 3 && pending.getStatus() == 1;
            {
            }
        }
    }

    public ConnectionSyncData getSyncData() {
        String uid = null;
        uid = this.m_channel > 0 ? this.m_conZero.getEffectiveUid() : this.getEffectiveUid();
        return new ConnectionSyncData(0, this.m_channel, SessionConfig.stringToClientId(uid, this.getApplicationId()), this.m_state, this.m_deliveryStarted, null, this.m_ackMode);
    }

    public boolean removeTunnelIfDisconnecting() {
        if (this.m_state == 4) {
            this.disconnectReply();
            return true;
        }
        return false;
    }

    public boolean internallyConnectTunnel(ConnectionSyncData csd) throws EGeneralException {
        TunnelRequest req = this.getPendingTunnelRequest();
        if (req != null) {
            req.completeInternally(csd);
            return true;
        }
        if (this.m_state != 0) {
            return false;
        }
        this.m_dropHandler = this.m_conZero.m_dropHandler;
        ClientSecurityContext csc = csd.getClientSecurityContext();
        this.getContext().newChannel(this, csd.getChannel());
        this.configQOP(csc);
        this.m_dirMsgHandler.bind(SessionConfig.getDirectedSubject(this.getEffectiveUid(), this.m_appid, "*", "#", "*"));
        return true;
    }

    private void configQOP(ClientSecurityContext csc) {
        if (csc.isQopSecurityEnabled()) {
            this.getContext().getClientListener().setupSecurity(csc, this.getChannel());
        }
        this.connectSuccess(csc);
    }

    public TunnelRequest getPendingTunnelRequest() {
        return this.m_pendingTunnelRequest;
    }

    public void setPendingTunnelRequest(TunnelRequest req) {
        this.m_pendingTunnelRequest = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCounter() {
        long result = 0L;
        Class<Connection> clazz = Connection.class;
        synchronized (Connection.class) {
            result = s_counter++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return result;
        }
    }

    final void handleRejection(Envelope rejected, int errorCode, String message) {
        this.m_rejectionListener.onRejection(rejected, Publication.buildException(errorCode, rejected.getSubject(), message));
    }

    public byte selectSessionVer(byte defaultSessionVer, byte ServerSessionVer) {
        return defaultSessionVer;
    }

    public void setLGSetting(boolean isInstrumented, int downStreamNodeType) {
        this.m_isLGInstrumented = isInstrumented;
        this.m_downStreamLGNodeType = downStreamNodeType;
    }

    public void initCompressionFactory(String factoryNameParam) throws EInvalidCompressionFactory {
        String factoryName = factoryNameParam;
        if (factoryName == null || factoryName.trim().length() == 0) {
            factoryName = SessionConfig.COMPRESSION_FACTORY;
        }
        this.m_compressionFactory = CompressionFactory.getInstance(factoryName);
        if (this.m_compressionFactory == null) {
            String err = progress.message.client.prAccessor.getString("INVALID_COMPRESSION_FACTORY");
            Object[] obj = new String[]{factoryName};
            String msg = prMessageFormat.format(err, obj);
            throw new EInvalidCompressionFactory(msg);
        }
    }

    public void resetCompressionFactory() {
        this.m_compressionFactory = null;
    }

    public ICompressionFactory getCompressionFactory() {
        return this.m_compressionFactory;
    }

    public void setMetricsListener(IMetricsListener listener) {
        this.m_metricsListener = listener;
    }

    public IMetricsListener getMetricsListener() {
        return this.m_metricsListener;
    }

    @Override
    public void updateBytesRcvdStats(long value) {
        if (this.m_metricsListener != null) {
            this.m_metricsListener.updateBytesRcvdStats(value);
        }
    }

    @Override
    public void updateBytesDelvdStats(long value) {
        if (this.m_metricsListener != null) {
            this.m_metricsListener.updateBytesDelvdStats(value);
        }
    }

    public void notifyNewLGSetting(boolean isInstrumented, int downStreamNodeType) throws EGeneralException {
        this.publishLGSetting(isInstrumented, downStreamNodeType, false);
    }

    public void publishLGSetting(boolean isInstrumented, int downStreamNodeType, boolean init) throws EGeneralException {
        if (!init && isInstrumented == this.m_isLGInstrumented && downStreamNodeType == this.m_downStreamLGNodeType) {
            return;
        }
        this.m_isLGInstrumented = isInstrumented;
        this.m_downStreamLGNodeType = downStreamNodeType;
        Message req = new Message(SessionConfig.getAdminPrefix(this.getEffectiveUid(), this.getApplicationId()) + ".LG");
        req.writeBoolean(isInstrumented);
        req.writeInt(downStreamNodeType);
        this.m_defaultSession.publish(req);
    }

    public boolean getBrokerRetainsJMSNonDurableState() {
        return this.m_brokerRetainsJMSNonDurableState;
    }

    public void setBrokerRetainsJMSNonDurableState(boolean m_brokerRetainsJMSNonDurableState) {
        this.m_brokerRetainsJMSNonDurableState = m_brokerRetainsJMSNonDurableState;
    }

    public boolean isEnterpriseEdition() {
        if (this.m_channel == 0) {
            if (this.m_brokerConnectParms != null) {
                return this.m_brokerConnectParms.isEnterpriseEdition();
            }
            return false;
        }
        return this.m_conZero.isEnterpriseEdition();
    }

    static {
        map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    class AcceptorUpdateHandler
    implements IMessageHandler {
        ReconnectHelper m_rh = null;

        AcceptorUpdateHandler(ReconnectHelper rh) {
            this.m_rh = rh;
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            try {
                int i;
                Message msg = env.getMessage();
                String[] localURLs = null;
                String[] standbyURLs = null;
                int count = msg.readInt();
                if (count > 0) {
                    localURLs = new String[count];
                    for (i = 0; i < localURLs.length; ++i) {
                        localURLs[i] = msg.readUTF();
                    }
                }
                if ((count = msg.readInt()) > 0) {
                    standbyURLs = new String[count];
                    for (i = 0; i < standbyURLs.length; ++i) {
                        standbyURLs[i] = msg.readUTF();
                    }
                }
                this.m_rh.notifyRedundancyAssociation(localURLs, standbyURLs);
                this.m_rh.reloadConnectTable();
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
            }
        }
    }

    class TunnelRequest
    extends Request {
        ConnectionSyncData m_csd;

        TunnelRequest(Envelope request, IJobResolver resolver) {
            super(request, resolver);
            this.m_csd = null;
        }

        @Override
        synchronized void setReply(Envelope rep) {
            try {
                boolean success = rep.getMessage().readBooleanAt(0);
                if (success) {
                    Connection.this.getContext().newChannel(Connection.this, Connection.this.m_channel);
                    Connection.this.m_state = 0;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.setReply(rep);
        }

        synchronized void completeInternally(ConnectionSyncData csd) {
            this.m_csd = csd;
            if (this.m_csd.getState() == 0) {
                Connection.this.getContext().newChannel(Connection.this, Connection.this.m_channel);
                Connection.this.m_state = 0;
            }
            super.setReply(null);
        }

        ConnectionSyncData getConnectionSyncData() {
            return this.m_csd;
        }
    }
}

