/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime;

import com.sonicsw.mq.common.runtime.IDestination;
import com.sonicsw.mq.common.runtime.IMessage;
import com.sonicsw.mq.common.runtime.impl.BrowseMessage;
import com.sonicsw.mq.common.runtime.impl.Destination;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.JMSException;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Topic;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.Envelope;
import progress.message.zclient.Subject;

public class JMSObjectFactory {
    public static javax.jms.Message createJMSMessage(IMessage msg) {
        BrowseMessage bm = (BrowseMessage)msg;
        byte[] mgram = bm.getMgram();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(mgram);
            Message result = null;
            if (bm.getVersion() >= 1) {
                IMgramConverter converter = MgramFactory.getMgramConverter(26);
                Hashtable<String, Boolean> props = new Hashtable<String, Boolean>(1);
                props.put(MgramConstants.TTE_TTL_CONVERT, new Boolean(true));
                converter.initializeConverter(props);
                result = Message.createMessage(new Envelope(converter.createMgram(bais), false, null, null));
            } else {
                result = Message.createMessage(new Envelope(MgramFactory.getMgramConverter(25).createMgram(bais), false, null, null));
            }
            result.setPropertiesReadOnly(true);
            result.setBodyReadOnly(true);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static javax.jms.Destination createJMSDestination(IDestination destination) {
        block5: {
            Destination d = (Destination)destination;
            try {
                String dest = d.getDestination();
                if (dest != null) {
                    short type = Message.getDestinationType(dest);
                    if (type == 1) {
                        Queue q = new Queue(dest, true);
                        return q;
                    }
                    if (type == 2) {
                        return new Topic(dest, true);
                    }
                    break block5;
                }
                return DestUtil.createDestination(d.getRouting(), Subject.createFromBytes(d.getSubject()));
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

