/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;

class ExternalDomainAuthSPINameChangeHandler
implements IAttributeChangeHandler {
    private HashMap m_attributeSet;

    ExternalDomainAuthSPINameChangeHandler(IAttributeSet attributeSet) {
        if (attributeSet != null) {
            this.m_attributeSet = attributeSet.getAttributes();
        }
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null || this.m_attributeSet == null) {
            return;
        }
        boolean isExternalDomainChanged = false;
        boolean isAuthSpiChanged = false;
        if (newValue instanceof IDeltaAttributeSet) {
            Object obj;
            String[] newAttrNames;
            String[] modifiedAttrNames;
            IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
            String[] deletedAttrNames = das.getDeletedAttributesNames();
            if (deletedAttrNames != null && deletedAttrNames.length > 0) {
                for (int i = 0; i < deletedAttrNames.length; ++i) {
                    if (!this.m_attributeSet.containsKey(deletedAttrNames[i])) continue;
                    this.m_attributeSet.remove(deletedAttrNames[i]);
                    isExternalDomainChanged = this.checkIsIsExternalDomainChanged(deletedAttrNames, i, isExternalDomainChanged);
                    isAuthSpiChanged = this.checkAuthSpiAttributeChanged(deletedAttrNames, i, isAuthSpiChanged);
                }
            }
            if ((modifiedAttrNames = das.getModifiedAttributesNames()) != null && modifiedAttrNames.length > 0) {
                for (int i = 0; i < modifiedAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(modifiedAttrNames[i], das.getNewValue(modifiedAttrNames[i]));
                        isExternalDomainChanged = this.checkIsIsExternalDomainChanged(modifiedAttrNames, i, isExternalDomainChanged);
                        isAuthSpiChanged = this.checkAuthSpiAttributeChanged(modifiedAttrNames, i, isAuthSpiChanged);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((newAttrNames = das.getNewAttributesNames()) != null && newAttrNames.length > 0) {
                for (int i = 0; i < newAttrNames.length; ++i) {
                    try {
                        this.m_attributeSet.put(newAttrNames[i], das.getNewValue(newAttrNames[i]));
                        isExternalDomainChanged = this.checkIsIsExternalDomainChanged(newAttrNames, i, isExternalDomainChanged);
                        isAuthSpiChanged = this.checkAuthSpiAttributeChanged(newAttrNames, i, isAuthSpiChanged);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ExternalDomainAuthSPIConfig authConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
            String authSPIRefrenceName = null;
            String authSPIName = null;
            String className = null;
            ArrayList classpath = null;
            if (isExternalDomainChanged && (obj = this.m_attributeSet.get("EXTERNAL")) != null) {
                String value = (String)obj;
                if (!value.equalsIgnoreCase("true")) {
                    if (authConfig != null) {
                        authConfig.setExternalDomainFlag(false);
                    }
                } else {
                    isAuthSpiChanged = true;
                }
            }
            if (isAuthSpiChanged) {
                obj = this.m_attributeSet.get("AUTH_SPI");
                if (obj != null) {
                    Reference ref = null;
                    IComponentContext context = BrokerComponent.getComponentContext();
                    if (context != null) {
                        IElement element;
                        ref = (Reference)obj;
                        String string = authSPIRefrenceName = ref == null ? null : ref.getElementName();
                        if (authSPIRefrenceName != null && (element = context.getConfiguration(authSPIRefrenceName, true)) != null) {
                            HashMap map;
                            IAttributeSet attributeSet = element.getAttributes();
                            if (attributeSet != null && (map = attributeSet.getAttributes()) != null) {
                                authSPIName = (String)map.get("AUTH_SPI_NAME");
                                className = (String)map.get("CLASS_NAME");
                                Object o = map.get("CLASSPATH");
                                if (o != null) {
                                    try {
                                        IAttributeList list = (IAttributeList)o;
                                        if (list != null) {
                                            classpath = list.getItems();
                                        }
                                    }
                                    catch (ClassCastException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
                                externalDomainAuthSPIConfig.setReferenceName(authSPIRefrenceName);
                                externalDomainAuthSPIConfig.setAuthSPIName(authSPIName);
                                externalDomainAuthSPIConfig.setClassName(className);
                                externalDomainAuthSPIConfig.setClasspath(classpath);
                                AgentRegistrar.initAuthenticationSPI();
                            }
                            ConfigurationChangeBindHelper bindHelper = BrokerComponent.getBrokerComponent().getChangeBindHelper();
                            bindHelper.bindAuthSPIDefinationChangeHandler(attributeSet);
                        }
                    }
                } else {
                    ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
                    externalDomainAuthSPIConfig.setAuthSPIName(null);
                }
            }
        }
    }

    private boolean checkIsIsExternalDomainChanged(String[] deletedAttrNames, int i, boolean isExternalDomainChangedParam) {
        boolean isExternalDomainChanged = isExternalDomainChangedParam;
        if (deletedAttrNames[i].equalsIgnoreCase("EXTERNAL")) {
            isExternalDomainChanged = true;
        }
        return isExternalDomainChanged;
    }

    private boolean checkAuthSpiAttributeChanged(String[] attributes, int i, boolean isAuthSpiChangedParam) {
        boolean isAuthSpiChanged = isAuthSpiChangedParam;
        if (attributes[i].equalsIgnoreCase("AUTH_SPI")) {
            isAuthSpiChanged = true;
        }
        return isAuthSpiChanged;
    }
}

