/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.cert;

import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;

public class TrustStore {
    private static boolean DEBUG = false;
    private KeyStore m_trustStore = null;
    private String m_trustStoreType = null;
    private String m_url = null;
    private char[] m_pwd = null;
    private boolean m_initialized = false;

    public TrustStore() {
        this("JKS");
    }

    public TrustStore(String type) {
        this.m_trustStoreType = type;
    }

    public void load(String url, char[] password) throws Exception {
        this.setURL(url);
        this.setPassword(password);
        this.loadInternal();
    }

    public boolean initialized() {
        return this.m_initialized;
    }

    public KeyStore getTrustStore() {
        return this.m_trustStore;
    }

    protected void setURL(String url) {
        this.m_url = url;
        if (this.m_url == null) {
            return;
        }
        int index = url.indexOf(":");
        if (index < 0 || !url.substring(0, index).equalsIgnoreCase("sonicfs")) {
            this.m_url = "file:///" + url;
        }
    }

    protected void setPassword(char[] pwd) {
        this.m_pwd = pwd;
    }

    protected void loadInternal() throws Exception {
        this.reset();
        if (this.m_url == null || this.m_url.length() == 0) {
            throw new KeyStoreException("invalid path.");
        }
        if (this.m_pwd == null || this.m_pwd.length == 0) {
            throw new KeyStoreException("invalid password.");
        }
        this.m_trustStore = KeyStore.getInstance("JKS");
        this.m_trustStore.load(new URL(this.m_url).openConnection().getInputStream(), this.m_pwd);
        this.m_initialized = true;
        if (DEBUG) {
            System.out.println("JKS trust store loaded from " + this.m_url);
        }
    }

    protected void reset() {
        this.m_trustStore = null;
        this.m_initialized = false;
    }
}

