/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import com.sonicsw.security.ssl.CertChain;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeyStoreHelper {
    private static boolean DEBUG = false;
    private static X509Certificate[] CerticateArray = new X509Certificate[0];

    public static KeyStore keyStoreFromPKCS7AndEncryptedPKCS8(String pkcs7, String pkcs8, String keyPass, String alias) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        return KeyStoreHelper.keyStoreFromPKCS7AndPKCS8(pkcs7, pkcs8, true, keyPass, alias, KeyStoreHelper.getKeyStore(null));
    }

    public static KeyStore keyStoreFromPKCS7AndUnencryptedPKCS8(String pkcs7, String pkcs8, String keyPass, String alias) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        return KeyStoreHelper.keyStoreFromPKCS7AndPKCS8(pkcs7, pkcs8, false, keyPass, alias, KeyStoreHelper.getKeyStore(null));
    }

    public static KeyStore keyStoreFromPKCS7AndPKCS8(String pkcs7, String pkcs8, boolean isKeyEncrypted, String keyPass, String alias, KeyStore ks) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        Certificate[] chain = null;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream fis = new FileInputStream(pkcs7);
        chain = new CertChain(cf.generateCertificates(fis).toArray(CerticateArray)).getCertificateChain();
        fis.close();
        if (DEBUG) {
            System.out.println("keyStoreFromPKCS7AndPKCS8(): certificate chain loaded from " + pkcs7 + "...");
            for (int i = 0; i < chain.length; ++i) {
                System.out.println("cert[" + i + "]:\n" + chain[i]);
            }
        }
        return KeyStoreHelper.loadKeyStoreFromCertificatesAndPKCS8(chain, pkcs8, isKeyEncrypted, keyPass, alias, ks);
    }

    public static KeyStore keyStoreFromPKCS12(String pkcs12, String password, String alias) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        String oldAlias;
        KeyStore ks = KeyStore.getInstance("PKCS12");
        if (DEBUG) {
            System.out.println("keyStoreFromPKCS12(): type = " + ks.getType() + ", path = " + pkcs12);
        }
        try {
            FileInputStream fis = new FileInputStream(pkcs12);
            ks.load(fis, password.toCharArray());
        }
        catch (Exception ex) {
            throw KeyStoreHelper.createExceptionCreateInMemory(ex);
        }
        if (ks.size() > 1) {
            throw new KeyStoreException("More than one pair of certificate & private key found in PKCS12 " + pkcs12);
        }
        if (alias != null && !(oldAlias = ks.aliases().nextElement()).equals(alias)) {
            try {
                ks.setKeyEntry(alias, ks.getKey(oldAlias, password.toCharArray()), password.toCharArray(), ks.getCertificateChain(oldAlias));
                ks.deleteEntry(oldAlias);
            }
            catch (Exception ex) {
                throw KeyStoreHelper.createExceptionUnableAddKeyCertificate(alias, ex);
            }
        }
        return ks;
    }

    public static KeyStore loadKeyStoreFromPKCS12(String pkcs12, String password, String alias, KeyStore keyStoreParam) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        KeyStore keyStore = keyStoreParam;
        KeyStore pkcs12Store = null;
        try {
            pkcs12Store = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(pkcs12);
            pkcs12Store.load(fis, password.toCharArray());
            fis.close();
        }
        catch (Exception ex) {
            if (DEBUG) {
                ex.printStackTrace();
            }
            throw new KeyStoreException("Failed to load PKCS12 from " + pkcs12 + " : " + ex.getMessage(), ex);
        }
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, password.toCharArray());
            }
            catch (Exception ex) {
                throw new KeyStoreException("Failed to create a new JKS keystore: " + ex.getMessage(), ex);
            }
        }
        if (alias == null) {
            throw new KeyStoreException("Key entry alias not specified.");
        }
        if (pkcs12Store.size() > 1) {
            throw new KeyStoreException("More than one pair of certificate & private key found in PKCS12 " + pkcs12);
        }
        String oldAlias = pkcs12Store.aliases().nextElement();
        try {
            keyStore.setKeyEntry(alias, pkcs12Store.getKey(oldAlias, password.toCharArray()), password.toCharArray(), pkcs12Store.getCertificateChain(oldAlias));
        }
        catch (Exception ex) {
            throw KeyStoreHelper.createExceptionUnableAddKeyCertificate(alias, ex);
        }
        return keyStore;
    }

    private static KeyStoreException createExceptionUnableAddKeyCertificate(String alias, Exception ex) {
        if (DEBUG) {
            ex.printStackTrace();
        }
        return new KeyStoreException("Unable to add key & certificate(s) using alias " + alias + ": " + ex.getMessage(), ex);
    }

    public static KeyStore keyStoreFromCertificatesAndPKCS8(String[] certs, String pkcs8, boolean isKeyEncrypted, String keyPass, String alias, String keyStoreType) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        Certificate[] chain = null;
        if (certs.length > 0) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            chain = new Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                chain[i] = cf.generateCertificate(new FileInputStream(certs[i]));
            }
        }
        return KeyStoreHelper.loadKeyStoreFromCertificatesAndPKCS8(chain, pkcs8, isKeyEncrypted, keyPass, alias, KeyStoreHelper.getKeyStore(keyStoreType));
    }

    public static KeyStore getKeyStore(String keyStoreTypeParam) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        String keyStoreType = keyStoreTypeParam;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        if (DEBUG) {
            System.out.println("loadKeyStoreFromPKCS7AndPKCS8(): key store created, type = " + ks.getType());
        }
        try {
            ks.load(null, null);
        }
        catch (Exception ex) {
            throw KeyStoreHelper.createExceptionCreateInMemory(ex);
        }
        return ks;
    }

    private static KeyStoreException createExceptionCreateInMemory(Exception ex) {
        if (DEBUG) {
            ex.printStackTrace();
        }
        return new KeyStoreException("Failed to create in-memory key store: " + ex.getMessage(), ex);
    }

    public static KeyStore loadKeyStoreFromCertificatesAndPKCS8(Certificate[] chain, String pkcs8, boolean isKeyEncrypted, String keyPass, String alias, KeyStore ks) throws KeyStoreException, CertificateException, IOException, InvalidKeyException {
        try {
            FileInputStream fis = new FileInputStream(pkcs8);
            DataInputStream dis = new DataInputStream(fis);
            byte[] key = new byte[dis.available()];
            dis.readFully(key);
            dis.close();
            fis.close();
            PKCS8EncodedKeySpec pkcs8Spec = null;
            if (isKeyEncrypted) {
                EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(key);
                if (DEBUG) {
                    System.out.println("loadKeyStoreFromPKCS7AndPKCS8(): encrypted private key info...\nencryption algorithm name = " + epki.getAlgName() + "\nencryption algorithm parameter = " + epki.getAlgParameters());
                }
                PBEKeySpec pbeSpec = new PBEKeySpec(keyPass.toCharArray());
                SecretKeyFactory pbeKF = SecretKeyFactory.getInstance(epki.getAlgName());
                SecretKey decryptKey = pbeKF.generateSecret(pbeSpec);
                pkcs8Spec = epki.getKeySpec(decryptKey);
            } else {
                pkcs8Spec = new PKCS8EncodedKeySpec(key);
            }
            KeyFactory rsaKF = KeyFactory.getInstance(chain[0].getPublicKey().getAlgorithm());
            PrivateKey pk = rsaKF.generatePrivate(pkcs8Spec);
            if (DEBUG) {
                System.out.println("loadKeyStoreFromPKCS7AndPKCS8(): private key info...\nalgorithm name = " + pk.getAlgorithm() + "\nencoding format = " + pk.getFormat());
            }
            ks.setKeyEntry(alias, pk, keyPass.toCharArray(), chain);
        }
        catch (Exception ex) {
            if (DEBUG) {
                ex.printStackTrace();
            }
            throw new InvalidKeyException("Failed to load the private key from " + pkcs8 + ":" + ex.getMessage(), ex);
        }
        return ks;
    }

    public static X509Certificate[] loadCertificatesFromDirectory(String path) throws CertificateException {
        if (path == null || path.trim().length() <= 0) {
            return null;
        }
        File dir = new File(path.trim());
        if (!dir.isDirectory()) {
            return null;
        }
        if (DEBUG) {
            System.out.println("Loading certificate(s) from directory " + path);
        }
        Object[] certs = null;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            Vector<X509Certificate> certVec = new Vector<X509Certificate>();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileInputStream fis = new FileInputStream(files[i]);
                    certVec.addElement((X509Certificate)cf.generateCertificate(fis));
                    fis.close();
                    continue;
                }
                catch (Exception ex) {
                    if (!DEBUG) continue;
                    System.out.println(ex + " : Unable to load X.509 certificate from " + files[i].getName());
                }
            }
            certs = new X509Certificate[certVec.size()];
            certVec.copyInto(certs);
        }
        return certs;
    }

    public static KeyStore trustStoreFromCertificates(X509Certificate[] caCertificates, KeyStore trustStore) throws KeyStoreException {
        if (DEBUG) {
            System.out.println("Populating a trust store with trusted " + caCertificates.length + " certificates, store = " + trustStore);
        }
        if (caCertificates == null || caCertificates.length == 0) {
            return null;
        }
        KeyStore ts = trustStore;
        try {
            if (ts == null) {
                ts = KeyStore.getInstance(KeyStore.getDefaultType());
                ts.load(null, null);
            }
            for (int i = 0; i < caCertificates.length; ++i) {
                ts.setCertificateEntry(caCertificates[i].getSubjectDN().getName(), caCertificates[i]);
            }
        }
        catch (Exception ex) {
            if (DEBUG) {
                ex.printStackTrace();
            }
            throw new KeyStoreException("Failed to add CA certificate(s) into a trust store: " + ex.getMessage(), ex);
        }
        return ts;
    }

    public static void dumpProviderInfo() {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            TreeSet<String> sortedListing = new TreeSet<String>();
            System.out.println(provider.getName());
            System.out.println("ver. " + provider.getVersion());
            System.out.println(provider.getInfo());
            for (Map.Entry<Object, Object> entry : provider.entrySet()) {
                String description = entry.getKey().toString();
                description = description + (entry.getKey().toString().startsWith("Alg.Alias.") ? " is aliased to " : " = ");
                sortedListing.add(description + entry.getValue().toString());
            }
            Iterator listing = sortedListing.iterator();
            while (listing.hasNext()) {
                System.out.println((String)listing.next());
            }
        }
    }

    private boolean testPKCS7AndEncryptedPKCS8(String pkcs7, String pkcs8, String keyPass, String alias, String storeType) {
        boolean status = true;
        try {
            KeyStore ks = KeyStoreHelper.keyStoreFromPKCS7AndPKCS8(pkcs7, pkcs8, true, keyPass, alias, KeyStoreHelper.getKeyStore(storeType));
            this.printCertificateAndKeys(ks, alias, keyPass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = false;
        }
        return status;
    }

    private boolean testPKCS12(String pkcs12, String password, String alias) {
        boolean status = true;
        try {
            KeyStore ks = KeyStoreHelper.keyStoreFromPKCS12(pkcs12, password, alias);
            int i = 0;
            String aliasFound = ks.aliases().nextElement();
            if (!aliasFound.equals(alias)) {
                System.out.println("ERROR: unable to retrieve key & certificate(s) from entry \"" + alias + "\", found \"" + aliasFound + "\"");
                return false;
            }
            System.out.println("retrieving key & certificate(s) from key entry[" + i + "] " + alias);
            this.printCertificateAndKeys(ks, alias, password);
            ++i;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = false;
        }
        return status;
    }

    private void printCertificateAndKeys(KeyStore ks, String alias, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Certificate[] certs = ks.getCertificateChain(alias);
        for (int j = 0; j < certs.length; ++j) {
            System.out.println("cert[" + j + "]:\n" + certs[j]);
        }
        Key pk = ks.getKey(alias, password.toCharArray());
        KeyStoreHelper.printPrivateKeyDetails(pk);
    }

    private static void printPrivateKeyDetails(Key pk) {
        System.out.println("private key is of instance of " + pk.getClass());
        System.out.println("private key info:\nalgorithm name = " + pk.getAlgorithm() + "\nencoding format = " + pk.getFormat() + "\n");
    }

    public static void main(String[] argv) {
        String baseDir = "C:/sandboxMQ8.0/MQ8.0";
        boolean testPKCS7 = true;
        boolean testPKCS12 = true;
        for (int i = 0; i < argv.length; ++i) {
            String type;
            if ("-dir".equalsIgnoreCase(argv[i])) {
                baseDir = argv[++i];
                continue;
            }
            if (!"-type".equalsIgnoreCase(argv[i])) continue;
            if ("pkcs7".equalsIgnoreCase(type = argv[++i])) {
                testPKCS12 = false;
                continue;
            }
            if (!"pkcs12".equalsIgnoreCase(type)) continue;
            testPKCS7 = false;
        }
        String serverp7c = baseDir + "server.p7c";
        String serverpkcs8 = baseDir + "serverKey.pkcs8";
        String clientp7c = baseDir + "client.p7c";
        String clientpkcs8 = baseDir + "clientKey.pkcs8";
        String serverp12 = baseDir + "server.p12";
        String clientp12 = baseDir + "client.p12";
        String keypass = "password";
        boolean status = true;
        KeyStoreHelper helper = new KeyStoreHelper();
        if (testPKCS7) {
            if (status && !helper.testPKCS7AndEncryptedPKCS8(serverp7c, serverpkcs8, keypass, "server", null)) {
                status = false;
            }
            if (status && !helper.testPKCS7AndEncryptedPKCS8(clientp7c, clientpkcs8, keypass, "client", "JKS")) {
                status = false;
            }
            if (status && !helper.testPKCS7AndEncryptedPKCS8(serverp7c, serverpkcs8, keypass, "server", "PKCS12")) {
                status = false;
            }
        }
        if (testPKCS12) {
            if (status && !helper.testPKCS12(serverp12, keypass, "server")) {
                status = false;
            }
            if (status && !helper.testPKCS12(clientp12, keypass, "client")) {
                status = false;
            }
        }
        if (!status) {
            System.out.println("\nTest [v3] failed, provider info:\n");
            KeyStoreHelper.dumpProviderInfo();
        } else {
            System.out.println("\nTest [v3] passed.");
        }
    }
}

