/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TxnBeginEvt;
import progress.message.xa.XidImpl;

class GlobalTxnBeginEvt
extends TxnBeginEvt {
    private XidImpl m_xid;

    GlobalTxnBeginEvt(int tid, String uid, String appid, Object xid, long requestId) {
        super(tid, -1, uid, appid, requestId, (short)0);
        if (xid instanceof XidImpl) {
            this.m_xid = (XidImpl)xid;
        } else {
            System.out.println("[GlobalTxnBeginEvt]unknow xid type");
        }
        if (this.DEBUG) {
            this.debug("xid=" + this.m_xid);
        }
    }

    GlobalTxnBeginEvt(short typ) {
        super(typ);
        this.m_xid = new XidImpl();
    }

    XidImpl getXid() {
        return this.m_xid;
    }

    @Override
    public short type() {
        return 91;
    }

    @Override
    protected int memSizeBody() {
        return super.memSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int streamSizeBody() {
        return super.streamSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int serializedSizeBody() {
        return super.serializedSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        super.writeBodyToLog(out, maxbytes);
        this.m_xid.writebody(out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        super.writeBodyToStream(os, tteTTLConvert);
        this.m_xid.writebody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        super.readBodyFromStream(in, tteTTLConvert);
        this.m_xid.readbody(in);
        if (this.DEBUG) {
            this.debug(" *** readbody().m_xid=" + this.m_xid);
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnBegin(this);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.m_xid.toString() + "]";
    }
}

