/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public final class GuarQAckDoneEvt
extends LogEvent {
    private long m_tracking;

    public GuarQAckDoneEvt(long tracking) {
        this.m_tracking = tracking;
    }

    public GuarQAckDoneEvt() {
    }

    long getTracking() {
        return this.m_tracking;
    }

    @Override
    public short type() {
        return 28;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_tracking, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_tracking, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tracking = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoGuarQAckDone(this.m_tracking);
    }

    @Override
    public String toString() {
        return super.toString() + "QMessage " + this.m_tracking + " acknowledged at sending broker";
    }
}

