/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class MsgRestoreBeginEvt
extends LogEvent {
    private long m_cid;
    private long m_rid;
    private boolean m_remote;
    private boolean m_SMO;
    private int m_maxSizeInDoubt;

    MsgRestoreBeginEvt(long cid, long id, boolean remote, boolean SMO, int size) {
        this.m_cid = cid;
        this.m_rid = id;
        this.m_remote = remote;
        this.m_SMO = SMO;
        this.m_maxSizeInDoubt = size;
    }

    MsgRestoreBeginEvt() {
    }

    @Override
    public short type() {
        return 152;
    }

    public long getCid() {
        return this.m_cid;
    }

    public long getRestoreId() {
        return this.m_rid;
    }

    public boolean getRemote() {
        return this.m_remote;
    }

    public boolean getSMO() {
        return this.m_SMO;
    }

    public int getSize() {
        return this.m_maxSizeInDoubt;
    }

    @Override
    protected int memSizeBody() {
        return 22;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_cid, os);
        StreamUtil.writeLong(this.m_rid, os);
        StreamUtil.writeBoolean(this.m_remote, os);
        StreamUtil.writeBoolean(this.m_SMO, os);
        StreamUtil.writeInt(this.m_maxSizeInDoubt, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_cid = StreamUtil.readLong(in);
        this.m_rid = StreamUtil.readLong(in);
        this.m_remote = StreamUtil.readBoolean(in);
        this.m_SMO = StreamUtil.readBoolean(in);
        this.m_maxSizeInDoubt = StreamUtil.readInt(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        AgentRegistrar.getAgentRegistrar().getMsgRestoreMgr().redoMsgRestoreBeginEvt(this);
    }

    @Override
    public String toString() {
        return super.toString() + " cid: " + this.m_cid + " rid: " + this.m_rid;
    }
}

